/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.AttributeInfo;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamespaceInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.tree.AttributeImpl;
import com.icl.saxon.tree.DOMExceptionImpl;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NamespaceImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ElementWithAttributes
extends ElementImpl
implements ElementInfo,
Element,
NamedNodeMap {
    private static AttributeCollection emptyAtts = new AttributeCollection();
    protected AttributeCollection attributeList;
    protected String[] namespaceList = null;

    public void initialise(Name name, AttributeCollection attributeCollection, NodeInfo nodeInfo, String string, int n, int n2) throws SAXException {
        this.fullName = name;
        this.attributeList = attributeCollection;
        this.parent = (ParentNodeImpl)nodeInfo;
        this.sequence = n2;
        DocumentImpl documentImpl = (DocumentImpl)this.getDocumentRoot();
        documentImpl.setLineNumber(n2, n);
        documentImpl.setBaseURI(n2, string);
    }

    public void setNamespaceDeclarations(String[] stringArray, int n) throws SAXException {
        this.namespaceList = new String[n];
        System.arraycopy(stringArray, 0, this.namespaceList, 0, n);
    }

    public String getURIforPrefix(String string) throws SAXException {
        if (string.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (this.namespaceList != null) {
            int n = 0;
            while (n < this.namespaceList.length) {
                if (this.namespaceList[n].equals(string)) {
                    return this.namespaceList[n + 1];
                }
                n += 2;
            }
        }
        if (this.parent instanceof DocumentInfo) {
            if (string.equals("")) {
                return "";
            }
            throw new SAXException("Namespace for prefix \"" + string + "\" has not been declared");
        }
        return ((ElementInfo)((Object)this.parent)).getURIforPrefix(string);
    }

    public String getPrefixForURI(String string) {
        if (this.namespaceList != null) {
            int n = 0;
            while (n < this.namespaceList.length) {
                if (this.namespaceList[n + 1].equals(string)) {
                    return this.namespaceList[n];
                }
                n += 2;
            }
        }
        if (this.parent instanceof DocumentInfo) {
            return null;
        }
        return ((ElementInfo)((Object)this.parent)).getPrefixForURI(string);
    }

    public void addNamespaceNodes(ElementInfo elementInfo, Vector vector, NodeInfo nodeInfo) throws SAXException {
        if (this.namespaceList != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < this.namespaceList.length) {
                String string = this.namespaceList[n2++];
                String string2 = this.namespaceList[n2++];
                boolean bl = false;
                int n3 = 0;
                while (n3 < n) {
                    NamespaceInfo namespaceInfo;
                    if (!(namespaceInfo = (NamespaceInfo)vector.elementAt(n3++)).getNamespacePrefix().equals(string)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                vector.addElement(new NamespaceImpl((ElementImpl)elementInfo, string, string2, vector.size() + 1));
            }
        }
        if (!(this.parent instanceof DocumentInfo) && this.parent != nodeInfo) {
            ((ElementInfo)((Object)this.parent)).addNamespaceNodes(elementInfo, vector, nodeInfo);
        }
    }

    public void outputNamespaceNodes(Outputter outputter) throws SAXException {
        if (this.namespaceList != null) {
            int n = 0;
            while (n < this.namespaceList.length) {
                String string = this.namespaceList[n++];
                String string2 = this.namespaceList[n++];
                outputter.writeNamespaceDeclaration(string, string2, false);
            }
        }
        if (!(this.parent instanceof DocumentInfo)) {
            ((ElementInfo)((Object)this.parent)).outputNamespaceNodes(outputter);
        }
    }

    public AttributeCollection getAttributeList() {
        return this.attributeList;
    }

    public String getAttributeValue(Name name) {
        return this.attributeList.getValue(name);
    }

    public String getAttributeValue(String string) {
        return this.attributeList.getValue(string);
    }

    public AttributeInfo makeAttributeNode(Name name) {
        return new AttributeImpl((ElementImpl)this, name);
    }

    public void setAttribute(String string, String string2) throws DOMException {
        if (this.attributeList.getLength() == 0) {
            this.attributeList = new AttributeCollection();
        }
        try {
            Name name = new Name(string, this, false);
            this.attributeList.setAttribute(name, string2);
        }
        catch (SAXException sAXException) {
            throw new DOMExceptionImpl(9999, sAXException.getMessage());
        }
    }

    public void copy(Outputter outputter) throws SAXException {
        outputter.writeStartTag(this.fullName);
        this.outputNamespaceNodes(outputter);
        int n = 0;
        while (n < this.attributeList.getLength()) {
            outputter.writeAttribute(this.attributeList.getExpandedName(n), this.attributeList.getValue(n));
            ++n;
        }
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            nodeInfo.copy(outputter);
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
        outputter.writeEndTag(this.fullName);
    }

    public String getAttribute(String string) {
        try {
            if (string.equals("xmlns")) {
                return this.getURIforPrefix("");
            }
            if (string.startsWith("xmlns:")) {
                return this.getURIforPrefix(string.substring(6));
            }
            Name name = this.makeName(string, false);
            String string2 = this.getAttributeValue(name);
            return string2 == null ? "" : string2;
        }
        catch (SAXException sAXException) {
            return "";
        }
    }

    public NamedNodeMap getAttributes() {
        return this;
    }

    public void removeAttribute(String string) {
        this.setAttribute(string, null);
    }

    public Attr getAttributeNode(String string) {
        try {
            if (string.equals("xmlns")) {
                int n = 0;
                while (n < this.namespaceList.length) {
                    if (this.namespaceList[n].equals("")) {
                        return new NamespaceAttribute("", this.namespaceList[n + 1]);
                    }
                    n += 2;
                }
                return null;
            }
            if (string.startsWith("xmlns:")) {
                String string2 = string.substring(6);
                int n = 0;
                while (n < this.namespaceList.length) {
                    if (this.namespaceList[n].equals(string2)) {
                        return new NamespaceAttribute(string2, this.namespaceList[n + 1]);
                    }
                    n += 2;
                }
                return null;
            }
            Name name = this.makeName(string, false);
            return (AttributeImpl)this.makeAttributeNode(name);
        }
        catch (SAXException sAXException) {
            return null;
        }
    }

    public Attr setAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Attr removeAttributeNode(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public String getAttributeNS(String string, String string2) {
        String string3 = this.getPrefixForURI(string);
        if (string3 == null) {
            return "";
        }
        Name name = Name.reconstruct(string3, string, string2);
        return this.getAttribute(name.getDisplayName());
    }

    public void setAttributeNS(String string, String string2, String string3) throws DOMException {
        this.disallowUpdate();
    }

    public void removeAttributeNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
    }

    public Attr getAttributeNodeNS(String string, String string2) {
        String string3 = this.getPrefixForURI(string);
        if (string3 == null) {
            return null;
        }
        Name name = Name.reconstruct(string3, string, string2);
        return this.getAttributeNode(name.getDisplayName());
    }

    public Attr setAttributeNodeNS(Attr attr) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public boolean hasAttributes() {
        return this.attributeList.getLength() > 0;
    }

    public boolean hasAttribute(String string) {
        try {
            if (string.equals("xmlns")) {
                this.getURIforPrefix("");
                return true;
            }
            if (string.startsWith("xmlns:")) {
                this.getURIforPrefix(string.substring(6));
                return true;
            }
            Name name = this.makeName(string, false);
            return this.getAttributeValue(name) != null;
        }
        catch (SAXException sAXException) {
            return false;
        }
    }

    public boolean hasAttributeNS(String string, String string2) {
        String string3 = this.getPrefixForURI(string);
        if (string3 == null) {
            return false;
        }
        Name name = Name.reconstruct(string3, string, string2);
        return this.hasAttribute(name.getDisplayName());
    }

    public Node getNamedItem(String string) {
        return this.getAttributeNode(string);
    }

    public Node setNamedItem(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeNamedItem(String string) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node item(int n) {
        if (n < 0) {
            return null;
        }
        if (n >= this.attributeList.getLength()) {
            if (this.namespaceList == null) {
                return null;
            }
            int n2 = n - this.attributeList.getLength();
            if (n2 * 2 < this.namespaceList.length) {
                String string = this.namespaceList[n2 * 2];
                String string2 = this.namespaceList[n2 * 2 + 1];
                return new NamespaceAttribute(string, string2);
            }
            return null;
        }
        return this.makeAttributeNode(this.attributeList.getExpandedName(n));
    }

    public int getLength() {
        return this.attributeList.getLength() + (this.namespaceList == null ? 0 : this.namespaceList.length / 2);
    }

    public Node getNamedItemNS(String string, String string2) {
        return this.getAttributeNodeNS(string, string2);
    }

    public Node setNamedItemNS(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeNamedItemNS(String string, String string2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    class NamespaceAttribute
    extends AttributeImpl {
        public NamespaceAttribute(String string, String string2) {
            try {
                this.parent = ElementWithAttributes.this;
                this.name = string.equals("") ? new Name("xmlns") : new Name("xmlns", "http://www.w3.org/xml/xmlns", string);
                this.value = string2;
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
        }
    }
}

