/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.expr.AnyNameTest;
import com.icl.saxon.expr.PrefixTest;
import com.icl.saxon.om.Name;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.tree.Stripper;
import java.util.StringTokenizer;
import org.xml.sax.SAXException;

public class XSLPreserveSpace
extends StyleElement {
    private boolean preserve;
    private String elements;

    public void prepareAttributes() throws SAXException {
        String[] stringArray = new String[]{"elements"};
        this.allowAttributes(stringArray);
        this.preserve = this.getLocalName().equals("preserve-space");
        this.elements = this.attributeList.getValue("elements");
        if (this.elements == null) {
            this.reportAbsence("elements");
        }
    }

    public void validate() throws SAXException {
        this.checkTopLevel();
    }

    public void preprocess() throws SAXException {
        Stripper stripper = this.getPrincipalStyleSheet().getStripper();
        StringTokenizer stringTokenizer = new StringTokenizer(this.elements);
        while (stringTokenizer.hasMoreTokens()) {
            Object object;
            String string = stringTokenizer.nextToken().intern();
            if (string == "*") {
                stripper.setPreserveSpace(new AnyNameTest(), this.preserve);
                continue;
            }
            if (string.endsWith(":*")) {
                object = string.substring(0, string.length() - 2);
                PrefixTest prefixTest = new PrefixTest(this.getURIforPrefix((String)object));
                stripper.setPreserveSpace(prefixTest, this.preserve);
                continue;
            }
            object = new Name(string, this, true);
            stripper.setPreserveSpace((Name)object, this.preserve);
        }
    }

    public void process(Context context) {
    }
}

