/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.sql;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Value;
import com.icl.saxon.sql.SQLColumn;
import com.icl.saxon.style.StyleElement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SQLInsert
extends StyleElement {
    String table;

    public void prepareAttributes() throws SAXException {
        this.table = this.getAttribute("table");
        if (this.table == null) {
            this.reportAbsence("table");
        }
    }

    public void validate() throws SAXException {
        this.checkWithinTemplate();
    }

    public void process(Context context) throws SAXException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("INSERT INTO " + this.table + " (");
        Node node = this.getFirstChild();
        int n = 0;
        while (node != null) {
            if (node instanceof SQLColumn) {
                if (n++ > 0) {
                    stringBuffer.append(',');
                }
                String string = ((SQLColumn)node).getColumnName();
                stringBuffer.append(string);
            }
            node = node.getNextSibling();
        }
        stringBuffer.append(") VALUES (");
        int n2 = 0;
        while (n2 < n) {
            if (n2 != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append('?');
            ++n2;
        }
        stringBuffer.append(')');
        Connection connection = (Connection)context.getController().getUserData(this.getPrincipalStyleSheet(), "sql:connection");
        if (connection == null) {
            throw this.styleError("No SQL connection has been established");
        }
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(stringBuffer.toString());
            Vector vector = new Vector();
            node = this.getFirstChild();
            int n3 = 1;
            while (node != null) {
                if (node instanceof SQLColumn) {
                    Value value = ((SQLColumn)node).getColumnValue(context);
                    String string = value.asString();
                    if (string.length() == 1) {
                        string = string + " ";
                    }
                    preparedStatement.setString(n3++, string);
                }
                node = node.getNextSibling();
            }
            preparedStatement.executeUpdate();
        }
        catch (SQLException sQLException) {
            throw this.styleError("(SQL) " + stringBuffer + ": " + sQLException.getMessage());
        }
    }
}

