/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.OutputDetails;
import org.xml.sax.SAXException;

public class Outputter {
    private Emitter emitter;
    private OutputDetails outputDetails;
    private Name pendingStartTag = null;
    private AttributeCollection pendingAttList = new AttributeCollection(10);
    private String[] pendingNSList = new String[20];
    private int pendingNSListSize = 0;
    char[] charbuffer = new char[1024];

    public void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public Emitter getEmitter() throws SAXException {
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        return this.emitter;
    }

    public void setOutputDetails(OutputDetails outputDetails) throws SAXException {
        this.outputDetails = outputDetails;
        this.emitter.setOutputDetails(outputDetails);
    }

    public OutputDetails getOutputDetails() {
        return this.outputDetails;
    }

    public void setEscaping(boolean bl) throws SAXException {
        this.emitter.setEscaping(bl);
    }

    public void open() throws SAXException {
        this.emitter.startDocument();
    }

    public void write(String string) throws SAXException {
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        this.emitter.setEscaping(false);
        int n = string.length();
        if (n > this.charbuffer.length) {
            this.charbuffer = new char[n];
        }
        string.getChars(0, n, this.charbuffer, 0);
        this.emitter.characters(this.charbuffer, 0, n);
        this.emitter.setEscaping(true);
    }

    public void writeContent(String string) throws SAXException {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n > this.charbuffer.length) {
            this.charbuffer = new char[n];
        }
        string.getChars(0, n, this.charbuffer, 0);
        this.writeContent(this.charbuffer, 0, n);
    }

    public void writeContent(char[] cArray, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        this.emitter.characters(cArray, n, n2);
    }

    public void writeContent(StringBuffer stringBuffer, int n, int n2) throws SAXException {
        if (n2 == 0) {
            return;
        }
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        char[] cArray = new char[n2];
        stringBuffer.getChars(n, n + n2, cArray, 0);
        this.emitter.characters(cArray, 0, n2);
    }

    public void writeStartTag(Name name) throws SAXException {
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        this.pendingAttList.clear();
        this.pendingNSListSize = 0;
        this.pendingStartTag = name;
    }

    public void writeNamespaceDeclaration(String string, String string2, boolean bl) throws SAXException {
        if (this.pendingStartTag == null) {
            throw new SAXException("Cannot write a namespace declaration when there is no open start tag");
        }
        int n = 0;
        while (n < this.pendingNSListSize) {
            if (this.pendingNSList[n].equals(string)) {
                if (this.pendingNSList[n + 1].equals(string2) || !bl) {
                    return;
                }
                string = this.getSubstitutePrefix(string, string2);
                break;
            }
            n += 2;
        }
        if (this.pendingNSListSize + 2 > this.pendingNSList.length) {
            String[] stringArray = new String[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, stringArray, 0, this.pendingNSListSize);
            this.pendingNSList = stringArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = string;
        this.pendingNSList[this.pendingNSListSize++] = string2;
    }

    private String getSubstitutePrefix(String string, String string2) {
        return string + "." + (string2.hashCode() & 0xFFFFFF);
    }

    public void writeAttribute(Name name, String string) throws SAXException {
        this.writeAttribute(name, string, false);
    }

    public void writeAttribute(Name name, String string, boolean bl) throws SAXException {
        if (this.pendingStartTag == null) {
            throw new SAXException("Cannot write an attribute when there is no open start tag");
        }
        String string2 = name.getPrefix();
        String string3 = name.getURI();
        if (!string2.equals("")) {
            boolean bl2 = false;
            while (!bl2) {
                int n = 0;
                while (n < this.pendingNSListSize) {
                    if (this.pendingNSList[n + 1].equals(string3)) {
                        bl2 = true;
                        String string4 = this.pendingNSList[n];
                        if (string2.equals(string4)) break;
                        name = new Name(string4, string3, name.getLocalName());
                        break;
                    }
                    n += 2;
                }
                if (bl2) continue;
                this.writeNamespaceDeclaration(string2, string3, true);
            }
        }
        this.pendingAttList.setAttribute(name, bl ? "NO-ESC" : "CDATA", string);
    }

    public void writeEndTag(Name name) throws SAXException {
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        this.emitter.endElement(name);
    }

    public void writeComment(String string) throws SAXException {
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        this.emitter.comment(string.toCharArray(), 0, string.length());
    }

    public void writePI(String string, String string2) throws SAXException {
        if (this.pendingStartTag != null) {
            this.flushStartTag();
        }
        this.emitter.processingInstruction(string, string2);
    }

    public void close() throws SAXException {
        this.emitter.endDocument();
    }

    protected void flushStartTag() throws SAXException {
        int n = 0;
        while (n < this.pendingNSListSize) {
            String string = this.pendingNSList[n];
            String string2 = this.pendingNSList[n + 1];
            this.emitter.startPrefixMapping(string, string2);
            n += 2;
        }
        this.pendingNSListSize = 0;
        this.emitter.startElement(this.pendingStartTag, this.pendingAttList);
        this.pendingStartTag = null;
    }
}

