/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.output.ASCIICharacterSet;
import com.icl.saxon.output.CDATAFilter;
import com.icl.saxon.output.CharacterSet;
import com.icl.saxon.output.CharacterSetFactory;
import com.icl.saxon.output.DOMEmitter;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.ErrorEmitter;
import com.icl.saxon.output.HTMLEmitter;
import com.icl.saxon.output.HTMLIndenter;
import com.icl.saxon.output.OutputDetails;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.output.ProxyEmitter;
import com.icl.saxon.output.TEXTEmitter;
import com.icl.saxon.output.UncommittedEmitter;
import com.icl.saxon.output.XHTMLEmitter;
import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.output.XMLIndenter;
import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.xml.sax.SAXException;

public class OutputManager {
    private Stack outputterStack = new Stack();
    private Outputter currentOutputter;
    private static Writer dummyWriter = new StringWriter();

    public Outputter setOutputDetails(OutputDetails outputDetails) throws SAXException {
        Object object;
        Object object2;
        Object object3;
        Outputter outputter = new Outputter();
        String string = outputDetails.getMethod();
        if (string.equals("html")) {
            object3 = new HTMLEmitter();
            if (outputDetails.isIndenting()) {
                object2 = new HTMLIndenter();
                ((ProxyEmitter)object2).setUnderlyingEmitter((Emitter)object3);
                object3 = object2;
            }
        } else if (string.equals("xml")) {
            object3 = new XMLEmitter();
            if (outputDetails.isIndenting()) {
                object2 = new XMLIndenter();
                ((ProxyEmitter)object2).setUnderlyingEmitter((Emitter)object3);
                object3 = object2;
            }
            if (outputDetails.getCdataElements().size() > 0) {
                object2 = new CDATAFilter();
                ((ProxyEmitter)object2).setUnderlyingEmitter((Emitter)object3);
                object3 = object2;
            }
        } else if (string.equals("text")) {
            object3 = new TEXTEmitter();
        } else if (string.equals("xhtml")) {
            object3 = new XHTMLEmitter();
            if (outputDetails.isIndenting()) {
                object2 = new HTMLIndenter();
                ((ProxyEmitter)object2).setUnderlyingEmitter((Emitter)object3);
                object3 = object2;
            }
            if (outputDetails.getCdataElements().size() > 0) {
                object2 = new CDATAFilter();
                ((ProxyEmitter)object2).setUnderlyingEmitter((Emitter)object3);
                object3 = object2;
            }
        } else if (string.equals("saxon:user")) {
            object3 = outputDetails.getEmitter();
        } else if (string.equals("saxon:fragment")) {
            object3 = outputDetails.getEmitter();
            outputDetails.setIndent("no");
            outputDetails.setWriter(dummyWriter);
        } else if (string.equals("saxon:uncommitted")) {
            object3 = new UncommittedEmitter();
        } else if (string.equals("saxon:dom")) {
            object3 = new DOMEmitter();
            outputDetails.setWriter(dummyWriter);
            if (outputDetails.getDOMNode() == null) {
                throw new SAXException("Output to DOM requested, but no DOM Node supplied");
            }
        } else if (string.equals("saxon:error")) {
            object3 = new ErrorEmitter();
            outputDetails.setWriter(dummyWriter);
        } else {
            object3 = new UncommittedEmitter();
        }
        outputter.setEmitter((Emitter)object3);
        object3.setOutputDetails(outputDetails);
        object2 = outputDetails.getWriter();
        String string2 = outputDetails.getEncoding();
        if (string2 == null) {
            string2 = "UTF8";
        }
        if (string2.equalsIgnoreCase("utf-8")) {
            string2 = "UTF8";
        }
        if (object2 == null) {
            object = outputDetails.getOutputStream();
            if (object == null) {
                object = System.out;
                outputDetails.setCloseAfterUse(false);
            }
            while (true) {
                try {
                    object2 = new BufferedWriter(new OutputStreamWriter((OutputStream)object, string2));
                }
                catch (Exception exception) {
                    if (string2.equalsIgnoreCase("UTF8")) {
                        throw new SAXException("Failed to create a UTF8 output writer");
                    }
                    System.err.println("Encoding " + string2 + " is not supported: using UTF8");
                    string2 = "UTF8";
                    continue;
                }
                break;
            }
        }
        object3.setWriter((Writer)object2);
        outputter.setOutputDetails(outputDetails);
        object = CharacterSetFactory.makeCharacterSet(string2);
        if (object == null) {
            object = new ASCIICharacterSet();
        }
        object3.setCharacterSet((CharacterSet)object);
        this.currentOutputter = outputter;
        this.outputterStack.push(outputter);
        outputter.open();
        return outputter;
    }

    public OutputDetails getOutputDetails() {
        return this.currentOutputter.getOutputDetails();
    }

    public Outputter getOutputter() {
        return this.currentOutputter;
    }

    public Outputter resetOutputDetails() throws SAXException {
        if (this.currentOutputter == null) {
            throw new SAXException("No outputter has been allocated");
        }
        this.outputterStack.pop();
        this.currentOutputter.close();
        if (this.outputterStack.isEmpty()) {
            return null;
        }
        this.currentOutputter = (Outputter)this.outputterStack.peek();
        return this.currentOutputter;
    }
}

