/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.AttributeCollection;
import com.icl.saxon.om.Name;
import com.icl.saxon.output.XMLEmitter;
import java.io.IOException;
import org.xml.sax.SAXException;

public class DTDEmitter
extends XMLEmitter {
    private String current = null;
    private boolean openSquare = false;

    protected void writeDocType(String string, String string2, String string3) throws SAXException {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(Name name, AttributeCollection attributeCollection) throws SAXException {
        String string = name.getURI();
        String string2 = name.getLocalName();
        try {
            if (string.equals("http://icl.com/saxon/dtd")) {
                if ("doctype".equals(this.current) && !this.openSquare) {
                    this.writer.write(" [");
                    this.openSquare = true;
                }
                if (string2.equals("doctype")) {
                    if (this.current != null) {
                        throw new SAXException("dtd:doctype can only appear at top level of DTD");
                    }
                    String string3 = attributeCollection.getValue("name");
                    String string4 = attributeCollection.getValue("system");
                    String string5 = attributeCollection.getValue("public");
                    if (string3 == null) {
                        throw new SAXException("dtd:doctype must have a name attribute");
                    }
                    this.writer.write("<!DOCTYPE " + string3 + " ");
                    if (string4 != null) {
                        if (string5 != null) {
                            this.writer.write("PUBLIC \"" + string5 + "\" \"" + string4 + "\"");
                        } else {
                            this.writer.write("SYSTEM \"" + string4 + "\"");
                        }
                    }
                } else if (string2.equals("element")) {
                    if (!"doctype".equals(this.current)) {
                        throw new SAXException("dtd:element can only appear as child of dtd:doctype");
                    }
                    String string6 = attributeCollection.getValue("name");
                    String string7 = attributeCollection.getValue("content");
                    if (string6 == null) {
                        throw new SAXException("dtd:element must have a name attribute");
                    }
                    if (string7 == null) {
                        throw new SAXException("dtd:element must have a content attribute");
                    }
                    this.writer.write("\n  <!ELEMENT " + string6 + " " + string7 + " ");
                } else if (string2.equals("attlist")) {
                    if (!"doctype".equals(this.current)) {
                        throw new SAXException("dtd:attlist can only appear as child of dtd:doctype");
                    }
                    String string8 = attributeCollection.getValue("element");
                    if (string8 == null) {
                        throw new SAXException("dtd:attlist must have an attribute named 'element'");
                    }
                    this.writer.write("\n  <!ATTLIST " + string8 + " ");
                } else if (string2.equals("attribute")) {
                    if (!"attlist".equals(this.current)) {
                        throw new SAXException("dtd:attribute can only appear as child of dtd:attlist");
                    }
                    String string9 = attributeCollection.getValue("name");
                    String string10 = attributeCollection.getValue("type");
                    String string11 = attributeCollection.getValue("value");
                    if (string9 == null) {
                        throw new SAXException("dtd:attribute must have a name attribute");
                    }
                    if (string10 == null) {
                        throw new SAXException("dtd:attribute must have a type attribute");
                    }
                    if (string11 == null) {
                        throw new SAXException("dtd:attribute must have a value attribute");
                    }
                    this.writer.write("\n    " + string9 + " " + string10 + " " + string11);
                } else if (string2.equals("entity")) {
                    if (!"doctype".equals(this.current)) {
                        throw new SAXException("dtd:entity can only appear as child of dtd:doctype");
                    }
                    String string12 = attributeCollection.getValue("name");
                    String string13 = attributeCollection.getValue("parameter");
                    String string14 = attributeCollection.getValue("system");
                    String string15 = attributeCollection.getValue("public");
                    String string16 = attributeCollection.getValue("notation");
                    if (string12 == null) {
                        throw new SAXException("dtd:entity must have a name attribute");
                    }
                    this.writer.write("\n  <!ENTITY ");
                    if ("yes".equals(string13)) {
                        this.writer.write("% ");
                    }
                    this.writer.write(string12 + " ");
                    if (string14 != null) {
                        if (string15 != null) {
                            this.writer.write("PUBLIC \"" + string15 + "\" \"" + string14 + "\" ");
                        } else {
                            this.writer.write("SYSTEM \"" + string14 + "\" ");
                        }
                    }
                    if (string16 != null) {
                        this.writer.write("NDATA " + string16 + " ");
                    }
                } else {
                    if (!string2.equals("notation")) throw new SAXException("Unrecognized element " + name + " in DTD output");
                    if (!"doctype".equals(this.current)) {
                        throw new SAXException("dtd:notation can only appear as a child of dtd:doctype");
                    }
                    String string17 = attributeCollection.getValue("name");
                    String string18 = attributeCollection.getValue("system");
                    String string19 = attributeCollection.getValue("public");
                    if (string17 == null) {
                        throw new SAXException("dtd:notation must have a name attribute");
                    }
                    if (string18 == null && string19 == null) {
                        throw new SAXException("dtd:notation must have a system attribute or a public attribute");
                    }
                    this.writer.write("\n  <!NOTATION " + string17);
                    if (string19 != null) {
                        this.writer.write(" PUBLIC \"" + string19 + "\" ");
                        if (string18 != null) {
                            this.writer.write("\"" + string18 + "\" ");
                        }
                    } else {
                        this.writer.write(" SYSTEM \"" + string18 + "\" ");
                    }
                }
            } else {
                if (!this.current.equals("entity")) {
                    throw new SAXException("Unrecognized element " + name + " in DTD output");
                }
                super.startElement(name, attributeCollection);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
        this.current = string2;
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        if (!"http://icl.com/saxon/dtd".equals(string2)) {
            super.startPrefixMapping(string, string2);
        }
    }

    public void endElement(Name name) throws SAXException {
        String string = name.getURI();
        String string2 = name.getLocalName();
        try {
            if (string.equals("http://icl.com/saxon/dtd")) {
                if (string2.equals("doctype")) {
                    if (this.openSquare) {
                        this.writer.write("\n]");
                        this.openSquare = false;
                    }
                    this.writer.write(">\n");
                    this.current = null;
                } else if (string2.equals("element")) {
                    this.writer.write(">");
                    this.current = "doctype";
                } else if (string2.equals("attlist")) {
                    this.writer.write(">");
                    this.current = "doctype";
                } else if (string2.equals("attribute")) {
                    this.current = "attlist";
                } else if (string2.equals("entity")) {
                    this.writer.write(">");
                    this.current = "doctype";
                } else if (string2.equals("notation")) {
                    this.writer.write(">");
                    this.current = "doctype";
                }
            } else {
                super.endElement(name);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }
}

