/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.DOMDriver;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.expr.NodeSetValue;
import com.icl.saxon.expr.SingletonNodeSet;
import com.icl.saxon.expr.Value;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.trax.URIResolver;
import com.icl.saxon.tree.Builder;
import com.icl.saxon.tree.DocumentImpl;
import java.util.Vector;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Document
extends Function {
    private Controller boundController = null;

    public String getName() {
        return "document";
    }

    public int getDataType() {
        return 4;
    }

    public int getIntrinsicDependencies() {
        if (this.boundController == null) {
            return 64;
        }
        return 0;
    }

    protected Expression reduceIntrinsic(int n, Context context) throws SAXException {
        int n2 = this.checkArgumentCount(1, 2);
        if ((n & 0x40) != 0) {
            Document document = new Document();
            document.addArgument((Expression)this.arguments.elementAt(0));
            if (n2 == 2) {
                document.addArgument((Expression)this.arguments.elementAt(1));
            }
            document.boundController = context.getController();
            document.setStaticContext(this.getStaticContext());
            return document;
        }
        return this;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(1, 2);
        Value value = (Value)vector.elementAt(0);
        Value value2 = null;
        if (n == 2 && !((value2 = (Value)vector.elementAt(1)) instanceof NodeSetValue)) {
            throw new SAXException("Second argument to document() must be a nodeset");
        }
        String string = this.getStaticContext().getSystemId();
        return this.getDocuments(value, (NodeSetValue)value2, string, context);
    }

    public NodeSetValue getDocuments(Value value, NodeSetValue nodeSetValue, String string, Context context) throws SAXException {
        Object object;
        if (value instanceof NodeSetValue) {
            NodeInfo[] nodeInfoArray = ((NodeSetValue)value).getNodes();
            Vector<NodeInfo> vector = new Vector<NodeInfo>(nodeInfoArray.length);
            int n = 0;
            while (n < nodeInfoArray.length) {
                NodeInfo nodeInfo;
                NodeInfo nodeInfo2 = nodeInfoArray[n];
                String string2 = nodeSetValue == null ? nodeInfo2.getSystemId() : ((nodeInfo = nodeSetValue.getFirst()) == null ? nodeInfo2.getSystemId() : nodeInfo.getSystemId());
                nodeInfo = this.makeDoc(nodeInfo2.getValue(), string2, context);
                if (nodeInfo != null) {
                    vector.addElement(nodeInfo);
                }
                ++n;
            }
            return new NodeSetExtent(vector);
        }
        String string3 = nodeSetValue == null ? string : ((object = nodeSetValue.getFirst()) == null ? string : object.getSystemId());
        object = value.asString();
        DocumentInfo documentInfo = this.makeDoc((String)object, string3, context);
        return new SingletonNodeSet(documentInfo);
    }

    private DocumentInfo makeDoc(String string, String string2, Context context) throws SAXException {
        Object object;
        if (string2 == null) {
            throw new SAXException("No base URI available for resolving relative URI");
        }
        Controller controller = this.boundController;
        if (controller == null) {
            controller = context.getController();
        }
        if (controller == null) {
            throw new SAXException("Internal error: no controller available for document() function");
        }
        URIResolver uRIResolver = controller.getURIResolver();
        uRIResolver.setURI(string2, string);
        String string3 = uRIResolver.getURI();
        DocumentInfo documentInfo = (DocumentInfo)controller.getDocumentPool().get(string3);
        if (documentInfo != null) {
            return documentInfo;
        }
        InputSource inputSource = uRIResolver.getInputSource();
        XMLReader xMLReader = uRIResolver.getXMLReader();
        if (inputSource == null) {
            object = uRIResolver.getDOMNode();
            if (object == null) {
                controller.reportRecoverableError("Cannot retrieve document " + string, null);
                return null;
            }
            xMLReader = new DOMDriver();
            ((DOMDriver)xMLReader).setStartNode((Node)object);
            inputSource = new InputSource();
            inputSource.setSystemId(string3);
        }
        object = new Builder();
        ((Builder)object).setStripper(controller.getStripper());
        ((Builder)object).setLineNumbering(controller.isLineNumbering());
        if (xMLReader != null) {
            ((Builder)object).setXMLReader(xMLReader);
        }
        DocumentImpl documentImpl = ((Builder)object).build(inputSource);
        controller.getDocumentPool().put(string3, documentImpl);
        return documentImpl;
    }
}

