/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.axis;

import com.icl.saxon.NameTest;
import com.icl.saxon.axis.AxisEnumeration;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.NamespaceInfo;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.tree.ElementImpl;
import com.icl.saxon.tree.NamespaceImpl;
import java.util.Vector;
import org.xml.sax.SAXException;

class NamespaceEnumeration
extends AxisEnumeration {
    private ElementInfo element;
    private Vector nslist;
    private int index;
    private int length;

    public NamespaceEnumeration(NodeInfo nodeInfo, int n, NameTest nameTest) throws SAXException {
        super(nodeInfo, n, nameTest);
        if (nodeInfo instanceof ElementInfo) {
            this.element = (ElementInfo)nodeInfo;
            this.nslist = new Vector(10);
            this.element.addNamespaceNodes(this.element, this.nslist, null);
            this.nslist.addElement(new NamespaceImpl((ElementImpl)this.element, "xml", "http://www.w3.org/XML/1998/namespace", this.nslist.size() + 1));
            this.index = -1;
            this.length = this.nslist.size();
            this.advance();
        } else {
            this.next = null;
        }
    }

    public void step() throws SAXException {
        ++this.index;
        this.next = this.index < this.length ? (NamespaceInfo)this.nslist.elementAt(this.index) : null;
    }

    protected boolean conforms(NodeInfo nodeInfo) throws SAXException {
        if (nodeInfo == null) {
            return true;
        }
        NamespaceInfo namespaceInfo = (NamespaceInfo)nodeInfo;
        if (namespaceInfo.getNamespacePrefix().equals("") && namespaceInfo.getNamespaceURI().equals("")) {
            return false;
        }
        return this.nodeName.isNameOf(nodeInfo);
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isPeer() throws SAXException {
        return true;
    }
}

