/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT44Transmit.h"

#include "common/Exception.h"
#include "common/NCO.h"
#include "common/SoundFile.h"

#include "jt44/JT44Lookups.h"
#include "jt44/JT44Defs.h"

#include <wx/debug.h>
#include <wx/log.h>

int main(int argc, char **argv)
{
	if (argc < 3) {
		::fprintf(stderr, "Usage: JT44Transmit <filename> <message>\n");
		return 0;
	}

	wxString fileName = wxString(argv[1]);
	wxString message  = wxString(argv[2]);

	try {
		ISoundDev* soundDev = new CSoundFile(fileName, JT44_SAMPLE_RATE, 8);

		CJT44Transmit transmit(soundDev, message);
		transmit.run();
	}
	catch (CException& ex) {
		::fprintf(stderr, "Error: %s\n", ex.getMessage().c_str());
		return 1;
	}

	catch (...) {
		::fprintf(stderr, "An Exception has occurred\n");
		return 1;
	}

	return 0;
}

CJT44Transmit::CJT44Transmit(ISoundDev* soundDev, wxString& message) :
m_soundDev(soundDev),
m_message(message)
{
	wxASSERT(m_soundDev != NULL);
}

CJT44Transmit::~CJT44Transmit()
{
}

void CJT44Transmit::run()
{
	wxASSERT(m_soundDev != NULL);

	m_soundDev->openWrite();

	m_message.resize(JT44_MESSAGE_LENGTH, wxT(' '));

	CJT44Lookups lookups;
	CNCO nco(JT44_SAMPLE_RATE, JT44_SEND_VOLUME);

	for (int i = 0; i < 135; i++) {
		int pos = lookups.lookupPosition(i);
		int tone;

		if (pos == -1) {
			tone = 118;
		} else {
			tone = lookups.lookupChar(m_message.GetChar(pos));

			if (tone == -1)
				tone = lookups.lookupChar(wxT(' '));
		}

		double freq, out[JT44_SYMBOL_LENGTH];

		freq = double(tone * 2) * double(JT44_SAMPLE_RATE) / double(JT44_SYMBOL_LENGTH);
		nco.generate(freq, out, JT44_SYMBOL_LENGTH);
		m_soundDev->write(out, JT44_SYMBOL_LENGTH);
	}

	m_soundDev->close();
}
