/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef JT6MReceive_H
#define	JT6MReceive_H

#include <wx/thread.h>

#include "JT6MDefs.h"
#include "JT6MLevels.h"
#include "JT6MMessage.h"

#include "common/Receive.h"
#include "common/SoundDev.h"
#include "common/Correlation.h"
#include "common/Average.h"
#include "common/FFT.h"

class CJT6MReceive : public CReceive {

    public:
	CJT6MReceive(const wxString& name, EWho who);
	virtual ~CJT6MReceive();

	virtual void reset(bool firstTime);
	virtual void run();

	virtual void       openSoundDevice() = 0;
	virtual ISoundDev* getSoundDevice() = 0;
	virtual void       closeSoundDevice() = 0;

	virtual bool getEndTime() = 0;

	virtual void recordAudio(const wxString& id, double* audioData, int length) const = 0;

	virtual wxString createId()  = 0;

    private:
	double*       m_audioSamples;
	double*       m_syncSamples;
	double*       m_binSamples[JT6M_ALPHABET_COUNT + 1];
	CCorrelation* m_correlations;
	int           m_samplesCount;
	CFFT          m_fft;

	void storeCorrelations(double* bins, int samplesCount);
	void createReceiveData() const;
	void findCorrelation(int& syncBin, int& timeOffset) const;
	void correlate(int syncBin, int& timeOffset) const;
	void decode(const wxString& id, int syncBin, int timeOffset);

	int  getCorrelationsIndex(int bin, int timeOffset) const;
};

#endif
