/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	FSK441Message_H
#define	FSK441Message_H

#include <wx/wx.h>

class CFSK441Message {

    public:
	CFSK441Message(const wxString& id, double time, int length, int strength, int DF, const wxString& text);
	virtual ~CFSK441Message();

	virtual wxString getId() const;
	virtual double   getTime() const;
	virtual int      getLength() const;
	virtual int      getStrength() const;
	virtual int      getDF() const;
	virtual wxString getText() const;

    private:
	wxString m_id;
	double   m_time;
	int      m_length;
	int      m_strength;
	int      m_DF;
	wxString m_text;
};

WX_DECLARE_LIST(CFSK441Message, CFSK441MessageList);

#endif
