/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.xhtml;

import writer2latex.office.OfficeReader;
import writer2latex.office.OfficeStyleFamily;
import writer2latex.office.StyleWithProperties;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.xhtml.Converter;
import writer2latex.xhtml.StyleWithPropertiesConverterHelper;

public class ParStyleConverter
extends StyleWithPropertiesConverterHelper {
    private String[] sHeadingStyles = new String[7];

    public ParStyleConverter(OfficeReader ofr, Config config, Converter converter, int nType) {
        super(ofr, config, converter, nType);
        this.styleMap = config.getXParStyleMap();
        this.bConvertStyles = config.xhtmlFormatting() == 4 || config.xhtmlFormatting() == 7;
        this.bConvertHard = config.xhtmlFormatting() == 4 || config.xhtmlFormatting() == 6;
    }

    public void setHeadingStyle(int nLevel, String sStyleName) {
        if (this.sHeadingStyles[nLevel] == null) {
            this.sHeadingStyles[nLevel] = sStyleName;
        }
    }

    public String getStyleDeclarations(String sIndent) {
        StringBuffer buf = new StringBuffer();
        buf.append(super.getStyleDeclarations(sIndent));
        if (this.bConvertStyles) {
            int i = 1;
            while (i <= 6) {
                StyleWithProperties style;
                if (this.sHeadingStyles[i] != null && (style = this.ofr.getParStyle(this.sHeadingStyles[i])) != null) {
                    CSVList props = new CSVList(";");
                    this.applyProperties(style, props, true);
                    props.addValue("clear", "left");
                    buf.append(sIndent).append("h").append(i).append(" {").append(props.toString()).append("}\n");
                }
                ++i;
            }
        }
        return buf.toString();
    }

    public OfficeStyleFamily getStyles() {
        return this.ofr.getParStyles();
    }

    public String getDefaultTagName(StyleWithProperties style) {
        return "p";
    }

    public void applyProperties(StyleWithProperties style, CSVList props, boolean bInherit) {
        this.getFrameSc().cssMargins(style, props, bInherit);
        this.getFrameSc().cssBorder(style, props, bInherit);
        this.getFrameSc().cssPadding(style, props, bInherit);
        this.getFrameSc().cssBackgroundCommon(style, props, bInherit);
        this.cssPar(style, props, bInherit);
        this.getTextSc().cssTextCommon(style, props, bInherit);
    }

    public String getTextBackground(String sStyleName) {
        CSVList props = new CSVList(";");
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style != null) {
            this.getTextSc().cssTextBackground(style, props, true);
        }
        return props.toString();
    }

    public String getRealParStyleName(String sStyleName) {
        if (sStyleName == null) {
            return sStyleName;
        }
        StyleWithProperties style = this.ofr.getParStyle(sStyleName);
        if (style == null || !style.isAutomatic()) {
            return sStyleName;
        }
        return style.getParentName();
    }

    public void cssPar(StyleWithProperties style, CSVList props, boolean bInherit) {
        String s = style.getParProperty("fo:background-color", bInherit);
        if (s != null) {
            props.addValue("background-color", s);
        }
        if (bInherit || style.getProperty("fo:text-indent", false) != null) {
            s = style.getAbsoluteProperty("fo:text-indent");
            if (s != null) {
                props.addValue("text-indent", this.scale(s));
            } else {
                s = style.getProperty("style:auto-text-indent");
                if ("true".equals(s)) {
                    props.addValue("text-indent", "2em");
                }
            }
        }
        if ((s = style.getProperty("fo:text-align", bInherit)) != null) {
            if (s.equals("start")) {
                s = "left";
            } else if (s.equals("end")) {
                s = "right";
            }
            props.addValue("text-align", s);
        }
        if (this.ofr.isSpreadsheet()) {
            s = style.getProperty("fo:wrap-option", bInherit);
            if ("no-wrap".equals(s)) {
                props.addValue("white-space", "nowrap");
            } else if ("wrap".equals(s)) {
                props.addValue("white-space", "normal");
            }
        }
    }
}

