/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.latex;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Stack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import writer2latex.latex.ConverterHelper;
import writer2latex.latex.ConverterPalette;
import writer2latex.latex.LaTeXDocumentPortion;
import writer2latex.latex.util.BeforeAfter;
import writer2latex.latex.util.Context;
import writer2latex.office.OfficeReader;
import writer2latex.util.CSVList;
import writer2latex.util.Config;
import writer2latex.util.Misc;
import writer2latex.xmerge.EmbeddedObject;
import writer2latex.xmerge.EmbeddedXMLObject;

public class DrawConverter
extends ConverterHelper {
    private boolean bNeedGraphicx = false;
    private Stack floatingFramesStack = new Stack();

    private Element getFrame(Element onode) {
        if (this.ofr.isOpenDocument()) {
            return (Element)onode.getParentNode();
        }
        return onode;
    }

    public DrawConverter(OfficeReader ofr, Config config, ConverterPalette palette) {
        super(ofr, config, palette);
        this.floatingFramesStack.push(new LinkedList());
    }

    public void appendDeclarations(LaTeXDocumentPortion pack, LaTeXDocumentPortion decl) {
        if (this.bNeedGraphicx) {
            pack.append("\\usepackage");
            if (this.config.getBackend() == 2) {
                pack.append("[pdftex]");
            } else if (this.config.getBackend() == 1) {
                pack.append("[dvips]");
            }
            pack.append("{graphicx}").nl();
        }
    }

    public void handleCaption(Element node, LaTeXDocumentPortion ldp, Context oc) {
        LaTeXDocumentPortion capLdp = new LaTeXDocumentPortion(true);
        if (oc.isInFigureFloat()) {
            capLdp.append("\\caption");
            this.palette.getCaptionCv().handleCaptionBody(node, capLdp, oc, false);
        } else {
            capLdp.append("\\captionof{figure}");
            this.palette.getCaptionCv().handleCaptionBody(node, capLdp, oc, true);
        }
        this.flushFloatingFrames(ldp, oc);
        ldp.append(capLdp);
    }

    public void handleDrawElement(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sName = node.getTagName();
        if (sName.equals("draw:object")) {
            this.handleDrawObject(node, ldp, oc);
        } else if (sName.equals("draw:object-ole")) {
            this.handleDrawObject(node, ldp, oc);
        } else if (!oc.isInHeaderFooter() && sName.equals("draw:image")) {
            this.handleDrawImage(node, ldp, oc);
        } else if (!oc.isInHeaderFooter() && sName.equals("draw:text-box")) {
            this.handleDrawTextBox(node, ldp, oc);
        } else if (sName.equals("draw:a")) {
            this.palette.getFieldCv().handleAnchor(node, ldp, oc);
        } else if (sName.equals("draw:frame")) {
            this.handleDrawElement(Misc.getFirstChildElement(node), ldp, oc);
        } else {
            ldp.append("[Warning: Draw object ignored]");
        }
    }

    private void handleDrawObject(Element node, LaTeXDocumentPortion ldp, Context oc) {
        String sHref = Misc.getAttribute(node, "xlink:href");
        if (sHref != null) {
            if (this.ofr.isInPackage(sHref)) {
                EmbeddedObject object;
                if (sHref.startsWith("#")) {
                    sHref = sHref.substring(1);
                }
                if (sHref.startsWith("./")) {
                    sHref = sHref.substring(2);
                }
                if ((object = this.palette.getEmbeddedObject(sHref)) != null) {
                    if ("application/vnd.sun.xml.math".equals(object.getType()) || "application/vnd.oasis.opendocument.formula".equals(object.getType())) {
                        try {
                            Document settings = ((EmbeddedXMLObject)object).getSettingsDOM();
                            Document formuladoc = ((EmbeddedXMLObject)object).getContentDOM();
                            Element formula = Misc.getChildByTagName(formuladoc, "math:math");
                            ldp.append(" $").append(this.palette.getMathmlCv().convert(settings, formula)).append("$");
                            if (Character.isLetterOrDigit(this.getNextChar(node))) {
                                ldp.append(" ");
                            }
                        }
                        catch (SAXException e) {
                            e.printStackTrace();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    } else {
                        Element replacementImage;
                        boolean bIgnore = true;
                        if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(node), "draw:image")) != null) {
                            this.handleDrawImage(replacementImage, ldp, oc);
                            bIgnore = false;
                        }
                        if (bIgnore) {
                            ldp.append("[Warning: object ignored]");
                        }
                    }
                }
            }
        } else {
            Element formula = Misc.getChildByTagName(node, "math:math");
            if (formula != null) {
                ldp.append(" $").append(this.palette.getMathmlCv().convert(null, formula)).append("$");
                if (Character.isLetterOrDigit(this.getNextChar(node))) {
                    ldp.append(" ");
                }
            } else {
                Element replacementImage;
                boolean bIgnore = true;
                if (this.ofr.isOpenDocument() && (replacementImage = Misc.getChildByTagName(this.getFrame(node), "draw:image")) != null) {
                    this.handleDrawImage(replacementImage, ldp, oc);
                    bIgnore = false;
                }
                if (bIgnore) {
                    ldp.append("[Warning: object ignored]");
                }
            }
        }
    }

    private void applyFigureFloat(BeforeAfter ba, Context oc) {
        if (this.config.floatFigures() && !oc.isInFrame() && !oc.isInTable()) {
            if (oc.isInMulticols()) {
                ba.add("\\begin{figure*}", "\\end{figure*}\n");
            } else {
                ba.add("\\begin{figure}", "\\end{figure}\n");
            }
            if (this.config.getFloatOptions().length() > 0) {
                ba.add("[" + this.config.getFloatOptions() + "]", "");
            }
            ba.add("\n", "");
            oc.setInFigureFloat(true);
        }
        if (!oc.isInFrame() && this.config.alignFrames()) {
            ba.add("\\begin{center}\n", "\n\\end{center}\n");
        }
    }

    private void handleDrawImage(Element node, LaTeXDocumentPortion ldp, Context oc) {
        switch (this.config.imageContent()) {
            case 0: {
                return;
            }
            case 2: {
                System.err.println("Warning: Images are not allowed");
                return;
            }
            case 3: {
                ldp.append("% Error in document: An image was ignored");
                return;
            }
        }
        Element frame = this.getFrame(node);
        String sName = frame.getAttribute("draw:name");
        this.palette.getFieldCv().addTarget(frame, "|graphics", ldp);
        String sAnchor = frame.getAttribute("text:anchor-type");
        if ("as-char".equals(sAnchor)) {
            this.handleDrawImageAsChar(node, ldp, oc);
        } else {
            ((LinkedList)this.floatingFramesStack.peek()).add(node);
        }
    }

    private void handleDrawImageAsChar(Element node, LaTeXDocumentPortion ldp, Context oc) {
        ldp.append(" ");
        this.includeGraphics(node, ldp, oc);
        ldp.append(" ");
    }

    private void handleDrawImageFloat(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Context ic = (Context)oc.clone();
        BeforeAfter ba = new BeforeAfter();
        this.applyFigureFloat(ba, ic);
        ldp.append(ba.getBefore());
        this.includeGraphics(node, ldp, ic);
        ldp.append(ba.getAfter());
    }

    /*
     * Unable to fully structure code
     */
    private void includeGraphics(Element node, LaTeXDocumentPortion ldp, Context oc) {
        block18: {
            block17: {
                sFileName = null;
                bCommentOut = true;
                sHref = node.getAttribute("xlink:href");
                if (!node.hasAttribute("xlink:href") || this.ofr.isInPackage(sHref)) break block17;
                sFileName = sHref;
                if (this.ofr.isOpenDocument() && this.ofr.isPackageFormat() && sFileName.startsWith("../")) {
                    sFileName = sFileName.substring(3);
                }
                v0 = sExt = (nExtStart = sHref.lastIndexOf(".")) >= 0 ? sHref.substring(nExtStart).toLowerCase() : "";
                if (sFileName.indexOf(":") > -1) ** GOTO lbl-1000
                if (this.config.getBackend() != 3) {
                    if (this.config.getBackend() != 2 || !".jpg".equals(sExt)) {
                        if (this.config.getBackend() != 2 || !".png".equals(sExt)) {
                            ** if (this.config.getBackend() == 1 && ".eps".equals((Object)sExt)) goto lbl-1000
                        }
                    }
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v1 = true;
                    ** GOTO lbl22
                }
lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
lbl22:
                // 2 sources

                bCommentOut = v1;
                break block18;
            }
            bgd = this.palette.getImageLoader().getImage(node);
            if (bgd == null) break block18;
            this.palette.addDocument(bgd);
            sFileName = bgd.getFileName();
            sMIME = bgd.getDocumentMIMEType();
            if (this.config.getBackend() == 3) ** GOTO lbl-1000
            if (this.config.getBackend() == 2 && "image/jpeg".equals(sMIME)) ** GOTO lbl-1000
            if (this.config.getBackend() == 2 && "image/png".equals(sMIME)) ** GOTO lbl-1000
            if (this.config.getBackend() != 1 || !"image/x-eps".equals(sMIME)) {
                v2 = true;
            } else lbl-1000:
            // 4 sources

            {
                v2 = bCommentOut = false;
            }
        }
        if (sFileName == null) {
            ldp.append("[Warning: Image not found]");
            return;
        }
        this.bNeedGraphicx = true;
        if (bCommentOut) {
            ldp.append(" [Warning: Image ignored] ");
            ldp.append("% Unhandled or unsupported graphics:").nl().append("%");
        }
        ldp.append("\\includegraphics");
        options = new CSVList(',');
        if (!this.config.keepImageSize()) {
            frame = this.getFrame(node);
            sWidth = Misc.truncateLength(frame.getAttribute("svg:width"));
            sHeight = Misc.truncateLength(frame.getAttribute("svg:height"));
            if (sWidth != null) {
                options.addValue("width=" + sWidth);
            }
            if (sHeight != null) {
                options.addValue("height=" + sHeight);
            }
        }
        if (this.config.getImageOptions().length() > 0) {
            options.addValue(this.config.getImageOptions());
        }
        if (!options.isEmpty()) {
            ldp.append("[").append(options.toString()).append("]");
        }
        if (this.config.removeGraphicsExtension()) {
            sFileName = Misc.removeExtension(sFileName);
        }
        ldp.append("{").append(sFileName).append("}");
        if (bCommentOut) {
            ldp.nl();
        }
    }

    private void handleDrawTextBox(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Element frame = this.getFrame(node);
        String sName = frame.getAttribute("draw:name");
        this.palette.getFieldCv().addTarget(frame, "|frame", ldp);
        String sAnchor = frame.getAttribute("text:anchor-type");
        if ("as-char".equals(sAnchor)) {
            this.makeDrawTextBox(node, ldp, oc);
        } else {
            ((LinkedList)this.floatingFramesStack.peek()).add(node);
        }
    }

    private void handleDrawTextBoxFloat(Element node, LaTeXDocumentPortion ldp, Context oc) {
        BeforeAfter ba = new BeforeAfter();
        Context ic = (Context)oc.clone();
        this.applyFigureFloat(ba, ic);
        ldp.append(ba.getBefore());
        this.makeDrawTextBox(node, ldp, ic);
        ldp.append(ba.getAfter());
    }

    private void makeDrawTextBox(Element node, LaTeXDocumentPortion ldp, Context oc) {
        Element par;
        String sSeqName;
        Context ic = (Context)oc.clone();
        ic.setInFrame(true);
        ic.setNoFootnotes(true);
        boolean bIsCaption = false;
        if (OfficeReader.isSingleParagraph(node) && this.ofr.isFigureSequenceName(sSeqName = this.ofr.getSequenceName(par = Misc.getFirstChildElement(node)))) {
            bIsCaption = true;
        }
        String sWidth = Misc.truncateLength(this.getFrame(node).getAttribute("svg:width"));
        if (!bIsCaption) {
            ldp.append("\\begin{minipage}{").append(sWidth).append("}").nl();
        }
        this.floatingFramesStack.push(new LinkedList());
        this.palette.getBlockCv().traverseBlockText(node, ldp, ic);
        this.flushFloatingFrames(ldp, ic);
        this.floatingFramesStack.pop();
        if (!bIsCaption) {
            ldp.append("\\end{minipage}");
        }
        if (!oc.isNoFootnotes()) {
            this.palette.getNoteCv().flushFootnotes(ldp, oc);
        }
    }

    public void flushFloatingFrames(LaTeXDocumentPortion ldp, Context oc) {
        LinkedList floatingFrames = (LinkedList)this.floatingFramesStack.peek();
        int n = floatingFrames.size();
        if (n == 0) {
            return;
        }
        int i = 0;
        while (i < n) {
            Element node = (Element)floatingFrames.get(i);
            String sName = node.getNodeName();
            if (sName.equals("draw:image")) {
                this.handleDrawImageFloat(node, ldp, oc);
            } else if (sName.equals("draw:text-box")) {
                this.handleDrawTextBoxFloat(node, ldp, oc);
            }
            ++i;
        }
        floatingFrames.clear();
    }

    private Node getNextNode(Node node) {
        if (node.getNodeType() == 1 && node.hasChildNodes()) {
            if (!OfficeReader.isDrawElement(node)) {
                if (!OfficeReader.isNoteElement(node)) {
                    return node.getFirstChild();
                }
            }
        }
        Node next = node;
        do {
            if (next.getNextSibling() != null) {
                return next.getNextSibling();
            }
            if ((next = next.getParentNode()).getNodeType() != 1 || !next.getNodeName().equals("text:p")) continue;
            return null;
        } while (next != null);
        return null;
    }

    private char getNextChar(Node node) {
        Node next = node;
        do {
            if ((next = this.getNextNode(next)) == null || next.getNodeType() != 3 || next.getNodeValue().length() <= 0) continue;
            return next.getNodeValue().charAt(0);
        } while (next != null);
        return '\u0000';
    }
}

