///////////////////////////////////////////////////////////////////////////////
//
// Wall Paper Changer for GNOME
// Copyright (C) 2000-2001  Kenichi Shibata <ken_s@cat.zero.ad.jp>
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// Please read the file "COPYING" for more information.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
///////////////////////////////////////////////////////////////////////////////
//
// ken_s@cat.zero.ad.jp
// http://www3.might.co.jp/~sibata/top/
//
///////////////////////////////////////////////////////////////////////////////

#define __MAIN_H
#include "global.h"

// static
static GtkWidget *sMain_dialog;
static GtkWidget *sApplet;

////////////////////////////////////////////////////////
//                                                    //
//  Wall paper changer main function                  //
//                                                    //
////////////////////////////////////////////////////////
int main (int argc, char *argv[])
{
#ifdef ENABLE_NLS
  bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
  textdomain (PACKAGE);
#endif
  sApplet = create_applet(argc, argv);

  sMain_dialog = NULL;
  wpac_load_file();
  wpac_change_wallpaper();
  initial_wpac_timer();

  applet_widget_gtk_main ();
  wpac_quit();

  return 0;
}

////////////////////////////////////////////////////////
//                                                    //
//  Main dialog create                                //
//                                                    //
//    Parameter                                       //
//      void                                          //
//    Return                                          //
//      void                                          //
//                                                    //
////////////////////////////////////////////////////////
void mainDialog_create(void)
{
  //  GtkWidget *toggle_button;

  ///toggle_button = get_widget(sApplet, "applet_toggle_button");
  if (sMain_dialog == NULL) {
    sMain_dialog = create_main_dialog ();
    main_dialog_init();
    //gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle_button), TRUE);
    //    enable_mainAppletChild("applet_toggle_button", FALSE);
    enable_mainDialogChild("del_button", FALSE);
    gtk_grab_add(sMain_dialog);
    gtk_widget_show(sMain_dialog);
  }
}

////////////////////////////////////////////////////////
//                                                    //
//  Main dialog destroy                               //
//                                                    //
//    Parameter                                       //
//      void                                          //
//    Return                                          //
//      void                                          //
//                                                    //
////////////////////////////////////////////////////////
void mainDialog_destroy(void)
{
  //  GtkWidget *toggle_button;

  //  toggle_button = get_widget(sApplet, "applet_toggle_button");

  if (sMain_dialog != NULL) {
    //    gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(toggle_button), FALSE);
    //enable_mainAppletChild("applet_toggle_button", TRUE);
    gtk_widget_destroy(sMain_dialog);
    sMain_dialog = NULL;
  }
}

////////////////////////////////////////////////////////
//                                                    //
//  Get Main dialog child widget                      //
//                                                    //
//    Parameter                                       //
//      name : Widget name                            //
//    Return                                          //
//      void                                          //
//                                                    //
////////////////////////////////////////////////////////
GtkWidget *get_mainDialogChild(gchar *name)
{
  return (get_widget(sMain_dialog, name));
}

////////////////////////////////////////////////////////
//                                                    //
//  Main dialog widget enable                         //
//                                                    //
//    Parameter                                       //
//      widgetName : Widget name                      //
//      eneble     : TRUE  = Enable                   //
//                   FALSE = Disable                  //
//    Return                                          //
//      GtkWidget* : widget pointer                   //
//                                                    //
////////////////////////////////////////////////////////
GtkWidget *enable_mainDialogChild(gchar *widgetName, gboolean enable)
{
  GtkWidget *widget;
  
  widget = lookup_widget(GTK_WIDGET(sMain_dialog), widgetName);
  if (GTK_IS_WIDGET(widget)) {
    
    if (GTK_WIDGET_SENSITIVE(widget) && (enable == FALSE)) {
      gtk_widget_set_sensitive(widget, FALSE);
    } else if (!GTK_WIDGET_SENSITIVE(widget) && (enable == TRUE)) {
      gtk_widget_set_sensitive(widget, TRUE);
    }
  }
  return (widget);
}

////////////////////////////////////////////////////////
//                                                    //
//  Applet child widget enable                        //
//                                                    //
//    Parameter                                       //
//      widgetName : Widget name                      //
//      eneble     : TRUE  = Enable                   //
//                   FALSE = Disable                  //
//    Return                                          //
//      GtkWidget* : widget pointer                   //
//                                                    //
////////////////////////////////////////////////////////
//static GtkWidget *enable_mainAppletChild(gchar *widgetName, gboolean enable)
//{
//  GtkWidget *widget;
//  
//  widget = lookup_widget(GTK_WIDGET(sApplet), widgetName);
//  if (GTK_IS_WIDGET(widget)) {
//    
//    if (GTK_WIDGET_SENSITIVE(widget) && (enable == FALSE)) {
//      gtk_widget_set_sensitive(widget, FALSE);
//    } else if (!GTK_WIDGET_SENSITIVE(widget) && (enable == TRUE)) {
//      gtk_widget_set_sensitive(widget, TRUE);
//    }
//  }
//  return (widget);
//}
//
////////////////////////////////////////////////////////
//                                                    //
//  Decimal String to gulong                          //
//                                                    //
//    Parameter                                       //
//      str : string                                  //
//    Return                                          //
//      gulong                                        //
//                                                    //
////////////////////////////////////////////////////////
gulong d_to_gulong(gchar *str)
{
  gulong ret;

  ret = 0L;
  while (*str) {
    ret = (ret * 10L) + ((*str) - '0');
    str++;
  }
  return (ret);
}

////////////////////////////////////////////////////////
//                                                    //
//  Is Digit String ?                                 //
//                                                    //
//    Parameter                                       //
//      str : string                                  //
//    Return                                          //
//      gboolean : TRUE  = digit                      //
//                 FALSE = not digit                  //
//                                                    //
////////////////////////////////////////////////////////
gboolean isDigitStr(gchar *str)
{
  gint  i, len;

  len = strlen(str);
  for (i=0; i<len; i++) {
    if (isdigit(str[i]))
      continue;
    if (str[i] == ' ')
      continue;
    if (str[i] == '\t')
      continue;
    if (str[i] == ',')
      continue;
    return (FALSE);
  }
  return (TRUE);
}

////////////////////////////////////////////////////////
//                                                    //
//  String to digit string                            //
//                                                    //
//    Parameter                                       //
//      str : string                                  //
//    Return                                          //
//      void                                          //
//                                                    //
////////////////////////////////////////////////////////
void toDigitStr(gchar *str)
{
  gint  i, bi, len;
  gchar buff[256];

  len = strlen(str);
  for (i=0, bi=0; i<len; i++) {
    if (isdigit(str[i]))
      buff[bi++] = str[i];
  }
  buff[bi] = (gchar)NULL;
  strcpy(str, buff);
}

