/* fontreq.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fontreq.h,v 1.2 2001/11/03 17:10:07 ralf Exp $ */

#ifndef FONTREQ_H
#define FONTREQ_H

#include <aguix/listview.h>
#include <aguix/text.h>

const static struct request_fonts {
  char *name;
  enum { SCALEABLE, FIXED } type;
  char *xname;
  int size; } use_fonts[]={ { "default", request_fonts::FIXED, "fixed", 8},
		            { "9x15", request_fonts::FIXED, "9x15", 9},
		            { "10x20", request_fonts::FIXED, "10x20", 10},
		            { "12x24", request_fonts::FIXED, "12x24", 12},
		            { "fixed", request_fonts::SCALEABLE, "-misc-fixed-medium-r-*-*-%d-*-*-*-*-*-*-*", 0},
		            { "fixed bold", request_fonts::SCALEABLE, "-misc-fixed-bold-*-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier", request_fonts::SCALEABLE, "-adobe-courier-medium-r-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier bold", request_fonts::SCALEABLE, "-adobe-courier-bold-r-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier italic", request_fonts::SCALEABLE, "-adobe-courier-medium-o-*-*-%d-*-*-*-*-*-*-*", 0},
                            { "courier bold italic", request_fonts::SCALEABLE, "-adobe-courier-bold-o-*-*-%d-*-*-*-*-*-*-*", 0}
                          };

#define FONTREQ_MINSIZE 8
#define FONTREQ_STEPSIZE 2
#define FONTREQ_STEPS 20

class FontRequester
{
public:
  FontRequester(class AGUIX *parent);
  ~FontRequester();
  int request(char *xname,char**return_xname);
private:
  class AGUIX *aguix;
  ListView *lv,*lv2;
  Text *ftext,*etext,*text1;
  Button *okb,*cb,*xb;
  AWindow *win;
  List *fontlist;
  
  void showsizes(int i);
  void updatefont();
  int getsize(int i,int j);
  int findfont(const char *xn,int *return_i, int *return_j);
};

#endif

