/* filereq.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: filereq.h,v 1.5 2002/02/06 19:12:18 ralf Exp $ */

#ifndef FILEREQ_H
#define FILEREQ_H

#include "datei.h"
#include <string>

class AGUIX;
class List;
class ListView;
class StringGadget;

class FileRequester
{
public:
  FileRequester(AGUIX *parent);
  ~FileRequester();
  int request(char *title,char *dir,char *oktext,char *canceltext,char *infotext);
  int request_entry( char *title,
                     char *dir,
                     char *oktext,
                     char *canceltext,
                     char *infotext,
                     bool allowEnterName );
  FileEntry *getFirstFE();
  FileEntry *getNextFE();
  std::string getLastEntryStr();
private:
  AGUIX *aguix;
  List *selfes;
  char *actdir;
  Verzeichnis *verz;
  std::string last_entry_str;
  
  ListView *lv;
  StringGadget *sg;
  void setDir(const char *);
  void setDirOneSelect(const char *);
  void reset();
};

#endif
