/***************************************************************************
                          libidp.cpp  -  description
                             -------------------
    begin                : Fri Oct 5 2001
    copyright            : (C) 2001 by Ricardo Villalba
    email                : rvm@escomposlinux.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "libidp.h"
#include <iostream.h>
#include <stdio.h>

string conv_idp="a/e/i/o/u/a\\e\\i\\o\\u\\n~a.e.i.o.u."
                "a^e^i^o^u^";

string convierte_idp(const string & linea, bool codifica) {
	string resultado = linea;
	
	string orig;
	string res;

	for (unsigned int n=0; n < conv_idp.length(); n+=3) {
		orig = conv_idp.substr( n, 2 );
		res = conv_idp.substr( n+2, 1 );
		
		//printf("orig='%s', res='%s'\n", orig.c_str(), res.c_str() );
		
		if (!codifica) { // DECODIFICAR
			int index= resultado.find( orig, 0 );
			while (index != -1) {
				resultado.replace( index, 2, res );
				index= resultado.find( orig, 0 );
			}
		} else { //CODIFICAR
			int index= resultado.find( res, 0 );
			while (index != -1) {
				resultado.replace( index, 1, orig );
				index= resultado.find( res, 0 );
			}
		}
		
	}

	//Vamos a dejar el saparador tal cual por ahora.
	/*	
	if (!codifica) { //DECODIFICAR
		//Sustituye los <tabs> por " : ".
		int index= resultado.find( '\t', 0 );
		while (index != -1) {
			resultado.replace( index, 1, " : " );
			index= resultado.find( '\t', 0 );
		}
	} else { //CODIFICA
		//Sustituye los " : " por <tabs>.
		int index= resultado.find( " : ", 0 );
		while (index != -1) {
			resultado.replace( index, 3, "\t" );
			index= resultado.find( " : ", 0 );
		}
	}
	*/

	return resultado;
}

