/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000 Ricardo Villalba <rvm@linuxfan.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#include "QCuestionario.h"
#include "intern.h"
#include <qlayout.h>
#include <qlabel.h>
#include <qfile.h>
#include <qtextstream.h>
#include <qtooltip.h>
//#include <qclipboard.h>
//#include <qapplication.h>
#include "DiccionarioBase.h"
#include "qfunciones.h"
#include "qmensaje.h"


QCuestionario::QCuestionario
(
	QWidget* parent,
	const char* name
)
	:
	QDialog( parent, name, FALSE )
{
	setCaption( _("Wordtrans questionnaire") );


	editor= new QMultiLineEdit( this, "editor");
	editor->setFont( QFont( "courier", 12 ) );
	editor->setOverwriteMode( true );

	send_button = new QPushButton( this, "PushButton_1" );
	send_button->setText( _("&Send") );
	send_button->setDefault( true );
	connect( send_button, SIGNAL(clicked()), SLOT(enviar()) );
	QToolTip::add( send_button, 
		_("Send the text using the 'mail' command. Be sure you have it "
		  "installed and properly configured."));

	QPushButton* cancel_button;
	cancel_button = new QPushButton( this, "PushButton_2" );
	cancel_button->setText( _("&Cancel") );
	connect( cancel_button, SIGNAL(clicked()), SLOT(cancelar()) );
	
	QPushButton* copy_button;
	copy_button = new QPushButton( this, "PushButton_3" );
	connect( copy_button, SIGNAL(clicked()), SLOT(copiar_todo()) );
	copy_button->setText( _("Copy all &text to clipboard") );
	QToolTip::add( copy_button, 
		_("Copy all text to clipboard so you can paste it into your "
          "favorite mail reader."));

	QPushButton* add_info;
	add_info = new QPushButton( this, "add_info" );
	connect( add_info, SIGNAL(clicked()), SLOT(add_system_info()) );
	add_info->setText( _("&Add system info") );
	QToolTip::add( add_info, 
		_("Append some system info to the end of the questionnaire."));

	QLabel* label1;
	label1 = new QLabel( this, "Label_1" );
	label1->setText( 
		_("<p>A short questionnaire is included in wordtrans. "
          "I would appreciate if you could take some minutes "
          "to fill it. Your answers could help me improve this "
          "application.</p>"
		  "<p>This form will be send using the 'mail' command. If you don't "
		  "have install it (or you don't know) you may copy the text "
		  "and paste it into you favorite mail reader and sent it to "
		  "&lt;rvm@escomposlinux.org&gt;</p>"));
	label1->setAlignment( AlignLeft | AlignHCenter | WordBreak );
	//label1->setMargin(4);
	//label1->setLineWidth(1);
	label1->setFrameStyle( QFrame::Panel | QFrame::Sunken );

	QBoxLayout* layout_1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5 );
	//layout_1->addStrut( 0 );
	layout_1->addWidget( label1, 1, AlignTop ); //36 );
	layout_1->addWidget( editor, 15, 0 ); //AlignCenter ); //36 );


	QBoxLayout* botones = new QBoxLayout( QBoxLayout::LeftToRight, -1, NULL );
	layout_1->addLayout( botones, 1 );
	//botones->addStrut( 0 );
	botones->addStretch( 5 );
	botones->addWidget( add_info, 1, AlignRight );
	botones->addWidget( copy_button, 1, AlignRight ); //36 );
	botones->addSpacing( 15 );
	botones->addWidget( send_button, 1, AlignRight ); //36 );
	botones->addWidget( cancel_button, 1, AlignRight ); //36 );

	setMinimumSize( 400, 300 );
	setMaximumSize( 32767, 32767 );
	resize( 546, 396 );

	if (!load()) 
		editor->setText( _("It seems the questionnaire is not installed\n"
						"Please, install the wordtrans-doc package."));

	editor->setFocus();
}


QCuestionario::~QCuestionario()
{
	debug("Destruyendo QCuestionario");
	delete send_button;
	delete editor;
}


void QCuestionario::enviar() {
	send();

	close(TRUE);
}

void QCuestionario::copiar_todo() {
	//QApplication::clipboard()->setText( editor->text() );
	editor->selectAll();
	editor->copy();
}

void QCuestionario::cancelar() {
	//QSize s=size();
    //debug("ancho: %d, alto: %d", s.width(), s.height() );

	close(TRUE);
}


bool QCuestionario::load() {
	QCString orden="";
	QString fichero= _("/usr/share/doc/wordtrans-doc/questionnaire.txt");

	//Sin comprimir
	if ( QFile::exists(fichero) ) {
		orden="cat ";
	} else {
		fichero+=".gz";
		//Comprimido
		if ( QFile::exists(fichero) ) {
			orden="zcat ";
		}
	}

	if (orden.isEmpty()) return false;

	orden+= fichero.latin1();

	QString output;
	DiccionarioBase::exec_command( orden, output );
	editor->setText( output );

	return true;
}


bool QCuestionario::send() {
	debug("Saving questionnaire in /tmp/wordtrans.mail");
	QFile f( "/tmp/wordtrans.mail" );
	if (f.open(  IO_WriteOnly ) ) {
		QTextStream t( &f );
		t << editor->text();
		f.close();
	}

	debug("Sending mail using 'mail' command");
	int r=ejecuta("mail -s \"Wordtrans Questionnaire\" rvm@escomposlinux.org < /tmp/wordtrans.mail");
	//debug("Cdigo de retorno: %d", r );
	//if ((r==127) || (r==-1)) {
	if (r!=0) {
		debug("Error executing 'mail'");
		qmensaje(this, _("Error"), 
			_("Error sending mail. Mail not sent.\n"
			"The form has been saved in /tmp/wordtrans.mail"));
		return false;
	}

	QFile::remove( "/tmp/wordtrans.mail" );
	return true;
}

QString QCuestionario::leeFichero(const QString& fichero) {
	QString s=fichero+":\n";
	QFile f( fichero );
	if (f.open( IO_ReadOnly ) ) {
		QTextStream t( &f );
		s+=t.read();
		f.close();
	}
	s+="\n";
	return s;
}

void QCuestionario::add_system_info() {
	QString r= _("Some system info has been appended in the following lines.\n"
				 "You can delete it if you don't want to send it to me.\n"
				 "This information is only for statistics reasons.\n\n");

	r+= leeFichero("/proc/version");
	r+= leeFichero("/proc/cpuinfo");
	r+= leeFichero("/proc/meminfo");
	r+= leeFichero("/etc/debian_version");

	int last_line= editor->numLines();

	editor->append( r );
	editor->setCursorPosition( last_line, 0 );
}

