
#include "wnconsts.h"
#include "consts.h"
#include "typedef.h"
#include "extern.h"

static char *Id = "$Id: wnparse.y,v 1.43 2003/03/27 15:27:12 wn Exp $";

Pointer ptrlist = NULL;		/* keep track of ptrs in syngroup */
Framelist frlist = NULL;	/* keep track of frames in syngroup */
Synset lastss = NULL;		/* last synset in list */
Synonym lastsyn = NULL;		/* last synonym in this synset */
Symbol satellite = NULL;	/* satellite pointed to */
int headptr = FALSE;		/* indicate whether ptr is to head word */
int headword = FALSE;		/* indicate whether word is head word */
int foundhyper = FALSE;		/* indicate whether hypernym found in synset */
short wdcnt = 0;		/* index of current synonym in synset */
int aclass = 0;			/* keep track of adjective clss in syngroup */
int wsense = 0;			/* keep track of word's sense number */
int sense = 0;			/* keep track of sense number for ptrs */
int satellite_sense = 0;	/* sense number for pointer to satellite */
int cluscnt = 1;		/* count clusters (needed to resolve ptrs) */
char *label;
char buf[100];			/* useful buffer for building messages */
char fnbuf[100];		/* save cross-file pointer for warning msg */

typedef union
#ifdef __cplusplus
	YYSTYPE
#endif
 {
    char *tx;			/* for definitions, WYRD print names */
    int number;			/* file #, sense # */
    Synset ss;			/* for pointers to sense space */
    Pointer p;			/* for pointers */
    Synonym s;			/* for synonyms */
    Symbol sym;			/* for pointer into symbol table */
    Framelist fr;		/* for frame lists */
} YYSTYPE;
# define NOUNSYNSET 257
# define VERBSYNSET 258
# define ADJSYNSET 259
# define ADVSYNSET 260
# define OPENCLUS 261
# define CLOSECLUS 262
# define DEFN 263
# define WYRD 264
# define HEADWYRD 265
# define VERBFRAMES 266
# define FILENAME 267
# define NUM 268
# define PTRSYM 269
# define ADJCLASS 270
# define SYNSET 271
# define SYNSETKEY 272

#include <inttypes.h>

#ifdef __STDC__
#include <stdlib.h>
#include <string.h>
#define	YYCONST	const
#else
#include <malloc.h>
#include <memory.h>
#define	YYCONST
#endif

#include <values.h>

#if defined(__cplusplus) || defined(__STDC__)

#if defined(__cplusplus) && defined(__EXTERN_C__)
extern "C" {
#endif
#ifndef yyerror
#if defined(__cplusplus)
	void yyerror(YYCONST char *);
#endif
#endif
#ifndef yylex
	int yylex(void);
#endif
	int yyparse(void);
#if defined(__cplusplus) && defined(__EXTERN_C__)
}
#endif

#endif

#define yyclearin yychar = -1
#define yyerrok yyerrflag = 0
extern int yychar;
extern int yyerrflag;
YYSTYPE yylval;
YYSTYPE yyval;
typedef int yytabelem;
#ifndef YYMAXDEPTH
#define YYMAXDEPTH 150
#endif
#if YYMAXDEPTH > 0
int yy_yys[YYMAXDEPTH], *yys = yy_yys;
YYSTYPE yy_yyv[YYMAXDEPTH], *yyv = yy_yyv;
#else	/* user does initial allocation */
int *yys;
YYSTYPE *yyv;
#endif
static int yymaxdepth = YYMAXDEPTH;
# define YYERRCODE 256

static void AddToSynList();
static Synset MakeSynset(int, Synonym, Pointer, Framelist, char *, int);
static Synonym AddSynonym(Synonym, Synonym);
static Pointer AddPointer(Pointer, Pointer);
static Synonym InsertSynonym(Synonym, Synonym);
static void AddSynset(Synset);
static void AddToSynList(Synset);
static void MakeSyngroup(Pointer, Framelist);
static Pointer DoPointer(Symbol, int);
static int UniqueSynonym(Synonym, Synonym);
static int UniquePointer(Pointer, Pointer);
static int UniqueSynSense(Synonym, int);
static int UniqueFanSynonym(Synonym, int, int);
static char *UseLabel(char *);

static Synset MakeSynset(int type, Synonym syns, Pointer ptrs,
			 Framelist frames, char *defn, int key)
{
    register Synonym syn;
    register Pointer p;
    Synset ss;
    Framelist f;
    
    wdcnt = 0;			/* reset word counter for next synset */
    lastsyn = NULL;		/* reset pointer to last synonym */

    if (!syns) {
	yywarn("No valid synonyms: synset discarded\n");
	return(NULL);
    } else if (type == VERB && !frames) {
	yyerror("No frame list in verb synset: synset discarded\n");
	return(NULL);
    } else if (type == NOUN && foundhyper == FALSE) {
	yywarn("No hypernyms in synset\n");
	if (verifyflag)
	    errcount--;		/* don't count as real error */
    }
    foundhyper = FALSE;

    /* Link in any pointers and frame lists found in syngroups. */
    
    if (ptrlist) {
	if (ptrs) {
	    for (p = ptrs; p->pnext; p = p->pnext);
	    p->pnext = ptrlist;
	} else {
	    ptrs = ptrlist;
	}
	ptrlist = NULL;
    }
    
    if (frlist) {
	if (frames)
	    frames->fnext = frlist;
	else
	    frames = frlist;
	frlist = NULL;
    }

    ss = CreateSynset((unsigned char)type, syns, ptrs, frames, defn, key,
		      yylineno, curfilenum());

    /* Add pointer to the synset to each synonym in it.  Make sure
       that the synonym is unique (using sense number) within the file. */

    for (syn = syns; syn; syn = syn->synnext) {
	if ((type != SATELLITE && !UniqueSynSense(syn, FALSE)) ||
	    (type == SATELLITE && (curfilenum() != 0) &&
	     !UniqueSynSense(syn, TRUE))) {
	    if (syn->sensenum)
		sprintf(buf,
			"Synonym \"%s%d\" is not unique in file\n",
			syn->word->label, syn->sensenum);
	    else
		sprintf(buf,
			"Synonym \"%s\" is not unique in file\n",
			syn->word->label);
	    yyerror(buf);
	}
	syn->ss = ss;
	syn->infanss = (type == SATELLITE) ? TRUE : FALSE;
    }

    return(ss);
}

static Synonym AddSynonym(Synonym syns, Synonym newsyn)
{
    register Synonym s;

    /* Add synonym to end of list.  First make sure this synonym
       is unique within the synset. */
    
    if (UniqueSynonym(syns, newsyn)) {
	if (syns) {
	    for (s = syns; s->synnext; s = s->synnext);	/* find end of list */
	    s->synnext = newsyn;
	} else
	    syns = newsyn;
	
	lastsyn = newsyn;	/* save last synonym in synset for errors */
    } else {
	if (newsyn->sensenum)
	    sprintf(buf,
		    "Synonym \"%s%d\" is not unique in synset\n",
		    newsyn->word->label, newsyn->sensenum);
	else
	    sprintf(buf,
		    "Synonym \"%s\" is not unique in synset\n",
		    newsyn->word->label);
	yyerror(buf);
	free(newsyn);		/* free up space */
    }
    if (newsyn->sensenum > 16) {
	sprintf(buf,
		"Sense number must be less than 16: \"%s%d\" - changed to %d\n",
		newsyn->word->label, newsyn->sensenum, newsyn->sensenum % 16);
	yywarn(buf);
    }

    return(syns);
}

static Pointer AddPointer(Pointer ptrs, Pointer newptr)
{
    register Pointer p;
    extern int nominalizations;

    /* Discard nominalization pointer if we're skipping nominalizations */

    if (!nominalizations && (newptr->ptype == DERIVATION) ) {
	free(newptr);
	return (ptrs);
    }

    if (UniquePointer(ptrs, newptr)) {
	if (ptrs) {
	    for (p = ptrs; p->pnext; p = p->pnext);	/* find end of list */
	    p->pnext = newptr;
	} else
	    ptrs = newptr;
    } else {
	if (newptr->pfilenum != curfilenum()) {
	    sprintf(buf,
		    "Pointer \"%s:%s\" is not unique: pointer discarded\n",
		    PrintFileName(newptr->pfilenum), PrintPointer(newptr));
	} else {
	    sprintf(buf, "Pointer \"%s\" is not unique: pointer discarded\n",
		    PrintPointer(newptr));
	}
	yywarn(buf);
	free(newptr);		/* free up space */
    }

    return(ptrs);
}

static Synonym InsertSynonym(Synonym syns, Synonym newsyn)
{
    /* Insert synonym onto front of list.  First make sure this synonym
       is unique within the synset. */
    
    if (UniqueSynonym(syns, newsyn)) {
	newsyn->synnext = syns;
	syns = newsyn;
    } else {
	if (newsyn->sensenum)
	    sprintf(buf,
		    "Synonym \"%s%d\" is not unique in synset\n",
		    newsyn->word->label, newsyn->sensenum);
	else
	    sprintf(buf,
		    "Synonym \"%s\" is not unique in synset\n",
		    newsyn->word->label);
	yyerror(buf);
	free(newsyn);		/* free up space */
    }
    return(syns);
}

static void AddSynset(Synset ss)
{
    register Synset fan;
    register Synonym fansyn;
    int svlineno;
    
    if (headss == NULL)
	headss = ss;
    else
	lastss->ssnext = ss;
    lastss = ss;		/* set current end of list to this synset  */

    AddToSynList(ss);		/* update synlists for words in synset */

    /* If a cluster, make fans point back to head synset and check for
       use of a HEADWORD in a fan. */

    for (fan = ss->fans; fan; fan = fan->ssnext) {
	for (fansyn = fan->syns; fansyn; fansyn = fansyn->synnext)
	    if (!UniqueFanSynonym(fansyn, ss->clusnum, fan->lineno)) {
		sprintf(buf,
			"\"%s\" is not unique in this cluster\n",
			fansyn->word->label);
		svlineno = yylineno;
		yylineno = fan->lineno;
		yyerror(buf);
		yylineno = svlineno;
	    }
	fan->fans = ss;
    }
}    

static void AddToSynList(Synset ss)
{
    register Synonym syn;
    register SynList sl;
    int unique;

    /* For all words in this synset, add a pointer to this synset to
       the word's list of pointers to synsets containing the word.
       (confusing, but if you read it slowly, it makes sense) */

    for (syn = ss->syns; syn; syn = syn->synnext) {

	/* First, make sure that a pointer to this word in this
	   synset isn't already on the list.  This can occur if there
	   are multiple spellings of a word in a synset.  If only
	   one occurrence in the synset is added to the list, only
	   one pointer to this synset will be output in the index
	   file, and pointer resolution will be easier since we
	   don't have to weed out multiples. */

	unique = TRUE;

	for (sl = syn->word->syns; sl; sl = sl->snext)
	    if (sl->psyn->ss == syn->ss) {
		unique = FALSE;
		break;
	    }
	if (unique) {
	    if (sl = (SynList)malloc(sizeof(Synl))) {
		sl->psyn = syn;	/* add this synonym to list */
		sl->snext = syn->word->syns;
		syn->word->syns = sl;
	    } else {
		fprintf(logfile, "Cannot malloc space for sslist\n");
		exit(-1);
	    }
	}
    }
}

static void MakeSyngroup(Pointer ptrs, Framelist frame)
{
    register Pointer p, lp;
    register int wc;

    wc = wdcnt + 1;		/* count this word */
    
    /* Set the word count for all pointers specific to this word.
       Note that since the lists of pointers and synonyms are built
       with the last entry first, the word count counts from the
       wrong direction.  Once the number of words in the synset is
       known, the word counts are adjusted. */
    
    if (ptrs) {
	for (p = ptrs; p; p = p->pnext) {
	    p->fromwdnum = (headword ? -wc : wc);
	    lp = p;
	}
	if (!ptrlist) {
	    ptrlist = ptrs;
	} else {
	    lp->pnext = ptrlist;
	    ptrlist = ptrs;
	}
    }
    
    if (frame) {
	frame->frwdnum = wc;
	if (!frlist)
	    frlist = frame;
	else {
	    frame->fnext = frlist;
	    frlist = frame;
	}
    }
}

static Pointer DoPointer(Symbol sym, int ptrtype)
{
    Pointer p = NULL;
    int mode, fn;
    char ptrbuf[100];
    static int pmode[] = { 0, P_NOUN, P_VERB, P_ADJ, P_ADV };
    extern int nominalizations;

   /* Discard nominalization pointer if we're skipping nominalizations */

    if (!nominalizations && (ptrtype == DERIVATION) ) {
	return (NULL);
    }
    
    /* used later to make sure NOUN synset has HYPERNYM */
    if (ptrtype == HYPERPTR)
	foundhyper = TRUE;

    fn = (fnbuf[0] ? filenum(fnbuf) : curfilenum());
    mode=filemode(fn);

    p = CreatePointer(sym,
		      satellite,
		      (unsigned char)fn,
		      (unsigned char)sense,
		      (unsigned char)satellite_sense,
		      (unsigned char)ptrtype,
		      ALLWORDS, ALLWORDS);

    p->phead = headptr;

    if (mode && (legalptrs[ptrtype] & pmode[mode])) {
	return(p);
    } else {			/* Construct pretty error message & print it */
	if (fnbuf[0])
	    sprintf(ptrbuf, "\"%s:", fnbuf);
	else
	    sprintf(ptrbuf, "\"");

	sprintf(ptrbuf + strlen(ptrbuf), "%s\"", PrintPointer(p));

	if (!mode) { /* Don't print this message if only verifyng files */
	    if (!verifyflag) {
		sprintf(buf,
			"Pointer to unknown file %s: pointer discarded\n",
			ptrbuf);
		yywarn(buf);
	    }
	} else if (!legalptrs[ptrtype]) {
	    sprintf(buf,
		    "Invalid pointer type %s in %s file: pointer discarded\n",
		    ptrbuf, partnames[curfilemode()]);
	    yywarn(buf);
	} else if (!(legalptrs[ptrtype] & pmode[mode])) {
	    sprintf(buf,
		    "%s can't point to a %s file: pointer discarded\n",
		    ptrbuf, partnames[mode]);
	    yywarn(buf);
	} else {
	    sprintf(buf, "Error in pointer %s: pointer discarded\n", ptrbuf);
	    yywarn(buf);
	}
	free(p);
	return(NULL);
    }
}

static int UniqueSynonym(Synonym syns, Synonym syn)
{
    register Synonym s;

    /* check for uniqueness within this synset */

    for (s = syns; s; s = s->synnext)
	if (s->word == syn->word) {
	    if (s->label || syn->label)
		continue;	/* alternate spelling, ok. */
	    else
		return(0);
	}
    return(1);
}

static int UniquePointer(Pointer ptrs, Pointer ptr)
{
    register Pointer p;

    for (p = ptrs; p; p = p->pnext)
	if (p->pword == ptr->pword &&
	    p->psensenum == ptr->psensenum &&
	    p->pfilenum == ptr->pfilenum &&
	    p->ptype == ptr->ptype &&
	    p->fromwdnum == ptr->fromwdnum &&
	    p->towdnum == ptr->towdnum &&
	    p->phead == ptr->phead)
	    return(0);


    return(1);
}

static int UniqueSynSense(Synonym syn, int test)
{
    register SynList sl;
    
    for (sl = syn->word->syns; sl; sl = sl->snext)
	if ((sl->psyn->sensenum == syn->sensenum) &&
	    (sl->psyn->ss->filenum == curfilenum()) &&
	    (sl->psyn->infanss == test))
	    return(0);

    return(1);
}

static int UniqueFanSynonym(Synonym syn, int clusnum, int lineno)
{
    register SynList sl;

    for (sl = syn->word->syns; sl; sl = sl->snext)
	if ((sl->psyn->ss->clusnum == clusnum) &&
	    (sl->psyn->sensenum == syn->sensenum) && 
	    (sl->psyn->ss->lineno != lineno))
#ifdef FOOP
	if ((sl->psyn->ss->part == ADJ) && /* word is an adjective */
	    (!sl->psyn->infanss) && /* word is in a cluster head */
	    (sl->psyn->ss->clusnum == clusnum)) /* word is in same cluster */
#endif
	    return(0);

    return(1);
}

static char *UseLabel(char *s)
{
    register int i = 0;
    register char *ls;

    /* Decide if string is lower case or not */

    ls = strlower(s);
    while (*(s + i)) {
	if (*(s + i) != *(ls + i))
	    return(s);
	i++;
    }
    return(NULL);
}

/*
  Revision Log: (since version 1.5)

  $Log: wnparse.y,v $
  Revision 1.43  2003/03/27 15:27:12  wn
  changed NOMIN_START and NOMIN_END with DERIVATION

  Revision 1.42  2001/09/06 17:55:38  wn
  added code for synset keys

  Revision 1.41  2001/02/16 19:52:06  wn
  *** empty log message ***

  Revision 1.40  2000/10/27 16:53:29  wn
  fixed error message

  Revision 1.39  2000/07/11 15:23:59  wn
  added code to AddPointer to skip nominalization pointers if
  !nominalizations (-n not specified)

  Revision 1.38  1997/08/05 14:23:46  wn
  added function prototypes, other small cleanups

 * Revision 1.37  1996/05/30  20:56:48  wn
 * *** empty log message ***
 *
 * Revision 1.36  1995/07/28  21:29:19  wn
 * added check for wsense > MAXID (only 1 hex digit in databae allowed)
 *
 * Revision 1.35  1995/06/16  21:09:34  wn
 * fixed bug with adj head pointers
 *
 * Revision 1.34  1995/05/25  19:00:09  wn
 * added code to find senses taht are not unique in adj.pert files
 *
 * Revision 1.33  1995/02/14  18:50:40  wn
 * fixed bug in UniquePointer
 *
 * Revision 1.32  1995/02/14  18:24:49  wn
 * *** empty log message ***
 *
 * Revision 1.31  1995/02/07  21:40:17  wn
 * fixed bug in fan and changed NOUNSS to NOUN, etc.
 *
 * Revision 1.30  1994/09/27  19:50:46  wn
 * *** empty log message ***
 *
 * Revision 1.29  1994/04/27  09:49:02  wn
 * *** empty log message ***
 *
 * Revision 1.28  94/03/03  11:56:02  wn
 * no changes
 * 
 * Revision 1.27  93/07/08  16:23:35  wn
 * added test to find noun synsets which don't have hypernyms
 * 
 * Revision 1.26  93/04/21  12:40:33  wn
 * added new ATTRIBUTE pointer (=)
 * 
 * Revision 1.1  91/09/11  11:58:56  wn
 * Initial revision
 * 

*/
static YYCONST yytabelem yyexca[] ={
-1, 1,
	0, -1,
	-2, 0,
-1, 16,
	125, 42,
	-2, 0,
-1, 17,
	125, 42,
	-2, 0,
-1, 18,
	125, 42,
	-2, 0,
-1, 25,
	125, 42,
	-2, 0,
-1, 27,
	125, 42,
	-2, 0,
-1, 35,
	269, 28,
	-2, 24,
-1, 36,
	269, 30,
	-2, 26,
-1, 39,
	125, 42,
	-2, 0,
-1, 40,
	125, 42,
	-2, 0,
-1, 43,
	125, 42,
	-2, 0,
-1, 54,
	125, 42,
	-2, 0,
-1, 68,
	269, 29,
	-2, 25,
-1, 69,
	269, 31,
	-2, 27,
-1, 72,
	125, 42,
	-2, 0,
-1, 83,
	125, 42,
	-2, 0,
-1, 107,
	125, 42,
	-2, 0,
	};
# define YYNPROD 68
# define YYLAST 268
static YYCONST yytabelem yyact[]={

    34,    93,    63,    58,    63,    70,   126,   135,    99,   130,
    33,    59,    60,    42,    38,    75,    34,    58,    59,    60,
    42,    38,   124,   103,    33,    59,    60,    97,    38,    59,
    60,    96,    38,    46,    91,    90,    78,    69,    68,    15,
    52,     8,    66,    67,    53,   129,   117,    71,    15,    22,
    75,    75,    23,   132,    28,   123,   118,   111,   105,   102,
   101,    89,    88,    80,    77,    61,   116,    27,    40,    24,
    62,    20,    41,    44,    47,    94,    32,    16,    30,    51,
    55,     2,    56,    19,     6,    39,    43,    21,    17,    18,
     5,     4,    25,    54,    73,    74,     3,    49,    79,   134,
   128,    48,    29,     7,    57,    37,    50,     1,    72,    87,
     0,     0,     0,    65,     0,     0,    57,    26,    81,     0,
    57,     0,     0,    82,    85,     0,     0,   100,    83,     0,
     0,    57,    84,     0,    92,     0,    95,     0,   108,     0,
     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     0,   107,   109,     0,     0,     0,     0,   110,     0,     0,
     0,     0,   122,   114,   115,    31,     0,     0,     0,    58,
     0,     0,    33,    35,    36,    42,    38,    59,    60,    42,
    38,    31,    98,   127,    57,    58,    57,     0,    33,    35,
    36,    57,    38,    59,    60,     0,    38,     0,     0,     0,
     0,     0,     0,     0,    13,     9,    10,    14,    11,    12,
     0,     0,   104,     0,    53,   106,    14,     0,     0,     0,
     0,     0,     0,   112,   113,     0,    86,    76,    64,     0,
    64,     0,     0,     0,    33,     0,   119,   120,     0,     0,
   121,     0,     0,     0,     0,     0,   125,     0,     0,     0,
    45,     0,     0,   131,     0,     0,     0,     0,   133,     0,
     0,     0,    76,    76,     0,     0,     0,   136 };
static YYCONST yytabelem yypact[]={

-10000000,   -52,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,-10000000,
-10000000,-10000000,  -207,   -24,-10000000,   -43,   -75,   -91,   -75,   -12,
-10000000,   -43,   -43,   -51,-10000000,   -75,-10000000,  -239,   -60,-10000000,
   -40,-10000000,-10000000,-10000000,  -222,  -230,  -231,  -264,  -217,  -253,
   -29,   -61,  -232,  -239,   -62,-10000000,  -207,-10000000,   -43,-10000000,
-10000000,-10000000,  -221,   -42,  -239,   -63,   -64,-10000000,-10000000,  -233,
  -234,  -271,-10000000,-10000000,    31,   -40,  -237,  -241,-10000000,-10000000,
-10000000,   -86,   -29,   -65,   -66,  -245,-10000000,  -271,-10000000,   -67,
  -271,-10000000,-10000000,   -75,  -235,-10000000,   -40,   -68,  -271,  -271,
-10000000,-10000000,-10000000,-10000000,-10000000,  -246,-10000000,-10000000,   -28,  -218,
   -69,  -271,  -271,-10000000,-10000000,  -271,-10000000,  -239,   -70,   -71,
-10000000,  -271,-10000000,-10000000,   -87,     7,  -219,  -259,  -271,-10000000,
-10000000,-10000000,   -72,  -271,-10000000,-10000000,-10000000,     6,-10000000,  -261,
-10000000,-10000000,  -271,-10000000,-10000000,-10000000,-10000000 };
static YYCONST yytabelem yypgo[]={

     0,   107,    70,   134,    68,    54,    76,    67,    77,   106,
   105,    78,   102,    79,    96,    91,    90,    87,    71,   101,
    74,    84,    83,    81 };
static YYCONST yytabelem yyr1[]={

     0,     1,     1,    23,    23,    23,    23,    23,    23,    14,
    14,    15,    15,    15,    15,    16,    16,     8,     8,     8,
     8,    12,    12,    12,    11,    11,    11,    11,    10,    10,
    10,    10,    10,    10,    10,    10,    10,    10,     6,     7,
     7,     7,     5,     5,     3,     3,     2,     2,     4,     4,
     4,    21,    21,    22,    22,    18,    18,    20,    20,    19,
    19,    19,    17,    17,     9,     9,    13,    13 };
static YYCONST yytabelem yyr2[]={

     0,     4,     0,     3,     3,     3,     3,     3,     3,    13,
    11,    15,    13,    13,    11,    13,    11,     1,     5,     7,
     5,    11,    13,    11,     3,     5,     3,     5,     3,     5,
     3,     5,     5,     7,     9,    11,    13,    11,     5,     5,
     3,     5,     1,     3,     1,     3,     3,     5,     5,     7,
     5,     7,     5,     3,     7,     5,     5,     1,     5,    13,
    11,     5,    15,    13,     3,     9,     5,     7 };
static YYCONST yytabelem yychk[]={

-10000000,    -1,   -23,   -14,   -15,   -16,   -21,   -19,    93,   257,
   258,   260,   261,   256,   259,    91,    -8,    -8,    -8,   -22,
   -18,   -17,   256,   259,    93,    -8,   -19,    -7,    -5,   -12,
   -11,   256,    -6,   263,    91,   264,   265,   -10,   267,    -7,
    -4,    -5,   266,    -7,    -5,   262,    45,   -20,   -19,   -20,
    -9,   -13,    91,   265,    -7,    -5,    -5,    -6,   256,   264,
   265,   125,    -2,    44,   270,   -11,   264,   265,   268,   268,
   269,   264,    -4,    -5,    -5,    44,   256,   125,   268,    -5,
   125,   -18,   -20,    -8,   -13,    -2,   268,    -5,   125,   125,
   268,   268,    -3,   272,    44,    -2,   268,   268,   268,    94,
    -5,   125,   125,   268,    -3,   125,    -3,    -7,    -5,    -7,
    -2,   125,    -3,    -3,    -7,    -4,    94,   264,   125,    -3,
    -3,    -3,    -5,   125,    93,    -3,    93,    -4,    93,   264,
   268,    -3,   125,    -3,    93,   268,    -3 };
static YYCONST yytabelem yydef[]={

     2,    -2,     1,     3,     4,     5,     6,     7,     8,    17,
    17,    17,     0,     0,    17,     0,    -2,    -2,    -2,     0,
    53,    57,    57,     0,    52,    -2,    61,    -2,     0,    18,
     0,    20,    40,    43,     0,    -2,    -2,     0,     0,    -2,
    -2,     0,     0,    -2,     0,    51,     0,    55,    57,    56,
    17,    64,     0,     0,    -2,     0,     0,    39,    41,    28,
    30,    44,    19,    46,     0,     0,    24,    26,    -2,    -2,
    38,    32,    -2,     0,     0,     0,    50,    44,    48,     0,
    44,    54,    58,    -2,     0,    66,     0,     0,    44,    44,
    29,    31,    10,    45,    47,     0,    25,    27,    33,     0,
     0,    44,    44,    49,    14,    44,    16,    -2,     0,     0,
    67,    44,    60,     9,     0,     0,     0,    34,    44,    13,
    12,    15,     0,    44,    65,    59,    21,     0,    23,    35,
    37,    11,    44,    63,    22,    36,    62 };
typedef struct
#ifdef __cplusplus
	yytoktype
#endif
{ char *t_name; int t_val; } yytoktype;
#ifndef YYDEBUG
#	define YYDEBUG	0	/* don't allow debugging */
#endif

#if YYDEBUG

yytoktype yytoks[] =
{
	"NOUNSYNSET",	257,
	"VERBSYNSET",	258,
	"ADJSYNSET",	259,
	"ADVSYNSET",	260,
	"OPENCLUS",	261,
	"CLOSECLUS",	262,
	"DEFN",	263,
	"WYRD",	264,
	"HEADWYRD",	265,
	"VERBFRAMES",	266,
	"FILENAME",	267,
	"NUM",	268,
	"PTRSYM",	269,
	"ADJCLASS",	270,
	"SYNSET",	271,
	"SYNSETKEY",	272,
	"-unknown-",	-1	/* ends search */
};

char * yyreds[] =
{
	"-no such reduction-",
	"wordnet : wordnet wordelem",
	"wordnet : /* empty */",
	"wordelem : nss",
	"wordelem : vss",
	"wordelem : rss",
	"wordelem : acluster",
	"wordelem : fan",
	"wordelem : ']'",
	"nss : NOUNSYNSET syns ptrs defn '}' key",
	"nss : NOUNSYNSET syns defn '}' key",
	"vss : VERBSYNSET syns ptrs framelist defn '}' key",
	"vss : VERBSYNSET syns framelist defn '}' key",
	"vss : VERBSYNSET syns ptrs defn '}' key",
	"vss : VERBSYNSET syns defn '}' key",
	"rss : ADVSYNSET syns ptrs defn '}' key",
	"rss : ADVSYNSET syns defn '}' key",
	"syns : /* empty */",
	"syns : syns syngroup",
	"syns : syns syn adjclass",
	"syns : syns error",
	"syngroup : '[' syn adjclass ptrs ']'",
	"syngroup : '[' syn adjclass ptrs framelist ']'",
	"syngroup : '[' syn adjclass framelist ']'",
	"syn : WYRD",
	"syn : WYRD NUM",
	"syn : HEADWYRD",
	"syn : HEADWYRD NUM",
	"psyn : WYRD",
	"psyn : WYRD NUM",
	"psyn : HEADWYRD",
	"psyn : HEADWYRD NUM",
	"psyn : FILENAME WYRD",
	"psyn : FILENAME WYRD NUM",
	"psyn : FILENAME WYRD '^' WYRD",
	"psyn : FILENAME WYRD NUM '^' WYRD",
	"psyn : FILENAME WYRD NUM '^' WYRD NUM",
	"psyn : FILENAME WYRD '^' WYRD NUM",
	"ptr : psyn PTRSYM",
	"ptrs : ptrs ptr",
	"ptrs : ptr",
	"ptrs : ptrs error",
	"defn : /* empty */",
	"defn : DEFN",
	"key : /* empty */",
	"key : SYNSETKEY",
	"adjclass : ','",
	"adjclass : ADJCLASS ','",
	"framelist : VERBFRAMES NUM",
	"framelist : framelist ',' NUM",
	"framelist : framelist error",
	"acluster : OPENCLUS asslist CLOSECLUS",
	"acluster : error ']'",
	"asslist : ass",
	"asslist : asslist '-' ass",
	"ass : ahead fanlist",
	"ass : error fanlist",
	"fanlist : /* empty */",
	"fanlist : fan fanlist",
	"fan : ADJSYNSET syns ptrs defn '}' key",
	"fan : ADJSYNSET syns defn '}' key",
	"fan : '[' fan",
	"ahead : ADJSYNSET headsyn syns ptrs defn '}' key",
	"ahead : ADJSYNSET headsyn syns defn '}' key",
	"headsyn : headwyrd",
	"headsyn : '[' headwyrd ptrs ']'",
	"headwyrd : HEADWYRD adjclass",
	"headwyrd : HEADWYRD NUM adjclass",
};
#endif /* YYDEBUG */
/*
 * Copyright (c) 1993 by Sun Microsystems, Inc.
 */

#pragma ident	"@(#)yaccpar	6.16	99/01/20 SMI"

/*
** Skeleton parser driver for yacc output
*/

/*
** yacc user known macros and defines
*/
#define YYERROR		goto yyerrlab
#define YYACCEPT	return(0)
#define YYABORT		return(1)
#define YYBACKUP( newtoken, newvalue )\
{\
	if ( yychar >= 0 || ( yyr2[ yytmp ] >> 1 ) != 1 )\
	{\
		yyerror( "syntax error - cannot backup" );\
		goto yyerrlab;\
	}\
	yychar = newtoken;\
	yystate = *yyps;\
	yylval = newvalue;\
	goto yynewstate;\
}
#define YYRECOVERING()	(!!yyerrflag)
#define YYNEW(type)	malloc(sizeof(type) * yynewmax)
#define YYCOPY(to, from, type) \
	(type *) memcpy(to, (char *) from, yymaxdepth * sizeof (type))
#define YYENLARGE( from, type) \
	(type *) realloc((char *) from, yynewmax * sizeof(type))
#ifndef YYDEBUG
#	define YYDEBUG	1	/* make debugging available */
#endif

/*
** user known globals
*/
int yydebug;			/* set to 1 to get debugging */

/*
** driver internal defines
*/
#define YYFLAG		(-10000000)

/*
** global variables used by the parser
*/
YYSTYPE *yypv;			/* top of value stack */
int *yyps;			/* top of state stack */

int yystate;			/* current state */
int yytmp;			/* extra var (lasts between blocks) */

int yynerrs;			/* number of errors */
int yyerrflag;			/* error recovery flag */
int yychar;			/* current input token number */



#ifdef YYNMBCHARS
#define YYLEX()		yycvtok(yylex())
/*
** yycvtok - return a token if i is a wchar_t value that exceeds 255.
**	If i<255, i itself is the token.  If i>255 but the neither 
**	of the 30th or 31st bit is on, i is already a token.
*/
#if defined(__STDC__) || defined(__cplusplus)
int yycvtok(int i)
#else
int yycvtok(i) int i;
#endif
{
	int first = 0;
	int last = YYNMBCHARS - 1;
	int mid;
	wchar_t j;

	if(i&0x60000000){/*Must convert to a token. */
		if( yymbchars[last].character < i ){
			return i;/*Giving up*/
		}
		while ((last>=first)&&(first>=0)) {/*Binary search loop*/
			mid = (first+last)/2;
			j = yymbchars[mid].character;
			if( j==i ){/*Found*/ 
				return yymbchars[mid].tvalue;
			}else if( j<i ){
				first = mid + 1;
			}else{
				last = mid -1;
			}
		}
		/*No entry in the table.*/
		return i;/* Giving up.*/
	}else{/* i is already a token. */
		return i;
	}
}
#else/*!YYNMBCHARS*/
#define YYLEX()		yylex()
#endif/*!YYNMBCHARS*/

/*
** yyparse - return 0 if worked, 1 if syntax error not recovered from
*/
#if defined(__STDC__) || defined(__cplusplus)
int yyparse(void)
#else
int yyparse()
#endif
{
	register YYSTYPE *yypvt = 0;	/* top of value stack for $vars */

#if defined(__cplusplus) || defined(lint)
/*
	hacks to please C++ and lint - goto's inside
	switch should never be executed
*/
	static int __yaccpar_lint_hack__ = 0;
	switch (__yaccpar_lint_hack__)
	{
		case 1: goto yyerrlab;
		case 2: goto yynewstate;
	}
#endif

	/*
	** Initialize externals - yyparse may be called more than once
	*/
	yypv = &yyv[-1];
	yyps = &yys[-1];
	yystate = 0;
	yytmp = 0;
	yynerrs = 0;
	yyerrflag = 0;
	yychar = -1;

#if YYMAXDEPTH <= 0
	if (yymaxdepth <= 0)
	{
		if ((yymaxdepth = YYEXPAND(0)) <= 0)
		{
			yyerror("yacc initialization error");
			YYABORT;
		}
	}
#endif

	{
		register YYSTYPE *yy_pv;	/* top of value stack */
		register int *yy_ps;		/* top of state stack */
		register int yy_state;		/* current state */
		register int  yy_n;		/* internal state number info */
	goto yystack;	/* moved from 6 lines above to here to please C++ */

		/*
		** get globals into registers.
		** branch to here only if YYBACKUP was called.
		*/
	yynewstate:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;
		goto yy_newstate;

		/*
		** get globals into registers.
		** either we just started, or we just finished a reduction
		*/
	yystack:
		yy_pv = yypv;
		yy_ps = yyps;
		yy_state = yystate;

		/*
		** top of for (;;) loop while no reductions done
		*/
	yy_stack:
		/*
		** put a state and value onto the stacks
		*/
#if YYDEBUG
		/*
		** if debugging, look up token value in list of value vs.
		** name pairs.  0 and negative (-1) are special values.
		** Note: linear search is used since time is not a real
		** consideration while debugging.
		*/
		if ( yydebug )
		{
			register int yy_i;

			printf( "State %d, token ", yy_state );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ++yy_ps >= &yys[ yymaxdepth ] )	/* room on stack? */
		{
			/*
			** reallocate and recover.  Note that pointers
			** have to be reset, or bad things will happen
			*/
			long yyps_index = (yy_ps - yys);
			long yypv_index = (yy_pv - yyv);
			long yypvt_index = (yypvt - yyv);
			int yynewmax;
#ifdef YYEXPAND
			yynewmax = YYEXPAND(yymaxdepth);
#else
			yynewmax = 2 * yymaxdepth;	/* double table size */
			if (yymaxdepth == YYMAXDEPTH)	/* first time growth */
			{
				char *newyys = (char *)YYNEW(int);
				char *newyyv = (char *)YYNEW(YYSTYPE);
				if (newyys != 0 && newyyv != 0)
				{
					yys = YYCOPY(newyys, yys, int);
					yyv = YYCOPY(newyyv, yyv, YYSTYPE);
				}
				else
					yynewmax = 0;	/* failed */
			}
			else				/* not first time */
			{
				yys = YYENLARGE(yys, int);
				yyv = YYENLARGE(yyv, YYSTYPE);
				if (yys == 0 || yyv == 0)
					yynewmax = 0;	/* failed */
			}
#endif
			if (yynewmax <= yymaxdepth)	/* tables not expanded */
			{
				yyerror( "yacc stack overflow" );
				YYABORT;
			}
			yymaxdepth = yynewmax;

			yy_ps = yys + yyps_index;
			yy_pv = yyv + yypv_index;
			yypvt = yyv + yypvt_index;
		}
		*yy_ps = yy_state;
		*++yy_pv = yyval;

		/*
		** we have a new state - find out what to do
		*/
	yy_newstate:
		if ( ( yy_n = yypact[ yy_state ] ) <= YYFLAG )
			goto yydefault;		/* simple state */
#if YYDEBUG
		/*
		** if debugging, need to mark whether new token grabbed
		*/
		yytmp = yychar < 0;
#endif
		if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
			yychar = 0;		/* reached EOF */
#if YYDEBUG
		if ( yydebug && yytmp )
		{
			register int yy_i;

			printf( "Received token " );
			if ( yychar == 0 )
				printf( "end-of-file\n" );
			else if ( yychar < 0 )
				printf( "-none-\n" );
			else
			{
				for ( yy_i = 0; yytoks[yy_i].t_val >= 0;
					yy_i++ )
				{
					if ( yytoks[yy_i].t_val == yychar )
						break;
				}
				printf( "%s\n", yytoks[yy_i].t_name );
			}
		}
#endif /* YYDEBUG */
		if ( ( ( yy_n += yychar ) < 0 ) || ( yy_n >= YYLAST ) )
			goto yydefault;
		if ( yychk[ yy_n = yyact[ yy_n ] ] == yychar )	/*valid shift*/
		{
			yychar = -1;
			yyval = yylval;
			yy_state = yy_n;
			if ( yyerrflag > 0 )
				yyerrflag--;
			goto yy_stack;
		}

	yydefault:
		if ( ( yy_n = yydef[ yy_state ] ) == -2 )
		{
#if YYDEBUG
			yytmp = yychar < 0;
#endif
			if ( ( yychar < 0 ) && ( ( yychar = YYLEX() ) < 0 ) )
				yychar = 0;		/* reached EOF */
#if YYDEBUG
			if ( yydebug && yytmp )
			{
				register int yy_i;

				printf( "Received token " );
				if ( yychar == 0 )
					printf( "end-of-file\n" );
				else if ( yychar < 0 )
					printf( "-none-\n" );
				else
				{
					for ( yy_i = 0;
						yytoks[yy_i].t_val >= 0;
						yy_i++ )
					{
						if ( yytoks[yy_i].t_val
							== yychar )
						{
							break;
						}
					}
					printf( "%s\n", yytoks[yy_i].t_name );
				}
			}
#endif /* YYDEBUG */
			/*
			** look through exception table
			*/
			{
				register YYCONST int *yyxi = yyexca;

				while ( ( *yyxi != -1 ) ||
					( yyxi[1] != yy_state ) )
				{
					yyxi += 2;
				}
				while ( ( *(yyxi += 2) >= 0 ) &&
					( *yyxi != yychar ) )
					;
				if ( ( yy_n = yyxi[1] ) < 0 )
					YYACCEPT;
			}
		}

		/*
		** check for syntax error
		*/
		if ( yy_n == 0 )	/* have an error */
		{
			/* no worry about speed here! */
			switch ( yyerrflag )
			{
			case 0:		/* new error */
				yyerror( "syntax error" );
				goto skip_init;
			yyerrlab:
				/*
				** get globals into registers.
				** we have a user generated syntax type error
				*/
				yy_pv = yypv;
				yy_ps = yyps;
				yy_state = yystate;
			skip_init:
				yynerrs++;
				/* FALLTHRU */
			case 1:
			case 2:		/* incompletely recovered error */
					/* try again... */
				yyerrflag = 3;
				/*
				** find state where "error" is a legal
				** shift action
				*/
				while ( yy_ps >= yys )
				{
					yy_n = yypact[ *yy_ps ] + YYERRCODE;
					if ( yy_n >= 0 && yy_n < YYLAST &&
						yychk[yyact[yy_n]] == YYERRCODE)					{
						/*
						** simulate shift of "error"
						*/
						yy_state = yyact[ yy_n ];
						goto yy_stack;
					}
					/*
					** current state has no shift on
					** "error", pop stack
					*/
#if YYDEBUG
#	define _POP_ "Error recovery pops state %d, uncovers state %d\n"
					if ( yydebug )
						printf( _POP_, *yy_ps,
							yy_ps[-1] );
#	undef _POP_
#endif
					yy_ps--;
					yy_pv--;
				}
				/*
				** there is no state on stack with "error" as
				** a valid shift.  give up.
				*/
				YYABORT;
			case 3:		/* no shift yet; eat a token */
#if YYDEBUG
				/*
				** if debugging, look up token in list of
				** pairs.  0 and negative shouldn't occur,
				** but since timing doesn't matter when
				** debugging, it doesn't hurt to leave the
				** tests here.
				*/
				if ( yydebug )
				{
					register int yy_i;

					printf( "Error recovery discards " );
					if ( yychar == 0 )
						printf( "token end-of-file\n" );
					else if ( yychar < 0 )
						printf( "token -none-\n" );
					else
					{
						for ( yy_i = 0;
							yytoks[yy_i].t_val >= 0;
							yy_i++ )
						{
							if ( yytoks[yy_i].t_val
								== yychar )
							{
								break;
							}
						}
						printf( "token %s\n",
							yytoks[yy_i].t_name );
					}
				}
#endif /* YYDEBUG */
				if ( yychar == 0 )	/* reached EOF. quit */
					YYABORT;
				yychar = -1;
				goto yy_newstate;
			}
		}/* end if ( yy_n == 0 ) */
		/*
		** reduction by production yy_n
		** put stack tops, etc. so things right after switch
		*/
#if YYDEBUG
		/*
		** if debugging, print the string that is the user's
		** specification of the reduction which is just about
		** to be done.
		*/
		if ( yydebug )
			printf( "Reduce by (%d) \"%s\"\n",
				yy_n, yyreds[ yy_n ] );
#endif
		yytmp = yy_n;			/* value to switch over */
		yypvt = yy_pv;			/* $vars top of value stack */
		/*
		** Look in goto table for next state
		** Sorry about using yy_state here as temporary
		** register variable, but why not, if it works...
		** If yyr2[ yy_n ] doesn't have the low order bit
		** set, then there is no action to be done for
		** this reduction.  So, no saving & unsaving of
		** registers done.  The only difference between the
		** code just after the if and the body of the if is
		** the goto yy_stack in the body.  This way the test
		** can be made before the choice of what to do is needed.
		*/
		{
			/* length of production doubled with extra bit */
			register int yy_len = yyr2[ yy_n ];

			if ( !( yy_len & 01 ) )
			{
				yy_len >>= 1;
				yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
				yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
					*( yy_ps -= yy_len ) + 1;
				if ( yy_state >= YYLAST ||
					yychk[ yy_state =
					yyact[ yy_state ] ] != -yy_n )
				{
					yy_state = yyact[ yypgo[ yy_n ] ];
				}
				goto yy_stack;
			}
			yy_len >>= 1;
			yyval = ( yy_pv -= yy_len )[1];	/* $$ = $1 */
			yy_state = yypgo[ yy_n = yyr1[ yy_n ] ] +
				*( yy_ps -= yy_len ) + 1;
			if ( yy_state >= YYLAST ||
				yychk[ yy_state = yyact[ yy_state ] ] != -yy_n )
			{
				yy_state = yyact[ yypgo[ yy_n ] ];
			}
		}
					/* save until reenter driver code */
		yystate = yy_state;
		yyps = yy_ps;
		yypv = yy_pv;
	}
	/*
	** code supplied by user is placed in this switch
	*/
	switch( yytmp )
	{
		
case 3:{ if (yypvt[-0].ss) AddSynset(yypvt[-0].ss); } break;
case 4:{ if (yypvt[-0].ss) AddSynset(yypvt[-0].ss); } break;
case 5:{ if (yypvt[-0].ss) AddSynset(yypvt[-0].ss); } break;
case 6:{ } break;
case 7:{
	    if (yypvt[-0].ss) {
		yypvt[-0].ss->isfanss = FALSE;
		yypvt[-0].ss->part = ADJ;
		yypvt[-0].ss->clusnum = 0;
		AddSynset(yypvt[-0].ss);
	    }
	} break;
case 8:{	yyerror("']' without matching '['\n"); } break;
case 9:{ 
            yyval.ss = MakeSynset(NOUN, yypvt[-4].s, yypvt[-3].p, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 10:{
            yyval.ss = MakeSynset(NOUN, yypvt[-3].s, NULL, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 11:{
            yyval.ss = MakeSynset(VERB, yypvt[-5].s, yypvt[-4].p, yypvt[-3].fr, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 12:{
	    yyval.ss = MakeSynset(VERB, yypvt[-4].s, NULL, yypvt[-3].fr, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 13:{
	    yyval.ss = MakeSynset(VERB, yypvt[-4].s, yypvt[-3].p, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 14:{ 
	    yyval.ss = MakeSynset(VERB, yypvt[-3].s, NULL, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 15:{ 
            yyval.ss = MakeSynset(ADV, yypvt[-4].s, yypvt[-3].p, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 16:{
            yyval.ss = MakeSynset(ADV, yypvt[-3].s, NULL, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 17:{ yyval.s=NULL; } break;
case 18:{
	    wdcnt++;
	    yyval.s = AddSynonym(yypvt[-1].s, CreateSynonym(yypvt[-0].sym,
					      (unsigned char)wsense,
					      (headword ? -wdcnt : wdcnt),
					      (unsigned char)aclass,
					      label));
	    headword = FALSE;
	    aclass = 0;
	} break;
case 19:{
	    wdcnt++;
	    yyval.s = AddSynonym(yypvt[-2].s, CreateSynonym(yypvt[-1].sym,
					      (unsigned char)wsense,
					      (headword ? -wdcnt : wdcnt),
					      (unsigned char)yypvt[-0].number,
					      label));
	    headword = FALSE;
	    aclass = 0;
	} break;
case 20:{ 
	    yyerror("Error in synonym list, "); 
	    if (yypvt[-1].s) {
		fprintf(logfile, "last good synonym: \"%s\"\n",
			PrintSynonym(lastsyn));
	    } else if (!wdcnt) {
		fprintf(logfile, "invalid string found\n");
	    } else {
		fprintf(logfile,"first synonym group is bad\n");
	    }
	    yyval.s = yypvt[-1].s;
	} break;
case 21:{
            aclass = yypvt[-2].number;
	    MakeSyngroup(yypvt[-1].p, NULL);
	    yyval.sym = yypvt[-3].sym;
	} break;
case 22:{
            aclass = yypvt[-3].number;
	    MakeSyngroup(yypvt[-2].p, yypvt[-1].fr);
	    yyval.sym = yypvt[-4].sym;
	} break;
case 23:{
            aclass = yypvt[-2].number;
	    MakeSyngroup(NULL, yypvt[-1].fr);
	    yyval.sym = yypvt[-3].sym;
	} break;
case 24:{
            yyval.sym = CreateSymbol(strlower(yypvt[-0].tx));
	    label = UseLabel(yypvt[-0].tx); /* decide whether to save original string */
	    headword = FALSE;
	    wsense = 0;
	} break;
case 25:{ 
	    yyval.sym = CreateSymbol(strlower(yypvt[-1].tx));
	    label = UseLabel(yypvt[-1].tx); /* decide whether to save original string */
	    headword = FALSE;
	    wsense = yypvt[-0].number;
	    if (wsense > MAXID) {
		sprintf(buf, "ID must be less than 16: %s%d\n",
			yyval.sym->label, wsense);
		yyerror(buf);
	    }
	} break;
case 26:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-0].tx));
	    label = NULL;
	    headword = TRUE;
	    wsense = 0;
	} break;
case 27:{ 
	    yyval.sym = CreateSymbol(strlower(yypvt[-1].tx));
	    label = NULL;
	    headword = TRUE;
	    wsense = yypvt[-0].number;
	    if (wsense > MAXID) {
		sprintf(buf, "ID must be less than 16: %s%d\n",
			yyval.sym->label, wsense);
		yyerror(buf);
	    }
	} break;
case 28:{
            yyval.sym = CreateSymbol(strlower(yypvt[-0].tx));
	    sense = 0;
	    satellite = NULL;
	    satellite_sense = 0;
	    headptr = FALSE;
	    fnbuf[0] = '\0';
	} break;
case 29:{ 
	    yyval.sym = CreateSymbol(strlower(yypvt[-1].tx));
	    sense = yypvt[-0].number;
	    satellite = NULL;
	    satellite_sense = 0;
	    headptr = FALSE;
	    fnbuf[0] = '\0';
	} break;
case 30:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-0].tx));
	    sense = 0;
	    satellite = NULL;
	    satellite_sense = 0;
	    headptr = TRUE;
	    fnbuf[0] = '\0';
	} break;
case 31:{ 
	    yyval.sym = CreateSymbol(strlower(yypvt[-1].tx));
	    sense = yypvt[-0].number;
	    satellite = NULL;
	    satellite_sense = 0;
	    headptr = TRUE;
	    fnbuf[0] = '\0';
	} break;
case 32:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-0].tx));
	    sense = 0;
	    satellite = NULL;
	    satellite_sense = 0;
	    headptr = FALSE;
	    strcpy(fnbuf, yypvt[-1].tx);	/* save filename for warning msg */
	    free(yypvt[-1].tx);		/* free space malloc'd for string */
	} break;
case 33:{ 
	    yyval.sym = CreateSymbol(strlower(yypvt[-1].tx));
	    sense = yypvt[-0].number;
	    satellite = NULL;
	    satellite_sense = 0;
	    headptr = FALSE;
	    strcpy(fnbuf, yypvt[-2].tx);	/* save filename for warning msg */
	    free(yypvt[-2].tx);		/* free space malloc'd for string */
	} break;
case 34:{/* new ones start here */
	    yyval.sym = CreateSymbol(strlower(yypvt[-2].tx));
	    sense = 0;
	    satellite = CreateSymbol(strlower(yypvt[-0].tx));
	    satellite_sense = 0;
	    headptr = FALSE;
	    strcpy(fnbuf, yypvt[-3].tx);	/* save filename for warning msg */
	    free(yypvt[-3].tx);		/* free space malloc'd for string */
	} break;
case 35:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-3].tx));
	    sense = yypvt[-2].number;
	    satellite = CreateSymbol(strlower(yypvt[-0].tx));
	    satellite_sense = 0;
	    headptr = FALSE;
	    strcpy(fnbuf, yypvt[-4].tx);	/* save filename for warning msg */
	    free(yypvt[-4].tx);		/* free space malloc'd for string */
	} break;
case 36:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-4].tx));
	    sense = yypvt[-3].number;
	    satellite = CreateSymbol(strlower(yypvt[-1].tx));
	    satellite_sense = yypvt[-0].number;
	    headptr = FALSE;
	    strcpy(fnbuf, yypvt[-5].tx);	/* save filename for warning msg */
	    free(yypvt[-5].tx);		/* free space malloc'd for string */
	} break;
case 37:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-3].tx));
	    sense = 0;
	    satellite = CreateSymbol(strlower(yypvt[-1].tx));
	    satellite_sense = yypvt[-0].number;
	    headptr = FALSE;
	    strcpy(fnbuf, yypvt[-4].tx);	/* save filename for warning msg */
	    free(yypvt[-4].tx);		/* free space malloc'd for string */
	} break;
case 38:{ yyval.p = DoPointer(yypvt[-1].sym, yypvt[-0].number); } break;
case 39:{
            if (yypvt[-0].p) {
		yyval.p = AddPointer(yypvt[-1].p, yypvt[-0].p);
	    } else { 
		yyval.p=yypvt[-1].p;
	    }
	} break;
case 40:{ yyval.p=yypvt[-0].p; } break;
case 41:{
	    Pointer p;

	    yyerror("Error in pointer list, ");
	    p = yypvt[-1].p;
	    if (p) {
		for (; p->pnext; p = p->pnext);	/* find end of list */
		fprintf(logfile,
			"last valid pointer: \"%s\"\n",
			PrintPointer(p));
	    } else
		fprintf(logfile,"first pointer in list is bad\n");
	    yyval.p=yypvt[-1].p;
	} break;
case 42:{ yyval.tx = NULL; } break;
case 43:{ yyval.tx = yypvt[-0].tx; } break;
case 44:{ yyval.number = NULL; } break;
case 45:{ yyval.number = yypvt[-0].number; } break;
case 46:{ yyval.number=0; } break;
case 47:{ yyval.number=yypvt[-1].number; } break;
case 48:{
            if (yypvt[-0].number < 1 || yypvt[-0].number > NUMFRAMES) {
		sprintf(buf, "Bad frame number: %d\n", yypvt[-0].number);
		yyerror(buf);
		yyval.fr = CreateFramelist(0);
	    } else
		yyval.fr = CreateFramelist(yypvt[-0].number);
	} break;
case 49:{
	    if (yypvt[-0].number < 1 || yypvt[-0].number > NUMFRAMES) {
		sprintf(buf, "Bad frame number: %d\n", yypvt[-0].number);
		yyerror(buf);
		yyval.fr = yypvt[-2].fr;
	    } else {
		yypvt[-2].fr->frames[(yypvt[-0].number-1)/32] |= 1<<((yypvt[-0].number - 1) % 32);
		yyval.fr = yypvt[-2].fr;
	    }
	} break;
case 50:{ 
	    yyerror("Error in frame list.\n"); 
	    yyval.fr = yypvt[-1].fr;
	} break;
case 51:{ cluscnt++; yyval.ss = yypvt[-1].ss; } break;
case 52:{
	    yyval.ss=NULL;
	    yyerror("Had trouble finding the beginning of this cluster\n");
	    yyerrok;
	} break;
case 53:{ yyval.ss = yypvt[-0].ss; } break;
case 54:{ yyval.ss = yypvt[-2].ss; } break;
case 55:{
            if (yypvt[-1].ss) {
		yypvt[-1].ss->fans = yypvt[-0].ss;
		yypvt[-1].ss->clusnum = cluscnt;
		AddSynset(yypvt[-1].ss);
	    }
	    yyval.ss = yypvt[-1].ss;
	} break;
case 56:{
	    yyval.ss=NULL;
	    yyerror("Can't find a head synset for this part of the cluster\n");
	} break;
case 57:{ yyval.ss=NULL; } break;
case 58:{ if (yypvt[-1].ss) yypvt[-1].ss->ssnext = yypvt[-0].ss; yyval.ss = yypvt[-1].ss; } break;
case 59:{
	    if (yyval.ss = MakeSynset(SATELLITE, yypvt[-4].s, yypvt[-3].p, NULL, yypvt[-2].tx, yypvt[-0].number)) {
		yyval.ss->isfanss = TRUE;
		yyval.ss->clusnum = cluscnt;
		AddToSynList(yyval.ss); /* need since AddSynset() not done */
	    }
	} break;
case 60:{
	    if (yyval.ss = MakeSynset(SATELLITE, yypvt[-3].s, NULL, NULL, yypvt[-2].tx, yypvt[-0].number)) {
		yyval.ss->isfanss = TRUE;
		yyval.ss->clusnum = cluscnt;
		AddToSynList(yyval.ss); /* need since AddSynset() not done */
	    }
	} break;
case 61:{
	    yyerror("Opened a '[' in the middle of a cluster somewhere above here\n");
	    yyval.ss=yypvt[-0].ss;
	} break;
case 62:{
	    yyval.ss = MakeSynset(ADJ, InsertSynonym(yypvt[-4].s, yypvt[-5].s), yypvt[-3].p, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 63:{
	    yyval.ss = MakeSynset(ADJ, InsertSynonym(yypvt[-3].s, yypvt[-4].s), NULL, NULL, yypvt[-2].tx, yypvt[-0].number);
	} break;
case 64:{
           wdcnt = 1;
           yyval.s = CreateSynonym(yypvt[-0].sym,
			      (unsigned char)wsense,
			      -wdcnt,
			      (unsigned char)aclass,
			      NULL);
	   headword = FALSE;
	   aclass = 0;
       } break;
case 65:{
	   MakeSyngroup(yypvt[-1].p, NULL);
	   wdcnt = 1;
	   yyval.s = CreateSynonym(yypvt[-2].sym,
			      (unsigned char)wsense,
			      -wdcnt,
			      (unsigned char)aclass,
			      NULL);
	   headword = FALSE;
	   aclass = 0;
       } break;
case 66:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-1].tx));
	    wsense = 0;
    	    aclass = yypvt[-0].number;
	    headword = TRUE;
	} break;
case 67:{
	    yyval.sym = CreateSymbol(strlower(yypvt[-2].tx));
	    wsense = yypvt[-1].number;
	    aclass = yypvt[-0].number;
	    headword = TRUE;
	} break;
	}
	goto yystack;		/* reset registers in driver code */
}

