/*

  extern.h - extern declarations for grinder

*/

/* $Id: extern.h,v 1.8 2001/09/06 17:55:38 wn Rel $ */

#ifndef _EXTERN_
#define _EXTERN_

#include <stdio.h>
#include "typedef.h"
#include "wnglobal.h"

extern int yylineno;
extern Synset headss;
extern int pcount;
extern int errcount;
extern int verifyflag;
extern int nowarn;
extern int ordersenses;
extern int synsetkeys;
extern char *ptrsymbols[];
extern char *legalptrs;
extern char *legalptrsets[];
extern char *ptrreflects[];
extern struct {
    char *fname;
    int present;
} filelist[];
extern char **Argv;
extern int Argc;
extern FILE *logfile;
extern char partprefix[];
extern char partseen[];
extern char *adjclass[];
extern Symbol hashtab[];

/* External functions */

extern int arraypos(char **, char *);
extern int filenum(char *);
extern char *strclone(char *);
extern char *strupper(char *);
extern char *strlower(char *);
extern char *PrintFileName(int);
extern char *PrintPointer(Pointer);
extern char *PrintSynonym(Synonym);
extern char *NextFile();
extern int filemode();
extern Synset CreateSynset(unsigned char, Synonym, Pointer,
		    Framelist, char *, unsigned int, int, unsigned char);
extern Pointer CreatePointer(Symbol, Symbol, unsigned char,
		      unsigned char, unsigned char, unsigned char,
		      short, short);
extern Synonym CreateSynonym(Symbol, unsigned char, short,
		      unsigned char, char *);
extern Framelist CreateFramelist(int);
extern Symbol CreateSymbol(char *);
extern Symbol FindSymbol(char *);
extern void ResolvePointers();
extern void FindOffsets();
extern void DumpData();	
extern void DumpIndex();
extern void DumpSenseIndex();
extern void ReadCntlist();

#endif				/* _EXTERN_ */

/*
  Revision log:

  $Log: extern.h,v $
  Revision 1.8  2001/09/06 17:55:38  wn
  added code for synset keys

  Revision 1.7  1997/08/05 14:23:46  wn
  added function prototypes, other small cleanups

 * Revision 1.6  1995/06/23  16:39:17  wn
 * removed nonlocal
 *
 * Revision 1.5  1994/09/27  19:51:53  wn
 * changed filelist to structure
 *
 * Revision 1.4  1994/07/01  19:26:43  wn
 * *** empty log message ***
 *
 * Revision 1.3  1994/03/03  11:55:19  wn
 * added
 * ordersenses
 *
 * Revision 1.2  91/12/13  15:55:24  wn
 * removed things that are in wnglobals
 * 
 * Revision 1.1  91/09/11  14:43:37  wn
 * Initial revision
 * 
*/
