/* sha3_asm
 *
 * Copyright (C) 2006-2022 wolfSSL Inc.
 *
 * This file is part of wolfSSL.
 *
 * wolfSSL is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * wolfSSL is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1335, USA
 */

#ifdef WOLFSSL_USER_SETTINGS
#ifdef WOLFSSL_USER_SETTINGS_ASM
/*
 * user_settings_asm.h is a file generated by the script user_settings_asm.sh.
 * The script takes in a user_settings.h and produces user_settings_asm.h, which
 * is a stripped down version of user_settings.h containing only preprocessor
 * directives. This makes the header safe to include in assembly (.S) files.
 */
#include "user_settings_asm.h"
#else
/*
 * Note: if user_settings.h contains any C code (e.g. a typedef or function
 * prototype), including it here in an assembly (.S) file will cause an
 * assembler failure. See user_settings_asm.h above.
 */
#include "user_settings.h"
#endif /* WOLFSSL_USER_SETTINGS_ASM */
#endif /* WOLFSSL_USER_SETTINGS */

#ifndef HAVE_INTEL_AVX1
#define HAVE_INTEL_AVX1
#endif /* HAVE_INTEL_AVX1 */
#ifndef NO_AVX2_SUPPORT
#define HAVE_INTEL_AVX2
#endif /* NO_AVX2_SUPPORT */

#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_sha3_avx2_r:
.quad	0x1,0x1
.quad	0x1,0x1
.quad	0x8082,0x8082
.quad	0x8082,0x8082
.quad	0x800000000000808a,0x800000000000808a
.quad	0x800000000000808a,0x800000000000808a
.quad	0x8000000080008000,0x8000000080008000
.quad	0x8000000080008000,0x8000000080008000
.quad	0x808b,0x808b
.quad	0x808b,0x808b
.quad	0x80000001,0x80000001
.quad	0x80000001,0x80000001
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000000008009,0x8000000000008009
.quad	0x8000000000008009,0x8000000000008009
.quad	0x8a,0x8a
.quad	0x8a,0x8a
.quad	0x88,0x88
.quad	0x88,0x88
.quad	0x80008009,0x80008009
.quad	0x80008009,0x80008009
.quad	0x8000000a,0x8000000a
.quad	0x8000000a,0x8000000a
.quad	0x8000808b,0x8000808b
.quad	0x8000808b,0x8000808b
.quad	0x800000000000008b,0x800000000000008b
.quad	0x800000000000008b,0x800000000000008b
.quad	0x8000000000008089,0x8000000000008089
.quad	0x8000000000008089,0x8000000000008089
.quad	0x8000000000008003,0x8000000000008003
.quad	0x8000000000008003,0x8000000000008003
.quad	0x8000000000008002,0x8000000000008002
.quad	0x8000000000008002,0x8000000000008002
.quad	0x8000000000000080,0x8000000000000080
.quad	0x8000000000000080,0x8000000000000080
.quad	0x800a,0x800a
.quad	0x800a,0x800a
.quad	0x800000008000000a,0x800000008000000a
.quad	0x800000008000000a,0x800000008000000a
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000000008080,0x8000000000008080
.quad	0x8000000000008080,0x8000000000008080
.quad	0x80000001,0x80000001
.quad	0x80000001,0x80000001
.quad	0x8000000080008008,0x8000000080008008
.quad	0x8000000080008008,0x8000000080008008
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_sha3_x4_avx2_r:
.quad	0x1,0x1
.quad	0x1,0x1
.quad	0x8082,0x8082
.quad	0x8082,0x8082
.quad	0x800000000000808a,0x800000000000808a
.quad	0x800000000000808a,0x800000000000808a
.quad	0x8000000080008000,0x8000000080008000
.quad	0x8000000080008000,0x8000000080008000
.quad	0x808b,0x808b
.quad	0x808b,0x808b
.quad	0x80000001,0x80000001
.quad	0x80000001,0x80000001
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000000008009,0x8000000000008009
.quad	0x8000000000008009,0x8000000000008009
.quad	0x8a,0x8a
.quad	0x8a,0x8a
.quad	0x88,0x88
.quad	0x88,0x88
.quad	0x80008009,0x80008009
.quad	0x80008009,0x80008009
.quad	0x8000000a,0x8000000a
.quad	0x8000000a,0x8000000a
.quad	0x8000808b,0x8000808b
.quad	0x8000808b,0x8000808b
.quad	0x800000000000008b,0x800000000000008b
.quad	0x800000000000008b,0x800000000000008b
.quad	0x8000000000008089,0x8000000000008089
.quad	0x8000000000008089,0x8000000000008089
.quad	0x8000000000008003,0x8000000000008003
.quad	0x8000000000008003,0x8000000000008003
.quad	0x8000000000008002,0x8000000000008002
.quad	0x8000000000008002,0x8000000000008002
.quad	0x8000000000000080,0x8000000000000080
.quad	0x8000000000000080,0x8000000000000080
.quad	0x800a,0x800a
.quad	0x800a,0x800a
.quad	0x800000008000000a,0x800000008000000a
.quad	0x800000008000000a,0x800000008000000a
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000080008081,0x8000000080008081
.quad	0x8000000000008080,0x8000000000008080
.quad	0x8000000000008080,0x8000000000008080
.quad	0x80000001,0x80000001
.quad	0x80000001,0x80000001
.quad	0x8000000080008008,0x8000000080008008
.quad	0x8000000080008008,0x8000000080008008
#ifdef HAVE_INTEL_AVX2
#ifndef __APPLE__
.text
.globl	sha3_block_bmi2
.type	sha3_block_bmi2,@function
.align	16
sha3_block_bmi2:
#else
.section	__TEXT,__text
.globl	_sha3_block_bmi2
.p2align	4
_sha3_block_bmi2:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        movq	(%rdi), %rsi
        addq	$0x60, %rdi
        # Round 0
        movq	%rsi, %r10
        movq	-88(%rdi), %r11
        movq	-80(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	-64(%rdi), %r14
        xorq	-56(%rdi), %r10
        xorq	-48(%rdi), %r11
        xorq	-40(%rdi), %r12
        xorq	-32(%rdi), %r13
        xorq	-24(%rdi), %r14
        xorq	-16(%rdi), %r10
        xorq	-8(%rdi), %r11
        xorq	(%rdi), %r12
        xorq	8(%rdi), %r13
        xorq	16(%rdi), %r14
        xorq	24(%rdi), %r10
        xorq	32(%rdi), %r11
        xorq	40(%rdi), %r12
        xorq	48(%rdi), %r13
        xorq	56(%rdi), %r14
        xorq	64(%rdi), %r10
        xorq	72(%rdi), %r11
        xorq	80(%rdi), %r12
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-48(%rdi), %r11
        movq	(%rdi), %r12
        movq	48(%rdi), %r13
        movq	96(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, (%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 96(%rdi)
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	$0x01, %rsi
        # Row 1
        movq	-72(%rdi), %r10
        movq	-24(%rdi), %r11
        movq	-16(%rdi), %r12
        movq	32(%rdi), %r13
        movq	80(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 80(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -72(%rdi)
        # Row 2
        movq	-88(%rdi), %r10
        movq	-40(%rdi), %r11
        movq	8(%rdi), %r12
        movq	56(%rdi), %r13
        movq	64(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 64(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -88(%rdi)
        # Row 3
        movq	-64(%rdi), %r10
        movq	-56(%rdi), %r11
        movq	-8(%rdi), %r12
        movq	40(%rdi), %r13
        movq	88(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 88(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -64(%rdi)
        # Row 4
        xorq	-80(%rdi), %rcx
        xorq	-32(%rdi), %r8
        xorq	16(%rdi), %r9
        xorq	24(%rdi), %rdx
        xorq	72(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -80(%rdi)
        movq	%r11, -32(%rdi)
        movq	%r12, 16(%rdi)
        movq	%r13, 24(%rdi)
        movq	%r14, 72(%rdi)
        # Round 1
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r10
        xorq	-72(%rdi), %r10
        xorq	-64(%rdi), %r10
        xorq	-56(%rdi), %r11
        xorq	-48(%rdi), %r11
        xorq	-40(%rdi), %r11
        xorq	-24(%rdi), %r11
        xorq	-16(%rdi), %r12
        xorq	-8(%rdi), %r12
        xorq	(%rdi), %r12
        xorq	8(%rdi), %r12
        xorq	32(%rdi), %r13
        xorq	40(%rdi), %r13
        xorq	48(%rdi), %r13
        xorq	56(%rdi), %r13
        xorq	64(%rdi), %r14
        xorq	80(%rdi), %r14
        xorq	88(%rdi), %r14
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-24(%rdi), %r11
        movq	8(%rdi), %r12
        movq	40(%rdi), %r13
        movq	72(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 72(%rdi)
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	$0x8082, %rsi
        # Row 1
        movq	48(%rdi), %r10
        movq	80(%rdi), %r11
        movq	-88(%rdi), %r12
        movq	-56(%rdi), %r13
        movq	16(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 16(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 48(%rdi)
        # Row 2
        movq	-48(%rdi), %r10
        movq	-16(%rdi), %r11
        movq	56(%rdi), %r12
        movq	88(%rdi), %r13
        movq	-80(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -80(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -48(%rdi)
        # Row 3
        movq	96(%rdi), %r10
        movq	-72(%rdi), %r11
        movq	-40(%rdi), %r12
        movq	-8(%rdi), %r13
        movq	24(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 24(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 96(%rdi)
        # Row 4
        xorq	(%rdi), %rcx
        xorq	32(%rdi), %r8
        xorq	64(%rdi), %r9
        xorq	-64(%rdi), %rdx
        xorq	-32(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, (%rdi)
        movq	%r11, 32(%rdi)
        movq	%r12, 64(%rdi)
        movq	%r13, -64(%rdi)
        movq	%r14, -32(%rdi)
        # Round 2
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r12
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r11
        xorq	-56(%rdi), %r13
        xorq	-48(%rdi), %r10
        xorq	-40(%rdi), %r12
        xorq	-24(%rdi), %r11
        xorq	-16(%rdi), %r11
        xorq	-8(%rdi), %r13
        xorq	8(%rdi), %r12
        xorq	16(%rdi), %r14
        xorq	24(%rdi), %r14
        xorq	40(%rdi), %r13
        xorq	48(%rdi), %r10
        xorq	56(%rdi), %r12
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %r11
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %r10
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	80(%rdi), %r11
        movq	56(%rdi), %r12
        movq	-8(%rdi), %r13
        movq	-32(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -32(%rdi)
        movq	$0x800000000000808a, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	40(%rdi), %r10
        movq	16(%rdi), %r11
        movq	-48(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	64(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 64(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 40(%rdi)
        # Row 2
        movq	-24(%rdi), %r10
        movq	-88(%rdi), %r11
        movq	88(%rdi), %r12
        movq	24(%rdi), %r13
        movq	(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, (%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -24(%rdi)
        # Row 3
        movq	72(%rdi), %r10
        movq	48(%rdi), %r11
        movq	-16(%rdi), %r12
        movq	-40(%rdi), %r13
        movq	-64(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -64(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 72(%rdi)
        # Row 4
        xorq	8(%rdi), %rcx
        xorq	-56(%rdi), %r8
        xorq	-80(%rdi), %r9
        xorq	96(%rdi), %rdx
        xorq	32(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 8(%rdi)
        movq	%r11, -56(%rdi)
        movq	%r12, -80(%rdi)
        movq	%r13, 96(%rdi)
        movq	%r14, 32(%rdi)
        # Round 3
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r11
        xorq	-72(%rdi), %r13
        xorq	-64(%rdi), %r14
        xorq	-48(%rdi), %r12
        xorq	-40(%rdi), %r13
        xorq	-32(%rdi), %r14
        xorq	-24(%rdi), %r10
        xorq	-16(%rdi), %r12
        xorq	-8(%rdi), %r13
        xorq	(%rdi), %r14
        xorq	16(%rdi), %r11
        xorq	24(%rdi), %r13
        xorq	40(%rdi), %r10
        xorq	48(%rdi), %r11
        xorq	56(%rdi), %r12
        xorq	64(%rdi), %r14
        xorq	72(%rdi), %r10
        xorq	80(%rdi), %r11
        xorq	88(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	16(%rdi), %r11
        movq	88(%rdi), %r12
        movq	-40(%rdi), %r13
        movq	32(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 32(%rdi)
        movq	$0x8000000080008000, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	-8(%rdi), %r10
        movq	64(%rdi), %r11
        movq	-24(%rdi), %r12
        movq	48(%rdi), %r13
        movq	-80(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -80(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -8(%rdi)
        # Row 2
        movq	80(%rdi), %r10
        movq	-48(%rdi), %r11
        movq	24(%rdi), %r12
        movq	-64(%rdi), %r13
        movq	8(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 8(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 80(%rdi)
        # Row 3
        movq	-32(%rdi), %r10
        movq	40(%rdi), %r11
        movq	-88(%rdi), %r12
        movq	-16(%rdi), %r13
        movq	96(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 96(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -32(%rdi)
        # Row 4
        xorq	56(%rdi), %rcx
        xorq	-72(%rdi), %r8
        xorq	(%rdi), %r9
        xorq	72(%rdi), %rdx
        xorq	-56(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 56(%rdi)
        movq	%r11, -72(%rdi)
        movq	%r12, (%rdi)
        movq	%r13, 72(%rdi)
        movq	%r14, -56(%rdi)
        # Round 4
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r12
        xorq	-80(%rdi), %r14
        xorq	-64(%rdi), %r13
        xorq	-48(%rdi), %r11
        xorq	-40(%rdi), %r13
        xorq	-32(%rdi), %r10
        xorq	-24(%rdi), %r12
        xorq	-16(%rdi), %r13
        xorq	-8(%rdi), %r10
        xorq	8(%rdi), %r14
        xorq	16(%rdi), %r11
        xorq	24(%rdi), %r12
        xorq	32(%rdi), %r14
        xorq	40(%rdi), %r11
        xorq	48(%rdi), %r13
        xorq	64(%rdi), %r11
        xorq	80(%rdi), %r10
        xorq	88(%rdi), %r12
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	64(%rdi), %r11
        movq	24(%rdi), %r12
        movq	-16(%rdi), %r13
        movq	-56(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -56(%rdi)
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	$0x808b, %rsi
        # Row 1
        movq	-40(%rdi), %r10
        movq	-80(%rdi), %r11
        movq	80(%rdi), %r12
        movq	40(%rdi), %r13
        movq	(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, (%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -40(%rdi)
        # Row 2
        movq	16(%rdi), %r10
        movq	-24(%rdi), %r11
        movq	-64(%rdi), %r12
        movq	96(%rdi), %r13
        movq	56(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 96(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 56(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 16(%rdi)
        # Row 3
        movq	32(%rdi), %r10
        movq	-8(%rdi), %r11
        movq	-48(%rdi), %r12
        movq	-88(%rdi), %r13
        movq	72(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 72(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 32(%rdi)
        # Row 4
        xorq	88(%rdi), %rcx
        xorq	48(%rdi), %r8
        xorq	8(%rdi), %r9
        xorq	-32(%rdi), %rdx
        xorq	-72(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 88(%rdi)
        movq	%r11, 48(%rdi)
        movq	%r12, 8(%rdi)
        movq	%r13, -32(%rdi)
        movq	%r14, -72(%rdi)
        # Round 5
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r11
        xorq	-64(%rdi), %r12
        xorq	-56(%rdi), %r14
        xorq	-48(%rdi), %r12
        xorq	-40(%rdi), %r10
        xorq	-24(%rdi), %r11
        xorq	-16(%rdi), %r13
        xorq	-8(%rdi), %r11
        xorq	(%rdi), %r14
        xorq	16(%rdi), %r10
        xorq	24(%rdi), %r12
        xorq	32(%rdi), %r10
        xorq	40(%rdi), %r13
        xorq	56(%rdi), %r14
        xorq	64(%rdi), %r11
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %r12
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-80(%rdi), %r11
        movq	-64(%rdi), %r12
        movq	-88(%rdi), %r13
        movq	-72(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -72(%rdi)
        movq	$0x80000001, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	-16(%rdi), %r10
        movq	(%rdi), %r11
        movq	16(%rdi), %r12
        movq	-8(%rdi), %r13
        movq	8(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, (%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 8(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -16(%rdi)
        # Row 2
        movq	64(%rdi), %r10
        movq	80(%rdi), %r11
        movq	96(%rdi), %r12
        movq	72(%rdi), %r13
        movq	88(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 96(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 88(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 64(%rdi)
        # Row 3
        movq	-56(%rdi), %r10
        movq	-40(%rdi), %r11
        movq	-24(%rdi), %r12
        movq	-48(%rdi), %r13
        movq	-32(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -32(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -56(%rdi)
        # Row 4
        xorq	24(%rdi), %rcx
        xorq	40(%rdi), %r8
        xorq	56(%rdi), %r9
        xorq	32(%rdi), %rdx
        xorq	48(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 24(%rdi)
        movq	%r11, 40(%rdi)
        movq	%r12, 56(%rdi)
        movq	%r13, 32(%rdi)
        movq	%r14, 48(%rdi)
        # Round 6
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r11
        xorq	-72(%rdi), %r14
        xorq	-64(%rdi), %r12
        xorq	-56(%rdi), %r10
        xorq	-48(%rdi), %r13
        xorq	-40(%rdi), %r11
        xorq	-32(%rdi), %r14
        xorq	-24(%rdi), %r12
        xorq	-16(%rdi), %r10
        xorq	-8(%rdi), %r13
        xorq	(%rdi), %r11
        xorq	8(%rdi), %r14
        xorq	16(%rdi), %r12
        xorq	64(%rdi), %r10
        xorq	72(%rdi), %r13
        xorq	80(%rdi), %r11
        xorq	88(%rdi), %r14
        xorq	96(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	(%rdi), %r11
        movq	96(%rdi), %r12
        movq	-48(%rdi), %r13
        movq	48(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, (%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 96(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 48(%rdi)
        movq	$0x8000000080008081, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	-88(%rdi), %r10
        movq	8(%rdi), %r11
        movq	64(%rdi), %r12
        movq	-40(%rdi), %r13
        movq	56(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 56(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -88(%rdi)
        # Row 2
        movq	-80(%rdi), %r10
        movq	16(%rdi), %r11
        movq	72(%rdi), %r12
        movq	-32(%rdi), %r13
        movq	24(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 24(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -80(%rdi)
        # Row 3
        movq	-72(%rdi), %r10
        movq	-16(%rdi), %r11
        movq	80(%rdi), %r12
        movq	-24(%rdi), %r13
        movq	32(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 32(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -72(%rdi)
        # Row 4
        xorq	-64(%rdi), %rcx
        xorq	-8(%rdi), %r8
        xorq	88(%rdi), %r9
        xorq	-56(%rdi), %rdx
        xorq	40(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -64(%rdi)
        movq	%r11, -8(%rdi)
        movq	%r12, 88(%rdi)
        movq	%r13, -56(%rdi)
        movq	%r14, 40(%rdi)
        # Round 7
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r10
        xorq	-80(%rdi), %r10
        xorq	-72(%rdi), %r10
        xorq	-48(%rdi), %r13
        xorq	-40(%rdi), %r13
        xorq	-32(%rdi), %r13
        xorq	-24(%rdi), %r13
        xorq	-16(%rdi), %r11
        xorq	(%rdi), %r11
        xorq	8(%rdi), %r11
        xorq	16(%rdi), %r11
        xorq	24(%rdi), %r14
        xorq	32(%rdi), %r14
        xorq	48(%rdi), %r14
        xorq	56(%rdi), %r14
        xorq	64(%rdi), %r12
        xorq	72(%rdi), %r12
        xorq	80(%rdi), %r12
        xorq	96(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	8(%rdi), %r11
        movq	72(%rdi), %r12
        movq	-24(%rdi), %r13
        movq	40(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 40(%rdi)
        movq	$0x8000000000008009, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	-48(%rdi), %r10
        movq	56(%rdi), %r11
        movq	-80(%rdi), %r12
        movq	-16(%rdi), %r13
        movq	88(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 88(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -48(%rdi)
        # Row 2
        movq	(%rdi), %r10
        movq	64(%rdi), %r11
        movq	-32(%rdi), %r12
        movq	32(%rdi), %r13
        movq	-64(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -64(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, (%rdi)
        # Row 3
        movq	48(%rdi), %r10
        movq	-88(%rdi), %r11
        movq	16(%rdi), %r12
        movq	80(%rdi), %r13
        movq	-56(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -56(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 48(%rdi)
        # Row 4
        xorq	96(%rdi), %rcx
        xorq	-40(%rdi), %r8
        xorq	24(%rdi), %r9
        xorq	-72(%rdi), %rdx
        xorq	-8(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 96(%rdi)
        movq	%r11, -40(%rdi)
        movq	%r12, 24(%rdi)
        movq	%r13, -72(%rdi)
        movq	%r14, -8(%rdi)
        # Round 8
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r11
        xorq	-80(%rdi), %r12
        xorq	-64(%rdi), %r14
        xorq	-56(%rdi), %r14
        xorq	-48(%rdi), %r10
        xorq	-32(%rdi), %r12
        xorq	-24(%rdi), %r13
        xorq	-16(%rdi), %r13
        xorq	(%rdi), %r10
        xorq	8(%rdi), %r11
        xorq	16(%rdi), %r12
        xorq	32(%rdi), %r13
        xorq	40(%rdi), %r14
        xorq	48(%rdi), %r10
        xorq	56(%rdi), %r11
        xorq	64(%rdi), %r11
        xorq	72(%rdi), %r12
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	56(%rdi), %r11
        movq	-32(%rdi), %r12
        movq	80(%rdi), %r13
        movq	-8(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -8(%rdi)
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	$0x8a, %rsi
        # Row 1
        movq	-24(%rdi), %r10
        movq	88(%rdi), %r11
        movq	(%rdi), %r12
        movq	-88(%rdi), %r13
        movq	24(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, (%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 24(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -24(%rdi)
        # Row 2
        movq	8(%rdi), %r10
        movq	-80(%rdi), %r11
        movq	32(%rdi), %r12
        movq	-56(%rdi), %r13
        movq	96(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 96(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 8(%rdi)
        # Row 3
        movq	40(%rdi), %r10
        movq	-48(%rdi), %r11
        movq	64(%rdi), %r12
        movq	16(%rdi), %r13
        movq	-72(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -72(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 40(%rdi)
        # Row 4
        xorq	72(%rdi), %rcx
        xorq	-16(%rdi), %r8
        xorq	-64(%rdi), %r9
        xorq	48(%rdi), %rdx
        xorq	-40(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 72(%rdi)
        movq	%r11, -16(%rdi)
        movq	%r12, -64(%rdi)
        movq	%r13, 48(%rdi)
        movq	%r14, -40(%rdi)
        # Round 9
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r11
        xorq	-72(%rdi), %r14
        xorq	-56(%rdi), %r13
        xorq	-48(%rdi), %r11
        xorq	-32(%rdi), %r12
        xorq	-24(%rdi), %r10
        xorq	-8(%rdi), %r14
        xorq	(%rdi), %r12
        xorq	8(%rdi), %r10
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %r14
        xorq	32(%rdi), %r12
        xorq	40(%rdi), %r10
        xorq	56(%rdi), %r11
        xorq	64(%rdi), %r12
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %r11
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	88(%rdi), %r11
        movq	32(%rdi), %r12
        movq	16(%rdi), %r13
        movq	-40(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -40(%rdi)
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	$0x88, %rsi
        # Row 1
        movq	80(%rdi), %r10
        movq	24(%rdi), %r11
        movq	8(%rdi), %r12
        movq	-48(%rdi), %r13
        movq	-64(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -64(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 80(%rdi)
        # Row 2
        movq	56(%rdi), %r10
        movq	(%rdi), %r11
        movq	-56(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	72(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, (%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 72(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 56(%rdi)
        # Row 3
        movq	-8(%rdi), %r10
        movq	-24(%rdi), %r11
        movq	-80(%rdi), %r12
        movq	64(%rdi), %r13
        movq	48(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 48(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -8(%rdi)
        # Row 4
        xorq	-32(%rdi), %rcx
        xorq	-88(%rdi), %r8
        xorq	96(%rdi), %r9
        xorq	40(%rdi), %rdx
        xorq	-16(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -32(%rdi)
        movq	%r11, -88(%rdi)
        movq	%r12, 96(%rdi)
        movq	%r13, 40(%rdi)
        movq	%r14, -16(%rdi)
        # Round 10
        xorq	%rsi, %r10
        xorq	-80(%rdi), %r12
        xorq	-72(%rdi), %r13
        xorq	-64(%rdi), %r14
        xorq	-56(%rdi), %r12
        xorq	-48(%rdi), %r13
        xorq	-40(%rdi), %r14
        xorq	-24(%rdi), %r11
        xorq	-8(%rdi), %r10
        xorq	(%rdi), %r11
        xorq	8(%rdi), %r12
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %r11
        xorq	32(%rdi), %r12
        xorq	48(%rdi), %r14
        xorq	56(%rdi), %r10
        xorq	64(%rdi), %r13
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %r10
        xorq	88(%rdi), %r11
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	24(%rdi), %r11
        movq	-56(%rdi), %r12
        movq	64(%rdi), %r13
        movq	-16(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -16(%rdi)
        movq	$0x80008009, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	16(%rdi), %r10
        movq	-64(%rdi), %r11
        movq	56(%rdi), %r12
        movq	-24(%rdi), %r13
        movq	96(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 96(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 16(%rdi)
        # Row 2
        movq	88(%rdi), %r10
        movq	8(%rdi), %r11
        movq	-72(%rdi), %r12
        movq	48(%rdi), %r13
        movq	-32(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -32(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 88(%rdi)
        # Row 3
        movq	-40(%rdi), %r10
        movq	80(%rdi), %r11
        movq	(%rdi), %r12
        movq	-80(%rdi), %r13
        movq	40(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, (%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 40(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -40(%rdi)
        # Row 4
        xorq	32(%rdi), %rcx
        xorq	-48(%rdi), %r8
        xorq	72(%rdi), %r9
        xorq	-8(%rdi), %rdx
        xorq	-88(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 32(%rdi)
        movq	%r11, -48(%rdi)
        movq	%r12, 72(%rdi)
        movq	%r13, -8(%rdi)
        movq	%r14, -88(%rdi)
        # Round 11
        xorq	%rsi, %r10
        xorq	-80(%rdi), %r13
        xorq	-72(%rdi), %r12
        xorq	-64(%rdi), %r11
        xorq	-56(%rdi), %r12
        xorq	-40(%rdi), %r10
        xorq	-32(%rdi), %r14
        xorq	-24(%rdi), %r13
        xorq	-16(%rdi), %r14
        xorq	(%rdi), %r12
        xorq	8(%rdi), %r11
        xorq	16(%rdi), %r10
        xorq	24(%rdi), %r11
        xorq	40(%rdi), %r14
        xorq	48(%rdi), %r13
        xorq	56(%rdi), %r12
        xorq	64(%rdi), %r13
        xorq	80(%rdi), %r11
        xorq	88(%rdi), %r10
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-64(%rdi), %r11
        movq	-72(%rdi), %r12
        movq	-80(%rdi), %r13
        movq	-88(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -88(%rdi)
        movq	$0x8000000a, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	64(%rdi), %r10
        movq	96(%rdi), %r11
        movq	88(%rdi), %r12
        movq	80(%rdi), %r13
        movq	72(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 96(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 72(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 64(%rdi)
        # Row 2
        movq	24(%rdi), %r10
        movq	56(%rdi), %r11
        movq	48(%rdi), %r12
        movq	40(%rdi), %r13
        movq	32(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 32(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 24(%rdi)
        # Row 3
        movq	-16(%rdi), %r10
        movq	16(%rdi), %r11
        movq	8(%rdi), %r12
        movq	(%rdi), %r13
        movq	-8(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, (%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -8(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -16(%rdi)
        # Row 4
        xorq	-56(%rdi), %rcx
        xorq	-24(%rdi), %r8
        xorq	-32(%rdi), %r9
        xorq	-40(%rdi), %rdx
        xorq	-48(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -56(%rdi)
        movq	%r11, -24(%rdi)
        movq	%r12, -32(%rdi)
        movq	%r13, -40(%rdi)
        movq	%r14, -48(%rdi)
        # Round 12
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r14
        xorq	-80(%rdi), %r13
        xorq	-72(%rdi), %r12
        xorq	-64(%rdi), %r11
        xorq	-16(%rdi), %r10
        xorq	-8(%rdi), %r14
        xorq	(%rdi), %r13
        xorq	8(%rdi), %r12
        xorq	16(%rdi), %r11
        xorq	24(%rdi), %r10
        xorq	32(%rdi), %r14
        xorq	40(%rdi), %r13
        xorq	48(%rdi), %r12
        xorq	56(%rdi), %r11
        xorq	64(%rdi), %r10
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %r12
        xorq	96(%rdi), %r11
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	96(%rdi), %r11
        movq	48(%rdi), %r12
        movq	(%rdi), %r13
        movq	-48(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 96(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, (%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -48(%rdi)
        movq	$0x8000808b, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	-80(%rdi), %r10
        movq	72(%rdi), %r11
        movq	24(%rdi), %r12
        movq	16(%rdi), %r13
        movq	-32(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -32(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -80(%rdi)
        # Row 2
        movq	-64(%rdi), %r10
        movq	88(%rdi), %r11
        movq	40(%rdi), %r12
        movq	-8(%rdi), %r13
        movq	-56(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -56(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -64(%rdi)
        # Row 3
        movq	-88(%rdi), %r10
        movq	64(%rdi), %r11
        movq	56(%rdi), %r12
        movq	8(%rdi), %r13
        movq	-40(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -40(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -88(%rdi)
        # Row 4
        xorq	-72(%rdi), %rcx
        xorq	80(%rdi), %r8
        xorq	32(%rdi), %r9
        xorq	-16(%rdi), %rdx
        xorq	-24(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -72(%rdi)
        movq	%r11, 80(%rdi)
        movq	%r12, 32(%rdi)
        movq	%r13, -16(%rdi)
        movq	%r14, -24(%rdi)
        # Round 13
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r10
        xorq	-80(%rdi), %r10
        xorq	-64(%rdi), %r10
        xorq	-56(%rdi), %r14
        xorq	-48(%rdi), %r14
        xorq	-40(%rdi), %r14
        xorq	-32(%rdi), %r14
        xorq	-8(%rdi), %r13
        xorq	(%rdi), %r13
        xorq	8(%rdi), %r13
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %r12
        xorq	40(%rdi), %r12
        xorq	48(%rdi), %r12
        xorq	56(%rdi), %r12
        xorq	64(%rdi), %r11
        xorq	72(%rdi), %r11
        xorq	88(%rdi), %r11
        xorq	96(%rdi), %r11
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	72(%rdi), %r11
        movq	40(%rdi), %r12
        movq	8(%rdi), %r13
        movq	-24(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -24(%rdi)
        movq	$0x800000000000008b, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	(%rdi), %r10
        movq	-32(%rdi), %r11
        movq	-64(%rdi), %r12
        movq	64(%rdi), %r13
        movq	32(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 32(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, (%rdi)
        # Row 2
        movq	96(%rdi), %r10
        movq	24(%rdi), %r11
        movq	-8(%rdi), %r12
        movq	-40(%rdi), %r13
        movq	-72(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -40(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -72(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 96(%rdi)
        # Row 3
        movq	-48(%rdi), %r10
        movq	-80(%rdi), %r11
        movq	88(%rdi), %r12
        movq	56(%rdi), %r13
        movq	-16(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -80(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -16(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -48(%rdi)
        # Row 4
        xorq	48(%rdi), %rcx
        xorq	16(%rdi), %r8
        xorq	-56(%rdi), %r9
        xorq	-88(%rdi), %rdx
        xorq	80(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 48(%rdi)
        movq	%r11, 16(%rdi)
        movq	%r12, -56(%rdi)
        movq	%r13, -88(%rdi)
        movq	%r14, 80(%rdi)
        # Round 14
        xorq	%rsi, %r10
        xorq	-80(%rdi), %r11
        xorq	-72(%rdi), %r14
        xorq	-64(%rdi), %r12
        xorq	-48(%rdi), %r10
        xorq	-40(%rdi), %r13
        xorq	-32(%rdi), %r11
        xorq	-24(%rdi), %r14
        xorq	-16(%rdi), %r14
        xorq	-8(%rdi), %r12
        xorq	(%rdi), %r10
        xorq	8(%rdi), %r13
        xorq	24(%rdi), %r11
        xorq	32(%rdi), %r14
        xorq	40(%rdi), %r12
        xorq	56(%rdi), %r13
        xorq	64(%rdi), %r13
        xorq	72(%rdi), %r11
        xorq	88(%rdi), %r12
        xorq	96(%rdi), %r10
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-32(%rdi), %r11
        movq	-8(%rdi), %r12
        movq	56(%rdi), %r13
        movq	80(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 80(%rdi)
        movq	$0x8000000000008089, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	8(%rdi), %r10
        movq	32(%rdi), %r11
        movq	96(%rdi), %r12
        movq	-80(%rdi), %r13
        movq	-56(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 96(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -56(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 8(%rdi)
        # Row 2
        movq	72(%rdi), %r10
        movq	-64(%rdi), %r11
        movq	-40(%rdi), %r12
        movq	-16(%rdi), %r13
        movq	48(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 48(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 72(%rdi)
        # Row 3
        movq	-24(%rdi), %r10
        movq	(%rdi), %r11
        movq	24(%rdi), %r12
        movq	88(%rdi), %r13
        movq	-88(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, (%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -88(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -24(%rdi)
        # Row 4
        xorq	40(%rdi), %rcx
        xorq	64(%rdi), %r8
        xorq	-72(%rdi), %r9
        xorq	-48(%rdi), %rdx
        xorq	16(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 40(%rdi)
        movq	%r11, 64(%rdi)
        movq	%r12, -72(%rdi)
        movq	%r13, -48(%rdi)
        movq	%r14, 16(%rdi)
        # Round 15
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r14
        xorq	-80(%rdi), %r13
        xorq	-64(%rdi), %r11
        xorq	-56(%rdi), %r14
        xorq	-40(%rdi), %r12
        xorq	-32(%rdi), %r11
        xorq	-24(%rdi), %r10
        xorq	-16(%rdi), %r13
        xorq	-8(%rdi), %r12
        xorq	(%rdi), %r11
        xorq	8(%rdi), %r10
        xorq	24(%rdi), %r12
        xorq	32(%rdi), %r11
        xorq	48(%rdi), %r14
        xorq	56(%rdi), %r13
        xorq	72(%rdi), %r10
        xorq	80(%rdi), %r14
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	32(%rdi), %r11
        movq	-40(%rdi), %r12
        movq	88(%rdi), %r13
        movq	16(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 16(%rdi)
        movq	$0x8000000000008003, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	56(%rdi), %r10
        movq	-56(%rdi), %r11
        movq	72(%rdi), %r12
        movq	(%rdi), %r13
        movq	-72(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, (%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -72(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 56(%rdi)
        # Row 2
        movq	-32(%rdi), %r10
        movq	96(%rdi), %r11
        movq	-16(%rdi), %r12
        movq	-88(%rdi), %r13
        movq	40(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 96(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 40(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -32(%rdi)
        # Row 3
        movq	80(%rdi), %r10
        movq	8(%rdi), %r11
        movq	-64(%rdi), %r12
        movq	24(%rdi), %r13
        movq	-48(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -48(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 80(%rdi)
        # Row 4
        xorq	-8(%rdi), %rcx
        xorq	-80(%rdi), %r8
        xorq	48(%rdi), %r9
        xorq	-24(%rdi), %rdx
        xorq	64(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -8(%rdi)
        movq	%r11, -80(%rdi)
        movq	%r12, 48(%rdi)
        movq	%r13, -24(%rdi)
        movq	%r14, 64(%rdi)
        # Round 16
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r13
        xorq	-72(%rdi), %r14
        xorq	-64(%rdi), %r12
        xorq	-56(%rdi), %r11
        xorq	-48(%rdi), %r14
        xorq	-40(%rdi), %r12
        xorq	-32(%rdi), %r10
        xorq	-16(%rdi), %r12
        xorq	(%rdi), %r13
        xorq	8(%rdi), %r11
        xorq	16(%rdi), %r14
        xorq	24(%rdi), %r13
        xorq	32(%rdi), %r11
        xorq	40(%rdi), %r14
        xorq	56(%rdi), %r10
        xorq	72(%rdi), %r12
        xorq	80(%rdi), %r10
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %r11
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-56(%rdi), %r11
        movq	-16(%rdi), %r12
        movq	24(%rdi), %r13
        movq	64(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 64(%rdi)
        movq	$0x8000000000008002, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	88(%rdi), %r10
        movq	-72(%rdi), %r11
        movq	-32(%rdi), %r12
        movq	8(%rdi), %r13
        movq	48(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 48(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 88(%rdi)
        # Row 2
        movq	32(%rdi), %r10
        movq	72(%rdi), %r11
        movq	-88(%rdi), %r12
        movq	-48(%rdi), %r13
        movq	-8(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -8(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 32(%rdi)
        # Row 3
        movq	16(%rdi), %r10
        movq	56(%rdi), %r11
        movq	96(%rdi), %r12
        movq	-64(%rdi), %r13
        movq	-24(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 96(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -24(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 16(%rdi)
        # Row 4
        xorq	-40(%rdi), %rcx
        xorq	(%rdi), %r8
        xorq	40(%rdi), %r9
        xorq	80(%rdi), %rdx
        xorq	-80(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -40(%rdi)
        movq	%r11, (%rdi)
        movq	%r12, 40(%rdi)
        movq	%r13, 80(%rdi)
        movq	%r14, -80(%rdi)
        # Round 17
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r12
        xorq	-72(%rdi), %r11
        xorq	-64(%rdi), %r13
        xorq	-56(%rdi), %r11
        xorq	-48(%rdi), %r13
        xorq	-32(%rdi), %r12
        xorq	-24(%rdi), %r14
        xorq	-16(%rdi), %r12
        xorq	-8(%rdi), %r14
        xorq	8(%rdi), %r13
        xorq	16(%rdi), %r10
        xorq	24(%rdi), %r13
        xorq	32(%rdi), %r10
        xorq	48(%rdi), %r14
        xorq	56(%rdi), %r11
        xorq	64(%rdi), %r14
        xorq	72(%rdi), %r11
        xorq	88(%rdi), %r10
        xorq	96(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-72(%rdi), %r11
        movq	-88(%rdi), %r12
        movq	-64(%rdi), %r13
        movq	-80(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -88(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -80(%rdi)
        movq	$0x8000000000000080, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	24(%rdi), %r10
        movq	48(%rdi), %r11
        movq	32(%rdi), %r12
        movq	56(%rdi), %r13
        movq	40(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 40(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 24(%rdi)
        # Row 2
        movq	-56(%rdi), %r10
        movq	-32(%rdi), %r11
        movq	-48(%rdi), %r12
        movq	-24(%rdi), %r13
        movq	-40(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -40(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -56(%rdi)
        # Row 3
        movq	64(%rdi), %r10
        movq	88(%rdi), %r11
        movq	72(%rdi), %r12
        movq	96(%rdi), %r13
        movq	80(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 96(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 80(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 64(%rdi)
        # Row 4
        xorq	-16(%rdi), %rcx
        xorq	8(%rdi), %r8
        xorq	-8(%rdi), %r9
        xorq	16(%rdi), %rdx
        xorq	(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -16(%rdi)
        movq	%r11, 8(%rdi)
        movq	%r12, -8(%rdi)
        movq	%r13, 16(%rdi)
        movq	%r14, (%rdi)
        # Round 18
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r12
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r11
        xorq	-64(%rdi), %r13
        xorq	-56(%rdi), %r10
        xorq	-48(%rdi), %r12
        xorq	-40(%rdi), %r14
        xorq	-32(%rdi), %r11
        xorq	-24(%rdi), %r13
        xorq	24(%rdi), %r10
        xorq	32(%rdi), %r12
        xorq	40(%rdi), %r14
        xorq	48(%rdi), %r11
        xorq	56(%rdi), %r13
        xorq	64(%rdi), %r10
        xorq	72(%rdi), %r12
        xorq	80(%rdi), %r14
        xorq	88(%rdi), %r11
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	48(%rdi), %r11
        movq	-48(%rdi), %r12
        movq	96(%rdi), %r13
        movq	(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 96(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, (%rdi)
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	$0x800a, %rsi
        # Row 1
        movq	-64(%rdi), %r10
        movq	40(%rdi), %r11
        movq	-56(%rdi), %r12
        movq	88(%rdi), %r13
        movq	-8(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 88(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -8(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -64(%rdi)
        # Row 2
        movq	-72(%rdi), %r10
        movq	32(%rdi), %r11
        movq	-24(%rdi), %r12
        movq	80(%rdi), %r13
        movq	-16(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -16(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -72(%rdi)
        # Row 3
        movq	-80(%rdi), %r10
        movq	24(%rdi), %r11
        movq	-32(%rdi), %r12
        movq	72(%rdi), %r13
        movq	16(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 24(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 16(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -80(%rdi)
        # Row 4
        xorq	-88(%rdi), %rcx
        xorq	56(%rdi), %r8
        xorq	-40(%rdi), %r9
        xorq	64(%rdi), %rdx
        xorq	8(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -88(%rdi)
        movq	%r11, 56(%rdi)
        movq	%r12, -40(%rdi)
        movq	%r13, 64(%rdi)
        movq	%r14, 8(%rdi)
        # Round 19
        xorq	%rsi, %r10
        xorq	-80(%rdi), %r10
        xorq	-72(%rdi), %r10
        xorq	-64(%rdi), %r10
        xorq	-56(%rdi), %r12
        xorq	-48(%rdi), %r12
        xorq	-32(%rdi), %r12
        xorq	-24(%rdi), %r12
        xorq	-16(%rdi), %r14
        xorq	-8(%rdi), %r14
        xorq	(%rdi), %r14
        xorq	16(%rdi), %r14
        xorq	24(%rdi), %r11
        xorq	32(%rdi), %r11
        xorq	40(%rdi), %r11
        xorq	48(%rdi), %r11
        xorq	72(%rdi), %r13
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	40(%rdi), %r11
        movq	-24(%rdi), %r12
        movq	72(%rdi), %r13
        movq	8(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -24(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 8(%rdi)
        movq	$0x800000008000000a, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	96(%rdi), %r10
        movq	-8(%rdi), %r11
        movq	-72(%rdi), %r12
        movq	24(%rdi), %r13
        movq	-40(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 24(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -40(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 96(%rdi)
        # Row 2
        movq	48(%rdi), %r10
        movq	-56(%rdi), %r11
        movq	80(%rdi), %r12
        movq	16(%rdi), %r13
        movq	-88(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -56(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 16(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -88(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 48(%rdi)
        # Row 3
        movq	(%rdi), %r10
        movq	-64(%rdi), %r11
        movq	32(%rdi), %r12
        movq	-32(%rdi), %r13
        movq	64(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -64(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 32(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 64(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, (%rdi)
        # Row 4
        xorq	-48(%rdi), %rcx
        xorq	88(%rdi), %r8
        xorq	-16(%rdi), %r9
        xorq	-80(%rdi), %rdx
        xorq	56(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -48(%rdi)
        movq	%r11, 88(%rdi)
        movq	%r12, -16(%rdi)
        movq	%r13, -80(%rdi)
        movq	%r14, 56(%rdi)
        # Round 20
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r14
        xorq	-72(%rdi), %r12
        xorq	-64(%rdi), %r11
        xorq	-56(%rdi), %r11
        xorq	-40(%rdi), %r14
        xorq	-32(%rdi), %r13
        xorq	-24(%rdi), %r12
        xorq	-8(%rdi), %r11
        xorq	(%rdi), %r10
        xorq	8(%rdi), %r14
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %r13
        xorq	32(%rdi), %r12
        xorq	40(%rdi), %r11
        xorq	48(%rdi), %r10
        xorq	64(%rdi), %r14
        xorq	72(%rdi), %r13
        xorq	80(%rdi), %r12
        xorq	96(%rdi), %r10
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-8(%rdi), %r11
        movq	80(%rdi), %r12
        movq	-32(%rdi), %r13
        movq	56(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 56(%rdi)
        movq	$0x8000000080008081, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	72(%rdi), %r10
        movq	-40(%rdi), %r11
        movq	48(%rdi), %r12
        movq	-64(%rdi), %r13
        movq	-16(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -16(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 72(%rdi)
        # Row 2
        movq	40(%rdi), %r10
        movq	-72(%rdi), %r11
        movq	16(%rdi), %r12
        movq	64(%rdi), %r13
        movq	-48(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 64(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -48(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 40(%rdi)
        # Row 3
        movq	8(%rdi), %r10
        movq	96(%rdi), %r11
        movq	-56(%rdi), %r12
        movq	32(%rdi), %r13
        movq	-80(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 96(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -56(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -80(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 8(%rdi)
        # Row 4
        xorq	-24(%rdi), %rcx
        xorq	24(%rdi), %r8
        xorq	-88(%rdi), %r9
        xorq	(%rdi), %rdx
        xorq	88(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, -24(%rdi)
        movq	%r11, 24(%rdi)
        movq	%r12, -88(%rdi)
        movq	%r13, (%rdi)
        movq	%r14, 88(%rdi)
        # Round 21
        xorq	%rsi, %r10
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r11
        xorq	-64(%rdi), %r13
        xorq	-56(%rdi), %r12
        xorq	-48(%rdi), %r14
        xorq	-40(%rdi), %r11
        xorq	-32(%rdi), %r13
        xorq	-16(%rdi), %r14
        xorq	-8(%rdi), %r11
        xorq	8(%rdi), %r10
        xorq	16(%rdi), %r12
        xorq	32(%rdi), %r13
        xorq	40(%rdi), %r10
        xorq	48(%rdi), %r12
        xorq	56(%rdi), %r14
        xorq	64(%rdi), %r13
        xorq	72(%rdi), %r10
        xorq	80(%rdi), %r12
        xorq	96(%rdi), %r11
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-40(%rdi), %r11
        movq	16(%rdi), %r12
        movq	32(%rdi), %r13
        movq	88(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 16(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 88(%rdi)
        movq	$0x8000000000008080, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	-32(%rdi), %r10
        movq	-16(%rdi), %r11
        movq	40(%rdi), %r12
        movq	96(%rdi), %r13
        movq	-88(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 96(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -88(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -32(%rdi)
        # Row 2
        movq	-8(%rdi), %r10
        movq	48(%rdi), %r11
        movq	64(%rdi), %r12
        movq	-80(%rdi), %r13
        movq	-24(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -80(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -24(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -8(%rdi)
        # Row 3
        movq	56(%rdi), %r10
        movq	72(%rdi), %r11
        movq	-72(%rdi), %r12
        movq	-56(%rdi), %r13
        movq	(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 72(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -72(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, (%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 56(%rdi)
        # Row 4
        xorq	80(%rdi), %rcx
        xorq	-64(%rdi), %r8
        xorq	-48(%rdi), %r9
        xorq	8(%rdi), %rdx
        xorq	24(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 80(%rdi)
        movq	%r11, -64(%rdi)
        movq	%r12, -48(%rdi)
        movq	%r13, 8(%rdi)
        movq	%r14, 24(%rdi)
        # Round 22
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r14
        xorq	-80(%rdi), %r13
        xorq	-72(%rdi), %r12
        xorq	-56(%rdi), %r13
        xorq	-40(%rdi), %r11
        xorq	-32(%rdi), %r10
        xorq	-24(%rdi), %r14
        xorq	-16(%rdi), %r11
        xorq	-8(%rdi), %r10
        xorq	(%rdi), %r14
        xorq	16(%rdi), %r12
        xorq	32(%rdi), %r13
        xorq	40(%rdi), %r12
        xorq	48(%rdi), %r11
        xorq	56(%rdi), %r10
        xorq	64(%rdi), %r12
        xorq	72(%rdi), %r11
        xorq	88(%rdi), %r14
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-16(%rdi), %r11
        movq	64(%rdi), %r12
        movq	-56(%rdi), %r13
        movq	24(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -16(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 64(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -56(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 24(%rdi)
        movq	$0x80000001, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	32(%rdi), %r10
        movq	-88(%rdi), %r11
        movq	-8(%rdi), %r12
        movq	72(%rdi), %r13
        movq	-48(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -8(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -48(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 32(%rdi)
        # Row 2
        movq	-40(%rdi), %r10
        movq	40(%rdi), %r11
        movq	-80(%rdi), %r12
        movq	(%rdi), %r13
        movq	80(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 40(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, (%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 80(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -40(%rdi)
        # Row 3
        movq	88(%rdi), %r10
        movq	-32(%rdi), %r11
        movq	48(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	8(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 48(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 8(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 88(%rdi)
        # Row 4
        xorq	16(%rdi), %rcx
        xorq	96(%rdi), %r8
        xorq	-24(%rdi), %r9
        xorq	56(%rdi), %rdx
        xorq	-64(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 16(%rdi)
        movq	%r11, 96(%rdi)
        movq	%r12, -24(%rdi)
        movq	%r13, 56(%rdi)
        movq	%r14, -64(%rdi)
        # Round 23
        xorq	%rsi, %r10
        xorq	-88(%rdi), %r11
        xorq	-80(%rdi), %r12
        xorq	-72(%rdi), %r13
        xorq	-56(%rdi), %r13
        xorq	-48(%rdi), %r14
        xorq	-40(%rdi), %r10
        xorq	-32(%rdi), %r11
        xorq	-16(%rdi), %r11
        xorq	-8(%rdi), %r12
        xorq	(%rdi), %r13
        xorq	8(%rdi), %r14
        xorq	24(%rdi), %r14
        xorq	32(%rdi), %r10
        xorq	40(%rdi), %r11
        xorq	48(%rdi), %r12
        xorq	64(%rdi), %r12
        xorq	72(%rdi), %r13
        xorq	80(%rdi), %r14
        xorq	88(%rdi), %r10
        # Calc t[0..4]
        rorxq	$63, %r11, %rdx
        rorxq	$63, %r12, %rax
        rorxq	$63, %r13, %rcx
        rorxq	$63, %r14, %r8
        rorxq	$63, %r10, %r9
        xorq	%r14, %rdx
        xorq	%r10, %rax
        xorq	%r11, %rcx
        xorq	%r12, %r8
        xorq	%r13, %r9
        # Row Mix
        # Row 0
        movq	%rsi, %r10
        movq	-88(%rdi), %r11
        movq	-80(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	-64(%rdi), %r14
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        rolq	$44, %r11
        rolq	$43, %r12
        rolq	$21, %r13
        rolq	$14, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -88(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -80(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -72(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -64(%rdi)
        movq	$0x8000000080008008, %r14
        andnq	%r12, %r11, %rsi
        xorq	%r10, %rsi
        # XOR in constant
        xorq	%r14, %rsi
        # Row 1
        movq	-56(%rdi), %r10
        movq	-48(%rdi), %r11
        movq	-40(%rdi), %r12
        movq	-32(%rdi), %r13
        movq	-24(%rdi), %r14
        xorq	%r8, %r10
        xorq	%r9, %r11
        xorq	%rdx, %r12
        xorq	%rax, %r13
        xorq	%rcx, %r14
        rolq	$28, %r10
        rolq	$20, %r11
        rolq	$3, %r12
        rolq	$45, %r13
        rolq	$61, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -48(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, -40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, -32(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, -24(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -56(%rdi)
        # Row 2
        movq	-16(%rdi), %r10
        movq	-8(%rdi), %r11
        movq	(%rdi), %r12
        movq	8(%rdi), %r13
        movq	16(%rdi), %r14
        xorq	%rax, %r10
        xorq	%rcx, %r11
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%rdx, %r14
        rolq	$0x01, %r10
        rolq	$6, %r11
        rolq	$25, %r12
        rolq	$8, %r13
        rolq	$18, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, -8(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, (%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 8(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 16(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, -16(%rdi)
        # Row 3
        movq	24(%rdi), %r10
        movq	32(%rdi), %r11
        movq	40(%rdi), %r12
        movq	48(%rdi), %r13
        movq	56(%rdi), %r14
        xorq	%r9, %r10
        xorq	%rdx, %r11
        xorq	%rax, %r12
        xorq	%rcx, %r13
        xorq	%r8, %r14
        rolq	$27, %r10
        rolq	$36, %r11
        rolq	$10, %r12
        rolq	$15, %r13
        rolq	$56, %r14
        andnq	%r13, %r12, %r15
        xorq	%r11, %r15
        movq	%r15, 32(%rdi)
        andnq	%r14, %r13, %r15
        xorq	%r12, %r15
        movq	%r15, 40(%rdi)
        andnq	%r10, %r14, %r15
        xorq	%r13, %r15
        movq	%r15, 48(%rdi)
        andnq	%r11, %r10, %r15
        xorq	%r14, %r15
        movq	%r15, 56(%rdi)
        andnq	%r12, %r11, %r15
        xorq	%r10, %r15
        movq	%r15, 24(%rdi)
        # Row 4
        xorq	64(%rdi), %rcx
        xorq	72(%rdi), %r8
        xorq	80(%rdi), %r9
        xorq	88(%rdi), %rdx
        xorq	96(%rdi), %rax
        rorxq	$2, %rcx, %r10
        rorxq	$9, %r8, %r11
        rorxq	$25, %r9, %r12
        rorxq	$23, %rdx, %r13
        rorxq	$62, %rax, %r14
        andnq	%r12, %r11, %rdx
        andnq	%r13, %r12, %rax
        andnq	%r14, %r13, %rcx
        andnq	%r10, %r14, %r8
        andnq	%r11, %r10, %r9
        xorq	%rdx, %r10
        xorq	%rax, %r11
        xorq	%rcx, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        movq	%r10, 64(%rdi)
        movq	%r11, 72(%rdi)
        movq	%r12, 80(%rdi)
        movq	%r13, 88(%rdi)
        movq	%r14, 96(%rdi)
        movq	%rsi, -96(%rdi)
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sha3_block_bmi2,.-sha3_block_bmi2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	sha3_block_n_bmi2
.type	sha3_block_n_bmi2,@function
.align	16
sha3_block_n_bmi2:
#else
.section	__TEXT,__text
.globl	_sha3_block_n_bmi2
.p2align	4
_sha3_block_n_bmi2:
#endif /* __APPLE__ */
        pushq	%r12
        pushq	%r13
        pushq	%r14
        pushq	%r15
        pushq	%rbx
        pushq	%rbp
        pushq	%rcx
        movq	%rcx, %rbp
        movq	(%rdi), %rcx
        addq	$0x60, %rdi
L_sha3_block_n_bmi2_start:
        cmpq	$0x88, %rbp
        je	L_sha3_block_n_bmi2_load_256
        cmpq	$0xa8, %rbp
        je	L_sha3_block_n_bmi2_load_128
        cmpq	$0x90, %rbp
        je	L_sha3_block_n_bmi2_load_224
        cmpq	$0x68, %rbp
        je	L_sha3_block_n_bmi2_load_384
        movq	(%rsi), %r12
        movq	8(%rsi), %r13
        movq	16(%rsi), %r14
        movq	24(%rsi), %r15
        movq	32(%rsi), %rbx
        movq	40(%rsi), %rax
        movq	48(%rsi), %r8
        movq	56(%rsi), %r9
        movq	64(%rsi), %r10
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r15
        xorq	-64(%rdi), %rbx
        xorq	-56(%rdi), %rax
        xorq	-48(%rdi), %r8
        xorq	-40(%rdi), %r9
        xorq	-32(%rdi), %r10
        movq	%r12, %rcx
        movq	%r13, -88(%rdi)
        movq	%r14, -80(%rdi)
        movq	%r15, -72(%rdi)
        movq	%rbx, -64(%rdi)
        movq	%rax, -56(%rdi)
        movq	%r8, -48(%rdi)
        movq	%r9, -40(%rdi)
        movq	%r10, -32(%rdi)
        jmp	L_sha3_block_n_bmi2_rounds
L_sha3_block_n_bmi2_load_128:
        movq	(%rsi), %r12
        movq	8(%rsi), %r13
        movq	16(%rsi), %r14
        movq	24(%rsi), %r15
        movq	32(%rsi), %rbx
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r15
        xorq	-64(%rdi), %rbx
        movq	%r12, %rcx
        movq	%r13, -88(%rdi)
        movq	%r14, -80(%rdi)
        movq	%r15, -72(%rdi)
        movq	%rbx, -64(%rdi)
        movq	40(%rsi), %rax
        movq	48(%rsi), %r8
        movq	56(%rsi), %r9
        movq	64(%rsi), %r10
        movq	72(%rsi), %r11
        movq	80(%rsi), %rbp
        xorq	-56(%rdi), %rax
        xorq	-48(%rdi), %r8
        xorq	-40(%rdi), %r9
        xorq	-32(%rdi), %r10
        xorq	-24(%rdi), %r11
        xorq	-16(%rdi), %rbp
        movq	%rax, -56(%rdi)
        movq	%r8, -48(%rdi)
        movq	%r9, -40(%rdi)
        movq	%r10, -32(%rdi)
        movq	%r11, -24(%rdi)
        movq	%rbp, -16(%rdi)
        movq	88(%rsi), %rax
        movq	96(%rsi), %r8
        movq	104(%rsi), %r9
        movq	112(%rsi), %r10
        movq	120(%rsi), %r11
        movq	128(%rsi), %rbp
        xorq	-8(%rdi), %rax
        xorq	(%rdi), %r8
        xorq	8(%rdi), %r9
        xorq	16(%rdi), %r10
        xorq	24(%rdi), %r11
        xorq	32(%rdi), %rbp
        movq	%rax, -8(%rdi)
        movq	%r8, (%rdi)
        movq	%r9, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	%r11, 24(%rdi)
        movq	%rbp, 32(%rdi)
        movq	136(%rsi), %rax
        movq	144(%rsi), %r8
        movq	152(%rsi), %r9
        movq	160(%rsi), %r10
        xorq	40(%rdi), %rax
        xorq	48(%rdi), %r8
        xorq	56(%rdi), %r9
        xorq	64(%rdi), %r10
        movq	%rax, 40(%rdi)
        movq	%r8, 48(%rdi)
        movq	%r9, 56(%rdi)
        movq	%r10, 64(%rdi)
        jmp	L_sha3_block_n_bmi2_rounds
L_sha3_block_n_bmi2_load_224:
        movq	40(%rsi), %r12
        movq	48(%rsi), %r13
        movq	56(%rsi), %r14
        movq	64(%rsi), %r15
        movq	72(%rsi), %rbx
        movq	80(%rsi), %rax
        movq	88(%rsi), %r8
        movq	96(%rsi), %r9
        movq	104(%rsi), %r10
        movq	112(%rsi), %r11
        xorq	-56(%rdi), %r12
        xorq	-48(%rdi), %r13
        xorq	-40(%rdi), %r14
        xorq	-32(%rdi), %r15
        xorq	-24(%rdi), %rbx
        xorq	-16(%rdi), %rax
        xorq	-8(%rdi), %r8
        xorq	(%rdi), %r9
        xorq	8(%rdi), %r10
        xorq	16(%rdi), %r11
        movq	%r12, -56(%rdi)
        movq	%r13, -48(%rdi)
        movq	%r14, -40(%rdi)
        movq	%r15, -32(%rdi)
        movq	%rbx, -24(%rdi)
        movq	%rax, -16(%rdi)
        movq	%r8, -8(%rdi)
        movq	%r9, (%rdi)
        movq	%r10, 8(%rdi)
        movq	%r11, 16(%rdi)
        movq	(%rsi), %r12
        movq	8(%rsi), %r13
        movq	16(%rsi), %r14
        movq	24(%rsi), %r15
        movq	32(%rsi), %rbx
        movq	120(%rsi), %rax
        movq	128(%rsi), %r8
        movq	136(%rsi), %r9
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r15
        xorq	-64(%rdi), %rbx
        xorq	24(%rdi), %rax
        xorq	32(%rdi), %r8
        xorq	40(%rdi), %r9
        movq	%r12, %rcx
        movq	%r13, -88(%rdi)
        movq	%r14, -80(%rdi)
        movq	%r15, -72(%rdi)
        movq	%rbx, -64(%rdi)
        movq	%rax, 24(%rdi)
        movq	%r8, 32(%rdi)
        movq	%r9, 40(%rdi)
        jmp	L_sha3_block_n_bmi2_rounds
L_sha3_block_n_bmi2_load_384:
        movq	(%rsi), %r12
        movq	8(%rsi), %r13
        movq	16(%rsi), %r14
        movq	24(%rsi), %r15
        movq	32(%rsi), %rbx
        movq	40(%rsi), %rax
        movq	48(%rsi), %r8
        movq	56(%rsi), %r9
        movq	64(%rsi), %r10
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r15
        xorq	-64(%rdi), %rbx
        xorq	-56(%rdi), %rax
        xorq	-48(%rdi), %r8
        xorq	-40(%rdi), %r9
        xorq	-32(%rdi), %r10
        movq	%r12, %rcx
        movq	%r13, -88(%rdi)
        movq	%r14, -80(%rdi)
        movq	%r15, -72(%rdi)
        movq	%rbx, -64(%rdi)
        movq	%rax, -56(%rdi)
        movq	%r8, -48(%rdi)
        movq	%r9, -40(%rdi)
        movq	%r10, -32(%rdi)
        movq	72(%rsi), %rax
        movq	80(%rsi), %r8
        movq	88(%rsi), %r9
        movq	96(%rsi), %r10
        xorq	-24(%rdi), %rax
        xorq	-16(%rdi), %r8
        xorq	-8(%rdi), %r9
        xorq	(%rdi), %r10
        movq	%rax, -24(%rdi)
        movq	%r8, -16(%rdi)
        movq	%r9, -8(%rdi)
        movq	%r10, (%rdi)
        jmp	L_sha3_block_n_bmi2_rounds
L_sha3_block_n_bmi2_load_256:
        movq	(%rsi), %r12
        movq	8(%rsi), %r13
        movq	16(%rsi), %r14
        movq	24(%rsi), %r15
        movq	32(%rsi), %rbx
        movq	40(%rsi), %rax
        movq	48(%rsi), %r8
        movq	56(%rsi), %r9
        movq	64(%rsi), %r10
        movq	72(%rsi), %r11
        movq	80(%rsi), %rbp
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r15
        xorq	-64(%rdi), %rbx
        xorq	-56(%rdi), %rax
        xorq	-48(%rdi), %r8
        xorq	-40(%rdi), %r9
        xorq	-32(%rdi), %r10
        xorq	-24(%rdi), %r11
        xorq	-16(%rdi), %rbp
        movq	%r12, %rcx
        movq	%r13, -88(%rdi)
        movq	%r14, -80(%rdi)
        movq	%r15, -72(%rdi)
        movq	%rbx, -64(%rdi)
        movq	%rax, -56(%rdi)
        movq	%r8, -48(%rdi)
        movq	%r9, -40(%rdi)
        movq	%r10, -32(%rdi)
        movq	%r11, -24(%rdi)
        movq	%rbp, -16(%rdi)
        movq	88(%rsi), %rax
        movq	96(%rsi), %r8
        movq	104(%rsi), %r9
        movq	112(%rsi), %r10
        movq	120(%rsi), %r11
        movq	128(%rsi), %rbp
        xorq	-8(%rdi), %rax
        xorq	(%rdi), %r8
        xorq	8(%rdi), %r9
        xorq	16(%rdi), %r10
        xorq	24(%rdi), %r11
        xorq	32(%rdi), %rbp
        movq	%rax, -8(%rdi)
        movq	%r8, (%rdi)
        movq	%r9, 8(%rdi)
        movq	%r10, 16(%rdi)
        movq	%r11, 24(%rdi)
        movq	%rbp, 32(%rdi)
L_sha3_block_n_bmi2_rounds:
        # Round 0
        xorq	-56(%rdi), %r12
        xorq	-48(%rdi), %r13
        xorq	-40(%rdi), %r14
        xorq	-32(%rdi), %r15
        xorq	-24(%rdi), %rbx
        xorq	-16(%rdi), %r12
        xorq	-8(%rdi), %r13
        xorq	(%rdi), %r14
        xorq	8(%rdi), %r15
        xorq	16(%rdi), %rbx
        xorq	24(%rdi), %r12
        xorq	32(%rdi), %r13
        xorq	40(%rdi), %r14
        xorq	48(%rdi), %r15
        xorq	56(%rdi), %rbx
        xorq	64(%rdi), %r12
        xorq	72(%rdi), %r13
        xorq	80(%rdi), %r14
        xorq	88(%rdi), %r15
        xorq	96(%rdi), %rbx
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-48(%rdi), %r13
        movq	(%rdi), %r14
        movq	48(%rdi), %r15
        movq	96(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, (%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	$0x01, %rcx
        # Row 1
        movq	-72(%rdi), %r12
        movq	-24(%rdi), %r13
        movq	-16(%rdi), %r14
        movq	32(%rdi), %r15
        movq	80(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -72(%rdi)
        # Row 2
        movq	-88(%rdi), %r12
        movq	-40(%rdi), %r13
        movq	8(%rdi), %r14
        movq	56(%rdi), %r15
        movq	64(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -88(%rdi)
        # Row 3
        movq	-64(%rdi), %r12
        movq	-56(%rdi), %r13
        movq	-8(%rdi), %r14
        movq	40(%rdi), %r15
        movq	88(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -64(%rdi)
        # Row 4
        xorq	-80(%rdi), %r9
        xorq	-32(%rdi), %r10
        xorq	16(%rdi), %r11
        xorq	24(%rdi), %rax
        xorq	72(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -80(%rdi)
        movq	%r13, -32(%rdi)
        movq	%r14, 16(%rdi)
        movq	%r15, 24(%rdi)
        movq	%rbx, 72(%rdi)
        # Round 1
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r12
        xorq	-72(%rdi), %r12
        xorq	-64(%rdi), %r12
        xorq	-56(%rdi), %r13
        xorq	-48(%rdi), %r13
        xorq	-40(%rdi), %r13
        xorq	-24(%rdi), %r13
        xorq	-16(%rdi), %r14
        xorq	-8(%rdi), %r14
        xorq	(%rdi), %r14
        xorq	8(%rdi), %r14
        xorq	32(%rdi), %r15
        xorq	40(%rdi), %r15
        xorq	48(%rdi), %r15
        xorq	56(%rdi), %r15
        xorq	64(%rdi), %rbx
        xorq	80(%rdi), %rbx
        xorq	88(%rdi), %rbx
        xorq	96(%rdi), %rbx
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-24(%rdi), %r13
        movq	8(%rdi), %r14
        movq	40(%rdi), %r15
        movq	72(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	$0x8082, %rcx
        # Row 1
        movq	48(%rdi), %r12
        movq	80(%rdi), %r13
        movq	-88(%rdi), %r14
        movq	-56(%rdi), %r15
        movq	16(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 48(%rdi)
        # Row 2
        movq	-48(%rdi), %r12
        movq	-16(%rdi), %r13
        movq	56(%rdi), %r14
        movq	88(%rdi), %r15
        movq	-80(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -48(%rdi)
        # Row 3
        movq	96(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	-40(%rdi), %r14
        movq	-8(%rdi), %r15
        movq	24(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 96(%rdi)
        # Row 4
        xorq	(%rdi), %r9
        xorq	32(%rdi), %r10
        xorq	64(%rdi), %r11
        xorq	-64(%rdi), %rax
        xorq	-32(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, (%rdi)
        movq	%r13, 32(%rdi)
        movq	%r14, 64(%rdi)
        movq	%r15, -64(%rdi)
        movq	%rbx, -32(%rdi)
        # Round 2
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r14
        xorq	-80(%rdi), %rbx
        xorq	-72(%rdi), %r13
        xorq	-56(%rdi), %r15
        xorq	-48(%rdi), %r12
        xorq	-40(%rdi), %r14
        xorq	-24(%rdi), %r13
        xorq	-16(%rdi), %r13
        xorq	-8(%rdi), %r15
        xorq	8(%rdi), %r14
        xorq	16(%rdi), %rbx
        xorq	24(%rdi), %rbx
        xorq	40(%rdi), %r15
        xorq	48(%rdi), %r12
        xorq	56(%rdi), %r14
        xorq	72(%rdi), %rbx
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %r15
        xorq	96(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	80(%rdi), %r13
        movq	56(%rdi), %r14
        movq	-8(%rdi), %r15
        movq	-32(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -32(%rdi)
        movq	$0x800000000000808a, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	40(%rdi), %r12
        movq	16(%rdi), %r13
        movq	-48(%rdi), %r14
        movq	-72(%rdi), %r15
        movq	64(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 40(%rdi)
        # Row 2
        movq	-24(%rdi), %r12
        movq	-88(%rdi), %r13
        movq	88(%rdi), %r14
        movq	24(%rdi), %r15
        movq	(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, (%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -24(%rdi)
        # Row 3
        movq	72(%rdi), %r12
        movq	48(%rdi), %r13
        movq	-16(%rdi), %r14
        movq	-40(%rdi), %r15
        movq	-64(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 72(%rdi)
        # Row 4
        xorq	8(%rdi), %r9
        xorq	-56(%rdi), %r10
        xorq	-80(%rdi), %r11
        xorq	96(%rdi), %rax
        xorq	32(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 8(%rdi)
        movq	%r13, -56(%rdi)
        movq	%r14, -80(%rdi)
        movq	%r15, 96(%rdi)
        movq	%rbx, 32(%rdi)
        # Round 3
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-72(%rdi), %r15
        xorq	-64(%rdi), %rbx
        xorq	-48(%rdi), %r14
        xorq	-40(%rdi), %r15
        xorq	-32(%rdi), %rbx
        xorq	-24(%rdi), %r12
        xorq	-16(%rdi), %r14
        xorq	-8(%rdi), %r15
        xorq	(%rdi), %rbx
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %r15
        xorq	40(%rdi), %r12
        xorq	48(%rdi), %r13
        xorq	56(%rdi), %r14
        xorq	64(%rdi), %rbx
        xorq	72(%rdi), %r12
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	16(%rdi), %r13
        movq	88(%rdi), %r14
        movq	-40(%rdi), %r15
        movq	32(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 32(%rdi)
        movq	$0x8000000080008000, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	-8(%rdi), %r12
        movq	64(%rdi), %r13
        movq	-24(%rdi), %r14
        movq	48(%rdi), %r15
        movq	-80(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -8(%rdi)
        # Row 2
        movq	80(%rdi), %r12
        movq	-48(%rdi), %r13
        movq	24(%rdi), %r14
        movq	-64(%rdi), %r15
        movq	8(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 80(%rdi)
        # Row 3
        movq	-32(%rdi), %r12
        movq	40(%rdi), %r13
        movq	-88(%rdi), %r14
        movq	-16(%rdi), %r15
        movq	96(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -32(%rdi)
        # Row 4
        xorq	56(%rdi), %r9
        xorq	-72(%rdi), %r10
        xorq	(%rdi), %r11
        xorq	72(%rdi), %rax
        xorq	-56(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 56(%rdi)
        movq	%r13, -72(%rdi)
        movq	%r14, (%rdi)
        movq	%r15, 72(%rdi)
        movq	%rbx, -56(%rdi)
        # Round 4
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r14
        xorq	-80(%rdi), %rbx
        xorq	-64(%rdi), %r15
        xorq	-48(%rdi), %r13
        xorq	-40(%rdi), %r15
        xorq	-32(%rdi), %r12
        xorq	-24(%rdi), %r14
        xorq	-16(%rdi), %r15
        xorq	-8(%rdi), %r12
        xorq	8(%rdi), %rbx
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %r14
        xorq	32(%rdi), %rbx
        xorq	40(%rdi), %r13
        xorq	48(%rdi), %r15
        xorq	64(%rdi), %r13
        xorq	80(%rdi), %r12
        xorq	88(%rdi), %r14
        xorq	96(%rdi), %rbx
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	64(%rdi), %r13
        movq	24(%rdi), %r14
        movq	-16(%rdi), %r15
        movq	-56(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	$0x808b, %rcx
        # Row 1
        movq	-40(%rdi), %r12
        movq	-80(%rdi), %r13
        movq	80(%rdi), %r14
        movq	40(%rdi), %r15
        movq	(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, (%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -40(%rdi)
        # Row 2
        movq	16(%rdi), %r12
        movq	-24(%rdi), %r13
        movq	-64(%rdi), %r14
        movq	96(%rdi), %r15
        movq	56(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 16(%rdi)
        # Row 3
        movq	32(%rdi), %r12
        movq	-8(%rdi), %r13
        movq	-48(%rdi), %r14
        movq	-88(%rdi), %r15
        movq	72(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 32(%rdi)
        # Row 4
        xorq	88(%rdi), %r9
        xorq	48(%rdi), %r10
        xorq	8(%rdi), %r11
        xorq	-32(%rdi), %rax
        xorq	-72(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 88(%rdi)
        movq	%r13, 48(%rdi)
        movq	%r14, 8(%rdi)
        movq	%r15, -32(%rdi)
        movq	%rbx, -72(%rdi)
        # Round 5
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r15
        xorq	-80(%rdi), %r13
        xorq	-64(%rdi), %r14
        xorq	-56(%rdi), %rbx
        xorq	-48(%rdi), %r14
        xorq	-40(%rdi), %r12
        xorq	-24(%rdi), %r13
        xorq	-16(%rdi), %r15
        xorq	-8(%rdi), %r13
        xorq	(%rdi), %rbx
        xorq	16(%rdi), %r12
        xorq	24(%rdi), %r14
        xorq	32(%rdi), %r12
        xorq	40(%rdi), %r15
        xorq	56(%rdi), %rbx
        xorq	64(%rdi), %r13
        xorq	72(%rdi), %rbx
        xorq	80(%rdi), %r14
        xorq	96(%rdi), %r15
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-80(%rdi), %r13
        movq	-64(%rdi), %r14
        movq	-88(%rdi), %r15
        movq	-72(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -72(%rdi)
        movq	$0x80000001, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	-16(%rdi), %r12
        movq	(%rdi), %r13
        movq	16(%rdi), %r14
        movq	-8(%rdi), %r15
        movq	8(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, (%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -16(%rdi)
        # Row 2
        movq	64(%rdi), %r12
        movq	80(%rdi), %r13
        movq	96(%rdi), %r14
        movq	72(%rdi), %r15
        movq	88(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 64(%rdi)
        # Row 3
        movq	-56(%rdi), %r12
        movq	-40(%rdi), %r13
        movq	-24(%rdi), %r14
        movq	-48(%rdi), %r15
        movq	-32(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -56(%rdi)
        # Row 4
        xorq	24(%rdi), %r9
        xorq	40(%rdi), %r10
        xorq	56(%rdi), %r11
        xorq	32(%rdi), %rax
        xorq	48(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 24(%rdi)
        movq	%r13, 40(%rdi)
        movq	%r14, 56(%rdi)
        movq	%r15, 32(%rdi)
        movq	%rbx, 48(%rdi)
        # Round 6
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r15
        xorq	-80(%rdi), %r13
        xorq	-72(%rdi), %rbx
        xorq	-64(%rdi), %r14
        xorq	-56(%rdi), %r12
        xorq	-48(%rdi), %r15
        xorq	-40(%rdi), %r13
        xorq	-32(%rdi), %rbx
        xorq	-24(%rdi), %r14
        xorq	-16(%rdi), %r12
        xorq	-8(%rdi), %r15
        xorq	(%rdi), %r13
        xorq	8(%rdi), %rbx
        xorq	16(%rdi), %r14
        xorq	64(%rdi), %r12
        xorq	72(%rdi), %r15
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %rbx
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	(%rdi), %r13
        movq	96(%rdi), %r14
        movq	-48(%rdi), %r15
        movq	48(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, (%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 48(%rdi)
        movq	$0x8000000080008081, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	-88(%rdi), %r12
        movq	8(%rdi), %r13
        movq	64(%rdi), %r14
        movq	-40(%rdi), %r15
        movq	56(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -88(%rdi)
        # Row 2
        movq	-80(%rdi), %r12
        movq	16(%rdi), %r13
        movq	72(%rdi), %r14
        movq	-32(%rdi), %r15
        movq	24(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -80(%rdi)
        # Row 3
        movq	-72(%rdi), %r12
        movq	-16(%rdi), %r13
        movq	80(%rdi), %r14
        movq	-24(%rdi), %r15
        movq	32(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -72(%rdi)
        # Row 4
        xorq	-64(%rdi), %r9
        xorq	-8(%rdi), %r10
        xorq	88(%rdi), %r11
        xorq	-56(%rdi), %rax
        xorq	40(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -64(%rdi)
        movq	%r13, -8(%rdi)
        movq	%r14, 88(%rdi)
        movq	%r15, -56(%rdi)
        movq	%rbx, 40(%rdi)
        # Round 7
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r12
        xorq	-80(%rdi), %r12
        xorq	-72(%rdi), %r12
        xorq	-48(%rdi), %r15
        xorq	-40(%rdi), %r15
        xorq	-32(%rdi), %r15
        xorq	-24(%rdi), %r15
        xorq	-16(%rdi), %r13
        xorq	(%rdi), %r13
        xorq	8(%rdi), %r13
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %rbx
        xorq	32(%rdi), %rbx
        xorq	48(%rdi), %rbx
        xorq	56(%rdi), %rbx
        xorq	64(%rdi), %r14
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %r14
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	8(%rdi), %r13
        movq	72(%rdi), %r14
        movq	-24(%rdi), %r15
        movq	40(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 40(%rdi)
        movq	$0x8000000000008009, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	-48(%rdi), %r12
        movq	56(%rdi), %r13
        movq	-80(%rdi), %r14
        movq	-16(%rdi), %r15
        movq	88(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -48(%rdi)
        # Row 2
        movq	(%rdi), %r12
        movq	64(%rdi), %r13
        movq	-32(%rdi), %r14
        movq	32(%rdi), %r15
        movq	-64(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, (%rdi)
        # Row 3
        movq	48(%rdi), %r12
        movq	-88(%rdi), %r13
        movq	16(%rdi), %r14
        movq	80(%rdi), %r15
        movq	-56(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 48(%rdi)
        # Row 4
        xorq	96(%rdi), %r9
        xorq	-40(%rdi), %r10
        xorq	24(%rdi), %r11
        xorq	-72(%rdi), %rax
        xorq	-8(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 96(%rdi)
        movq	%r13, -40(%rdi)
        movq	%r14, 24(%rdi)
        movq	%r15, -72(%rdi)
        movq	%rbx, -8(%rdi)
        # Round 8
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r14
        xorq	-64(%rdi), %rbx
        xorq	-56(%rdi), %rbx
        xorq	-48(%rdi), %r12
        xorq	-32(%rdi), %r14
        xorq	-24(%rdi), %r15
        xorq	-16(%rdi), %r15
        xorq	(%rdi), %r12
        xorq	8(%rdi), %r13
        xorq	16(%rdi), %r14
        xorq	32(%rdi), %r15
        xorq	40(%rdi), %rbx
        xorq	48(%rdi), %r12
        xorq	56(%rdi), %r13
        xorq	64(%rdi), %r13
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %r15
        xorq	88(%rdi), %rbx
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	56(%rdi), %r13
        movq	-32(%rdi), %r14
        movq	80(%rdi), %r15
        movq	-8(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	$0x8a, %rcx
        # Row 1
        movq	-24(%rdi), %r12
        movq	88(%rdi), %r13
        movq	(%rdi), %r14
        movq	-88(%rdi), %r15
        movq	24(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, (%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -24(%rdi)
        # Row 2
        movq	8(%rdi), %r12
        movq	-80(%rdi), %r13
        movq	32(%rdi), %r14
        movq	-56(%rdi), %r15
        movq	96(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 8(%rdi)
        # Row 3
        movq	40(%rdi), %r12
        movq	-48(%rdi), %r13
        movq	64(%rdi), %r14
        movq	16(%rdi), %r15
        movq	-72(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 40(%rdi)
        # Row 4
        xorq	72(%rdi), %r9
        xorq	-16(%rdi), %r10
        xorq	-64(%rdi), %r11
        xorq	48(%rdi), %rax
        xorq	-40(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 72(%rdi)
        movq	%r13, -16(%rdi)
        movq	%r14, -64(%rdi)
        movq	%r15, 48(%rdi)
        movq	%rbx, -40(%rdi)
        # Round 9
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r15
        xorq	-80(%rdi), %r13
        xorq	-72(%rdi), %rbx
        xorq	-56(%rdi), %r15
        xorq	-48(%rdi), %r13
        xorq	-32(%rdi), %r14
        xorq	-24(%rdi), %r12
        xorq	-8(%rdi), %rbx
        xorq	(%rdi), %r14
        xorq	8(%rdi), %r12
        xorq	16(%rdi), %r15
        xorq	24(%rdi), %rbx
        xorq	32(%rdi), %r14
        xorq	40(%rdi), %r12
        xorq	56(%rdi), %r13
        xorq	64(%rdi), %r14
        xorq	80(%rdi), %r15
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %rbx
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	88(%rdi), %r13
        movq	32(%rdi), %r14
        movq	16(%rdi), %r15
        movq	-40(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	$0x88, %rcx
        # Row 1
        movq	80(%rdi), %r12
        movq	24(%rdi), %r13
        movq	8(%rdi), %r14
        movq	-48(%rdi), %r15
        movq	-64(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 80(%rdi)
        # Row 2
        movq	56(%rdi), %r12
        movq	(%rdi), %r13
        movq	-56(%rdi), %r14
        movq	-72(%rdi), %r15
        movq	72(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, (%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 56(%rdi)
        # Row 3
        movq	-8(%rdi), %r12
        movq	-24(%rdi), %r13
        movq	-80(%rdi), %r14
        movq	64(%rdi), %r15
        movq	48(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -8(%rdi)
        # Row 4
        xorq	-32(%rdi), %r9
        xorq	-88(%rdi), %r10
        xorq	96(%rdi), %r11
        xorq	40(%rdi), %rax
        xorq	-16(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -32(%rdi)
        movq	%r13, -88(%rdi)
        movq	%r14, 96(%rdi)
        movq	%r15, 40(%rdi)
        movq	%rbx, -16(%rdi)
        # Round 10
        xorq	%rcx, %r12
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r15
        xorq	-64(%rdi), %rbx
        xorq	-56(%rdi), %r14
        xorq	-48(%rdi), %r15
        xorq	-40(%rdi), %rbx
        xorq	-24(%rdi), %r13
        xorq	-8(%rdi), %r12
        xorq	(%rdi), %r13
        xorq	8(%rdi), %r14
        xorq	16(%rdi), %r15
        xorq	24(%rdi), %r13
        xorq	32(%rdi), %r14
        xorq	48(%rdi), %rbx
        xorq	56(%rdi), %r12
        xorq	64(%rdi), %r15
        xorq	72(%rdi), %rbx
        xorq	80(%rdi), %r12
        xorq	88(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	24(%rdi), %r13
        movq	-56(%rdi), %r14
        movq	64(%rdi), %r15
        movq	-16(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -16(%rdi)
        movq	$0x80008009, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	16(%rdi), %r12
        movq	-64(%rdi), %r13
        movq	56(%rdi), %r14
        movq	-24(%rdi), %r15
        movq	96(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 16(%rdi)
        # Row 2
        movq	88(%rdi), %r12
        movq	8(%rdi), %r13
        movq	-72(%rdi), %r14
        movq	48(%rdi), %r15
        movq	-32(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 88(%rdi)
        # Row 3
        movq	-40(%rdi), %r12
        movq	80(%rdi), %r13
        movq	(%rdi), %r14
        movq	-80(%rdi), %r15
        movq	40(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, (%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -40(%rdi)
        # Row 4
        xorq	32(%rdi), %r9
        xorq	-48(%rdi), %r10
        xorq	72(%rdi), %r11
        xorq	-8(%rdi), %rax
        xorq	-88(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 32(%rdi)
        movq	%r13, -48(%rdi)
        movq	%r14, 72(%rdi)
        movq	%r15, -8(%rdi)
        movq	%rbx, -88(%rdi)
        # Round 11
        xorq	%rcx, %r12
        xorq	-80(%rdi), %r15
        xorq	-72(%rdi), %r14
        xorq	-64(%rdi), %r13
        xorq	-56(%rdi), %r14
        xorq	-40(%rdi), %r12
        xorq	-32(%rdi), %rbx
        xorq	-24(%rdi), %r15
        xorq	-16(%rdi), %rbx
        xorq	(%rdi), %r14
        xorq	8(%rdi), %r13
        xorq	16(%rdi), %r12
        xorq	24(%rdi), %r13
        xorq	40(%rdi), %rbx
        xorq	48(%rdi), %r15
        xorq	56(%rdi), %r14
        xorq	64(%rdi), %r15
        xorq	80(%rdi), %r13
        xorq	88(%rdi), %r12
        xorq	96(%rdi), %rbx
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-64(%rdi), %r13
        movq	-72(%rdi), %r14
        movq	-80(%rdi), %r15
        movq	-88(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -88(%rdi)
        movq	$0x8000000a, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	64(%rdi), %r12
        movq	96(%rdi), %r13
        movq	88(%rdi), %r14
        movq	80(%rdi), %r15
        movq	72(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 64(%rdi)
        # Row 2
        movq	24(%rdi), %r12
        movq	56(%rdi), %r13
        movq	48(%rdi), %r14
        movq	40(%rdi), %r15
        movq	32(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 24(%rdi)
        # Row 3
        movq	-16(%rdi), %r12
        movq	16(%rdi), %r13
        movq	8(%rdi), %r14
        movq	(%rdi), %r15
        movq	-8(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, (%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -16(%rdi)
        # Row 4
        xorq	-56(%rdi), %r9
        xorq	-24(%rdi), %r10
        xorq	-32(%rdi), %r11
        xorq	-40(%rdi), %rax
        xorq	-48(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -56(%rdi)
        movq	%r13, -24(%rdi)
        movq	%r14, -32(%rdi)
        movq	%r15, -40(%rdi)
        movq	%rbx, -48(%rdi)
        # Round 12
        xorq	%rcx, %r12
        xorq	-88(%rdi), %rbx
        xorq	-80(%rdi), %r15
        xorq	-72(%rdi), %r14
        xorq	-64(%rdi), %r13
        xorq	-16(%rdi), %r12
        xorq	-8(%rdi), %rbx
        xorq	(%rdi), %r15
        xorq	8(%rdi), %r14
        xorq	16(%rdi), %r13
        xorq	24(%rdi), %r12
        xorq	32(%rdi), %rbx
        xorq	40(%rdi), %r15
        xorq	48(%rdi), %r14
        xorq	56(%rdi), %r13
        xorq	64(%rdi), %r12
        xorq	72(%rdi), %rbx
        xorq	80(%rdi), %r15
        xorq	88(%rdi), %r14
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	96(%rdi), %r13
        movq	48(%rdi), %r14
        movq	(%rdi), %r15
        movq	-48(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, (%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -48(%rdi)
        movq	$0x8000808b, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	-80(%rdi), %r12
        movq	72(%rdi), %r13
        movq	24(%rdi), %r14
        movq	16(%rdi), %r15
        movq	-32(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -80(%rdi)
        # Row 2
        movq	-64(%rdi), %r12
        movq	88(%rdi), %r13
        movq	40(%rdi), %r14
        movq	-8(%rdi), %r15
        movq	-56(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -64(%rdi)
        # Row 3
        movq	-88(%rdi), %r12
        movq	64(%rdi), %r13
        movq	56(%rdi), %r14
        movq	8(%rdi), %r15
        movq	-40(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -88(%rdi)
        # Row 4
        xorq	-72(%rdi), %r9
        xorq	80(%rdi), %r10
        xorq	32(%rdi), %r11
        xorq	-16(%rdi), %rax
        xorq	-24(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -72(%rdi)
        movq	%r13, 80(%rdi)
        movq	%r14, 32(%rdi)
        movq	%r15, -16(%rdi)
        movq	%rbx, -24(%rdi)
        # Round 13
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r12
        xorq	-80(%rdi), %r12
        xorq	-64(%rdi), %r12
        xorq	-56(%rdi), %rbx
        xorq	-48(%rdi), %rbx
        xorq	-40(%rdi), %rbx
        xorq	-32(%rdi), %rbx
        xorq	-8(%rdi), %r15
        xorq	(%rdi), %r15
        xorq	8(%rdi), %r15
        xorq	16(%rdi), %r15
        xorq	24(%rdi), %r14
        xorq	40(%rdi), %r14
        xorq	48(%rdi), %r14
        xorq	56(%rdi), %r14
        xorq	64(%rdi), %r13
        xorq	72(%rdi), %r13
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	72(%rdi), %r13
        movq	40(%rdi), %r14
        movq	8(%rdi), %r15
        movq	-24(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -24(%rdi)
        movq	$0x800000000000008b, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	(%rdi), %r12
        movq	-32(%rdi), %r13
        movq	-64(%rdi), %r14
        movq	64(%rdi), %r15
        movq	32(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, (%rdi)
        # Row 2
        movq	96(%rdi), %r12
        movq	24(%rdi), %r13
        movq	-8(%rdi), %r14
        movq	-40(%rdi), %r15
        movq	-72(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 96(%rdi)
        # Row 3
        movq	-48(%rdi), %r12
        movq	-80(%rdi), %r13
        movq	88(%rdi), %r14
        movq	56(%rdi), %r15
        movq	-16(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -48(%rdi)
        # Row 4
        xorq	48(%rdi), %r9
        xorq	16(%rdi), %r10
        xorq	-56(%rdi), %r11
        xorq	-88(%rdi), %rax
        xorq	80(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 48(%rdi)
        movq	%r13, 16(%rdi)
        movq	%r14, -56(%rdi)
        movq	%r15, -88(%rdi)
        movq	%rbx, 80(%rdi)
        # Round 14
        xorq	%rcx, %r12
        xorq	-80(%rdi), %r13
        xorq	-72(%rdi), %rbx
        xorq	-64(%rdi), %r14
        xorq	-48(%rdi), %r12
        xorq	-40(%rdi), %r15
        xorq	-32(%rdi), %r13
        xorq	-24(%rdi), %rbx
        xorq	-16(%rdi), %rbx
        xorq	-8(%rdi), %r14
        xorq	(%rdi), %r12
        xorq	8(%rdi), %r15
        xorq	24(%rdi), %r13
        xorq	32(%rdi), %rbx
        xorq	40(%rdi), %r14
        xorq	56(%rdi), %r15
        xorq	64(%rdi), %r15
        xorq	72(%rdi), %r13
        xorq	88(%rdi), %r14
        xorq	96(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-32(%rdi), %r13
        movq	-8(%rdi), %r14
        movq	56(%rdi), %r15
        movq	80(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 80(%rdi)
        movq	$0x8000000000008089, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	8(%rdi), %r12
        movq	32(%rdi), %r13
        movq	96(%rdi), %r14
        movq	-80(%rdi), %r15
        movq	-56(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 8(%rdi)
        # Row 2
        movq	72(%rdi), %r12
        movq	-64(%rdi), %r13
        movq	-40(%rdi), %r14
        movq	-16(%rdi), %r15
        movq	48(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 72(%rdi)
        # Row 3
        movq	-24(%rdi), %r12
        movq	(%rdi), %r13
        movq	24(%rdi), %r14
        movq	88(%rdi), %r15
        movq	-88(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, (%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -24(%rdi)
        # Row 4
        xorq	40(%rdi), %r9
        xorq	64(%rdi), %r10
        xorq	-72(%rdi), %r11
        xorq	-48(%rdi), %rax
        xorq	16(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 40(%rdi)
        movq	%r13, 64(%rdi)
        movq	%r14, -72(%rdi)
        movq	%r15, -48(%rdi)
        movq	%rbx, 16(%rdi)
        # Round 15
        xorq	%rcx, %r12
        xorq	-88(%rdi), %rbx
        xorq	-80(%rdi), %r15
        xorq	-64(%rdi), %r13
        xorq	-56(%rdi), %rbx
        xorq	-40(%rdi), %r14
        xorq	-32(%rdi), %r13
        xorq	-24(%rdi), %r12
        xorq	-16(%rdi), %r15
        xorq	-8(%rdi), %r14
        xorq	(%rdi), %r13
        xorq	8(%rdi), %r12
        xorq	24(%rdi), %r14
        xorq	32(%rdi), %r13
        xorq	48(%rdi), %rbx
        xorq	56(%rdi), %r15
        xorq	72(%rdi), %r12
        xorq	80(%rdi), %rbx
        xorq	88(%rdi), %r15
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	32(%rdi), %r13
        movq	-40(%rdi), %r14
        movq	88(%rdi), %r15
        movq	16(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 16(%rdi)
        movq	$0x8000000000008003, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	56(%rdi), %r12
        movq	-56(%rdi), %r13
        movq	72(%rdi), %r14
        movq	(%rdi), %r15
        movq	-72(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, (%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 56(%rdi)
        # Row 2
        movq	-32(%rdi), %r12
        movq	96(%rdi), %r13
        movq	-16(%rdi), %r14
        movq	-88(%rdi), %r15
        movq	40(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -32(%rdi)
        # Row 3
        movq	80(%rdi), %r12
        movq	8(%rdi), %r13
        movq	-64(%rdi), %r14
        movq	24(%rdi), %r15
        movq	-48(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 80(%rdi)
        # Row 4
        xorq	-8(%rdi), %r9
        xorq	-80(%rdi), %r10
        xorq	48(%rdi), %r11
        xorq	-24(%rdi), %rax
        xorq	64(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -8(%rdi)
        movq	%r13, -80(%rdi)
        movq	%r14, 48(%rdi)
        movq	%r15, -24(%rdi)
        movq	%rbx, 64(%rdi)
        # Round 16
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r15
        xorq	-72(%rdi), %rbx
        xorq	-64(%rdi), %r14
        xorq	-56(%rdi), %r13
        xorq	-48(%rdi), %rbx
        xorq	-40(%rdi), %r14
        xorq	-32(%rdi), %r12
        xorq	-16(%rdi), %r14
        xorq	(%rdi), %r15
        xorq	8(%rdi), %r13
        xorq	16(%rdi), %rbx
        xorq	24(%rdi), %r15
        xorq	32(%rdi), %r13
        xorq	40(%rdi), %rbx
        xorq	56(%rdi), %r12
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %r12
        xorq	88(%rdi), %r15
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-56(%rdi), %r13
        movq	-16(%rdi), %r14
        movq	24(%rdi), %r15
        movq	64(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 64(%rdi)
        movq	$0x8000000000008002, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	88(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	-32(%rdi), %r14
        movq	8(%rdi), %r15
        movq	48(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 88(%rdi)
        # Row 2
        movq	32(%rdi), %r12
        movq	72(%rdi), %r13
        movq	-88(%rdi), %r14
        movq	-48(%rdi), %r15
        movq	-8(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 32(%rdi)
        # Row 3
        movq	16(%rdi), %r12
        movq	56(%rdi), %r13
        movq	96(%rdi), %r14
        movq	-64(%rdi), %r15
        movq	-24(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 16(%rdi)
        # Row 4
        xorq	-40(%rdi), %r9
        xorq	(%rdi), %r10
        xorq	40(%rdi), %r11
        xorq	80(%rdi), %rax
        xorq	-80(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -40(%rdi)
        movq	%r13, (%rdi)
        movq	%r14, 40(%rdi)
        movq	%r15, 80(%rdi)
        movq	%rbx, -80(%rdi)
        # Round 17
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r14
        xorq	-72(%rdi), %r13
        xorq	-64(%rdi), %r15
        xorq	-56(%rdi), %r13
        xorq	-48(%rdi), %r15
        xorq	-32(%rdi), %r14
        xorq	-24(%rdi), %rbx
        xorq	-16(%rdi), %r14
        xorq	-8(%rdi), %rbx
        xorq	8(%rdi), %r15
        xorq	16(%rdi), %r12
        xorq	24(%rdi), %r15
        xorq	32(%rdi), %r12
        xorq	48(%rdi), %rbx
        xorq	56(%rdi), %r13
        xorq	64(%rdi), %rbx
        xorq	72(%rdi), %r13
        xorq	88(%rdi), %r12
        xorq	96(%rdi), %r14
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-72(%rdi), %r13
        movq	-88(%rdi), %r14
        movq	-64(%rdi), %r15
        movq	-80(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -80(%rdi)
        movq	$0x8000000000000080, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	24(%rdi), %r12
        movq	48(%rdi), %r13
        movq	32(%rdi), %r14
        movq	56(%rdi), %r15
        movq	40(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 24(%rdi)
        # Row 2
        movq	-56(%rdi), %r12
        movq	-32(%rdi), %r13
        movq	-48(%rdi), %r14
        movq	-24(%rdi), %r15
        movq	-40(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -56(%rdi)
        # Row 3
        movq	64(%rdi), %r12
        movq	88(%rdi), %r13
        movq	72(%rdi), %r14
        movq	96(%rdi), %r15
        movq	80(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 64(%rdi)
        # Row 4
        xorq	-16(%rdi), %r9
        xorq	8(%rdi), %r10
        xorq	-8(%rdi), %r11
        xorq	16(%rdi), %rax
        xorq	(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -16(%rdi)
        movq	%r13, 8(%rdi)
        movq	%r14, -8(%rdi)
        movq	%r15, 16(%rdi)
        movq	%rbx, (%rdi)
        # Round 18
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r14
        xorq	-80(%rdi), %rbx
        xorq	-72(%rdi), %r13
        xorq	-64(%rdi), %r15
        xorq	-56(%rdi), %r12
        xorq	-48(%rdi), %r14
        xorq	-40(%rdi), %rbx
        xorq	-32(%rdi), %r13
        xorq	-24(%rdi), %r15
        xorq	24(%rdi), %r12
        xorq	32(%rdi), %r14
        xorq	40(%rdi), %rbx
        xorq	48(%rdi), %r13
        xorq	56(%rdi), %r15
        xorq	64(%rdi), %r12
        xorq	72(%rdi), %r14
        xorq	80(%rdi), %rbx
        xorq	88(%rdi), %r13
        xorq	96(%rdi), %r15
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	48(%rdi), %r13
        movq	-48(%rdi), %r14
        movq	96(%rdi), %r15
        movq	(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, (%rdi)
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	$0x800a, %rcx
        # Row 1
        movq	-64(%rdi), %r12
        movq	40(%rdi), %r13
        movq	-56(%rdi), %r14
        movq	88(%rdi), %r15
        movq	-8(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 88(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -64(%rdi)
        # Row 2
        movq	-72(%rdi), %r12
        movq	32(%rdi), %r13
        movq	-24(%rdi), %r14
        movq	80(%rdi), %r15
        movq	-16(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -72(%rdi)
        # Row 3
        movq	-80(%rdi), %r12
        movq	24(%rdi), %r13
        movq	-32(%rdi), %r14
        movq	72(%rdi), %r15
        movq	16(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -80(%rdi)
        # Row 4
        xorq	-88(%rdi), %r9
        xorq	56(%rdi), %r10
        xorq	-40(%rdi), %r11
        xorq	64(%rdi), %rax
        xorq	8(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -88(%rdi)
        movq	%r13, 56(%rdi)
        movq	%r14, -40(%rdi)
        movq	%r15, 64(%rdi)
        movq	%rbx, 8(%rdi)
        # Round 19
        xorq	%rcx, %r12
        xorq	-80(%rdi), %r12
        xorq	-72(%rdi), %r12
        xorq	-64(%rdi), %r12
        xorq	-56(%rdi), %r14
        xorq	-48(%rdi), %r14
        xorq	-32(%rdi), %r14
        xorq	-24(%rdi), %r14
        xorq	-16(%rdi), %rbx
        xorq	-8(%rdi), %rbx
        xorq	(%rdi), %rbx
        xorq	16(%rdi), %rbx
        xorq	24(%rdi), %r13
        xorq	32(%rdi), %r13
        xorq	40(%rdi), %r13
        xorq	48(%rdi), %r13
        xorq	72(%rdi), %r15
        xorq	80(%rdi), %r15
        xorq	88(%rdi), %r15
        xorq	96(%rdi), %r15
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	40(%rdi), %r13
        movq	-24(%rdi), %r14
        movq	72(%rdi), %r15
        movq	8(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 8(%rdi)
        movq	$0x800000008000000a, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	96(%rdi), %r12
        movq	-8(%rdi), %r13
        movq	-72(%rdi), %r14
        movq	24(%rdi), %r15
        movq	-40(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 24(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 96(%rdi)
        # Row 2
        movq	48(%rdi), %r12
        movq	-56(%rdi), %r13
        movq	80(%rdi), %r14
        movq	16(%rdi), %r15
        movq	-88(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 48(%rdi)
        # Row 3
        movq	(%rdi), %r12
        movq	-64(%rdi), %r13
        movq	32(%rdi), %r14
        movq	-32(%rdi), %r15
        movq	64(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, (%rdi)
        # Row 4
        xorq	-48(%rdi), %r9
        xorq	88(%rdi), %r10
        xorq	-16(%rdi), %r11
        xorq	-80(%rdi), %rax
        xorq	56(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -48(%rdi)
        movq	%r13, 88(%rdi)
        movq	%r14, -16(%rdi)
        movq	%r15, -80(%rdi)
        movq	%rbx, 56(%rdi)
        # Round 20
        xorq	%rcx, %r12
        xorq	-88(%rdi), %rbx
        xorq	-72(%rdi), %r14
        xorq	-64(%rdi), %r13
        xorq	-56(%rdi), %r13
        xorq	-40(%rdi), %rbx
        xorq	-32(%rdi), %r15
        xorq	-24(%rdi), %r14
        xorq	-8(%rdi), %r13
        xorq	(%rdi), %r12
        xorq	8(%rdi), %rbx
        xorq	16(%rdi), %r15
        xorq	24(%rdi), %r15
        xorq	32(%rdi), %r14
        xorq	40(%rdi), %r13
        xorq	48(%rdi), %r12
        xorq	64(%rdi), %rbx
        xorq	72(%rdi), %r15
        xorq	80(%rdi), %r14
        xorq	96(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-8(%rdi), %r13
        movq	80(%rdi), %r14
        movq	-32(%rdi), %r15
        movq	56(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 56(%rdi)
        movq	$0x8000000080008081, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	72(%rdi), %r12
        movq	-40(%rdi), %r13
        movq	48(%rdi), %r14
        movq	-64(%rdi), %r15
        movq	-16(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 72(%rdi)
        # Row 2
        movq	40(%rdi), %r12
        movq	-72(%rdi), %r13
        movq	16(%rdi), %r14
        movq	64(%rdi), %r15
        movq	-48(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 40(%rdi)
        # Row 3
        movq	8(%rdi), %r12
        movq	96(%rdi), %r13
        movq	-56(%rdi), %r14
        movq	32(%rdi), %r15
        movq	-80(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 8(%rdi)
        # Row 4
        xorq	-24(%rdi), %r9
        xorq	24(%rdi), %r10
        xorq	-88(%rdi), %r11
        xorq	(%rdi), %rax
        xorq	88(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, -24(%rdi)
        movq	%r13, 24(%rdi)
        movq	%r14, -88(%rdi)
        movq	%r15, (%rdi)
        movq	%rbx, 88(%rdi)
        # Round 21
        xorq	%rcx, %r12
        xorq	-80(%rdi), %rbx
        xorq	-72(%rdi), %r13
        xorq	-64(%rdi), %r15
        xorq	-56(%rdi), %r14
        xorq	-48(%rdi), %rbx
        xorq	-40(%rdi), %r13
        xorq	-32(%rdi), %r15
        xorq	-16(%rdi), %rbx
        xorq	-8(%rdi), %r13
        xorq	8(%rdi), %r12
        xorq	16(%rdi), %r14
        xorq	32(%rdi), %r15
        xorq	40(%rdi), %r12
        xorq	48(%rdi), %r14
        xorq	56(%rdi), %rbx
        xorq	64(%rdi), %r15
        xorq	72(%rdi), %r12
        xorq	80(%rdi), %r14
        xorq	96(%rdi), %r13
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-40(%rdi), %r13
        movq	16(%rdi), %r14
        movq	32(%rdi), %r15
        movq	88(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 88(%rdi)
        movq	$0x8000000000008080, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	-32(%rdi), %r12
        movq	-16(%rdi), %r13
        movq	40(%rdi), %r14
        movq	96(%rdi), %r15
        movq	-88(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 96(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -32(%rdi)
        # Row 2
        movq	-8(%rdi), %r12
        movq	48(%rdi), %r13
        movq	64(%rdi), %r14
        movq	-80(%rdi), %r15
        movq	-24(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -8(%rdi)
        # Row 3
        movq	56(%rdi), %r12
        movq	72(%rdi), %r13
        movq	-72(%rdi), %r14
        movq	-56(%rdi), %r15
        movq	(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, (%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 56(%rdi)
        # Row 4
        xorq	80(%rdi), %r9
        xorq	-64(%rdi), %r10
        xorq	-48(%rdi), %r11
        xorq	8(%rdi), %rax
        xorq	24(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 80(%rdi)
        movq	%r13, -64(%rdi)
        movq	%r14, -48(%rdi)
        movq	%r15, 8(%rdi)
        movq	%rbx, 24(%rdi)
        # Round 22
        xorq	%rcx, %r12
        xorq	-88(%rdi), %rbx
        xorq	-80(%rdi), %r15
        xorq	-72(%rdi), %r14
        xorq	-56(%rdi), %r15
        xorq	-40(%rdi), %r13
        xorq	-32(%rdi), %r12
        xorq	-24(%rdi), %rbx
        xorq	-16(%rdi), %r13
        xorq	-8(%rdi), %r12
        xorq	(%rdi), %rbx
        xorq	16(%rdi), %r14
        xorq	32(%rdi), %r15
        xorq	40(%rdi), %r14
        xorq	48(%rdi), %r13
        xorq	56(%rdi), %r12
        xorq	64(%rdi), %r14
        xorq	72(%rdi), %r13
        xorq	88(%rdi), %rbx
        xorq	96(%rdi), %r15
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-16(%rdi), %r13
        movq	64(%rdi), %r14
        movq	-56(%rdi), %r15
        movq	24(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -16(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 64(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -56(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 24(%rdi)
        movq	$0x80000001, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	32(%rdi), %r12
        movq	-88(%rdi), %r13
        movq	-8(%rdi), %r14
        movq	72(%rdi), %r15
        movq	-48(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 32(%rdi)
        # Row 2
        movq	-40(%rdi), %r12
        movq	40(%rdi), %r13
        movq	-80(%rdi), %r14
        movq	(%rdi), %r15
        movq	80(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, (%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 80(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -40(%rdi)
        # Row 3
        movq	88(%rdi), %r12
        movq	-32(%rdi), %r13
        movq	48(%rdi), %r14
        movq	-72(%rdi), %r15
        movq	8(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 88(%rdi)
        # Row 4
        xorq	16(%rdi), %r9
        xorq	96(%rdi), %r10
        xorq	-24(%rdi), %r11
        xorq	56(%rdi), %rax
        xorq	-64(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 16(%rdi)
        movq	%r13, 96(%rdi)
        movq	%r14, -24(%rdi)
        movq	%r15, 56(%rdi)
        movq	%rbx, -64(%rdi)
        # Round 23
        xorq	%rcx, %r12
        xorq	-88(%rdi), %r13
        xorq	-80(%rdi), %r14
        xorq	-72(%rdi), %r15
        xorq	-56(%rdi), %r15
        xorq	-48(%rdi), %rbx
        xorq	-40(%rdi), %r12
        xorq	-32(%rdi), %r13
        xorq	-16(%rdi), %r13
        xorq	-8(%rdi), %r14
        xorq	(%rdi), %r15
        xorq	8(%rdi), %rbx
        xorq	24(%rdi), %rbx
        xorq	32(%rdi), %r12
        xorq	40(%rdi), %r13
        xorq	48(%rdi), %r14
        xorq	64(%rdi), %r14
        xorq	72(%rdi), %r15
        xorq	80(%rdi), %rbx
        xorq	88(%rdi), %r12
        # Calc t[0..4]
        rorxq	$63, %r13, %rax
        rorxq	$63, %r14, %r8
        rorxq	$63, %r15, %r9
        rorxq	$63, %rbx, %r10
        rorxq	$63, %r12, %r11
        xorq	%rbx, %rax
        xorq	%r12, %r8
        xorq	%r13, %r9
        xorq	%r14, %r10
        xorq	%r15, %r11
        # Row Mix
        # Row 0
        movq	%rcx, %r12
        movq	-88(%rdi), %r13
        movq	-80(%rdi), %r14
        movq	-72(%rdi), %r15
        movq	-64(%rdi), %rbx
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        rolq	$44, %r13
        rolq	$43, %r14
        rolq	$21, %r15
        rolq	$14, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -88(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -80(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -72(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -64(%rdi)
        movq	$0x8000000080008008, %rbx
        andnq	%r14, %r13, %rcx
        xorq	%r12, %rcx
        # XOR in constant
        xorq	%rbx, %rcx
        # Row 1
        movq	-56(%rdi), %r12
        movq	-48(%rdi), %r13
        movq	-40(%rdi), %r14
        movq	-32(%rdi), %r15
        movq	-24(%rdi), %rbx
        xorq	%r10, %r12
        xorq	%r11, %r13
        xorq	%rax, %r14
        xorq	%r8, %r15
        xorq	%r9, %rbx
        rolq	$28, %r12
        rolq	$20, %r13
        rolq	$3, %r14
        rolq	$45, %r15
        rolq	$61, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -48(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, -40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, -32(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, -24(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -56(%rdi)
        # Row 2
        movq	-16(%rdi), %r12
        movq	-8(%rdi), %r13
        movq	(%rdi), %r14
        movq	8(%rdi), %r15
        movq	16(%rdi), %rbx
        xorq	%r8, %r12
        xorq	%r9, %r13
        xorq	%r10, %r14
        xorq	%r11, %r15
        xorq	%rax, %rbx
        rolq	$0x01, %r12
        rolq	$6, %r13
        rolq	$25, %r14
        rolq	$8, %r15
        rolq	$18, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, -8(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, (%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 8(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 16(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, -16(%rdi)
        # Row 3
        movq	24(%rdi), %r12
        movq	32(%rdi), %r13
        movq	40(%rdi), %r14
        movq	48(%rdi), %r15
        movq	56(%rdi), %rbx
        xorq	%r11, %r12
        xorq	%rax, %r13
        xorq	%r8, %r14
        xorq	%r9, %r15
        xorq	%r10, %rbx
        rolq	$27, %r12
        rolq	$36, %r13
        rolq	$10, %r14
        rolq	$15, %r15
        rolq	$56, %rbx
        andnq	%r15, %r14, %rbp
        xorq	%r13, %rbp
        movq	%rbp, 32(%rdi)
        andnq	%rbx, %r15, %rbp
        xorq	%r14, %rbp
        movq	%rbp, 40(%rdi)
        andnq	%r12, %rbx, %rbp
        xorq	%r15, %rbp
        movq	%rbp, 48(%rdi)
        andnq	%r13, %r12, %rbp
        xorq	%rbx, %rbp
        movq	%rbp, 56(%rdi)
        andnq	%r14, %r13, %rbp
        xorq	%r12, %rbp
        movq	%rbp, 24(%rdi)
        # Row 4
        xorq	64(%rdi), %r9
        xorq	72(%rdi), %r10
        xorq	80(%rdi), %r11
        xorq	88(%rdi), %rax
        xorq	96(%rdi), %r8
        rorxq	$2, %r9, %r12
        rorxq	$9, %r10, %r13
        rorxq	$25, %r11, %r14
        rorxq	$23, %rax, %r15
        rorxq	$62, %r8, %rbx
        andnq	%r14, %r13, %rax
        andnq	%r15, %r14, %r8
        andnq	%rbx, %r15, %r9
        andnq	%r12, %rbx, %r10
        andnq	%r13, %r12, %r11
        xorq	%rax, %r12
        xorq	%r8, %r13
        xorq	%r9, %r14
        xorq	%r10, %r15
        xorq	%r11, %rbx
        movq	%r12, 64(%rdi)
        movq	%r13, 72(%rdi)
        movq	%r14, 80(%rdi)
        movq	%r15, 88(%rdi)
        movq	%rbx, 96(%rdi)
        addq	(%rsp), %rsi
        subl	$0x01, %edx
        movq	(%rsp), %rbp
        jg	L_sha3_block_n_bmi2_start
        movq	%rcx, -96(%rdi)
        popq	%rbp
        popq	%rbp
        popq	%rbx
        popq	%r15
        popq	%r14
        popq	%r13
        popq	%r12
        repz retq
#ifndef __APPLE__
.size	sha3_block_n_bmi2,.-sha3_block_n_bmi2
#endif /* __APPLE__ */
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_sha3_block_avx2_rotl:
.quad	0x1,0x3e
.quad	0x1c,0x1b
.quad	0x2c,0x6
.quad	0x37,0x14
.quad	0xa,0x2b
.quad	0x19,0x27
.quad	0x2d,0xf
.quad	0x15,0x8
.quad	0x24,0x3
.quad	0x29,0x12
.quad	0x2,0x3d
.quad	0x38,0xe
#ifndef __APPLE__
.data
#else
.section	__DATA,__data
#endif /* __APPLE__ */
#ifndef __APPLE__
.align	16
#else
.p2align	4
#endif /* __APPLE__ */
L_sha3_block_avx2_rotr:
.quad	0x3f,0x2
.quad	0x24,0x25
.quad	0x14,0x3a
.quad	0x9,0x2c
.quad	0x36,0x15
.quad	0x27,0x19
.quad	0x13,0x31
.quad	0x2b,0x38
.quad	0x1c,0x3d
.quad	0x17,0x2e
.quad	0x3e,0x3
.quad	0x8,0x32
#ifndef __APPLE__
.text
.globl	sha3_block_avx2
.type	sha3_block_avx2,@function
.align	16
sha3_block_avx2:
#else
.section	__TEXT,__text
.globl	_sha3_block_avx2
.p2align	4
_sha3_block_avx2:
#endif /* __APPLE__ */
        leaq	L_sha3_avx2_r(%rip), %rdx
        leaq	L_sha3_block_avx2_rotl(%rip), %rax
        addq	$0x40, %rax
        leaq	L_sha3_block_avx2_rotr(%rip), %rcx
        addq	$0x40, %rcx
        movq	$24, %r8
        vpbroadcastq	(%rdi), %ymm0
        vmovdqu	8(%rdi), %ymm1
        vmovdqu	40(%rdi), %ymm2
        vmovdqu	72(%rdi), %ymm3
        vmovdqu	104(%rdi), %ymm4
        vmovdqu	136(%rdi), %ymm5
        vmovdqu	168(%rdi), %ymm6
        vpermq	$57, %ymm2, %ymm7
        vpermq	$30, %ymm3, %ymm8
        vpermq	$0x4b, %ymm4, %ymm9
        vpermq	$0x93, %ymm5, %ymm10
        vpblendd	$12, %ymm3, %ymm2, %ymm11
        vpblendd	$0xc0, %ymm5, %ymm4, %ymm12
        vpblendd	$0xc0, %ymm8, %ymm7, %ymm2
        vpblendd	$0xf0, %ymm9, %ymm8, %ymm3
        vpblendd	$3, %ymm9, %ymm10, %ymm4
        vpblendd	$0xf0, %ymm12, %ymm11, %ymm5
L_sha3_block_avx2_start:
        # Calc b[0..4]
        vpshufd	$0xee, %ymm5, %ymm7
        vpxor	%ymm7, %ymm5, %ymm14
        vpxor	%ymm2, %ymm1, %ymm15
        vpermq	$0xaa, %ymm14, %ymm7
        vpxor	%ymm0, %ymm14, %ymm14
        vpxor	%ymm4, %ymm3, %ymm12
        vpxor	%ymm7, %ymm14, %ymm14
        vpermq	$0x00, %ymm14, %ymm14
        vpxor	%ymm6, %ymm15, %ymm15
        vpxor	%ymm12, %ymm15, %ymm15
        # XOR in b[x+4]
        vpermq	$0x93, %ymm15, %ymm7
        vpermq	$57, %ymm15, %ymm9
        vpermq	$0xff, %ymm15, %ymm8
        vpermq	$0x00, %ymm15, %ymm10
        vpblendd	$3, %ymm14, %ymm7, %ymm7
        vpblendd	$0xc0, %ymm14, %ymm9, %ymm9
        vpxor	%ymm8, %ymm0, %ymm0
        vpxor	%ymm7, %ymm1, %ymm1
        vpxor	%ymm7, %ymm2, %ymm2
        vpxor	%ymm7, %ymm3, %ymm3
        vpxor	%ymm7, %ymm4, %ymm4
        vpxor	%ymm8, %ymm5, %ymm5
        vpxor	%ymm7, %ymm6, %ymm6
        # Rotate left 1
        vpsrlq	$63, %ymm9, %ymm7
        vpsrlq	$63, %ymm10, %ymm8
        vpaddq	%ymm9, %ymm9, %ymm9
        vpaddq	%ymm10, %ymm10, %ymm10
        vpor	%ymm7, %ymm9, %ymm9
        vpor	%ymm8, %ymm10, %ymm10
        # XOR in ROTL64(b[x+1])
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm9, %ymm1, %ymm1
        vpxor	%ymm9, %ymm2, %ymm2
        vpxor	%ymm9, %ymm3, %ymm3
        vpxor	%ymm9, %ymm4, %ymm4
        vpxor	%ymm10, %ymm5, %ymm5
        vpxor	%ymm9, %ymm6, %ymm6
        # Shuffle - Rotate
        vpsrlvq	-64(%rcx), %ymm1, %ymm8
        vpsrlvq	-32(%rcx), %ymm2, %ymm9
        vpsrlvq	(%rcx), %ymm3, %ymm10
        vpsrlvq	32(%rcx), %ymm4, %ymm11
        vpsrlvq	64(%rcx), %ymm5, %ymm12
        vpsrlvq	96(%rcx), %ymm6, %ymm13
        vpsllvq	-64(%rax), %ymm1, %ymm1
        vpsllvq	-32(%rax), %ymm2, %ymm2
        vpsllvq	(%rax), %ymm3, %ymm3
        vpsllvq	32(%rax), %ymm4, %ymm4
        vpsllvq	64(%rax), %ymm5, %ymm5
        vpsllvq	96(%rax), %ymm6, %ymm6
        vpor	%ymm8, %ymm1, %ymm1
        vpor	%ymm9, %ymm2, %ymm2
        vpor	%ymm10, %ymm3, %ymm3
        vpor	%ymm11, %ymm4, %ymm4
        vpor	%ymm12, %ymm5, %ymm5
        vpor	%ymm13, %ymm6, %ymm6
        # Row Mix
        vpermq	$0x00, %ymm2, %ymm12
        vpermq	$0x55, %ymm3, %ymm13
        vpermq	$0xaa, %ymm4, %ymm14
        vpermq	$0xff, %ymm6, %ymm15
        vpandn	%ymm14, %ymm13, %ymm7
        vpandn	%ymm15, %ymm14, %ymm8
        vpandn	%ymm0, %ymm15, %ymm9
        vpandn	%ymm12, %ymm0, %ymm10
        vpandn	%ymm13, %ymm12, %ymm11
        vpxor	%ymm7, %ymm12, %ymm12
        vpxor	%ymm8, %ymm13, %ymm13
        vpxor	%ymm9, %ymm14, %ymm14
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm0, %ymm0
        vpermq	$0x8d, %ymm5, %ymm7
        vpblendd	$12, %ymm13, %ymm12, %ymm10
        vpermq	$0x72, %ymm1, %ymm11
        vpblendd	$0xc0, %ymm15, %ymm14, %ymm9
        vpermq	$0x87, %ymm2, %ymm12
        vpblendd	$0xf0, %ymm9, %ymm10, %ymm1
        vpermq	$0xc9, %ymm3, %ymm13
        vpermq	$0x9c, %ymm4, %ymm14
        vpermq	$45, %ymm6, %ymm15
        vpblendd	$48, %ymm7, %ymm12, %ymm12
        vpblendd	$3, %ymm7, %ymm13, %ymm13
        vpblendd	$0xc0, %ymm7, %ymm14, %ymm14
        vpblendd	$12, %ymm7, %ymm15, %ymm15
        vpandn	%ymm13, %ymm12, %ymm5
        vpandn	%ymm14, %ymm13, %ymm7
        vpandn	%ymm15, %ymm14, %ymm2
        vpandn	%ymm11, %ymm15, %ymm3
        vpandn	%ymm12, %ymm11, %ymm4
        vpxor	%ymm5, %ymm11, %ymm5
        vpxor	%ymm7, %ymm12, %ymm12
        vpxor	%ymm2, %ymm13, %ymm13
        vpxor	%ymm3, %ymm14, %ymm14
        vpxor	%ymm4, %ymm15, %ymm15
        vpunpcklqdq	%ymm13, %ymm12, %ymm2
        vpunpckhqdq	%ymm13, %ymm12, %ymm3
        vpunpcklqdq	%ymm15, %ymm14, %ymm7
        vpunpckhqdq	%ymm15, %ymm14, %ymm8
        vperm2i128	$49, %ymm7, %ymm2, %ymm4
        vperm2i128	$49, %ymm8, %ymm3, %ymm6
        vperm2i128	$32, %ymm7, %ymm2, %ymm2
        vperm2i128	$32, %ymm8, %ymm3, %ymm3
        vpxor	(%rdx), %ymm0, %ymm0
        addq	$32, %rdx
        subq	$0x01, %r8
        jnz	L_sha3_block_avx2_start
        vpermq	$0x93, %ymm2, %ymm7
        vpermq	$0x4e, %ymm3, %ymm8
        vpermq	$57, %ymm4, %ymm9
        vpblendd	$3, %ymm5, %ymm7, %ymm2
        vpblendd	$3, %ymm7, %ymm8, %ymm3
        vpblendd	$12, %ymm5, %ymm3, %ymm3
        vpblendd	$0xc0, %ymm9, %ymm8, %ymm4
        vpblendd	$48, %ymm5, %ymm4, %ymm4
        vpblendd	$0xc0, %ymm5, %ymm9, %ymm5
        vmovq	%xmm0, (%rdi)
        vmovdqu	%ymm1, 8(%rdi)
        vmovdqu	%ymm2, 40(%rdi)
        vmovdqu	%ymm3, 72(%rdi)
        vmovdqu	%ymm4, 104(%rdi)
        vmovdqu	%ymm5, 136(%rdi)
        vmovdqu	%ymm6, 168(%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	sha3_block_avx2,.-sha3_block_avx2
#endif /* __APPLE__ */
#ifndef __APPLE__
.text
.globl	kyber_sha3_blocksx4_avx2
.type	kyber_sha3_blocksx4_avx2,@function
.align	16
kyber_sha3_blocksx4_avx2:
#else
.section	__TEXT,__text
.globl	_kyber_sha3_blocksx4_avx2
.p2align	4
_kyber_sha3_blocksx4_avx2:
#endif /* __APPLE__ */
        leaq	L_sha3_x4_avx2_r(%rip), %rdx
        vmovdqu	(%rdi), %ymm15
        movq	%rdi, %rax
        movq	%rdi, %rcx
        addq	$0x80, %rdi
        addq	$0x180, %rax
        addq	$0x280, %rcx
        # Round 0
        # Calc b[0..4]
        vmovdqu	-96(%rdi), %ymm11
        vmovdqu	-64(%rdi), %ymm12
        vmovdqu	-32(%rdi), %ymm13
        vmovdqu	(%rdi), %ymm14
        vpxor	32(%rdi), %ymm15, %ymm10
        vpxor	64(%rdi), %ymm11, %ymm11
        vpxor	96(%rdi), %ymm12, %ymm12
        vpxor	128(%rdi), %ymm13, %ymm13
        vpxor	-96(%rax), %ymm14, %ymm14
        vpxor	-64(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm10, %ymm10
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rdi), %ymm6, %ymm11
        vpxor	(%rax), %ymm7, %ymm12
        vpxor	-64(%rcx), %ymm8, %ymm13
        vpxor	128(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 1
        vpxor	-32(%rdi), %ymm8, %ymm10
        vpxor	-96(%rax), %ymm9, %ymm11
        vpxor	-64(%rax), %ymm5, %ymm12
        vpxor	128(%rax), %ymm6, %ymm13
        vpxor	64(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 2
        vpxor	-96(%rdi), %ymm6, %ymm10
        vpxor	96(%rdi), %ymm7, %ymm11
        vpxor	32(%rax), %ymm8, %ymm12
        vpxor	-32(%rcx), %ymm9, %ymm13
        vpxor	(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, (%rcx)
        # Row 3
        vpxor	(%rdi), %ymm9, %ymm10
        vpxor	32(%rdi), %ymm5, %ymm11
        vpxor	-32(%rax), %ymm6, %ymm12
        vpxor	-96(%rcx), %ymm7, %ymm13
        vpxor	96(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 4
        vpxor	-64(%rdi), %ymm7, %ymm10
        vpxor	128(%rdi), %ymm8, %ymm11
        vpxor	64(%rax), %ymm9, %ymm12
        vpxor	96(%rax), %ymm5, %ymm13
        vpxor	32(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 32(%rcx)
        # Round 1
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm1, %ymm11
        vpxor	64(%rdi), %ymm11, %ymm11
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm2, %ymm12
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm3, %ymm13
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm4, %ymm14
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rax), %ymm6, %ymm11
        vpxor	32(%rax), %ymm7, %ymm12
        vpxor	-96(%rcx), %ymm8, %ymm13
        vpxor	32(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	32(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 1
        vpxor	-64(%rcx), %ymm8, %ymm10
        vpxor	64(%rcx), %ymm9, %ymm11
        vpxor	-96(%rdi), %ymm5, %ymm12
        vpxor	32(%rdi), %ymm6, %ymm13
        vpxor	64(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 64(%rax)
        # Row 2
        vpxor	64(%rdi), %ymm6, %ymm10
        vpxor	-64(%rax), %ymm7, %ymm11
        vpxor	-32(%rcx), %ymm8, %ymm12
        vpxor	96(%rcx), %ymm9, %ymm13
        vpxor	-64(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 3
        vpxor	128(%rcx), %ymm9, %ymm10
        vpxor	-32(%rdi), %ymm5, %ymm11
        vpxor	96(%rdi), %ymm6, %ymm12
        vpxor	-32(%rax), %ymm7, %ymm13
        vpxor	96(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 96(%rax)
        # Row 4
        vpxor	(%rax), %ymm7, %ymm10
        vpxor	128(%rax), %ymm8, %ymm11
        vpxor	(%rcx), %ymm9, %ymm12
        vpxor	(%rdi), %ymm5, %ymm13
        vpxor	128(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        # Round 2
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm3, %ymm13
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	96(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rcx), %ymm6, %ymm11
        vpxor	-32(%rcx), %ymm7, %ymm12
        vpxor	-32(%rax), %ymm8, %ymm13
        vpxor	128(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	64(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 1
        vpxor	-96(%rcx), %ymm8, %ymm10
        vpxor	64(%rax), %ymm9, %ymm11
        vpxor	64(%rdi), %ymm5, %ymm12
        vpxor	-32(%rdi), %ymm6, %ymm13
        vpxor	(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, (%rcx)
        # Row 2
        vpxor	-96(%rax), %ymm6, %ymm10
        vpxor	-96(%rdi), %ymm7, %ymm11
        vpxor	96(%rcx), %ymm8, %ymm12
        vpxor	96(%rax), %ymm9, %ymm13
        vpxor	(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, (%rax)
        # Row 3
        vpxor	32(%rcx), %ymm9, %ymm10
        vpxor	-64(%rcx), %ymm5, %ymm11
        vpxor	-64(%rax), %ymm6, %ymm12
        vpxor	96(%rdi), %ymm7, %ymm13
        vpxor	(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 4
        vpxor	32(%rax), %ymm7, %ymm10
        vpxor	32(%rdi), %ymm8, %ymm11
        vpxor	-64(%rdi), %ymm9, %ymm12
        vpxor	128(%rcx), %ymm5, %ymm13
        vpxor	128(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Round 3
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm2, %ymm12
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	64(%rax), %ymm6, %ymm11
        vpxor	96(%rcx), %ymm7, %ymm12
        vpxor	96(%rdi), %ymm8, %ymm13
        vpxor	128(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	96(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 128(%rax)
        # Row 1
        vpxor	-32(%rax), %ymm8, %ymm10
        vpxor	(%rcx), %ymm9, %ymm11
        vpxor	-96(%rax), %ymm5, %ymm12
        vpxor	-64(%rcx), %ymm6, %ymm13
        vpxor	-64(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 2
        vpxor	64(%rcx), %ymm6, %ymm10
        vpxor	64(%rdi), %ymm7, %ymm11
        vpxor	96(%rax), %ymm8, %ymm12
        vpxor	(%rdi), %ymm9, %ymm13
        vpxor	32(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, 32(%rax)
        # Row 3
        vpxor	128(%rdi), %ymm9, %ymm10
        vpxor	-96(%rcx), %ymm5, %ymm11
        vpxor	-96(%rdi), %ymm6, %ymm12
        vpxor	-64(%rax), %ymm7, %ymm13
        vpxor	128(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 4
        vpxor	-32(%rcx), %ymm7, %ymm10
        vpxor	-32(%rdi), %ymm8, %ymm11
        vpxor	(%rax), %ymm9, %ymm12
        vpxor	32(%rcx), %ymm5, %ymm13
        vpxor	32(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 32(%rdi)
        # Round 4
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	64(%rdi), %ymm1, %ymm11
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rcx), %ymm6, %ymm11
        vpxor	96(%rax), %ymm7, %ymm12
        vpxor	-64(%rax), %ymm8, %ymm13
        vpxor	32(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	128(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 1
        vpxor	96(%rdi), %ymm8, %ymm10
        vpxor	-64(%rdi), %ymm9, %ymm11
        vpxor	64(%rcx), %ymm5, %ymm12
        vpxor	-96(%rcx), %ymm6, %ymm13
        vpxor	(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, (%rax)
        # Row 2
        vpxor	64(%rax), %ymm6, %ymm10
        vpxor	-96(%rax), %ymm7, %ymm11
        vpxor	(%rdi), %ymm8, %ymm12
        vpxor	128(%rcx), %ymm9, %ymm13
        vpxor	-32(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 3
        vpxor	128(%rax), %ymm9, %ymm10
        vpxor	-32(%rax), %ymm5, %ymm11
        vpxor	64(%rdi), %ymm6, %ymm12
        vpxor	-96(%rdi), %ymm7, %ymm13
        vpxor	32(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 4
        vpxor	96(%rcx), %ymm7, %ymm10
        vpxor	-64(%rcx), %ymm8, %ymm11
        vpxor	32(%rax), %ymm9, %ymm12
        vpxor	128(%rdi), %ymm5, %ymm13
        vpxor	-32(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Round 5
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rdi), %ymm6, %ymm11
        vpxor	(%rdi), %ymm7, %ymm12
        vpxor	-96(%rdi), %ymm8, %ymm13
        vpxor	-32(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	160(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 1
        vpxor	-64(%rax), %ymm8, %ymm10
        vpxor	(%rax), %ymm9, %ymm11
        vpxor	64(%rax), %ymm5, %ymm12
        vpxor	-32(%rax), %ymm6, %ymm13
        vpxor	32(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 32(%rax)
        # Row 2
        vpxor	(%rcx), %ymm6, %ymm10
        vpxor	64(%rcx), %ymm7, %ymm11
        vpxor	128(%rcx), %ymm8, %ymm12
        vpxor	32(%rcx), %ymm9, %ymm13
        vpxor	96(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 3
        vpxor	32(%rdi), %ymm9, %ymm10
        vpxor	96(%rdi), %ymm5, %ymm11
        vpxor	-96(%rax), %ymm6, %ymm12
        vpxor	64(%rdi), %ymm7, %ymm13
        vpxor	128(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 4
        vpxor	96(%rax), %ymm7, %ymm10
        vpxor	-96(%rcx), %ymm8, %ymm11
        vpxor	-32(%rcx), %ymm9, %ymm12
        vpxor	128(%rax), %ymm5, %ymm13
        vpxor	-64(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Round 6
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rax), %ymm6, %ymm11
        vpxor	128(%rcx), %ymm7, %ymm12
        vpxor	64(%rdi), %ymm8, %ymm13
        vpxor	-64(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	192(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 1
        vpxor	-96(%rdi), %ymm8, %ymm10
        vpxor	32(%rax), %ymm9, %ymm11
        vpxor	(%rcx), %ymm5, %ymm12
        vpxor	96(%rdi), %ymm6, %ymm13
        vpxor	-32(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 2
        vpxor	-64(%rdi), %ymm6, %ymm10
        vpxor	64(%rax), %ymm7, %ymm11
        vpxor	32(%rcx), %ymm8, %ymm12
        vpxor	128(%rdi), %ymm9, %ymm13
        vpxor	96(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 3
        vpxor	-32(%rdi), %ymm9, %ymm10
        vpxor	-64(%rax), %ymm5, %ymm11
        vpxor	64(%rcx), %ymm6, %ymm12
        vpxor	-96(%rax), %ymm7, %ymm13
        vpxor	128(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 128(%rax)
        # Row 4
        vpxor	(%rdi), %ymm7, %ymm10
        vpxor	-32(%rax), %ymm8, %ymm11
        vpxor	96(%rcx), %ymm9, %ymm12
        vpxor	32(%rdi), %ymm5, %ymm13
        vpxor	-96(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Round 7
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm3, %ymm13
        vpxor	96(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm13, %ymm13
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm1, %ymm11
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm4, %ymm14
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm2, %ymm12
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rax), %ymm6, %ymm11
        vpxor	32(%rcx), %ymm7, %ymm12
        vpxor	-96(%rax), %ymm8, %ymm13
        vpxor	-96(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	224(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 1
        vpxor	64(%rdi), %ymm8, %ymm10
        vpxor	-32(%rcx), %ymm9, %ymm11
        vpxor	-64(%rdi), %ymm5, %ymm12
        vpxor	-64(%rax), %ymm6, %ymm13
        vpxor	96(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 2
        vpxor	(%rax), %ymm6, %ymm10
        vpxor	(%rcx), %ymm7, %ymm11
        vpxor	128(%rdi), %ymm8, %ymm12
        vpxor	128(%rax), %ymm9, %ymm13
        vpxor	(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, (%rdi)
        # Row 3
        vpxor	-64(%rcx), %ymm9, %ymm10
        vpxor	-96(%rdi), %ymm5, %ymm11
        vpxor	64(%rax), %ymm6, %ymm12
        vpxor	64(%rcx), %ymm7, %ymm13
        vpxor	32(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 4
        vpxor	128(%rcx), %ymm7, %ymm10
        vpxor	96(%rdi), %ymm8, %ymm11
        vpxor	96(%rax), %ymm9, %ymm12
        vpxor	-32(%rdi), %ymm5, %ymm13
        vpxor	-32(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, -32(%rax)
        # Round 8
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm14, %ymm14
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm3, %ymm13
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rcx), %ymm6, %ymm11
        vpxor	128(%rdi), %ymm7, %ymm12
        vpxor	64(%rcx), %ymm8, %ymm13
        vpxor	-32(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	256(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -32(%rax)
        # Row 1
        vpxor	-96(%rax), %ymm8, %ymm10
        vpxor	96(%rcx), %ymm9, %ymm11
        vpxor	(%rax), %ymm5, %ymm12
        vpxor	-96(%rdi), %ymm6, %ymm13
        vpxor	96(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 2
        vpxor	32(%rax), %ymm6, %ymm10
        vpxor	-64(%rdi), %ymm7, %ymm11
        vpxor	128(%rax), %ymm8, %ymm12
        vpxor	32(%rdi), %ymm9, %ymm13
        vpxor	128(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 3
        vpxor	-96(%rcx), %ymm9, %ymm10
        vpxor	64(%rdi), %ymm5, %ymm11
        vpxor	(%rcx), %ymm6, %ymm12
        vpxor	64(%rax), %ymm7, %ymm13
        vpxor	-32(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 4
        vpxor	32(%rcx), %ymm7, %ymm10
        vpxor	-64(%rax), %ymm8, %ymm11
        vpxor	(%rdi), %ymm9, %ymm12
        vpxor	-64(%rcx), %ymm5, %ymm13
        vpxor	96(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 96(%rdi)
        # Round 9
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	64(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm2, %ymm12
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rcx), %ymm6, %ymm11
        vpxor	128(%rax), %ymm7, %ymm12
        vpxor	64(%rax), %ymm8, %ymm13
        vpxor	96(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	288(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 1
        vpxor	64(%rcx), %ymm8, %ymm10
        vpxor	96(%rax), %ymm9, %ymm11
        vpxor	32(%rax), %ymm5, %ymm12
        vpxor	64(%rdi), %ymm6, %ymm13
        vpxor	(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 2
        vpxor	-32(%rcx), %ymm6, %ymm10
        vpxor	(%rax), %ymm7, %ymm11
        vpxor	32(%rdi), %ymm8, %ymm12
        vpxor	-32(%rdi), %ymm9, %ymm13
        vpxor	32(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 3
        vpxor	-32(%rax), %ymm9, %ymm10
        vpxor	-96(%rax), %ymm5, %ymm11
        vpxor	-64(%rdi), %ymm6, %ymm12
        vpxor	(%rcx), %ymm7, %ymm13
        vpxor	-64(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 4
        vpxor	128(%rdi), %ymm7, %ymm10
        vpxor	-96(%rdi), %ymm8, %ymm11
        vpxor	128(%rcx), %ymm9, %ymm12
        vpxor	-96(%rcx), %ymm5, %ymm13
        vpxor	-64(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Round 10
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm4, %ymm14
        vpxor	32(%rdi), %ymm12, %ymm12
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	-96(%rax), %ymm1, %ymm11
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rax), %ymm6, %ymm11
        vpxor	32(%rdi), %ymm7, %ymm12
        vpxor	(%rcx), %ymm8, %ymm13
        vpxor	-64(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	320(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 1
        vpxor	64(%rax), %ymm8, %ymm10
        vpxor	(%rdi), %ymm9, %ymm11
        vpxor	-32(%rcx), %ymm5, %ymm12
        vpxor	-96(%rax), %ymm6, %ymm13
        vpxor	128(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 128(%rcx)
        # Row 2
        vpxor	96(%rcx), %ymm6, %ymm10
        vpxor	32(%rax), %ymm7, %ymm11
        vpxor	-32(%rdi), %ymm8, %ymm12
        vpxor	-64(%rcx), %ymm9, %ymm13
        vpxor	128(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 3
        vpxor	96(%rdi), %ymm9, %ymm10
        vpxor	64(%rcx), %ymm5, %ymm11
        vpxor	(%rax), %ymm6, %ymm12
        vpxor	-64(%rdi), %ymm7, %ymm13
        vpxor	-96(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 4
        vpxor	128(%rax), %ymm7, %ymm10
        vpxor	64(%rdi), %ymm8, %ymm11
        vpxor	32(%rcx), %ymm9, %ymm12
        vpxor	-32(%rax), %ymm5, %ymm13
        vpxor	-96(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, -96(%rdi)
        # Round 11
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm4, %ymm14
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm12, %ymm12
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm13, %ymm13
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm10, %ymm10
        vpxor	128(%rcx), %ymm14, %ymm14
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	(%rdi), %ymm6, %ymm11
        vpxor	-32(%rdi), %ymm7, %ymm12
        vpxor	-64(%rdi), %ymm8, %ymm13
        vpxor	-96(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	352(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 1
        vpxor	(%rcx), %ymm8, %ymm10
        vpxor	128(%rcx), %ymm9, %ymm11
        vpxor	96(%rcx), %ymm5, %ymm12
        vpxor	64(%rcx), %ymm6, %ymm13
        vpxor	32(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, 32(%rcx)
        # Row 2
        vpxor	96(%rax), %ymm6, %ymm10
        vpxor	-32(%rcx), %ymm7, %ymm11
        vpxor	-64(%rcx), %ymm8, %ymm12
        vpxor	-96(%rcx), %ymm9, %ymm13
        vpxor	128(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -96(%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Row 3
        vpxor	-64(%rax), %ymm9, %ymm10
        vpxor	64(%rax), %ymm5, %ymm11
        vpxor	32(%rax), %ymm6, %ymm12
        vpxor	(%rax), %ymm7, %ymm13
        vpxor	-32(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rax)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, -32(%rax)
        # Row 4
        vpxor	32(%rdi), %ymm7, %ymm10
        vpxor	-96(%rax), %ymm8, %ymm11
        vpxor	128(%rdi), %ymm9, %ymm12
        vpxor	96(%rdi), %ymm5, %ymm13
        vpxor	64(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, -96(%rax)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, 64(%rdi)
        # Round 12
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	-64(%rax), %ymm10, %ymm10
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm12, %ymm12
        vpxor	64(%rax), %ymm11, %ymm11
        vpxor	96(%rax), %ymm10, %ymm10
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm13, %ymm13
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm14, %ymm14
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rcx), %ymm6, %ymm11
        vpxor	-64(%rcx), %ymm7, %ymm12
        vpxor	(%rax), %ymm8, %ymm13
        vpxor	64(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	384(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 1
        vpxor	-64(%rdi), %ymm8, %ymm10
        vpxor	32(%rcx), %ymm9, %ymm11
        vpxor	96(%rax), %ymm5, %ymm12
        vpxor	64(%rax), %ymm6, %ymm13
        vpxor	128(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, 128(%rdi)
        # Row 2
        vpxor	(%rdi), %ymm6, %ymm10
        vpxor	96(%rcx), %ymm7, %ymm11
        vpxor	-96(%rcx), %ymm8, %ymm12
        vpxor	-32(%rax), %ymm9, %ymm13
        vpxor	32(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, -32(%rax)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 3
        vpxor	-96(%rdi), %ymm9, %ymm10
        vpxor	(%rcx), %ymm5, %ymm11
        vpxor	-32(%rcx), %ymm6, %ymm12
        vpxor	32(%rax), %ymm7, %ymm13
        vpxor	96(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -32(%rcx)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 4
        vpxor	-32(%rdi), %ymm7, %ymm10
        vpxor	64(%rcx), %ymm8, %ymm11
        vpxor	128(%rax), %ymm9, %ymm12
        vpxor	-64(%rax), %ymm5, %ymm13
        vpxor	-96(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, 64(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, -96(%rax)
        # Round 13
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm10, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm4, %ymm14
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm3, %ymm13
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm2, %ymm12
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm1, %ymm11
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rcx), %ymm6, %ymm11
        vpxor	-96(%rcx), %ymm7, %ymm12
        vpxor	32(%rax), %ymm8, %ymm13
        vpxor	-96(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	416(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, -96(%rax)
        # Row 1
        vpxor	(%rax), %ymm8, %ymm10
        vpxor	128(%rdi), %ymm9, %ymm11
        vpxor	(%rdi), %ymm5, %ymm12
        vpxor	(%rcx), %ymm6, %ymm13
        vpxor	128(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 128(%rax)
        # Row 2
        vpxor	128(%rcx), %ymm6, %ymm10
        vpxor	96(%rax), %ymm7, %ymm11
        vpxor	-32(%rax), %ymm8, %ymm12
        vpxor	96(%rdi), %ymm9, %ymm13
        vpxor	-32(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 96(%rdi)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 3
        vpxor	64(%rdi), %ymm9, %ymm10
        vpxor	-64(%rdi), %ymm5, %ymm11
        vpxor	96(%rcx), %ymm6, %ymm12
        vpxor	-32(%rcx), %ymm7, %ymm13
        vpxor	-64(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, 96(%rcx)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 4
        vpxor	-64(%rcx), %ymm7, %ymm10
        vpxor	64(%rax), %ymm8, %ymm11
        vpxor	32(%rdi), %ymm9, %ymm12
        vpxor	-96(%rdi), %ymm5, %ymm13
        vpxor	64(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 64(%rax)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, 64(%rcx)
        # Round 14
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm1, %ymm11
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm10, %ymm10
        vpxor	96(%rdi), %ymm3, %ymm13
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm14, %ymm14
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm11, %ymm11
        vpxor	128(%rax), %ymm14, %ymm14
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rdi), %ymm6, %ymm11
        vpxor	-32(%rax), %ymm7, %ymm12
        vpxor	-32(%rcx), %ymm8, %ymm13
        vpxor	64(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	448(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 1
        vpxor	32(%rax), %ymm8, %ymm10
        vpxor	128(%rax), %ymm9, %ymm11
        vpxor	128(%rcx), %ymm5, %ymm12
        vpxor	-64(%rdi), %ymm6, %ymm13
        vpxor	32(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, 32(%rdi)
        # Row 2
        vpxor	32(%rcx), %ymm6, %ymm10
        vpxor	(%rdi), %ymm7, %ymm11
        vpxor	96(%rdi), %ymm8, %ymm12
        vpxor	-64(%rax), %ymm9, %ymm13
        vpxor	-64(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, -64(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 3
        vpxor	-96(%rax), %ymm9, %ymm10
        vpxor	(%rax), %ymm5, %ymm11
        vpxor	96(%rax), %ymm6, %ymm12
        vpxor	96(%rcx), %ymm7, %ymm13
        vpxor	-96(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, 96(%rax)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 4
        vpxor	-96(%rcx), %ymm7, %ymm10
        vpxor	(%rcx), %ymm8, %ymm11
        vpxor	-32(%rdi), %ymm9, %ymm12
        vpxor	64(%rdi), %ymm5, %ymm13
        vpxor	64(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, (%rcx)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, 64(%rax)
        # Round 15
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm2, %ymm12
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm13, %ymm13
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	128(%rax), %ymm6, %ymm11
        vpxor	96(%rdi), %ymm7, %ymm12
        vpxor	96(%rcx), %ymm8, %ymm13
        vpxor	64(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	480(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, 64(%rax)
        # Row 1
        vpxor	-32(%rcx), %ymm8, %ymm10
        vpxor	32(%rdi), %ymm9, %ymm11
        vpxor	32(%rcx), %ymm5, %ymm12
        vpxor	(%rax), %ymm6, %ymm13
        vpxor	-32(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, -32(%rdi)
        # Row 2
        vpxor	128(%rdi), %ymm6, %ymm10
        vpxor	128(%rcx), %ymm7, %ymm11
        vpxor	-64(%rax), %ymm8, %ymm12
        vpxor	-96(%rdi), %ymm9, %ymm13
        vpxor	-96(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, -96(%rdi)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 3
        vpxor	64(%rcx), %ymm9, %ymm10
        vpxor	32(%rax), %ymm5, %ymm11
        vpxor	(%rdi), %ymm6, %ymm12
        vpxor	96(%rax), %ymm7, %ymm13
        vpxor	64(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, (%rdi)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 4
        vpxor	-32(%rax), %ymm7, %ymm10
        vpxor	-64(%rdi), %ymm8, %ymm11
        vpxor	-64(%rcx), %ymm9, %ymm12
        vpxor	-96(%rax), %ymm5, %ymm13
        vpxor	(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -64(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, (%rcx)
        # Round 16
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm4, %ymm14
        vpxor	(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm1, %ymm11
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm12, %ymm12
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm11, %ymm11
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm10, %ymm10
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	32(%rdi), %ymm6, %ymm11
        vpxor	-64(%rax), %ymm7, %ymm12
        vpxor	96(%rax), %ymm8, %ymm13
        vpxor	(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	512(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, (%rcx)
        # Row 1
        vpxor	96(%rcx), %ymm8, %ymm10
        vpxor	-32(%rdi), %ymm9, %ymm11
        vpxor	128(%rdi), %ymm5, %ymm12
        vpxor	32(%rax), %ymm6, %ymm13
        vpxor	-64(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, -64(%rcx)
        # Row 2
        vpxor	128(%rax), %ymm6, %ymm10
        vpxor	32(%rcx), %ymm7, %ymm11
        vpxor	-96(%rdi), %ymm8, %ymm12
        vpxor	64(%rdi), %ymm9, %ymm13
        vpxor	-32(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, 64(%rdi)
        vmovdqu	%ymm4, -32(%rax)
        # Row 3
        vpxor	64(%rax), %ymm9, %ymm10
        vpxor	-32(%rcx), %ymm5, %ymm11
        vpxor	128(%rcx), %ymm6, %ymm12
        vpxor	(%rdi), %ymm7, %ymm13
        vpxor	-96(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 128(%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 4
        vpxor	96(%rdi), %ymm7, %ymm10
        vpxor	(%rax), %ymm8, %ymm11
        vpxor	-96(%rcx), %ymm9, %ymm12
        vpxor	64(%rcx), %ymm5, %ymm13
        vpxor	-64(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, (%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -64(%rdi)
        # Round 17
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm11, %ymm11
        vpxor	64(%rdi), %ymm13, %ymm13
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm4, %ymm14
        vpxor	-64(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	32(%rax), %ymm13, %ymm13
        vpxor	64(%rax), %ymm10, %ymm10
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm14, %ymm14
        vpxor	-32(%rcx), %ymm11, %ymm11
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm10, %ymm10
        vpxor	128(%rcx), %ymm12, %ymm12
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rdi), %ymm6, %ymm11
        vpxor	-96(%rdi), %ymm7, %ymm12
        vpxor	(%rdi), %ymm8, %ymm13
        vpxor	-64(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	544(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 1
        vpxor	96(%rax), %ymm8, %ymm10
        vpxor	-64(%rcx), %ymm9, %ymm11
        vpxor	128(%rax), %ymm5, %ymm12
        vpxor	-32(%rcx), %ymm6, %ymm13
        vpxor	-96(%rcx), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, -96(%rcx)
        # Row 2
        vpxor	32(%rdi), %ymm6, %ymm10
        vpxor	128(%rdi), %ymm7, %ymm11
        vpxor	64(%rdi), %ymm8, %ymm12
        vpxor	-96(%rax), %ymm9, %ymm13
        vpxor	96(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, -96(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 3
        vpxor	(%rcx), %ymm9, %ymm10
        vpxor	96(%rcx), %ymm5, %ymm11
        vpxor	32(%rcx), %ymm6, %ymm12
        vpxor	128(%rcx), %ymm7, %ymm13
        vpxor	64(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, 32(%rcx)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 4
        vpxor	-64(%rax), %ymm7, %ymm10
        vpxor	32(%rax), %ymm8, %ymm11
        vpxor	-32(%rax), %ymm9, %ymm12
        vpxor	64(%rax), %ymm5, %ymm13
        vpxor	(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, 32(%rax)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, (%rax)
        # Round 18
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm2, %ymm12
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm10, %ymm10
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-96(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm10, %ymm10
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm14, %ymm14
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm13, %ymm13
        vpxor	(%rcx), %ymm10, %ymm10
        vpxor	32(%rcx), %ymm12, %ymm12
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm11, %ymm11
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rcx), %ymm6, %ymm11
        vpxor	64(%rdi), %ymm7, %ymm12
        vpxor	128(%rcx), %ymm8, %ymm13
        vpxor	(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	576(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, (%rax)
        # Row 1
        vpxor	(%rdi), %ymm8, %ymm10
        vpxor	-96(%rcx), %ymm9, %ymm11
        vpxor	32(%rdi), %ymm5, %ymm12
        vpxor	96(%rcx), %ymm6, %ymm13
        vpxor	-32(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, -32(%rax)
        # Row 2
        vpxor	-32(%rdi), %ymm6, %ymm10
        vpxor	128(%rax), %ymm7, %ymm11
        vpxor	-96(%rax), %ymm8, %ymm12
        vpxor	64(%rcx), %ymm9, %ymm13
        vpxor	-64(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rdi)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 64(%rcx)
        vmovdqu	%ymm4, -64(%rax)
        # Row 3
        vpxor	-64(%rdi), %ymm9, %ymm10
        vpxor	96(%rax), %ymm5, %ymm11
        vpxor	128(%rdi), %ymm6, %ymm12
        vpxor	32(%rcx), %ymm7, %ymm13
        vpxor	64(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rdi)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, 128(%rdi)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 64(%rax)
        # Row 4
        vpxor	-96(%rdi), %ymm7, %ymm10
        vpxor	-32(%rcx), %ymm8, %ymm11
        vpxor	96(%rdi), %ymm9, %ymm12
        vpxor	(%rcx), %ymm5, %ymm13
        vpxor	32(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rdi)
        vmovdqu	%ymm1, -32(%rcx)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 32(%rax)
        # Round 19
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm10, %ymm10
        vpxor	-32(%rdi), %ymm10, %ymm10
        vpxor	(%rdi), %ymm10, %ymm10
        vpxor	32(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm12, %ymm12
        vpxor	128(%rdi), %ymm12, %ymm12
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-64(%rax), %ymm4, %ymm14
        vpxor	-32(%rax), %ymm14, %ymm14
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm1, %ymm11
        vpxor	128(%rax), %ymm11, %ymm11
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	32(%rcx), %ymm3, %ymm13
        vpxor	64(%rcx), %ymm13, %ymm13
        vpxor	96(%rcx), %ymm13, %ymm13
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rcx), %ymm6, %ymm11
        vpxor	-96(%rax), %ymm7, %ymm12
        vpxor	32(%rcx), %ymm8, %ymm13
        vpxor	32(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	608(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 32(%rax)
        # Row 1
        vpxor	128(%rcx), %ymm8, %ymm10
        vpxor	-32(%rax), %ymm9, %ymm11
        vpxor	-32(%rdi), %ymm5, %ymm12
        vpxor	96(%rax), %ymm6, %ymm13
        vpxor	96(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rcx)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 96(%rax)
        vmovdqu	%ymm4, 96(%rdi)
        # Row 2
        vpxor	-64(%rcx), %ymm6, %ymm10
        vpxor	32(%rdi), %ymm7, %ymm11
        vpxor	64(%rcx), %ymm8, %ymm12
        vpxor	64(%rax), %ymm9, %ymm13
        vpxor	-96(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rcx)
        vmovdqu	%ymm1, 32(%rdi)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 64(%rax)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 3
        vpxor	(%rax), %ymm9, %ymm10
        vpxor	(%rdi), %ymm5, %ymm11
        vpxor	128(%rax), %ymm6, %ymm12
        vpxor	128(%rdi), %ymm7, %ymm13
        vpxor	(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rax)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 128(%rax)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, (%rcx)
        # Row 4
        vpxor	64(%rdi), %ymm7, %ymm10
        vpxor	96(%rcx), %ymm8, %ymm11
        vpxor	-64(%rax), %ymm9, %ymm12
        vpxor	-64(%rdi), %ymm5, %ymm13
        vpxor	-32(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rdi)
        vmovdqu	%ymm1, 96(%rcx)
        vmovdqu	%ymm2, -64(%rax)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Round 20
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	(%rdi), %ymm1, %ymm11
        vpxor	32(%rdi), %ymm11, %ymm11
        vpxor	96(%rdi), %ymm14, %ymm14
        vpxor	128(%rdi), %ymm3, %ymm13
        vpxor	-96(%rax), %ymm12, %ymm12
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	(%rax), %ymm10, %ymm10
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm13, %ymm13
        vpxor	96(%rax), %ymm13, %ymm13
        vpxor	128(%rax), %ymm12, %ymm12
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm14, %ymm14
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-32(%rax), %ymm6, %ymm11
        vpxor	64(%rcx), %ymm7, %ymm12
        vpxor	128(%rdi), %ymm8, %ymm13
        vpxor	-32(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	640(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 1
        vpxor	32(%rcx), %ymm8, %ymm10
        vpxor	96(%rdi), %ymm9, %ymm11
        vpxor	-64(%rcx), %ymm5, %ymm12
        vpxor	(%rdi), %ymm6, %ymm13
        vpxor	-64(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rcx)
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, (%rdi)
        vmovdqu	%ymm4, -64(%rax)
        # Row 2
        vpxor	-96(%rcx), %ymm6, %ymm10
        vpxor	-32(%rdi), %ymm7, %ymm11
        vpxor	64(%rax), %ymm8, %ymm12
        vpxor	(%rcx), %ymm9, %ymm13
        vpxor	64(%rdi), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rcx)
        vmovdqu	%ymm1, -32(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, (%rcx)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 3
        vpxor	32(%rax), %ymm9, %ymm10
        vpxor	128(%rcx), %ymm5, %ymm11
        vpxor	32(%rdi), %ymm6, %ymm12
        vpxor	128(%rax), %ymm7, %ymm13
        vpxor	-64(%rdi), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rax)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, 32(%rdi)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, -64(%rdi)
        # Row 4
        vpxor	-96(%rax), %ymm7, %ymm10
        vpxor	96(%rax), %ymm8, %ymm11
        vpxor	-96(%rdi), %ymm9, %ymm12
        vpxor	(%rax), %ymm5, %ymm13
        vpxor	96(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -96(%rax)
        vmovdqu	%ymm1, 96(%rax)
        vmovdqu	%ymm2, -96(%rdi)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Round 21
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-64(%rdi), %ymm4, %ymm14
        vpxor	-32(%rdi), %ymm1, %ymm11
        vpxor	(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm2, %ymm12
        vpxor	64(%rdi), %ymm14, %ymm14
        vpxor	96(%rdi), %ymm11, %ymm11
        vpxor	128(%rdi), %ymm13, %ymm13
        vpxor	-64(%rax), %ymm14, %ymm14
        vpxor	-32(%rax), %ymm11, %ymm11
        vpxor	32(%rax), %ymm10, %ymm10
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm10, %ymm10
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	-32(%rcx), %ymm14, %ymm14
        vpxor	(%rcx), %ymm13, %ymm13
        vpxor	32(%rcx), %ymm10, %ymm10
        vpxor	64(%rcx), %ymm12, %ymm12
        vpxor	128(%rcx), %ymm11, %ymm11
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	96(%rdi), %ymm6, %ymm11
        vpxor	64(%rax), %ymm7, %ymm12
        vpxor	128(%rax), %ymm8, %ymm13
        vpxor	96(%rcx), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	672(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, 96(%rdi)
        vmovdqu	%ymm2, 64(%rax)
        vmovdqu	%ymm3, 128(%rax)
        vmovdqu	%ymm4, 96(%rcx)
        # Row 1
        vpxor	128(%rdi), %ymm8, %ymm10
        vpxor	-64(%rax), %ymm9, %ymm11
        vpxor	-96(%rcx), %ymm5, %ymm12
        vpxor	128(%rcx), %ymm6, %ymm13
        vpxor	-96(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rdi)
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, 128(%rcx)
        vmovdqu	%ymm4, -96(%rdi)
        # Row 2
        vpxor	-32(%rax), %ymm6, %ymm10
        vpxor	-64(%rcx), %ymm7, %ymm11
        vpxor	(%rcx), %ymm8, %ymm12
        vpxor	-64(%rdi), %ymm9, %ymm13
        vpxor	-96(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rax)
        vmovdqu	%ymm1, -64(%rcx)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, -64(%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 3
        vpxor	-32(%rcx), %ymm9, %ymm10
        vpxor	32(%rcx), %ymm5, %ymm11
        vpxor	-32(%rdi), %ymm6, %ymm12
        vpxor	32(%rdi), %ymm7, %ymm13
        vpxor	(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -32(%rcx)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, -32(%rdi)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, (%rax)
        # Row 4
        vpxor	64(%rcx), %ymm7, %ymm10
        vpxor	(%rdi), %ymm8, %ymm11
        vpxor	64(%rdi), %ymm9, %ymm12
        vpxor	32(%rax), %ymm5, %ymm13
        vpxor	96(%rax), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rcx)
        vmovdqu	%ymm1, (%rdi)
        vmovdqu	%ymm2, 64(%rdi)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 96(%rax)
        # Round 22
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm4, %ymm14
        vpxor	-64(%rdi), %ymm3, %ymm13
        vpxor	-32(%rdi), %ymm2, %ymm12
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	96(%rdi), %ymm1, %ymm11
        vpxor	128(%rdi), %ymm10, %ymm10
        vpxor	-96(%rax), %ymm14, %ymm14
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm10, %ymm10
        vpxor	(%rax), %ymm14, %ymm14
        vpxor	64(%rax), %ymm12, %ymm12
        vpxor	128(%rax), %ymm13, %ymm13
        vpxor	-96(%rcx), %ymm12, %ymm12
        vpxor	-64(%rcx), %ymm11, %ymm11
        vpxor	-32(%rcx), %ymm10, %ymm10
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm11, %ymm11
        vpxor	96(%rcx), %ymm14, %ymm14
        vpxor	128(%rcx), %ymm13, %ymm13
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-64(%rax), %ymm6, %ymm11
        vpxor	(%rcx), %ymm7, %ymm12
        vpxor	32(%rdi), %ymm8, %ymm13
        vpxor	96(%rax), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	704(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -64(%rax)
        vmovdqu	%ymm2, (%rcx)
        vmovdqu	%ymm3, 32(%rdi)
        vmovdqu	%ymm4, 96(%rax)
        # Row 1
        vpxor	128(%rax), %ymm8, %ymm10
        vpxor	-96(%rdi), %ymm9, %ymm11
        vpxor	-32(%rax), %ymm5, %ymm12
        vpxor	32(%rcx), %ymm6, %ymm13
        vpxor	64(%rdi), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 128(%rax)
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, -32(%rax)
        vmovdqu	%ymm3, 32(%rcx)
        vmovdqu	%ymm4, 64(%rdi)
        # Row 2
        vpxor	96(%rdi), %ymm6, %ymm10
        vpxor	-96(%rcx), %ymm7, %ymm11
        vpxor	-64(%rdi), %ymm8, %ymm12
        vpxor	(%rax), %ymm9, %ymm13
        vpxor	64(%rcx), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rdi)
        vmovdqu	%ymm1, -96(%rcx)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, (%rax)
        vmovdqu	%ymm4, 64(%rcx)
        # Row 3
        vpxor	96(%rcx), %ymm9, %ymm10
        vpxor	128(%rdi), %ymm5, %ymm11
        vpxor	-64(%rcx), %ymm6, %ymm12
        vpxor	-32(%rdi), %ymm7, %ymm13
        vpxor	32(%rax), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rcx)
        vmovdqu	%ymm1, 128(%rdi)
        vmovdqu	%ymm2, -64(%rcx)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, 32(%rax)
        # Row 4
        vpxor	64(%rax), %ymm7, %ymm10
        vpxor	128(%rcx), %ymm8, %ymm11
        vpxor	-96(%rax), %ymm9, %ymm12
        vpxor	-32(%rcx), %ymm5, %ymm13
        vpxor	(%rdi), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 64(%rax)
        vmovdqu	%ymm1, 128(%rcx)
        vmovdqu	%ymm2, -96(%rax)
        vmovdqu	%ymm3, -32(%rcx)
        vmovdqu	%ymm4, (%rdi)
        # Round 23
        # Calc b[0..4]
        vpxor	%ymm15, %ymm0, %ymm10
        vpxor	-96(%rdi), %ymm1, %ymm11
        vpxor	-64(%rdi), %ymm2, %ymm12
        vpxor	-32(%rdi), %ymm3, %ymm13
        vpxor	32(%rdi), %ymm13, %ymm13
        vpxor	64(%rdi), %ymm4, %ymm14
        vpxor	96(%rdi), %ymm10, %ymm10
        vpxor	128(%rdi), %ymm11, %ymm11
        vpxor	-64(%rax), %ymm11, %ymm11
        vpxor	-32(%rax), %ymm12, %ymm12
        vpxor	(%rax), %ymm13, %ymm13
        vpxor	32(%rax), %ymm14, %ymm14
        vpxor	96(%rax), %ymm14, %ymm14
        vpxor	128(%rax), %ymm10, %ymm10
        vpxor	-96(%rcx), %ymm11, %ymm11
        vpxor	-64(%rcx), %ymm12, %ymm12
        vpxor	(%rcx), %ymm12, %ymm12
        vpxor	32(%rcx), %ymm13, %ymm13
        vpxor	64(%rcx), %ymm14, %ymm14
        vpxor	96(%rcx), %ymm10, %ymm10
        # Calc t[0..4]
        vpsrlq	$63, %ymm11, %ymm0
        vpsrlq	$63, %ymm12, %ymm1
        vpsrlq	$63, %ymm13, %ymm2
        vpsrlq	$63, %ymm14, %ymm3
        vpsrlq	$63, %ymm10, %ymm4
        vpaddq	%ymm11, %ymm11, %ymm5
        vpaddq	%ymm12, %ymm12, %ymm6
        vpaddq	%ymm13, %ymm13, %ymm7
        vpaddq	%ymm14, %ymm14, %ymm8
        vpaddq	%ymm10, %ymm10, %ymm9
        vpor	%ymm0, %ymm5, %ymm5
        vpor	%ymm1, %ymm6, %ymm6
        vpor	%ymm2, %ymm7, %ymm7
        vpor	%ymm3, %ymm8, %ymm8
        vpor	%ymm4, %ymm9, %ymm9
        vpxor	%ymm14, %ymm5, %ymm5
        vpxor	%ymm10, %ymm6, %ymm6
        vpxor	%ymm11, %ymm7, %ymm7
        vpxor	%ymm12, %ymm8, %ymm8
        vpxor	%ymm13, %ymm9, %ymm9
        # Row Mix
        # Row 0
        vpxor	%ymm15, %ymm5, %ymm10
        vpxor	-96(%rdi), %ymm6, %ymm11
        vpxor	-64(%rdi), %ymm7, %ymm12
        vpxor	-32(%rdi), %ymm8, %ymm13
        vpxor	(%rdi), %ymm9, %ymm14
        vpsrlq	$20, %ymm11, %ymm0
        vpsrlq	$21, %ymm12, %ymm1
        vpsrlq	$43, %ymm13, %ymm2
        vpsrlq	$50, %ymm14, %ymm3
        vpsllq	$44, %ymm11, %ymm11
        vpsllq	$43, %ymm12, %ymm12
        vpsllq	$21, %ymm13, %ymm13
        vpsllq	$14, %ymm14, %ymm14
        vpor	%ymm0, %ymm11, %ymm11
        vpor	%ymm1, %ymm12, %ymm12
        vpor	%ymm2, %ymm13, %ymm13
        vpor	%ymm3, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm15
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm15, %ymm15
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        # XOR in constant
        vpxor	736(%rdx), %ymm15, %ymm15
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm1, -96(%rdi)
        vmovdqu	%ymm2, -64(%rdi)
        vmovdqu	%ymm3, -32(%rdi)
        vmovdqu	%ymm4, (%rdi)
        # Row 1
        vpxor	32(%rdi), %ymm8, %ymm10
        vpxor	64(%rdi), %ymm9, %ymm11
        vpxor	96(%rdi), %ymm5, %ymm12
        vpxor	128(%rdi), %ymm6, %ymm13
        vpxor	-96(%rax), %ymm7, %ymm14
        vpsrlq	$36, %ymm10, %ymm0
        vpsrlq	$44, %ymm11, %ymm1
        vpsrlq	$61, %ymm12, %ymm2
        vpsrlq	$19, %ymm13, %ymm3
        vpsrlq	$3, %ymm14, %ymm4
        vpsllq	$28, %ymm10, %ymm10
        vpsllq	$20, %ymm11, %ymm11
        vpsllq	$3, %ymm12, %ymm12
        vpsllq	$45, %ymm13, %ymm13
        vpsllq	$61, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 32(%rdi)
        vmovdqu	%ymm1, 64(%rdi)
        vmovdqu	%ymm2, 96(%rdi)
        vmovdqu	%ymm3, 128(%rdi)
        vmovdqu	%ymm4, -96(%rax)
        # Row 2
        vpxor	-64(%rax), %ymm6, %ymm10
        vpxor	-32(%rax), %ymm7, %ymm11
        vpxor	(%rax), %ymm8, %ymm12
        vpxor	32(%rax), %ymm9, %ymm13
        vpxor	64(%rax), %ymm5, %ymm14
        vpsrlq	$63, %ymm10, %ymm0
        vpsrlq	$58, %ymm11, %ymm1
        vpsrlq	$39, %ymm12, %ymm2
        vpsrlq	$56, %ymm13, %ymm3
        vpsrlq	$46, %ymm14, %ymm4
        vpaddq	%ymm10, %ymm10, %ymm10
        vpsllq	$6, %ymm11, %ymm11
        vpsllq	$25, %ymm12, %ymm12
        vpsllq	$8, %ymm13, %ymm13
        vpsllq	$18, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, -64(%rax)
        vmovdqu	%ymm1, -32(%rax)
        vmovdqu	%ymm2, (%rax)
        vmovdqu	%ymm3, 32(%rax)
        vmovdqu	%ymm4, 64(%rax)
        # Row 3
        vpxor	96(%rax), %ymm9, %ymm10
        vpxor	128(%rax), %ymm5, %ymm11
        vpxor	-96(%rcx), %ymm6, %ymm12
        vpxor	-64(%rcx), %ymm7, %ymm13
        vpxor	-32(%rcx), %ymm8, %ymm14
        vpsrlq	$37, %ymm10, %ymm0
        vpsrlq	$28, %ymm11, %ymm1
        vpsrlq	$54, %ymm12, %ymm2
        vpsrlq	$49, %ymm13, %ymm3
        vpsrlq	$8, %ymm14, %ymm4
        vpsllq	$27, %ymm10, %ymm10
        vpsllq	$36, %ymm11, %ymm11
        vpsllq	$10, %ymm12, %ymm12
        vpsllq	$15, %ymm13, %ymm13
        vpsllq	$56, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, 96(%rax)
        vmovdqu	%ymm1, 128(%rax)
        vmovdqu	%ymm2, -96(%rcx)
        vmovdqu	%ymm3, -64(%rcx)
        vmovdqu	%ymm4, -32(%rcx)
        # Row 4
        vpxor	(%rcx), %ymm7, %ymm10
        vpxor	32(%rcx), %ymm8, %ymm11
        vpxor	64(%rcx), %ymm9, %ymm12
        vpxor	96(%rcx), %ymm5, %ymm13
        vpxor	128(%rcx), %ymm6, %ymm14
        vpsrlq	$2, %ymm10, %ymm0
        vpsrlq	$9, %ymm11, %ymm1
        vpsrlq	$25, %ymm12, %ymm2
        vpsrlq	$23, %ymm13, %ymm3
        vpsrlq	$62, %ymm14, %ymm4
        vpsllq	$62, %ymm10, %ymm10
        vpsllq	$55, %ymm11, %ymm11
        vpsllq	$39, %ymm12, %ymm12
        vpsllq	$41, %ymm13, %ymm13
        vpsllq	$2, %ymm14, %ymm14
        vpor	%ymm0, %ymm10, %ymm10
        vpor	%ymm1, %ymm11, %ymm11
        vpor	%ymm2, %ymm12, %ymm12
        vpor	%ymm3, %ymm13, %ymm13
        vpor	%ymm4, %ymm14, %ymm14
        vpandn	%ymm12, %ymm11, %ymm0
        vpandn	%ymm13, %ymm12, %ymm1
        vpandn	%ymm14, %ymm13, %ymm2
        vpandn	%ymm10, %ymm14, %ymm3
        vpandn	%ymm11, %ymm10, %ymm4
        vpxor	%ymm10, %ymm0, %ymm0
        vpxor	%ymm11, %ymm1, %ymm1
        vpxor	%ymm12, %ymm2, %ymm2
        vpxor	%ymm13, %ymm3, %ymm3
        vpxor	%ymm14, %ymm4, %ymm4
        vmovdqu	%ymm0, (%rcx)
        vmovdqu	%ymm1, 32(%rcx)
        vmovdqu	%ymm2, 64(%rcx)
        vmovdqu	%ymm3, 96(%rcx)
        vmovdqu	%ymm4, 128(%rcx)
        subq	$0x80, %rdi
        vmovdqu	%ymm15, (%rdi)
        vzeroupper
        repz retq
#ifndef __APPLE__
.size	kyber_sha3_blocksx4_avx2,.-kyber_sha3_blocksx4_avx2
#endif /* __APPLE__ */
#endif /* HAVE_INTEL_AVX2 */

#if defined(__linux__) && defined(__ELF__)
.section	.note.GNU-stack,"",%progbits
#endif
