.\"    This file is part of wmpload - a program to monitor ppp activity for X
.\"    Copyright (C) 1999-2000  Matt Smith <mdsmith@engr.utk.edu>
.\"
.\"    This program is free software; you can redistribute it and/or modify
.\"    it under the terms of the GNU General Public License as published by
.\"    the Free Software Foundation; either version 2 of the License, or
.\"    (at your option) any later version.
.\"
.\"    This program is distributed in the hope that it will be useful,
.\"    but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"    GNU General Public License for more details.
.\"
.\"    You should have received a copy of the GNU General Public License
.\"    along with this program; if not, write to the Free Software
.\"    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.TH WMPLOAD 1 "" "January 2000"

.SH NAME
wmpload \- dockapp to display ppp throughput statistics

.SH SYNOPSIS
.ta 6n
\fBwmpload\fP [-average \fIn\fP] [-device \fIX\fP] [-display \fId\fP] [-div \fIn\fP]
[-field1 \fIX\fP] [-field2 \fIX\fP] [-geometry \fIg\fP] [-greenin]
[-logscale] [-noproc] [-redin] [-update \fIn\fP]

.SH DESCRIPTION
The \fBwmpload\fP program displays information about network interface (ppp) statistics.
Additionally, for Linux 2.2 it can display statistics for any interface that
reports to /proc/net/dev .

.SH OPTIONS
.PP
\fBWmpload\fP accepts a few command line options.
The order of the options in unimportant.
.PP

.TP 8
.B \-average \fIn\fP
Average or smooth over \fIn\fP number of samples in the calculations of the current
rates for the displayed graphs.  The default is to average over 10 points.  For a more
instantaneous response this can be set to 1.

.TP 8
.B \-device \fIX\fP
Monitor this device.  The default is ppp0.

.TP 8
.B \-display \fId\fP
Attach to the X server display specified in \fId\fP. The default is to attach to the
display specified in the environment variable $DISPLAY. See the manual page for X(1)
for more information on X displays.

.TP 8
.B \-div \fIn\fP
Show  dividing lines for a rate of \fIn\fP bytes per second.  The 
default is to show a line every 2048 bytes per second (2 k/s).

.TP 8
.B \-field1 \fIX\fP
The wmpload window has two sections. One, the bottom, graphs the current and a short history of
the monitored device's throughput rate. The other top section displays some text based
information that is customizable. The argument \fIX\fP can be one of total, rate, max,
device, or none. Total displays the total number of bytes through the specified device,
rate displays the current rate in bytes/s, max displays the maximum rate recorded since
the program started, device displays the monitored device's name, and none leaves the 
field empty. The default is total.

.TP 8
.B \-field2 \fIX\fP
See the -field1 option. The default for the second field is rate.

.TP 8
.B \-geometry \fIg\fP
Use X11 geometry spec \fIg\fP. This really isn't very useful because wmpload's
window is a fixed size and the position part is ignored by Window Maker. The position
part may be honored by other window managers. See the manual page for X(1) for more
information on X11 window geometry specifications.

.TP 8
.B \-greenin
Represent inbound data as the green color. This also specifies that outbound data is
represented as the red color by default. Since there are only two colors available,
the following commands are equivalent: -greenin -redout. This is the default. To
reverse the colors either -greenout or -redin can be used.

.TP 8
.B \-logscale
The logscale option enables graphing the base 10 logarithm of the rates. This is
most useful for high bandwith devices like ethernet. The -div option
interacts with this option: a scale line will be drawn for 10*div, 100*div,
1000*div, ... bytes. The default is to graph linearly.

.TP 8
.B \-noproc
This option is only valid for Linux >=2.2.  It disables the default usage of the
proc filesystem for gathering device statistics.  The more portable ioctl()
method is used instead. When -noproc is specified only ppp stats can be read.

.TP 8
.B \-redin
See the -greenin option.

.TP 8
.B \-update \fIn\fP
The displayed charts are updated every integer \fIn\fP milliseconds.  The default is to
update every 1000 milliseconds (1 second). A fast moving display can be accomplished
with a setting of about 10. 

.SH SEE ALSO
wmaker(1), pppstats(8), X(1), pload(1)

.SH BUGS
No bugs are known as of this writing. Please contact the author if you think you
have found a bug.

.SH COPYRIGHT
Copyright (C) 1999,2000 Matt Smith

.SH AUTHOR
Wmpload was written by Matt Smith <mdsmith@engr.utk.edu> and is based on the
Xaw based program, pload and wmwave by Carsten Schuermann.
