MACPAIR [[:xdigit:]][[:xdigit:]]
MACA    {MACPAIR}:{MACPAIR}:{MACPAIR}:{MACPAIR}:{MACPAIR}:{MACPAIR}
IPA     [0-9]+\.[0-9]+\.[0-9]+\.[0-9]+
NUM32   [0-9]+
NUM64   [0-9]+:[0-9]+
IDENT   [[:alpha:]](\_|[[:alnum:]])*
SPACE   [ \t\n]+
COMMENT (\/\/.*\n)|(\#.*\n)
STRING  \"([^\"]|\\\")*\"

%option noyywrap
%option yylineno

%{
#include "common.h"
#include "parseprg.h"
#include "parseprg-internal.h"
#include "parseprg-yacc.h"

void yyerror(char*);

%}

%%


{ 
"if"            { return IF;          }
"else"          { return ELSE;        }
"while"         { return WHILE;       }
"print"         { return PRINT;       }
"prints"        { return PRINTS;      }

"TBLcardcnt"    { return TBLCARDCNT;  }
"TBLcntcnt"     { return TBLCNTCNT;   }
"TBLgetidx"     { return TBLGETIDX;   }
"TBLgetipaddr"  { return TBLGETIPADR; }
"TBLgetmacaddr" { return TBLGETMACADR;}
"TBLidxdel"     { return TBLIDXDEL;   }

"int"         { return DECLINT64;   }
"long"        { return DECLINT64;   }
"bool"        { return DECLBOOL;    }
"ipa"         { return DECLIPA;     }
"maca"        { return DECLMACA;    }

"<<="        { return SHLEQ; }
">>="        { return SHREQ; }
"+="         { return ADDEQ; }
"-="         { return SUBEQ; }
"*="         { return MULEQ; }
"/="         { return DIVEQ; }

"<="         { return LEQ;   }
">="         { return GEQ;   }
"=="         { return EQ;    }

"<<"         { return SHL;   }
">>"         { return SHR;   }
"||"         { return OR;    }
"&&"         { return AND;   }
"!="         { return NEQ;   }
"<"          { return LE;    }
">"          { return GE;    }

"true"       { yylval.nboolexpr=new ConstBool(1); return BOOLEXPR; }
"false"      { yylval.nboolexpr=new ConstBool(0); return BOOLEXPR; }

{MACA}   { // Create a symbol with the MAC address and return it:
           mac_addr val;
	   if(val.fromstr(yytext)) { // Should never happen...
	     yyerror("Bad format of MAC address");
	     return ERROR;
	   }
	   
	   yylval.nmacexpr=new ConstMac(val);
	   return MACEXPR;
	 }
	   
{IPA}    { // Create a symbol with the IP address and return it:
           ip_addr val;
	   if(val.fromstr(yytext)) { // Should never happen...
	     yyerror("Bad format of IP address");
	     return ERROR;
	   }
	   
	   yylval.nipexpr=new ConstIp(val);
	   return IPEXPR;
	 }

{NUM32}  { // Create a symbol with integr value and return it:
           unsigned val=0;
           sscanf(yytext,"%u",&val);
	   yylval.nint64expr=new ConstInt64(unsigned(val)); // GNU C++ seems to require the unsigned conversion...
	   return INT64EXPR;
	 }

{NUM64}  { // Create a symbol with integr value and return it:
           unsigned val1=0;
	   unsigned val2=0;
	   sscanf(yytext,"%u:%u",&val1,&val2);
	   yylval.nint64expr=new ConstInt64(
	     (((int64)unsigned(val1))<<32)+int64(unsigned(val2))
	   );
	   return INT64EXPR;
	 }

{IDENT}  { // See if the user has suplied this symbol:        
           void* v;
           ParseProgram::types t=ParseProgram::instance->getSymbol(yytext,v);	  
	   if(t!=ParseProgram::tUNKNOWN) {
             switch(t) {
 	       case ParseProgram::tINT64: yylval.nint64var=new VariabelInt64((int64*)v); return INT64VAR;
	       case ParseProgram::tBOOL:  yylval.nboolvar=new VariabelBool((Bool*)v);    return BOOLVAR;
	       case ParseProgram::tMAC:   yylval.nmacvar=new VariabelMac((mac_addr*)v);  return MACVAR;
	       case ParseProgram::tIP:    yylval.nipvar=new VariabelIp((ip_addr*)v);     return IPVAR;
	       case ParseProgram::tINT32: yylval.nint64expr=new IntToInt64Expr((int*)v); return INT64EXPR;
	     }
	     assert(0);
	   }
	  
           // Lookup symbol in symbol tabel.
           Symtable::SymEntry* se=symtabel.getSymbol(yytext);	   
	   if(se) {
  	     switch(se->type) {
	       case ParseProgram::tINT64: yylval.nint64var=se->value.int64_value; return INT64VAR;
	       case ParseProgram::tBOOL:  yylval.nboolvar=se->value.bool_value; return BOOLVAR;
	       case ParseProgram::tMAC:   yylval.nmacvar=se->value.mac_value; return MACVAR;
	       case ParseProgram::tIP:    yylval.nipvar=se->value.ip_value;   return IPVAR;
	     }
	     assert(0);
	   }
	   
	   // The symbol did not exists. Create it:
	   yylval.nnotypevar=symtabel.createSymbol(yytext);
	   if(yylval.nnotypevar==0) { return ERROR; }
	   return NOTYPEVAR;
	 }

{STRING} { // Allocate space:
           int l=strlen(yytext);
           yylval.nstring=new char[l-1];
	   
	   // Copy while replacing \n and \" and ignoreing starting and ending "
           int s=1,d=0;
           while(yytext[s+1]) { 
	     if(yytext[s]=='\\') {
	       if(yytext[s+1]=='n') {
	         yylval.nstring[d]='\n';
	 	 s+=2; d++;
	 	 continue;
	       } else if(yytext[s+1]=='\"') {
	         yylval.nstring[d]='\"';
		 s+=2; d++;
	         continue;
	       }
	     }
	     yylval.nstring[d++]=yytext[s++];
	   }  
	   yylval.nstring[d]='\x0';
	   return STRING;
	 }

{SPACE}

{COMMENT}

.        { return yytext[0]; }
}
