AC_DEFUN(CHECK_TCLTK, 
[
  # check for existence of file, AC_CHECK_FILE macro says somethig about
  # cross-compiling and doesn't work
  # warning: the "function" keyword currently doesn't work on FreeBSD
  TestFile () {
    local FileName
    FileName=${1}
    AC_MSG_CHECKING([for $FileName])
    if test -f $FileName ; then
      AC_MSG_RESULT([found])
      return 0
    else
      AC_MSG_RESULT([not found])
      return 1
    fi
  }

  # test for dir
  # warning: the "function" keyword currently doesn't work on FreeBSD
  TestDir () {
    local FileName
    FileName=${1}
    AC_MSG_CHECKING([for dir $FileName])
    if test -d $FileName ; then
      AC_MSG_RESULT([found])
      return 0
    else
      AC_MSG_RESULT([not found])
      return 1
    fi
  }

  # add --with-tcltk command
  AC_ARG_WITH(tcl,
    [  --with-tcltk=DIR        directory where statically compiled tcl, tk and itcl is]
  )
  AC_SUBST(with_tcltk)

  # var for compiler
  AC_SUBST(TCLTK_INC)
  TCLTK_INC=""  
  # var for linker
  AC_SUBST(TCLTK_LD)
  TCLTK_LD=""

  # whether the configure was successful
  AC_SUBST(TCLTK_CONF_OK)
  TCLTK_CONF_OK=NO  

  # versions
  AC_SUBST(TCL_VERSION)
  AC_SUBST(TK_VERSION)
  AC_SUBST(ITCL_VERSION)

  # goto trick
  while test 1 ; do
    # check if we got --with-tcltk
    if test -z "$with_tcltk" -o "$with_tcltk" = "no" ; then
      echo "warning: you have to specify --with-tcltk option."
      break
    fi

    # cut trailing "/" if any
    with_tcltk=`echo $with_tcltk | sed s,/$,,`

    # expansion of leading ~ (it's needed)
    with_tcltk=`echo $with_tcltk | sed s,^~,$HOME,`

    ############
    # check tcl
    ############
    FileName="${with_tcltk}/local/lib/tclConfig.sh"
    if ! TestFile $FileName ; then break ; fi
    . $FileName

    FileName="${with_tcltk}/local/bin/tclsh${TCL_VERSION}"
    if ! TestFile $FileName ; then break ; fi

    FileName="${with_tcltk}/local/lib/libtcl${TCL_VERSION}.a"
    if ! TestFile $FileName ; then break ; fi
    TCLTK_LD="$TCLTK_LD $FileName"

    FileName="${with_tcltk}/tcl${TCL_VERSION}${TCL_PATCH_LEVEL}/generic"
    if ! TestDir $FileName ; then break ; fi
    TCLTK_INC="$TCLTK_INC -I${FileName}"
    
    ###############
    # check for tk
    ###############
    FileName="${with_tcltk}/local/lib/tkConfig.sh"
    if ! TestFile $FileName ; then break ; fi
    . $FileName

    FileName="${with_tcltk}/local/lib/libtk${TK_VERSION}.a"
    if ! TestFile $FileName ; then break ; fi
    TCLTK_LD="$TCLTK_LD $FileName"

    FileName="${with_tcltk}/tk${TK_VERSION}${TK_PATCH_LEVEL}/generic"
    if ! TestDir $FileName ; then break ; fi
    TCLTK_INC="$TCLTK_INC -I${FileName}"

    #################
    # check for itcl
    #################
    FileName="${with_tcltk}/local/lib/itclConfig.sh"
    if ! TestFile $FileName ; then break ; fi
    . $FileName

    FileName="${with_tcltk}/local/lib/libitcl${ITCL_VERSION}.a"
    if ! TestFile $FileName ; then break ; fi
    TCLTK_LD="$TCLTK_LD $FileName"

    FileName="${with_tcltk}/itcl${ITCL_VERSION}.${ITCL_RELEASE_LEVEL}/itcl/generic"
    if ! TestDir $FileName ; then break ; fi
    TCLTK_INC="$TCLTK_INC -I${FileName}"
    #################
    # check for itk
    #################
    FileName="${with_tcltk}/local/lib/libitk${ITCL_VERSION}.a"
    if ! TestFile $FileName ; then break ; fi
    TCLTK_LD="$TCLTK_LD $FileName"

    FileName="${with_tcltk}/itcl${ITCL_VERSION}.${ITCL_RELEASE_LEVEL}/itk/generic"
    if ! TestDir $FileName ; then break ; fi
    TCLTK_INC="$TCLTK_INC -I${FileName}"

    # mktclapp is required, let's look for it.
    # we use our version of mktclapp, so we'll accept just one in tcltk dir
    # AC_CHECK_PROG(MKTCLAPP,mktclapp,mktclapp,,)
    AC_CHECK_PROG(MKTCLAPP,mktclapp,$with_tcltk/local/bin/mktclapp,no,$with_tcltk/local/bin)
    if test $MKTCLAPP = "no" ; then break ; fi

    TCLTK_CONF_OK=YES
    break
  done

  if test $TCLTK_CONF_OK != "YES" ; then
    echo -e "\nwarning: configuration NOT complete\n"
  fi
])
