(* This file was originally generated by why.
   It can be modified; only the generated parts will be overwritten. *)
Require Export WhyFloats.


(*Why axiom*) Lemma no_other_mode :
  (forall (m:mode), m = nearest_even \/ m = to_zero \/ m = up \/ m = down \/
   m = nearest_away).
Proof. intros m; destruct m; auto. Qed.

(*Why axiom*) Lemma mode_distinct :
  ~(nearest_even = to_zero) /\ ~(nearest_even = up) /\
  ~(nearest_even = down) /\ ~(nearest_even = nearest_away) /\
  ~(to_zero = up) /\ ~(to_zero = down) /\ ~(to_zero = nearest_away) /\
  ~(up = down) /\ ~(up = nearest_away) /\ ~(down = nearest_away).
Proof. repeat split; discriminate. Qed.


Inductive float_format : Set :=  Single | Double.

Record gen_float : Set := mk_gen_float {
   val        : float;
   format     : Fbound;
   Hcan       : Fcanonic radix format val;
   f_to_exact : R;
   f_to_model : R
 }.


Definition b_of_float_format (b:float_format) :=
 match b with 
  | Single => bsingle
  | Double => bdouble
 end.

Definition prec_of_float_format (b:float_format) :=
 match b with 
  | Single => 24
  | Double => 53
 end.


Lemma prec_of_float_format_gt_1: forall b, 1 < prec_of_float_format b.
intros b; case b; auto with zarith.
Qed.

Lemma vNum_b_of_float_format: forall b, 
 Zpos (vNum (b_of_float_format b)) = Zpower_nat radix (prec_of_float_format b).
intros b; case b.
simpl (b_of_float_format Single); simpl (prec_of_float_format Single).
apply psGivesBound.
simpl (b_of_float_format Double); simpl (prec_of_float_format Double).
apply pdGivesBound.
Qed.


Hint Resolve prec_of_float_format_gt_1 vNum_b_of_float_format : float.



Definition round_float_f (b:float_format) (m:mode) (r:R) := match m with
  |  nearest_even => RND_EvenClosest (b_of_float_format b) radix (prec_of_float_format b) r
  |  to_zero      => RND_Zero        (b_of_float_format b) radix (prec_of_float_format b) r
  |  up           => RND_Max         (b_of_float_format b) radix (prec_of_float_format b) r
  |  down         => RND_Min         (b_of_float_format b) radix (prec_of_float_format b) r
  |  neares_away  => RND_ClosestUp   (b_of_float_format b) radix (prec_of_float_format b) r
  end.

Definition round_float (b:float_format) (m:mode) (r:R) := FtoRradix (round_float_f b m r).


Lemma round_float_f_roundedMode: forall b m, exists P, 
   RoundedModeP (b_of_float_format b) radix P /\ forall r, P r (round_float_f b m r).
intros.
unfold round_float_f; case m.
exists (EvenClosest (b_of_float_format b) radix (prec_of_float_format b)); split.
apply EvenClosestRoundedModeP; auto with float zarith.
intros; apply RND_EvenClosest_correct; auto with zarith float.
exists (ToZeroP (b_of_float_format b) radix); split.
apply ToZeroRoundedModeP with (prec_of_float_format b); auto with float zarith.
intros; apply RND_Zero_correct; auto with zarith float.
exists (isMax (b_of_float_format b) radix); split.
apply MaxRoundedModeP with (prec_of_float_format b); auto with float zarith.
intros; apply RND_Max_correct; auto with zarith float.
exists (isMin (b_of_float_format b) radix); split.
apply MinRoundedModeP with (prec_of_float_format b); auto with float zarith.
intros; apply RND_Min_correct; auto with zarith float.
exists (Closest (b_of_float_format b) radix); split.
apply ClosestRoundedModeP with (prec_of_float_format b); auto with float zarith.
intros; apply RND_ClosestUp_correct; auto with zarith float.
Qed.



Lemma Fcanonic_gen_float_of_real_logic_aux: forall b m r,
  Fcanonic radix (b_of_float_format b) (round_float_f b m r).
intros.
unfold round_float_f; case m.
apply RND_EvenClosest_canonic; auto with zarith float.
apply RND_Zero_canonic; auto with zarith float.
apply RND_Max_canonic; auto with zarith float.
apply RND_Min_canonic; auto with zarith float.
apply RND_ClosestUp_canonic; auto with zarith float.
Qed.




Definition gen_float_of_real_logic (b:float_format) (m:mode) (r:R) := mk_gen_float
  (round_float_f b m r)
  (b_of_float_format b)
  (Fcanonic_gen_float_of_real_logic_aux b m r)
  r
  r.



(*Why logic*) Definition float_value := fun f => FtoRradix (val f).

(*Why logic*) Definition exact_value := f_to_exact.

(*Why logic*) Definition model_value := f_to_model.


Definition max_gen_float_f (f : float_format) :=
match f with 
| Single => Float 16777215 104
	    (* ((2-powerRZ 2 (-23))*powerRZ 2 127)%R *)
                  
| Double => Float 9007199254740991 971
 	    (* (2 - 2 ^ (-52)) * 2 ^ 1023 = 2 ^ 1024 - 2 ^ 971 = (2^53 - 1) * 2^ 971 *)
                  
end.

Lemma max_gen_float_f_bounded: forall b, Fbounded (b_of_float_format b) (max_gen_float_f b).
intros; split.
rewrite vNum_b_of_float_format.
case b.
simpl (prec_of_float_format Single).
simpl (Fnum (max_gen_float_f Single)).
auto with zarith.
simpl (prec_of_float_format Double).
simpl (Fnum (max_gen_float_f Double)).
auto with zarith.
case b; simpl; auto with zarith.
Qed.

(*Why logic*) Definition max_gen_float := fun b => FtoRradix (max_gen_float_f b).

(* Coq is too bad with computations !
(*Why axiom*) Lemma max_single :
  (eq (max_gen_float Single) (33554430 * 10141204801825835211973625643008)%R).
Admitted.

(*Why axiom*) Lemma max_double :
  (eq (max_gen_float Double) (9007199254740991 * 19958403095347198116563727130368385660674512604354575415025472424372118918689640657849579654926357010893424468441924952439724379883935936607391717982848314203200056729510856765175377214443629871826533567445439239933308104551208703888888552684480441575071209068757560416423584952303440099278848)%R).
Admitted.
*)

(*Why predicate*) Definition no_overflow  (f:float_format) (m:mode) (x:R)
  := (Rle (Rabs (round_float f m x)) (max_gen_float f)).

(*Why axiom*) Lemma bounded_real_no_overflow :
  (forall (f:float_format),
   (forall (m:mode),
    (forall (x:R), ((Rle (Rabs x) (max_gen_float f)) -> (no_overflow f m x))))).
intros; unfold no_overflow.
elim (round_float_f_roundedMode f m); intros P (H1,H2).
unfold max_gen_float in *.
apply RoundAbsMonotoner with (b_of_float_format f) (prec_of_float_format f) P x; auto with zarith float.
apply max_gen_float_f_bounded.
Qed.

(*Why axiom*) Lemma round_down_le :
  (forall (f:float_format), (forall (x:R), (Rle (round_float f down x) x))).
intros; unfold round_float; simpl.
eapply RND_Min_correct; auto with zarith float.
Qed.

(*Why axiom*) Lemma round_up_ge :
  (forall (f:float_format), (forall (x:R), (Rge (round_float f up x) x))).
intros; unfold round_float; simpl; apply Rle_ge.
eapply RND_Max_correct; auto with zarith float.
Qed.

(*Why axiom*) Lemma round_down_neg :
  (forall (f:float_format),
   (forall (x:R),
    (eq (round_float f down (Ropp x)) (Ropp (round_float f up x))))).
intros; unfold round_float; simpl; unfold FtoRradix; rewrite <- Fopp_correct.
eapply MinUniqueP.
eapply RND_Min_correct; auto with zarith float.
apply MaxOppMin.
apply RND_Max_correct; auto with zarith float.
Qed.

(*Why axiom*) Lemma round_up_neg :
  (forall (f:float_format),
   (forall (x:R),
    (eq (round_float f up (Ropp x)) (Ropp (round_float f down x))))).
intros; unfold round_float; simpl; unfold FtoRradix; rewrite <- Fopp_correct.
eapply MaxUniqueP.
eapply RND_Max_correct; auto with zarith float.
apply MinOppMax.
apply RND_Min_correct; auto with zarith float.
Qed.

(*Why axiom*) Lemma round_idempotent :
  (forall (f:float_format),
   (forall (m1:mode),
    (forall (m2:mode),
     (forall (x:R),
      (eq (round_float f m1 (round_float f m2 x)) (round_float f m2 x)))))).
intros; apply sym_eq.
elim (round_float_f_roundedMode f m1); intros P (H1,H2).
apply RoundedModeProjectorIdemEq with (4:=H1) (precision:=prec_of_float_format f); auto with zarith float.
elim (round_float_f_roundedMode f m2); intros P2 (H1',H2').
apply RoundedModeBounded with radix P2 x; auto.
Qed.

(*Why axiom*) Lemma prod_pos :
  (forall (x:R),
   (forall (y:R),
    (((Rgt x (0)%R) /\ (Rgt y (0)%R) -> (Rgt (Rmult x y) (0)%R))) /\
    (((Rlt x (0)%R) /\ (Rlt y (0)%R) -> (Rgt (Rmult x y) (0)%R))))).
intros x y; split; intros (H1,H2).
now apply Rmult_gt_0_compat.
replace (x*y)%R with ((-x)*(-y))%R by ring.
apply Rmult_gt_0_compat; auto with real.
Qed.

(*Why axiom*) Lemma abs_minus :
  (forall (x:R), (eq (Rabs (Ropp x)) (Rabs x))).
exact Rabs_Ropp.
Qed.

(*Why axiom*) Lemma a1 :
  (forall (f:float_format),
   (forall (m:mode),
    (forall (x:R),
     ((no_overflow f m x) ->
      (eq (float_value (gen_float_of_real_logic f m x)) (round_float f m x)))))).
intros; reflexivity.
Qed.

(*Why axiom*) Lemma a2 :
  (forall (f:float_format),
   (forall (m:mode),
    (forall (x:R), (eq (exact_value (gen_float_of_real_logic f m x)) x)))).
intros; reflexivity.
Qed.

(*Why axiom*) Lemma a3 :
  (forall (f:float_format),
   (forall (m:mode),
    (forall (x:R), (eq (model_value (gen_float_of_real_logic f m x)) x)))).
intros; reflexivity.
Qed.



(*Why predicate*) Definition gen_float_of_real_post  (f:float_format) (m:mode) (x:R) (res:gen_float)
  := (eq (float_value res) (round_float f m x)) /\
     (eq (exact_value res) x) /\ (eq (model_value res) x).

(*Why predicate*) Definition add_gen_float_post  (f:float_format) (m:mode) (x:gen_float) (y:gen_float) (res:gen_float)
  := (eq (float_value res) (round_float
                            f m (Rplus (float_value x) (float_value y)))) /\
     (eq (exact_value res) (Rplus (exact_value x) (exact_value y))) /\
     (eq (model_value res) (Rplus (model_value x) (model_value y))).

(*Why predicate*) Definition sub_gen_float_post  (f:float_format) (m:mode) (x:gen_float) (y:gen_float) (res:gen_float)
  := (eq (float_value res) (round_float
                            f m (Rminus (float_value x) (float_value y)))) /\
     (eq (exact_value res) (Rminus (exact_value x) (exact_value y))) /\
     (eq (model_value res) (Rminus (model_value x) (model_value y))).

(*Why predicate*) Definition neg_gen_float_post  (f:float_format) (m:mode) (x:gen_float) (res:gen_float)
  := (eq (float_value res) (round_float f m (Ropp (float_value x)))) /\
     (eq (exact_value res) (Ropp (exact_value x))) /\
     (eq (model_value res) (Ropp (model_value x))).

(*Why predicate*) Definition mul_gen_float_post  (f:float_format) (m:mode) (x:gen_float) (y:gen_float) (res:gen_float)
  := (eq (float_value res) (round_float
                            f m (Rmult (float_value x) (float_value y)))) /\
     (eq (exact_value res) (Rmult (exact_value x) (exact_value y))) /\
     (eq (model_value res) (Rmult (model_value x) (model_value y))).

(*Why predicate*) Definition div_gen_float_post  (f:float_format) (m:mode) (x:gen_float) (y:gen_float) (res:gen_float)
  := (eq (float_value res) (round_float
                            f m (Rdiv (float_value x) (float_value y)))) /\
     (eq (exact_value res) (Rdiv (exact_value x) (exact_value y))) /\
     (eq (model_value res) (Rdiv (model_value x) (model_value y))).

(*Why function*) Definition gen_round_error  (x:gen_float)
  := (Rabs (Rminus (float_value x) (exact_value x))).

(*Why function*) Definition gen_relative_error  (x:gen_float)
  := (Rdiv (Rabs (Rminus (float_value x) (exact_value x))) (exact_value x)).

(*Why function*) Definition gen_total_error  (x:gen_float)
  := (Rabs (Rminus (float_value x) (model_value x))).

(*Why predicate*) Definition cast_gen_float_post  (f:float_format) (m:mode) (x:gen_float) (res:gen_float)
  := (eq (float_value res) (round_float f m (float_value x))) /\
     (eq (exact_value res) (exact_value x)) /\
     (eq (model_value res) (model_value x)).

