/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer.common.input;

import java.util.ArrayList;
import java.util.HashSet;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.nodes.VRMLBindableNodeType;
import org.web3d.vrml.nodes.VRMLClock;
import org.web3d.vrml.nodes.VRMLDeviceSensorNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLPickingSensorNodeType;
import org.web3d.vrml.nodes.VRMLSensorNodeType;
import org.web3d.vrml.renderer.common.nodes.AreaListener;
import org.web3d.vrml.renderer.common.nodes.VisibilityListener;
import org.web3d.vrml.util.NodeArray;
import org.xj3d.core.eventmodel.BindableNodeManager;
import org.xj3d.core.eventmodel.InputDeviceManager;
import org.xj3d.core.eventmodel.LayerSensorManager;
import org.xj3d.core.eventmodel.PickingManager;
import org.xj3d.core.eventmodel.UserInputHandler;

public abstract class BaseLayerSensorManager
implements LayerSensorManager {
    private static final String ADD_SENSOR_UNKNOWN_TYPE = "An unknown sensor type has been added to the sensor manager: ";
    private static final String REMOVE_SENSOR_UNKNOWN_TYPE = "An unknown sensor type has been removed from the sensor manager: ";
    protected static final int DEFAULT_EVENT_SIZE = 128;
    protected boolean initialised = false;
    protected PickingManager pickManager;
    protected InputDeviceManager inputManager;
    protected ErrorReporter errorReporter = DefaultErrorReporter.getDefaultReporter();
    private boolean isPickable = true;
    protected UserInputHandler inputHandler;
    protected BindableNodeManager viewStack;
    protected BindableNodeManager navInfoStack;
    protected BindableNodeManager backgroundStack;
    protected BindableNodeManager fogStack;
    protected boolean navigationEnabled = true;
    protected boolean fogTypeChanged;
    protected boolean fogDetailsChanged;
    protected boolean backgroundSkyChanged;
    protected boolean backgroundGroundChanged;
    protected BackgroundListener backgroundListener;
    protected FogListener fogListener;
    protected float worldScale = 1.0f;
    protected float invWorldScale = 1.0f;
    protected int numVisibilityListeners;
    protected int numAreaListeners;
    protected int numPointingDeviceSensors;
    protected int layerId = -1;
    protected HashSet allSensorNodes = new HashSet();

    public int getLayerId() {
        return this.layerId;
    }

    public boolean getNavigationEnabled() {
        return this.navigationEnabled;
    }

    public void setNavigationEnabled(boolean bl) {
        this.navigationEnabled = bl;
        this.inputHandler.setNavigationEnabled(bl);
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
        if (this.inputManager != null) {
            this.inputManager.setErrorReporter(this.errorReporter);
        }
        if (this.pickManager != null) {
            this.pickManager.setErrorReporter(this.errorReporter);
        }
    }

    public UserInputHandler getUserInputHandler() {
        return this.inputHandler;
    }

    public boolean getIsPickable() {
        return this.isPickable;
    }

    public void setIsPickable(boolean bl) {
        this.isPickable = bl;
    }

    public void setInputManager(InputDeviceManager inputDeviceManager) {
        this.inputManager = inputDeviceManager;
        if (inputDeviceManager != null) {
            inputDeviceManager.setErrorReporter(this.errorReporter);
        }
    }

    public void setVRMLClock(VRMLClock vRMLClock) {
        this.inputHandler.setVRMLClock(vRMLClock);
    }

    public void setPickingManager(PickingManager pickingManager) {
        this.pickManager = pickingManager;
        if (pickingManager != null) {
            pickingManager.setErrorReporter(this.errorReporter);
        }
    }

    public void setNavigationStacks(BindableNodeManager bindableNodeManager, BindableNodeManager bindableNodeManager2, BindableNodeManager bindableNodeManager3, BindableNodeManager bindableNodeManager4) {
        this.viewStack = bindableNodeManager;
        this.navInfoStack = bindableNodeManager2;
        this.backgroundStack = bindableNodeManager3;
        this.fogStack = bindableNodeManager4;
    }

    public void addSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        block7: for (int i = 0; i < n; ++i) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(i);
            if (!this.checkLayerId(vRMLSensorNodeType) || this.allSensorNodes.contains(vRMLSensorNodeType)) continue;
            this.allSensorNodes.add(vRMLSensorNodeType);
            if (vRMLSensorNodeType instanceof AreaListener) {
                ++this.numAreaListeners;
            } else if (vRMLSensorNodeType instanceof VisibilityListener) {
                ++this.numVisibilityListeners;
            }
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 36: {
                    ++this.numPointingDeviceSensors;
                    continue block7;
                }
                case 26: 
                case 52: 
                case 53: {
                    continue block7;
                }
                case 78: {
                    this.inputManager.addX3DNode((VRMLDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block7;
                }
                case 14: 
                case 42: {
                    continue block7;
                }
                case 73: {
                    this.pickManager.addSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block7;
                }
                default: {
                    this.errorReporter.warningReport(ADD_SENSOR_UNKNOWN_TYPE + vRMLSensorNodeType.getVRMLNodeName(), null);
                }
            }
        }
        if (this.numPointingDeviceSensors > 0) {
            this.inputHandler.setTestPointingDevices(true);
        }
    }

    public void removeSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        block7: for (int i = 0; i < n; ++i) {
            VRMLSensorNodeType vRMLSensorNodeType = (VRMLSensorNodeType)nodeArray.get(i);
            if (!this.checkLayerId(vRMLSensorNodeType) && !this.allSensorNodes.contains(vRMLSensorNodeType)) continue;
            this.allSensorNodes.remove(vRMLSensorNodeType);
            if (vRMLSensorNodeType instanceof AreaListener) {
                --this.numAreaListeners;
            } else if (vRMLSensorNodeType instanceof VisibilityListener) {
                --this.numVisibilityListeners;
            }
            switch (vRMLSensorNodeType.getPrimaryType()) {
                case 36: {
                    --this.numPointingDeviceSensors;
                    continue block7;
                }
                case 26: 
                case 52: 
                case 53: {
                    continue block7;
                }
                case 73: {
                    this.pickManager.removeSensor((VRMLPickingSensorNodeType)vRMLSensorNodeType);
                    continue block7;
                }
                case 78: {
                    this.inputManager.removeX3DNode((VRMLDeviceSensorNodeType)vRMLSensorNodeType);
                    continue block7;
                }
                case 14: 
                case 42: {
                    continue block7;
                }
                default: {
                    this.errorReporter.warningReport(REMOVE_SENSOR_UNKNOWN_TYPE + vRMLSensorNodeType.getVRMLNodeName(), null);
                }
            }
        }
        if (this.numPointingDeviceSensors == 0) {
            this.inputHandler.setTestPointingDevices(false);
        }
    }

    public void addViewDependentNodes(NodeArray nodeArray) {
        this.processAddedSensors(nodeArray);
    }

    public void removeViewDependentNodes(NodeArray nodeArray) {
        this.processRemovedSensors(nodeArray);
    }

    public void loadScene(BasicScene basicScene) {
        ArrayList arrayList = basicScene.getByPrimaryType(14);
        this.processAddedSensors(arrayList);
        arrayList = basicScene.getBySecondaryType(88);
        this.processAddedSensors(arrayList);
        arrayList = basicScene.getByPrimaryType(36);
        this.processAddedPointingDeviceSensors(arrayList);
        arrayList = basicScene.getByPrimaryType(13);
        this.processAddedPointingDeviceSensors(arrayList);
        arrayList = basicScene.getBySecondaryType(28);
        this.processAddedPointingDeviceSensors(arrayList);
        arrayList = basicScene.getByPrimaryType(78);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType = (VRMLDeviceSensorNodeType)arrayList.get(i);
            this.inputManager.addX3DNode(vRMLDeviceSensorNodeType);
        }
        this.inputHandler.setTestPointingDevices(this.numPointingDeviceSensors != 0);
        if (this.pickManager != null) {
            this.pickManager.loadScene(basicScene);
        }
    }

    public void unloadScene(BasicScene basicScene) {
        if (basicScene.getLayerId() != this.layerId) {
            return;
        }
        if (this.pickManager != null) {
            this.pickManager.unloadScene(basicScene);
        }
        ArrayList arrayList = basicScene.getByPrimaryType(78);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VRMLDeviceSensorNodeType vRMLDeviceSensorNodeType = (VRMLDeviceSensorNodeType)arrayList.get(i);
            this.inputManager.removeX3DNode(vRMLDeviceSensorNodeType);
        }
        arrayList = basicScene.getByPrimaryType(14);
        this.processRemovedSensors(arrayList);
        arrayList = basicScene.getBySecondaryType(88);
        this.processRemovedSensors(arrayList);
        arrayList = basicScene.getByPrimaryType(36);
        this.processRemovePointingDeviceSensors(arrayList);
        arrayList = basicScene.getByPrimaryType(13);
        this.processRemovePointingDeviceSensors(arrayList);
        arrayList = basicScene.getBySecondaryType(28);
        this.processRemovePointingDeviceSensors(arrayList);
        this.inputHandler.setTestPointingDevices(this.numPointingDeviceSensors != 0);
    }

    public void clear() {
        this.numAreaListeners = 0;
        this.numVisibilityListeners = 0;
        this.numPointingDeviceSensors = 0;
        this.inputHandler.setNavigationEnabled(false);
        this.inputHandler.setNavigationInfo(null);
        this.fogStack.clearAll();
        this.viewStack.clearAll();
        this.navInfoStack.clearAll();
        this.backgroundStack.clearAll();
        this.allSensorNodes.clear();
    }

    public void setLayerId(int n) throws IllegalStateException {
        this.layerId = n;
    }

    protected void initialise() {
        this.initialised = true;
        VRMLBindableNodeType vRMLBindableNodeType = this.fogStack.getBoundNode();
        int n = vRMLBindableNodeType.getFieldIndex("fogType");
        int n2 = vRMLBindableNodeType.getFieldIndex("visibilityRange");
        int n3 = vRMLBindableNodeType.getFieldIndex("color");
        this.fogListener = new FogListener(n, n2, n3);
        vRMLBindableNodeType = this.backgroundStack.getBoundNode();
        int n4 = vRMLBindableNodeType.getFieldIndex("groundAngle");
        int n5 = vRMLBindableNodeType.getFieldIndex("groundColor");
        int n6 = vRMLBindableNodeType.getFieldIndex("skyAngle");
        int n7 = vRMLBindableNodeType.getFieldIndex("skyColor");
        this.backgroundListener = new BackgroundListener(n4, n5, n6, n7);
    }

    protected void clearChangeFlags() {
        this.fogTypeChanged = false;
        this.fogDetailsChanged = false;
        this.backgroundSkyChanged = false;
        this.backgroundGroundChanged = false;
    }

    private boolean checkLayerId(VRMLNodeType vRMLNodeType) {
        int[] nArray = vRMLNodeType.getLayerIds();
        if (nArray == null) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != this.layerId) continue;
            return true;
        }
        return false;
    }

    private void processAddedSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)nodeArray.get(i);
            if (!this.checkLayerId(vRMLNodeType) || this.allSensorNodes.contains(vRMLNodeType)) continue;
            if (vRMLNodeType instanceof AreaListener) {
                ++this.numAreaListeners;
                continue;
            }
            if (!(vRMLNodeType instanceof VisibilityListener)) continue;
            ++this.numVisibilityListeners;
        }
    }

    private void processAddedPointingDeviceSensors(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)arrayList.get(i);
            if (!this.checkLayerId(vRMLNodeType) || this.allSensorNodes.contains(vRMLNodeType)) continue;
            ++this.numPointingDeviceSensors;
        }
    }

    private void processAddedSensors(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)arrayList.get(i);
            if (!this.checkLayerId(vRMLNodeType) || this.allSensorNodes.contains(vRMLNodeType)) continue;
            if (vRMLNodeType instanceof AreaListener) {
                ++this.numAreaListeners;
                continue;
            }
            if (!(vRMLNodeType instanceof VisibilityListener)) continue;
            ++this.numVisibilityListeners;
        }
    }

    private void processRemovedSensors(NodeArray nodeArray) {
        int n = nodeArray.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)nodeArray.get(i);
            if (!this.checkLayerId(vRMLNodeType) && !this.allSensorNodes.contains(vRMLNodeType)) continue;
            this.allSensorNodes.remove(vRMLNodeType);
            if (vRMLNodeType instanceof AreaListener) {
                --this.numAreaListeners;
                continue;
            }
            if (!(vRMLNodeType instanceof VisibilityListener)) continue;
            --this.numVisibilityListeners;
        }
    }

    private void processRemovedSensors(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)arrayList.get(i);
            if (!this.checkLayerId(vRMLNodeType) && !this.allSensorNodes.contains(vRMLNodeType)) continue;
            this.allSensorNodes.remove(vRMLNodeType);
            if (vRMLNodeType instanceof AreaListener) {
                --this.numAreaListeners;
                continue;
            }
            if (!(vRMLNodeType instanceof VisibilityListener)) continue;
            --this.numVisibilityListeners;
        }
    }

    private void processRemovePointingDeviceSensors(ArrayList arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            VRMLNodeType vRMLNodeType = (VRMLNodeType)arrayList.get(i);
            if (!this.checkLayerId(vRMLNodeType) && !this.allSensorNodes.contains(vRMLNodeType)) continue;
            this.allSensorNodes.remove(vRMLNodeType);
            --this.numPointingDeviceSensors;
        }
    }

    private class FogListener
    implements VRMLNodeListener {
        private int typeField;
        private int visibilityField;
        private int colourField;

        FogListener(int n, int n2, int n3) {
            this.typeField = n;
            this.visibilityField = n2;
            this.colourField = n3;
        }

        public void fieldChanged(int n) {
            if (n == this.typeField) {
                BaseLayerSensorManager.this.fogTypeChanged = true;
            }
            if (n == this.visibilityField || n == this.colourField) {
                BaseLayerSensorManager.this.fogDetailsChanged = true;
            }
        }
    }

    private class BackgroundListener
    implements VRMLNodeListener {
        private int gndAngleField;
        private int gndColorField;
        private int skyAngleField;
        private int skyColorField;

        BackgroundListener(int n, int n2, int n3, int n4) {
            this.gndAngleField = n;
            this.gndColorField = n2;
            this.skyAngleField = n3;
            this.skyColorField = n4;
        }

        public void fieldChanged(int n) {
            if (n == this.gndAngleField || n == this.gndColorField) {
                BaseLayerSensorManager.this.backgroundGroundChanged = true;
            }
            if (n == this.skyAngleField || n == this.skyColorField) {
                BaseLayerSensorManager.this.backgroundSkyChanged = true;
            }
        }
    }
}

