//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
//
// Name :       mthumb.h
//
// Purpose :    Interface to class MThumb
//
// Created :    11 May 94    Bernhard Marschall
//
// $Id: mthumb.h,v 1.1 1996/03/12 16:54:59 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: mthumb.h,v $
// Revision 1.1  1996/03/12 16:54:59  bmarsch
// Initial revision
//


#ifndef har_widgets_mthumb_h
#define har_widgets_mthumb_h

#include <InterViews/geometry.h>
#include <InterViews/glyph.h>
#include <InterViews/telltale.h>


//<class>
//
// Name:    MThumb
//
// Purpose: thumb for class MSlider
//
// Public Interface:
//   Inherited from Glyph.
//
// Description:
//   This is just a simple Glyph to be used as thumb of a MSlider.
//
//</class>

class MThumb : public Glyph {
public:
  MThumb(const TelltaleFlags = TelltaleState::is_enabled,
         DimensionName = Dimension_X);
  virtual ~MThumb();

  virtual void allocate(Canvas*, const Allocation&, Extension&);
  virtual void draw(Canvas*, const Allocation&) const;

private:
  const Color* active_color_;
  const Color* inactive_color_;
  DimensionName dimension_;
  TelltaleFlags flags_;
};

#endif
