// This may look like C code, but it is really -*- C++ -*-

//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
// This file is part of VRweb.
//
// VRweb is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// VRweb is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with VRweb; see the file LICENCE. If not, write to the
// Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
//
// Note that the GNU General Public License does not permit incorporating
// the Software into proprietary or commercial programs. Such usage
// requires a separate license from IICM.
//
//</copyright>

//<file>
//
// Name:        fonts.h
//
// Purpose:     interface to VRML font management
//
// Created:     19 Jun 96   Michael Pichler
//
// Changed:     25 Jun 96   Michael Pichler
//
// $Id: fonts.h,v 1.2 1997/02/25 17:03:58 mpichler Exp $
//
//</file>


#ifndef harmony_scene_fonts_h
#define harmony_scene_fonts_h


class QvNode;


// FontChar
// information associated with one character

class FontChar
{
  public:
    FontChar ()
    { glyph_ = 0;
      width_ = 0;
    }

    void setGlyph (QvNode* node, float width = 0);

    void setWidth (float width)  { width_ = width; }

    QvNode* glyph ()
    { return glyph_; }

    float width ()
    { return width_; }

  private:
    QvNode* glyph_;
    float width_;

}; // FontChar


#endif
