// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1995
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        timeval.C
// 
// Purpose:     
// 
// Created:     13 Mar 96   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// $Id: timeval.C,v 1.1 1996/03/22 16:23:11 jfasch Exp $
// 
// $Log: timeval.C,v $
// Revision 1.1  1996/03/22 16:23:11  jfasch
// Initial revision
//
// 
// </file> 
#include "timeval.h"

// --------------------------------------------------------------------
bool TimeVal :: operator < (const TimeVal& t) const {
   if (tv_sec < t.tv_sec)
      return true ;
   else if (tv_sec == t.tv_sec  &&  tv_usec < t.tv_usec)
      return true ;
   else 
      return false ;
}

bool TimeVal :: operator > (const TimeVal& t) const {
   if (tv_sec > t.tv_sec)
      return true ;
   else if (tv_sec == t.tv_sec  &&  tv_usec > t.tv_usec)
      return true ;
   else 
      return false ;
}

bool TimeVal :: operator == (const TimeVal& t) const {
   return tv_sec == t.tv_usec  &&  tv_usec == t.tv_usec ;
}

TimeVal TimeVal :: now() {
   timeval tv ;
   struct timezone tz ;
   ::gettimeofday (&tv, &tz) ;
   return tv ;
}

TimeVal operator + (const TimeVal& t1, const TimeVal& t2) {
    TimeVal sum;
    sum.tv_sec = t1.tv_sec + t2.tv_sec;
    sum.tv_usec = t1.tv_usec + t2.tv_usec;
    if (sum.tv_usec >= TimeVal::one_second) {
	sum.tv_usec -= TimeVal::one_second;
	sum.tv_sec++;
    } else if (sum.tv_sec >= 1 && sum.tv_usec < 0) {
	sum.tv_usec += TimeVal::one_second;
	sum.tv_sec--;
    }
    return sum;   
}

TimeVal operator - (const TimeVal& t1, const TimeVal& t2) {
    TimeVal delta;
    delta.tv_sec = t1.tv_sec - t2.tv_sec;
    delta.tv_usec = t1.tv_usec - t2.tv_usec;
    if (delta.tv_usec < 0) {
	delta.tv_usec += TimeVal::one_second;
	delta.tv_sec--;
    } else if (delta.tv_usec >= TimeVal::one_second) {
	delta.tv_usec -= TimeVal::one_second;
	delta.tv_sec++;
    }
    return delta;
}
