// -*- C++ -*-
//<copyright>
//
// Copyright (c) 1996
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>

//<file>
//
// Name:    optionparser.h
//
// Purpose: declaration of class OptionParser
//
// Created: 5 Sep 1996 Bernhard Heidegger
//
// $Id: optionparser.h,v 1.3 1997/02/10 10:29:10 gorasche Exp $
//
// Description:
//   
//</file>
//
// $Log: optionparser.h,v $
// Revision 1.3  1997/02/10 10:29:10  gorasche
// renamed enums for Win32
//
// Revision 1.2  1996/12/30 16:38:28  jfasch
// oops
//
// Revision 1.1  1996/10/25 13:13:27  breising
// Initial revision
//
// Revision 1.2  1996/10/16 11:03:53  breising
// *** empty log message ***
//
//
// Revision 1.1  1996/10/16 10:48:57  bheide
// Initial revision
//
//

#ifndef hg_path_optionparser_h
#define hg_path_optionparser_h

#include "strarr.h"
#include "strfield.h"

struct OptionStruct
{
  const char * option;  // command line option
  int tag;              // return value
};

class OptionParser
{
  
public:
  enum {OPTNOERROR = 0, OPTUNKNOWN = -1, OPTAMBIGUOUS = -2, OPTINTERNAL = -3,
        OPTNOARGS = -4, OPTNOOPTS = -5, OPTNOMORE = -6};
  OptionParser(int argc, char ** argv, const OptionStruct * opts);
  virtual ~OptionParser();
  // bool parse(const OptionStruct * options);
  bool more() { return ((cur_+1) < argc_); }
  int getOption();
  RString getParam();
  bool nextisOption();
  int error() { return (error_); }
  const char * programName() { return (argv_[0]); }
  const char * current() { return (argv_[cur_]); }
  RString ambiguous();
  
private:
  int match(const RString opt, int& pos);
  
  enum {OPTOK, OPTERROR, OPTEND} state_;
  int error_;
  int cur_;
  int argc_;
  const char ** argv_;
  RStringField options_;
  const OptionStruct * opts_;
  RStringArray matches_;
  
};

#endif /* hg_path_optionparser_h */
