//<copyright>
//
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
//
//</copyright>


//<file>
//
// Name :       mslider.h
//
// Purpose :    Interface to classes MSlider, MXSlider and MYSlider
//
// Created :    13 May 94    Bernhard Marschall
//
// $Id: mslider.h,v 1.1 1996/03/12 16:54:59 bmarsch Exp $
//
// Description:
//
//</file>
//
// $Log: mslider.h,v $
// Revision 1.1  1996/03/12 16:54:59  bmarsch
// Initial revision
//

/*
 * Copyright (c) 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THIS SOFTWARE.
 */

/*
 *  "markable" slider - slider with marked region
 */

#ifndef har_widgets_mslider_h
#define har_widgets_mslider_h

#include "libwidgets.h"
#include <InterViews/input.h>
#include <InterViews/observe.h>


class MAdjustable;
class MSliderImpl;
class Stepper;
class Style;

typedef void (Adjustable::*SliderAdjustment)(DimensionName);


//<class>
//
// Name:       MSlider
//
// Purpose:    Slider with markable region
//
// Public Interface:
//
//
// Description:
// It's really just as InterViews' slider.h with some small changes
//
//</class>


class MSlider : public ActiveHandler, public Observer {
public:
    MSlider(Style*, MAdjustable*);
    virtual ~MSlider();

    virtual void normal_thumb(Glyph*);
    virtual void visible_thumb(Glyph*);
    virtual void old_thumb(Glyph*);
    virtual Coord minimum_thumb_size() const;

    virtual void request(Requisition&) const;
    virtual void allocate(Canvas*, const Allocation&, Extension&);
    virtual void draw(Canvas*, const Allocation&) const;
    virtual void undraw();

    virtual void move(const Event&);
    virtual void press(const Event&) {};
    virtual void drag(const Event&) {};
    virtual void release(const Event&) {};

    virtual void allocation_changed(Canvas*, const Allocation&);

    virtual void update(Observable*);

    virtual void forward_stepper(Stepper*);
    virtual void backward_stepper(Stepper*);
    virtual void move_to(Coord x, Coord y);
    virtual void allocate_thumb(const Allocation&);
    virtual void allot_thumb_major_axis(
     	const Allocation&, DimensionName, Adjustable*, Coord min_thumb_size,
      float& scale, Allotment&
    );
    virtual void allot_thumb_minor_axis(const Allotment&, Allotment&);
    virtual void redraw_thumb();
    virtual void reallocate_thumb(const Allocation&);
    virtual void apply_adjustment(SliderAdjustment);
    virtual void do_adjustment(Adjustable*, SliderAdjustment, DimensionName);

    virtual void redraw_slider();

protected:
    void adj_to_coord(Coord, Coord, Coord&, Coord&) const;

    MAdjustable* madj_;
    MSliderImpl* impl_;
};


//<class>
//
// Name:       MXSlider
//
// Purpose:    XSlider with markable region
//
//
// Public Interface:
//
//
// Description:
// It's really just as InterViews' slider.h with some small changes
//
//</class>

class MXSlider : public MSlider {
public:
    MXSlider(Style*, MAdjustable*);
    virtual ~MXSlider();

    virtual void draw(Canvas*, const Allocation&) const;
    virtual void move_to(Coord x, Coord y);
    virtual void allocate_thumb(const Allocation&);
    virtual void disconnect(Observable*);
    virtual void apply_adjustment(SliderAdjustment);

    virtual void press(const Event&);
    virtual void drag(const Event&);
    virtual void release(const Event&);

private:
    float xscale_;
    Stepper* forward_;
    Stepper* backward_;
};



//<class>
//
// Name:       MYSlider
//
// Purpose:    YSlider with markable region
//
//
// Public Interface:
//
//
// Description:
// It's really just as InterViews' slider.h with some small changes
//
//</class>

class MYSlider : public MSlider {
public:
    MYSlider(Style*, MAdjustable*);
    virtual ~MYSlider();

    virtual void draw(Canvas*, const Allocation&) const;
    virtual void move_to(Coord x, Coord y);
    virtual void allocate_thumb(const Allocation&);
    virtual void disconnect(Observable*);
    virtual void apply_adjustment(SliderAdjustment);

    virtual void press(const Event&);
    virtual void drag(const Event&);
    virtual void release(const Event&);

private:
    float yscale_;
    Stepper* forward_;
    Stepper* backward_;
};

#endif
