#if 0
// This allows usage of this file with plain C

//<copyright>
// 
// Copyright (c) 1994-96
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
//</copyright>

//<file>
//
// Name:        harcolors.h
//
// Purpose:     interface to Harmony colormap
//
// Created:     05 Apr 95   Michael Pichler
// Changed:     05 Apr 95   Bernhard Marschall
//
// $Id: harcolors.h,v 1.2 1996/03/04 17:06:38 bmarsch Exp $
//
//</file>
//
// $Log: harcolors.h,v $
// Revision 1.2  1996/03/04 17:06:38  bmarsch
// Added array harmony_pixel[]
//
#endif

#ifndef harcolors_h
#define harcolors_h

//<function>
//
// Prototype:  void enableHarmonyColors();
//
// Purpose:    (Pre-)Allocate colors of Harmony Colormap
//
// Description:
// The function causes InterViews to allocate the colors of the
// Harmony Colormap (or the closest color if no more color cells are
// available). It must be called before the first window is mapped.
//
//</function>

void enableHarmonyColors();


typedef struct {
  unsigned short r, g, b;
} HarColor;


// number of colors in Harmony Colormap
extern const int num_harmony_colors;
// Harmony Colormap in RGB
extern const HarColor harmony_color[];
// Harmony Colormap in indices to colormap
extern unsigned long harmony_pixel[];
// table to map an (arbitrary) color to it's closest Harmony color
extern const unsigned char map_RGB_harmony[];


#define HarGetColorIndex_f(r, g, b) \
( map_RGB_harmony[(int) ((r) * 15.5) << 8 | (int) ((g) * 15.5) << 4 | (int) ((b) * 15.5)] )
/* 0 <= r, g, b <= 1 */

#define HarGetColorIndex_16(r, g, b) \
( map_RGB_harmony[(int)(r) << 8 | (int)(g) << 4 | (int)(b)] )
/* 0 <= r, g, b <= 15 */

#define HarGetColorIndex_256(r, g, b) \
( map_RGB_harmony[(int) ((r)&0xf0) << 4 | (int) ((g)&0xf0) | (int) (b) >> 4] )
/* 0 <= r, g, b <= 255 */

#endif
