// This may look like C code, but it is really -*- C++ -*-
// <copyright> 
//  
//  Copyright (c) 1993 
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 

// <file> 
// 
// Name:        verbose.h
// 
// Purpose:     verbose (debugging) output
// 
// Created:     11 Jan 94   Michael Pichler
// 
// Modified:    29 Apr 94   Michael Pichler 
// Modified:    3 Nov 1995 Joerg Faschingbauer
//              cerr sometimes gets damaged by interrupting ::write() (EINTR).
//              Caught that.
// 
// Description: 
//
// Code for verbose messages is generated when VERBOSE is defined (this
// may be done in some files specifically) - code generation can be
// turned off globally by defining NOVERBOSE (e.g. as APP_CCDEFINES).
//
// Debug output is written to cerr, if the global variable verbose is set
// non zero; DEBUG appends a space, DEBUGNL a newline, several output may
// be written at once, separated with <<;
//
// If VERBOSE is not defined or NOVERBOSE is defined, DEBUG has no
// effect.  The variable verbose has to be defined in the program.
//
// $Id: verbose.h,v 1.2 1996/10/29 14:59:27 jfasch Exp $
//
// $Log: verbose.h,v $
// Revision 1.2  1996/10/29 14:59:27  jfasch
// inline Verbose :: operator int() const {
// #if defined (VERBOSE) && !defined (NOVERBOSE)
//                       ^^^^^^^^^^^^^^^^^^^^^^^
//                       IMPORTANT!!!!!!!!!!!!!!
// }
//
// Revision 1.1  1996/10/03 15:59:07  jfasch
// adaptions due to moving it from the previous location in DcCommon to HgUtilities
//
// Revision 1.7  1996/08/02 14:21:40  jfasch
// must not check ::verbose in DEBUG macros rather than verbose. in order
// for Verbose to function.
//
// Revision 1.6  1996/08/02 14:19:26  jfasch
// *** empty log message ***
//
// Revision 1.5  1996/07/31 08:27:30  jfasch
// changed bool to int in class Verbose
//
// Revision 1.4  1996/07/30 15:58:00  jfasch
// class Verbose
//
//
// </file> 


#ifndef hg_hyperg_verbose_h
#define hg_hyperg_verbose_h


#if defined (VERBOSE) && !defined (NOVERBOSE)

#include <iostream.h>

extern int verbose;
#define DEBUG(x)  \
{ if (verbose) {  \
    if (!cerr) cerr.clear() ;  \
    cerr << x << ' ';  \
  } \
}
#define DEBUGNL(x)  \
{ if (verbose) { \
    if (!cerr) cerr.clear() ;  \
    cerr << x << endl;  \
  }  \
}

#else

#define DEBUG(x)
#define DEBUGNL(x)

#endif

class Verbose {
public:
   Verbose() : verbose_(0) {}
   Verbose (int i) : verbose_(i) {}
   Verbose& operator = (int i) { verbose_=i; return *this; }
   operator int() const ;
private:
   int verbose_ ;
} ;
inline Verbose :: operator int() const {
#if defined (VERBOSE) && !defined (NOVERBOSE)
   return ::verbose | verbose_ ;
#else
   return verbose_ ;
#endif
}


#endif
