#include "global.h"
#include "images.h"

#ifndef VRENGD


typedef struct {
  void *th;
  ReadImageFunc read_func;
  int ch;
} PpmInfo;


static
void get_ch(PpmInfo *s)
{
  u_int8 data;

  if (s->read_func(s->th, (char *) &data, 1) < 1)
    data = 0;
  s->ch = data;
}

static
void get_ch1(PpmInfo *s)
{
  get_ch(s);
  while (s->ch == '#') {
    do {
      get_ch(s);
    } while (s->ch != 0 && s->ch != '\n' && s->ch!='\r');
    get_ch(s);
  }
}

static
void skip_spaces(PpmInfo *s)
{
  while (isspace(s->ch))
    get_ch1(s);
}

static
int get_int(PpmInfo *s)
{
  int n = 0;

  if (!isdigit(s->ch))
    return -1; /* returns -1 if error */
  do {
    n = n*10 + s->ch-'0';
    get_ch1(s);
  } while (isdigit(s->ch));
  return n;
}

Image *
loadPPM(void *th, ReadImageFunc read_func, DisplayImageFunc display_func)
{
  PpmInfo s1, *s = &s1;
  char header[2];
  int i, xsize, ysize, maxval;
  Image *image = NULL;

  s->read_func = read_func;
  s->th = th;
  get_ch(s);
  header[0] = s->ch;
  get_ch(s);
  header[1] = s->ch;
  if (header[0] != 'P' || header[1] != '6')
    return NULL;
  get_ch1(s);
  skip_spaces(s);
  xsize = get_int(s);
  skip_spaces(s);
  ysize = get_int(s);
  skip_spaces(s);
  maxval = get_int(s);
  if (!isspace(s->ch))
    return NULL;

  /* we read the data */
  if ((image = newImage(xsize, ysize, IMAGE_RGB, IMAGE_FIX)) == NULL)
    return NULL;
  for (i=0; i < ysize; i++) {
    s->read_func(s->th, (char *) image->pixmap+i*xsize*IMAGE_RGB, xsize*IMAGE_RGB);
    display_func(s->th, image);
  }
  return image;
}

#endif /* !VRENGD */
