
  // ------------------------------------------------------------------------ //
  // Author               : This file has been written by                     //
  //                            Yann Renard (MyselF / Dim4)                   //
  // Copyright            : This file is totaly free and you may distribute   //
  //                        it to anyone you want, without modifying this     //
  //                        header. If you use it in a commercial project (?) //
  //                        or in bigger project (!), I would be glad to know //
  //                        about it :) Please mail me...                     //
  //                        be glad to know about it, please mail me          //
  // Contact              : You can contact me at                             //
  //                            renard@esiea-ouest.fr                         //
  //                            myself_yr@hotmail.com                         //
  // Bug reports          : Mail me please so I can know about it             //
  // Purpose of this file : This package is my first experiment in bones      //
  //                        programming. I feel it works great for a first    //
  //                        time. For sure their are lots of optim to do...   //
  //                        Your ideas are welcome :)                         //
  // Version              : 1.0                                               //
  // History              : none                                              //
  // ToDo                 : lot's of things :)                                //
  //                        other things :))))                                //
  //                        Maybe buid an HTML tutorial about this subject ?  //
  // Greets               : Dim4 members :)                                   //
  //                        Latex, teacher forever                            //
  //                        Ethereal, thx for ideas of implementation         //
  //                        #codefr, thx for url                              //
  //                        comp.graphics.algorithm && comp.graphics.opengl   //
  //                        pech' and yoyo... newbies in demo hey !           //
  // ------------------------------------------------------------------------ //

#ifndef __BONEFACTORY_H__
#define __BONEFACTORY_H__

#include "boneCommon.h"
#include "boneIO.h"
#include "boneVect3d.h"
#include "boneMesh3d.h"
#include "boneVert.h"

   class FACTORY
    {
     public :

     //-----------------------------
     // Constructeurs / destructeur
     inline FACTORY ( void ) { };
     inline ~FACTORY ( void ) { };

     static void buildSphere ( MESH3D * result,
                               float radius = 1.0f,
			       int cpt1 = 8,
			       int cpt2 = 8,
			       float centerx = 0.0f,
			       float centery = 0.0f,
			       float centerz = 0.0f);
     static void buildTorus ( MESH3D * result,
			      float bigRadius = 1.0f,
			      float littleRadius = 0.3f,
			      int cpt1 = 8,
			      int cpt2 = 8,
			      float centrex = 0.0f,
			      float centrey = 0.0f,
			      float centrez = 0.0f);
     static void buildCylinder ( MESH3D * result,           // CA C'est bien pour toi Latex
			         float radius = 1.0f,       // tu le voulais, tu l'as
			         float height = 2.0f,       // ton cylindre... voila
			         int cpt1 = 8,              // tu vas pouvoir dire ce
			         int cpt2 = 8,              // que tu en pense...
			         float centrex = 0.0f,      // alors heureux ?
			         float centrey = 0.0f,      // :o)
			         float centrez = 0.0f);     // cherchez pas vous autre
     static void readVRMLfile ( MESH3D * result,
                                char * filename,
				float size = 1.0f,
			        float centrex = 0.0f,
			        float centrey = 0.0f,
			        float centrez = 0.0f,
				int colorMask = 0);

     static void readVRE3Dfile ( MESH3D * result,
				 BONEVERTEX * skeletonRoot,
				 char * filename,
				 float size = 1.0f );
     static void writeVRE3Dfile ( MESH3D * outMesh,
				  BONEVERTEX * skeletonRoot,
				  char * filename );
     static void readTGA ( char * filename, int ** buffer, int * width, int * height );
    };

#endif
