#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"
#include "parse.h"


ObjectList * grouplist = NULL;

static int section_type = 0;
static int grouped = 0;
static char *fileline = NULL;


/* change of section type */
static
int parseSectionType(char *l, int *psection_type)
{
  char *w, tokend[2];
  char l_tmp[BUFSIZ];

  strcpy(l_tmp, l);
  if ((w = strtok(l_tmp, SEP)) == NULL)
    fatal("parsing: can't read from the Fileline:\n%s", l);

  switch (*w) {

    case '[': tokend[0] = ']'; break;

    case '<':
      tokend[0] = '>';
      // check group
      if (strncmp(w, "<group>", 7) == 0) {
        grouped = 1;	// group begin
      }
      else if (strncmp(w, "</group>", 8) == 0) {
        ObjectList *list;

        for (list = grouplist; list != NULL; list = list->next) {
          if (list->next)
            list->pobject->next = list->next->pobject;	// forward linking
          else
            list->pobject->next = NULL;
          list->pobject->prev = grouplist->pobject;	// head linking
        }
        freeObjectList(grouplist);
        grouplist = NULL;
        grouped = 0;	// no group
      }
      //PD tokend[1] = '\0';
      //PD w = strtok(&w[1], tokend);
      return SAMESECTION;

    default: return SAMESECTION;
  }
  tokend[1] = '\0';
  w = strtok(&w[1], tokend);

  const WClass *cl = WClass::getWClass(w);
  if (cl) {
    *psection_type = cl->type_id;
    return SECTIONCHANGE;
  }

  *psection_type = UNKNOWN_TYPE;
  warning("object %s exits in this scene, but your Vreng doesn't know it.\nPlease upgrade with the current release at ftp://ftp.enst.fr/pub/mbone/vreng/vreng.tar.gz", w);
  return SAMESECTION;
}

int parseCfgLines(char *bufnet, int bufsize)
{
  char *tmpline;
  int linelen;

  if ((bufsize == TCPEOF) || (bufsize == BADREAD)) {
    free(fileline);
    fileline = NULL;
    return 0;	// end of data
  }

  if (fileline != NULL) {
    linelen = strlen(fileline);
    if ((tmpline = (char *) calloc(1, (bufsize + 1 + linelen))) == NULL)
      fatal("parsing: can't alloc tmpline");
    strcpy(tmpline, fileline);
  }
  else {
    if ((tmpline = (char *) calloc(1, (bufsize + 1))) == NULL)
      fatal("parsing: can't alloc tmpline");
    linelen = 0;
  }

  int i; int i0 = 0;

  for (i = 0; i < bufsize; i++)
    tmpline[linelen + i] = bufnet[i];
  linelen += bufsize;
  tmpline[linelen] = '\0';

  while (1) {
    int i1 = 0;

    for (i = i0; i < linelen; i++) {
      if (tmpline[i] == '\n') {
	i1 = i;
	i = linelen + 1;
      }
    }
    if (i == linelen + 2) {	// end of line
      if ((fileline = (char *) calloc(1, (i1 - i0 + 1))) == NULL)
        fatal("parsing: can't alloc fileline");

	for (i = 0; i < i1 - i0; i++)
	  fileline[i] = tmpline[i0 + i];
      fileline[i1 - i0] = '\0';	
#ifdef WIN32 /* pour pallier l'absence de mode texte */
      if (i1 - i0 > 0 && fileline[i1 - i0 - 1] == '\r')
        fileline[i1 - i0 - 1] = '\0';
#endif /* WIN32 */

      // discard comments begining with a #
      if (fileline[0] == '#') {
        free(fileline);
        fileline = NULL;
        i0 = i1 + 1;
        continue;
      }

      if (parseSectionType(fileline, &section_type) == SAMESECTION) {
	trace(DBG_WMGT, "cfg: %s", fileline);

        // discard tagged lines
        if (fileline[0] == '<') {
          free(fileline);
          fileline = NULL;
          i0 = i1 + 1;
          continue;
        }

        // discard line under unknown type
        if (section_type == UNKNOWN_TYPE) {
	  free(fileline);
          fileline = NULL;
	  i0 = i1 + 1;
	  continue;
        }
        WClass::creatorInstance(section_type, fileline);
      }
      free(fileline);
      fileline = NULL;
      i0 = i1 + 1;
    }
    else
      break;
  }

  if ((fileline = (char *) calloc(1, (linelen - i0 + 1))) == NULL)
    fatal("parsing: can't alloc fileline");

  for (i = 0; i < linelen - i0; i++)
    fileline[i] = tmpline[i + i0];
  fileline[linelen - i0] = '\0';

  free(tmpline);
  return 0;
}

void readCfg(void *h, void *handle)
{
  trace(DBG_WMGT, "readCfg");
  if (handle == NULL) {
    warning("Can't download file, check access to the remote http server");
    wmgtlockstate = LOCK_DOWNLOADED;
    return;
  }

  int len;
  char buf[BUFSIZ];

  while ((len = httpRead(handle, buf, sizeof(buf))) > 0) {
    parseCfgLines(buf, len);
    if (section_type == END_TYPE) {
      wmgtlockstate = LOCK_DOWNLOADED;
      trace(DBG_WMGT, "readCfg: dowloaded");
    }
  }
  fileline = NULL;
  return;
}

/* parse begining of line */
char * parseFileLine(char *l)
{
  if ((l = strtok(l, SEP)) == NULL)
    warning("parsing: can't get anything from the fileline:\n%s", l);
  return l;
}

/* parse object name: fill name and named */
char * parseName(char *l, WObject *po)
{
  if (!po) {
    warning("object not allocated: l=%s", l);
    return NULL;
  }

  // check group
  if (grouped == 1) {
    grouplist = addObjectToList(po, grouplist);
    po->pos.group = grouped;
    printf("parseName: grouped=1 l=%s\n", l);
    grouped = 2;
  }
  else if (grouped == 2) {
    grouplist = addObjectToList(po, grouplist);
    po->pos.group = grouped;
    printf("parseName: grouped=2 l=%s\n", l);
  }

  // check name
  while (isspace(*l))
    l++;
  if (*l == '(') {
    /* this object is named */
    int i;

    l++;
    for (i=0; *l != ')' && i < OBJNAME_LEN; po->name.given_name[i++] = *l++)
      ;
    if (i == OBJNAME_LEN)
      i--;
    po->name.given_name[i] = '\0';
    l++;
    while (*l == ' ')
      l++;
    po->name.named = 1;
  }
  return l;
}

/* parse space position: x y z az ax */
char * parsePosition(char *ptok, WObject *po)
{
  ptok = parseFileLine(ptok);
  po->pos.x  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  po->pos.y  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  po->pos.z  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  po->pos.az = (float) atof(ptok); ptok = strtok(NULL, SEP);
  if (ptok && (isdigit((int) *ptok) || *ptok == '-' || *ptok == '+')) {
    po->pos.ax = (float) atof(ptok); ptok = strtok(NULL, SEP);
  }
  return ptok;
}

/* parse colors: r g b a */
char * parseColor(char *ptok, WObject *po)
{
  ptok = parseFileLine(ptok);
  po->pos.x  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  po->pos.y  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  po->pos.z  = (float) atof(ptok); ptok = strtok(NULL, SEP);
  if (ptok)
    po->pos.az = (float) atof(ptok);
  return ptok;
}

/* parse url */
char * parseURL(char *ptok, WObject *po)
{
  strcpy(po->name.url, ptok); ptok = strtok(NULL, SEP);
  return ptok;
}

#endif /* !VRENGD */
