#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "names.h"


static struct hash_elt hashtable[NAME_HASH_SIZE];


u_int32 hash_name(char *str)
{
  u_int32 hval;

  for (hval = 0; *str != '\0'; str++)
    hval = ((hval << 8) + *str) % NAME_HASH_SIZE;
  return hval;
}

void initObjectsName(void)
{
  for (int i = 0; i < NAME_HASH_SIZE; i++)
    memset(hashtable[i].name, 0, OBJNAME_LEN);
}

void setObjectName(WObject *po, char *str)
{
  u_int32 hval;

  if (str == NULL) {
    trace(DBG_FORCE, "setObjectName: obj=%s name=NULL", po->name.class_name);
    return;
  }
  hval = hash_name(str);
  trace(DBG_WMGT, "setObjectName: hval=%d name=%s", hval, str);
  while (1) {
    if ((*(hashtable[hval].name) == '\0') ||
	(!strcmp(hashtable[hval].name, NAME_DELETED))) {
      strcpy(hashtable[hval].name, str);
      hashtable[hval].obj = po;
      return;
    }
    hval++;
  }
}

WObject *
getObjectByName(char *str)
{
  u_int32 hval;

  if (str == NULL) {
    trace(DBG_FORCE, "getObjectByName: name=NULL");
    return NULL;
  }
  hval = hash_name(str);
  trace(DBG_WMGT, "getObjectByName: hval=%d name=%s", hval, str);
  while (1) {
    if (*(hashtable[hval].name) == '\0')
      return NULL;
    if (!strcmp(hashtable[hval].name, str))
      return hashtable[hval].obj;
    hval++;
  }
}

void delObjectName(char *str)
{
  u_int32 hval;

  if (str == NULL) {
    trace(DBG_FORCE, "delObjectName: name=NULL");
    return;
  }
  hval = hash_name(str);
  while (1) {
    if (*(hashtable[hval].name) == '\0')
      return;
    if (!strcmp(hashtable[hval].name, str)) {
      strcpy(hashtable[hval].name, NAME_DELETED);
      return;
    }
    hval++;
  }
}
