#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "list.h"	/* getVicinityObjectList */
#include "grid.h"
#include "col.h"
#include "user.h"
#include "move.h"

#include "netImpl.h"    /* RESPONSIBLE */


/* Signale au module Gestion du Monde qu'une touche a change d'etat
 * key_id = 0..MAXKEYS-1
 * pressed is TRUE for a Key Press and FALSE for a Key Release
 * sec: seconds, usec: micro-seconds
 */
void changeKey(int k_id, boolean pressed, time_t sec, time_t usec)
{
  User *pu = worlds->plocaluser;  /* possibilite d'agir sur un autre user */
  
  /*  if ((k_id >= MAXKEYS) || (k_id < 0) || (k_state < 0) || (k_state > 1)) {*/
  if (k_id >= MAXKEYS || k_id < 0) {
    warning("Wmgt changeKey: invalid k_id = %d", k_id);
    return;
  }

  if (pu->kpressed[k_id] != pressed) {
    pu->kpressed[k_id] = pressed;
    if (pressed) {
      pu->kpstart_s[k_id] = sec;
      pu->kpstart_u[k_id] = usec;
    }
    else {
      pu->kpdur_s[k_id] = sec - pu->kpstart_s[k_id];
      pu->kpdur_u[k_id] = usec - pu->kpstart_u[k_id];
    }
  }
  /* else notice("Key '%x' already at '%x'", k_id, k_state);*/
}

/* clear keys times array */
void clearKeyTab(User *pu)
{
  for (int i = 0; i < MAXKEYS; i++) {
    pu->kpressed[i] = FALSE;
    pu->kpstart_s[i] = pu->kpstart_u[i] = 0;
    pu->kpdur_s[i] = pu->kpdur_u[i] = 0;
 }
}

/* update the keydifftime arrays */
static
void updateKeysTimes(User *pu, time_t sec, time_t usec)
{
  for (int i = 0; i < MAXKEYS; i++)
    if (pu->kpressed[i]) {
      pu->kpdur_s[i] = sec - pu->kpstart_s[i];
      pu->kpdur_u[i] = usec - pu->kpstart_u[i];
      pu->kpstart_s[i] = sec;
      pu->kpstart_u[i] = usec;
    }
}

/* modify user position in a direction */
static
void userChangePositionOneType(User *pu, int move_type, float last)
{
  switch (move_type) {
  case KEY_AV: /* move forward left */
    pu->pos.x += last * pu->lspeed * (float)Cos((double)pu->pos.az);
    pu->pos.y += last * pu->lspeed * (float)Sin((double)pu->pos.az);
    break;
  case KEY_AR: /* move backward right */
    pu->pos.x -= last * pu->lspeed * (float)Cos((double)pu->pos.az);
    pu->pos.y -= last * pu->lspeed * (float)Sin((double)pu->pos.az);
    break;
  case KEY_SD: /* move forward right */
    pu->pos.x += last * pu->lspeed * (float)sin((double)pu->pos.az);
    pu->pos.y -= last * pu->lspeed * (float)Cos((double)pu->pos.az);
    break;
  case KEY_SG: /* move backward left */
    pu->pos.x -= last * pu->lspeed * (float)Sin((double)pu->pos.az);
    pu->pos.y += last * pu->lspeed * (float)Cos((double)pu->pos.az);
    break;
  case KEY_DR: /* turn right */
    pu->pos.az -= last * pu->aspeed;
    pu->pos.az -= M_2PI * (float)floor((double)(pu->pos.az / M_2PI));
    break;
  case KEY_GA: /* turn left */
    pu->pos.az += last * pu->aspeed;
    pu->pos.az -= M_2PI * (float)floor((double)(pu->pos.az / M_2PI));
    break;
  case KEY_MT: /* down backward */
    pu->pos.ay = MINI(pu->pos.ay + last * pu->aspeed, M_2PI_5);
    break;
  case KEY_DE: /* down forward */
    pu->pos.ay = MAXI(pu->pos.ay - last * pu->aspeed, -M_2PI_5);
    break;
  case KEY_HZ: /* stand up */
    pu->pos.ay = pu->pos.ax = 0.0;
    break;
  case KEY_JU: /* move up */
    pu->pos.z += last * pu->lspeed;
    break;
  case KEY_JD: /* move down */
    pu->pos.z -= last * pu->lspeed;
    break;
  case KEY_TL: /* tilt left */
    pu->pos.ax = MINI(pu->pos.ax + last * pu->aspeed, M_PI_180);
    break;
  case KEY_TR: /* tilt right */
    pu->pos.ax = MAXI(pu->pos.ax - last * pu->aspeed, -M_PI_180);
    break;
  }
}

/* fill delays's array for each user motion direction */
static
void userUpdateTime(User *pu, float lasting[])
{
  for (int i = 0; i < MAXKEYS; i++) {
    lasting[i] = (float) pu->kpdur_s[i] + (float) pu->kpdur_u[i] / 1e6;
    pu->kpdur_s[i] = pu->kpdur_u[i] = 0;
  }
}

/* do the motion in each direction */
static
void userChangePosition(User *pu, float lasting[])
{
  for (int i = 0; i < MAXKEYS; i++) {
    if (lasting[i] > KEYLASTING) {
      userChangePositionOneType(pu, i, lasting[i] * (pu->kpressed[KEY_VI]+1));
    }
  }
}


/* user motion limited by the maxlast */
static
void userElementaryMovement(User *pu, float lasting[])
{
  WObject olduser;

  copyPositionAndBB(pu, &olduser);     /* copy oldpos, oldangle */
  userChangePosition(pu, lasting);
  updateObjectIn3D(pu);
  updateBB(pu);
  
  ObjectList *vicinitylist = getVicinityObjectList(pu, olduser.pos);
  generalIntersect(pu, &olduser, vicinitylist);
  freeObjectList(vicinitylist);
}

/* object motion limited by the maxlast */
static
void objectElementaryMovement(WObject *po, float lasting)
{
  WObject oldobj;

  if (!po) {
    trace(DBG_FORCE, "objectElementaryMovement: po NULL");
    return;
  }
  copyPositionAndBB(po, &oldobj);     /* copy oldpos, oldangle */

  po->changePosition(lasting);

  updateObjectIn3D(po);
  updateBB(po);
  if (po->nature.collision == COL_NEVER)
    return;	// else crashes in freeObjectList

  ObjectList *vicinitylist = getVicinityObjectList(po, oldobj.pos);
  generalIntersect(po, &oldobj, vicinitylist);
  freeObjectList(vicinitylist);
}

/* object permanent motion limited by the maxlast */
static
void objectElementaryPermanentMovement(WObject *po, float lasting)
{
  if (!po) {
    trace(DBG_FORCE, "objectElementaryPermanentMovement: po NULL");
    return;
  }

  WObject oldobj;

  copyPositionAndBB(po, &oldobj);	// copy oldpos, oldangle

  po->changePermanent(lasting);		// do the changePermanent in the object

  if (po->nature.bbable == VR_NO_BB) /* HACK! */
    return;

  updateObjectIn3D(po);
  updateBB(po);
  if (po->nature.collision == COL_NEVER)
    return;	// else crashes in freeObjectList

  ObjectList *vicinitylist = getVicinityObjectList(po, oldobj.pos);
  generalIntersect(po, &oldobj, vicinitylist);
  freeObjectList(vicinitylist);
}

/* user general motion */
void userMovement(User *pu, time_t sec, time_t usec)
{
  float maxlast, keylasting[MAXKEYS], delta[MAXKEYS], lasting = -1.0;
  // WObject olduser;
  Pos newpos = pu->pos;

  copyPosAndBB(pu, newpos);     /* copy oldpos, oldangle */

  updateKeysTimes(pu, sec, usec);
  userUpdateTime(pu, keylasting);

  for (int i = 0; i < MAXKEYS; i++) {
    if (keylasting[i] > lasting)
      lasting = keylasting[i];
  }
  if (lasting > LASTING) {                /* change */
    int n;
    maxlast = maxlasting[pu->noh.type];
    n = (int)(lasting / maxlast);
    for (int i = 0; i <= n; i++) {
      int j;
      for (j = 0; j < MAXKEYS; j++) {
	if (keylasting[j] > maxlast) {
	  delta[j] = maxlast;
	  keylasting[j] -= maxlast;
	}
	else {
	  delta[j] = keylasting[j];	/* last movement */
	  keylasting[j] = 0.0;
	}
      }
      userElementaryMovement(pu, delta);
    }
    if (pu->updateToNetwork(newpos)) {
      updateObjectIntoGrid(pu, newpos);
      updateObjectIn3D(pu);
      updateCameraFromObject(pu);
    }
  }
}

boolean responsibleFor(WObject *po)
{
  //PD BUG!
  //PD Comment this line because prop->responsible is false
  //PD and updateToNetwork is never called
  //PD for objects like door and thing 
  //PD return ((po->noh.prop == NULL) || (po->noh.prop->responsible == RESPONSIBLE));
  return 1;
}

/* object general motion, eg. door, anim, rocket, dart, lift */
void objectMovement(WObject *po, time_t sec, time_t usec)
{
  float lasting, maxlast, delta = 0.0;
  Pos newpos = po->pos;

  if (!isValidType(po->noh.type)) {
    trace(DBG_FORCE, "objectMovement: id_type=%d invalid", po->noh.type);
    return;
  }
  if (po->change()) {	// TRUE
    /* Correction: the anim object needs the whole definition,
       not just the position and BB */
    
    if (thisWorldIsDead == TRUE) return;
    po->updateTime(sec, usec, &lasting);

    maxlast = maxlasting[po->noh.type];
    if (lasting > LASTING) {
      int n = (int) (lasting / maxlast);
      for (int i = 0; i <= n; i++) {
	if (lasting > maxlast) {
	  delta = maxlast;
	  lasting -= maxlast;
	}
	else {
	  delta = lasting;
	  lasting = 0.0;
	}
	objectElementaryMovement(po, delta);
      }
    }
    if (responsibleFor(po) && (po->updateToNetwork(newpos))) {
      updateObjectIntoGrid(po, newpos);
      updateObjectIn3D(po);
    }
  }
}

/* object general permanent motion, eg. earth */
void objectPermanentMovement(WObject *po, time_t sec, time_t usec)
{
  float lasting, maxlast, delta = 0.0;
  Pos newpos = po->pos;

  if (po->move.perm_sec > 0) {
    copyPosAndBB(po, newpos);
    lasting = (float)(sec - po->move.perm_sec) + (float)(usec - po->move.perm_usec) / 1e6;
    po->move.perm_sec = sec;
    po->move.perm_usec = usec;
    
    maxlast = maxlasting[po->noh.type];
    if (lasting > LASTING) {
      int n = (int) (lasting / maxlast);
      n = MINI(n, 20);
      for (int i = 0; i <= n; i++) {
        //DAX printf("type=%d lasting=%.2f n=%d\n", po->noh.type, lasting, n);
	if (lasting > maxlast) {
	  delta = maxlast;
	  lasting -= maxlast;
	}
	else {
	  delta = lasting;
	  lasting = 0.0;
	}
	objectElementaryPermanentMovement(po, delta);
        if (po->nature.movable == VR_NO_ELEM_MOVE) /* HACK! */
          return;
      }
    }
    if (responsibleFor(po) && (po->updateToNetwork(newpos))) {
      updateObjectIntoGrid(po, newpos);
      updateObjectIn3D(po);
      if (po == worlds->plocaluser) {
	updateCameraFromObject(po);
      }
    }
  }
}

#endif /* !VRENGD */
