#ifndef VRENGD

#include "global.h"
#include "net.h"
#include "wobject.h"
#include "wmgt.h"
#include "parse.h"
#include "user.h"	/* USER_TYPE */
#include "ball.h"	/* BALL_TYPE */
#include "zv.h"		/* parseGeometry */
#include "caul.h"


const WClass Cauldron::wclass(CAULDRON_TYPE, "Cauldron", Cauldron::creator);


/* initialisation a partir d'une ligne de fichier */
void Cauldron::creator(char *l)
{
  new Cauldron(l);
}

Cauldron::Cauldron(char *l)
{
  l = parseName(l, this);
  l = parsePosition(l, this);
  soh = parseGeometry(l);

  initializeObject(this, CAULDRON_TYPE, VR_STILL);
} 

/* creation: see ball */
static
void cauldronCreateBall(Cauldron *po, void *data, time_t sec, time_t usec)
{
  if (generalMethodList[BALL_CREAT][BALL_TYPE].method != NULL)
    generalMethodList[BALL_CREAT][BALL_TYPE].method(po, data, sec, usec);
}

/* object intersects: up or down */
void Cauldron::whenIntersect(WObject *pcur, WObject *pold)
{
  if (pcur->noh.type != USER_TYPE)
    pcur->pos.z -= pos.bbsize.v[2] / 4;
  else
    pcur->pos.z += CAULDRON_DELTAZ;
  updateObjectIn3D(pcur);
  updateBB(pcur);
}

void cauldronInitFuncList(void)
{
  setMethodFunc(CAULDRON_TYPE, 0, WO_ACTION cauldronCreateBall, "Ball");
}

#endif /* !VRENGD */
