#ifndef BULLET_H
#define BULLET_H

#define BULLET_TYPE	15
#define BULLET_NAME	"Bullet"
#define	BULLET_INIT	bulletInitFuncList
#define BULLET_LASTING	0.03	/* 30 ms */
#define BULLET_PROPS	5

#define BULLET_PROPHNAME	0
#define BULLET_PROPXY		1
#define BULLET_PROPZ		2
#define BULLET_PROPAZ		3
#define BULLET_PROPHIT		4

#define BULLET_SPEED		5.0	// 5 m/s
#define BULLET_TTL		3.0	// 3 s
#define BULLET_DELTAZ		0.05	// 5 cm

/* bullet geometry */
#define BULLET_RADIUS		0.01	// 1 cm
#define BULLET_COLOR		"1,0,0"	// red

/* actions */
#define BULLET_CREAT		0


class Bullet: public WObject {
public:
  float lspeed;		// linear speed
  u_int8 hit;		// hit: no=0, yes=1

  static const WClass wclass;	// class variable
  virtual const WClass* getWClass() {return &wclass;};  //virtual inst. method

  Bullet(WObject *, void *, time_t, time_t);
  Bullet(u_int8 type_id, struct _NetObjectId noid, struct _Payload *);

  static WObject * replicator(u_int8 type_id,
                              struct _NetObjectId noid, Payload *pp);
  virtual boolean change();
  virtual void changePosition(float lasting);
  virtual void updateTime(time_t, time_t, float *);
  virtual boolean updateToNetwork(const Pos &oldpos);
  virtual void whenIntersect(WObject *pcur, WObject *pold);
  virtual void whenWallIntersect(WObject *pold, V3 *norm);
};

void BULLET_INIT(void);

#endif /* BULLET_H */
