/* ==================================================== ======== ======= *
 *
 *  ubwidgets.cc : Ubit Widgets for the VREng GUI
 *
 *  VREng / Ubit Project [Elc::001]
 *  Author: Eric Lecolinet
 *  Date:   08 Nov 01
 *
 *  Ubit Toolkit: A Brick Construction Game Model for Creating GUIs
 *  Please refer to the Ubit GUI Toolkit Home Page for details.
 *
 *  (C) 1999-2001 Eric Lecolinet @ ENST Paris
 *  WWW: http://www.enst.fr/~elc/ubit   Email: elc@enst.fr (subject: ubit)
 *
 * ***********************************************************************
 * COPYRIGHT NOTICE : 
 * THIS PROGRAM IS DISTRIBUTED WITHOUT ANY WARRANTY AND WITHOUT EVEN THE 
 * IMPLIED WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. 
 * YOU CAN REDISTRIBUTE IT AND/OR MODIFY IT UNDER THE TERMS OF THE GNU 
 * GENERAL PUBLIC LICENSE AS PUBLISHED BY THE FREE SOFTWARE FOUNDATION; 
 * EITHER VERSION 2 OF THE LICENSE, OR (AT YOUR OPTION) ANY LATER VERSION.
 * SEE FILES 'COPYRIGHT' AND 'COPYING' FOR MORE DETAILS.
 * ***********************************************************************
 */

#ifndef VRENGD

#undef MS

#include <ubit.hh>
#include <theme.hh>
#include <unat.hh>

#include "global.h"
#include "net.h"
#include "zv.h"
#include "wobject.h"		/* WObject */
#include "world.h"
#include "keys.h"
#include "move.h"		/* Move */
#include "user.h"		/* FOVY* */

#include "helpers.h"

#include "gui.h"
#include "guiImpl.hh"
#include "widgets.hh"
#include "vnc.h"

WTheme GuiWidgets::theme;    // the Theme of the GUI

// No Fallbacks for the Ubit version
char** GuiWidgets::getFallbackResources() {
  return NULL;
}

#if 0
static void tst(const char*s) {
  printf("tst %s\n", s);
}
#endif

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

GuiWidgets::GuiWidgets(GUI &_gui) : gui(_gui) { // points to the containing GUI class

  //Initialise le theme
  //NB: ca ne peut pas etre fait par le constructeur de WTheme
  // -1- parce qu'on veut pouvoir changer le theme dynamiquement
  //     en appelant une fonction
  // -2- car les initialisations dans setXXXStyle font reference
  //     a des constantes predefinies qui ne sont peut-etre pas
  //     encore initialisees quand static WTheme theme est evalue
  theme.setFlashyStyle();

  alertBox = null;
  vnc = null;
  vnc_dialog = null;

  followMouseMode = false;

  // size of the GL rendering zone
  glzoneWidth  = &uwidth(resources.width3D);
  glzoneHeight = &uheight(resources.height3D);

  UMenu *tool_menu =
    &umenu( ucheckbox("Audio"
		      + ucall(GUI::setAudio, TRUE, UOn::select)
		      + ucall(GUI::setAudio, FALSE, UOn::unselect)
		      )
	   + ucheckbox("Video"
			+ ucall(GUI::setVideo, TRUE, UOn::select)
			+ ucall(GUI::setVideo, FALSE, UOn::unselect)
			)
	   + ucheckbox("Whiteboard"
		       + ucall(GUI::setWhiteboard, TRUE, UOn::select)
		       + ucall(GUI::setWhiteboard, FALSE, UOn::unselect)
		       )
	   + ucheckbox("Slidecast"
		       + ucall(GUI::setSlidecast, TRUE, UOn::select)
		       + ucall(GUI::setSlidecast, FALSE, UOn::unselect)
		       )
	   + ucheckbox("Jmrc"
		       + ucall(GUI::setJmrc, TRUE, UOn::select)
		       + ucall(GUI::setJmrc, FALSE, UOn::unselect)
		       )
           + ucheckbox("Modeler"
                       + ucall(GUI::setModeler, TRUE, UOn::select)
                       + ucall(GUI::setModeler, FALSE, UOn::unselect)
                       )
	   );


  URadioSelect
    &pref1 = uradioSelect(1),
    &pref2 = uradioSelect(1),
    &pref3 = uradioSelect(1),
    &pref4 = uradioSelect(1),
    &pref5 = uradioSelect(1),
    &pref6 = uradioSelect(1);
  
  UMenu *option_menu =
    &umenu( ucheckbox("Vat" + pref1 
		       + ucall(GUI::setPref, VAT_TOOL, UOn::select))
	   + ucheckbox("Rat" + pref1 
		       + ucall(GUI::setPref, RAT_TOOL, UOn::select))
	   + ucheckbox("Fphone" + pref1 
		       + ucall(GUI::setPref, FPHONE_TOOL, UOn::select))
	   + uhbox(UBorder::shadowOut)
	   + ucheckbox("Vic" 
		       + ucall(GUI::setPref, VIC_TOOL, UOn::select))
	   + uhbox(UBorder::shadowOut)
	   + ucheckbox("Wb"  + pref2
		       + ucall(GUI::setPref, WB_TOOL, UOn::select))
	   + ucheckbox("Wbd" + pref2
		       + ucall(GUI::setPref, WBD_TOOL, UOn::select))
	   + ucheckbox("Nte" + pref2 
		       + ucall(GUI::setPref, NTE_TOOL, UOn::select))
	   + uhbox(UBorder::shadowOut)
	   + ucheckbox("Netscape" + pref3 
		       + ucall(GUI::setPref, NETSCAPE_TOOL, UOn::select))
	   + ucheckbox("mMosaic"  + pref3 
		       + ucall(GUI::setPref, MMOSAIC_TOOL, UOn::select))
	   + uhbox(UBorder::shadowOut)
	   + ucheckbox("Webspace" + pref4 
		       + ucall(GUI::setPref, WEBSPACE_TOOL, UOn::select))
	   + ucheckbox("Vrweb"    + pref4
		       + ucall(GUI::setPref, VRWEB_TOOL, UOn::select))
           + uhbox(UBorder::shadowOut)
           + ucheckbox("Vred" + pref5
                       + ucall(GUI::setPref, VRED_TOOL, UOn::select))
           + ucheckbox("Vrem"    + pref5
                       + ucall(GUI::setPref, VREM_TOOL, UOn::select))
	   + uhbox(UBorder::shadowOut)
	   + ucheckbox("Ssh"      + pref6
		       + ucall(GUI::setPref, SSH_TOOL, UOn::select))
	   + ucheckbox("Telnet"   + pref6
		       + ucall(GUI::setPref, TELNET_TOOL, UOn::select))
	   );

#if NOT_YET
  UMenu *edit_menu =
    &umenu( ucheckbox("Preferences"
		      + ucall(GUI::pref, TRUE, UOn::select)
		      + ucall(GUI::pref, FALSE, UOn::unselect))
	  );

  UMenu *views_menu =
    &umenu( ucheckbox("From Top"
		      + ucall(GUI::views, TRUE, UOn::select)
		      + ucall(GUI::views, FALSE, UOn::unselect))
	  );
#endif

  FILE *fp = NULL;
  char bookmark[URL_LEN + CHAN_LEN + 2];

  UBox *bookmark_box = &uvbox();
  UMenu *bookmark_menu =
    &umenu(
             //ubutton("Add Bookmark"
             //         + ucall(GUI::addbookmark, TRUE, UOn::action))
             UBgcolor::none
           + uscrollpane(uheight(100) + UBgcolor::none + bookmark_box)
          );

  bookmark_box->add( ubutton(UBgcolor::none + "Add Bookmark"
                             + ucall(GUI::addbookmark, TRUE, UOn::action)));
  if ((fp = fopen(vrengbookmarks, "r")) != NULL) {
    while (fgets(bookmark, sizeof(bookmark), fp)) {
      bookmark_box->add( uline(UBgcolor::none
                               + UColor::green
                               + UOn::enter/UColor::red
                               + UOn::arm/UColor::blue
                               + bookmark)
                        );
    }
    fclose(fp);
  }

  // ===== menubar ====== 

  UBox& menubar = umenubar
    ( 
     UFont::bold 
     + uscale(-1)
     //+ ubutton(UPix::stop + "Quit" + ucall(GUI::quit, 0, UOn::action))
     + ubutton(theme.File 
	       + umenu( ubutton(UPix::stop + "Quit" 
				+ ucall(GUI::quit, 0, UOn::action))
			)
	       )
     + ubutton(theme.Back1     + ucall(GUI::back, 0, UOn::action))
     + ubutton(theme.Forward1  + ucall(GUI::forward, 0, UOn::action))
     + ubutton(theme.Home1     + ucall(GUI::home, 0, UOn::action))
     + ubutton(theme.Bookmarks + *bookmark_menu)
     + ubutton(theme.Tools + *tool_menu)
     + ubutton(theme.Settings + *option_menu)
     + uhflex() + ulabel("")
     + uright() 
     + ubutton(theme.Help + ucall(GUI::help, 0, UOn::action))
     );

  // ===== toolbar & infobox ====== 

  infobox = &uhref
    (
     UBorder::none //UBorder::etchedIn
     + UFont::bold + UFont::italic
     + UPix::ray
     + UOn::idle/UColor::navy + " Welcome to the VREng "
     + UPix::ray
    );

  toolbar = &ubar
    ( 
     theme.toolbarBg + UBorder::etchedIn //UBorder::none
     + uheight(UHeight::keepSize) + uwidth(UWidth::keepSize)
     + infobox
     );

  // ===== worlds and users ====== 

  worlds = &uvbox(uwidth(LIST_WIDTH) + theme.listBg);
  users  = &uvbox(uwidth(LIST_WIDTH) + theme.listBg);

  UBox& rightPanel = uvbox
    ( 
     utop() 
     + ulabel(uvmargin(3) + UFont::bold + theme.World + "Worlds")
     + uvflex()
     + (worldsPane = 
	&uscrollPane(UScrollbar::always, UScrollbar::always,
		     UBorder::shadowIn + worlds)
	)
     
     + utop() 
     + ulabel(uvmargin(3) + UFont::bold + UPix::cross + "Avatars")
     + uvflex()
     + (usersPane = 
	&uscrollPane(UScrollbar::always, UScrollbar::always,
		     UBorder::shadowIn + users)
	)
     );
  
  // ===== Messages =====

  messages = &uvbox
    (
     //theme.messBg 
     UBgcolor::black
     + uleft()
     + ulabel( uhcenter() + UFont::bold + UColor::orange
	       + "Have fun with VREng ;-)")
     );
  
  messagesPane = &uscrollPane
    (
     UScrollbar::always, UScrollbar::never,
     uheight(70) + UBgcolor::grey //+ UBorder::etchedOut
     + messages
     );

  // ===== Text Entry =====

  entryStr = &ustr("");
  entry = &utextbox
    (
     //theme.entryBg 
     UBgcolor::grey + UColor::navy
     //+ UFont::large
     + uedit() + USymbol::right + " "
     + UOn::action / ucall(this, &GuiWidgets::entryAction)
     + entryStr
     );


  // ===== OpenGL drawing zone  ====== 

  // UIncrust = a True X Window that is "incrusted" in the Ubit Window
  // (this is necessary for displaying OpenGL data)
  glzone = &uincrust
    (
     UBgcolor::none + glzoneWidth + glzoneHeight
     + UOn::mmove    / ucall(this, &GuiWidgets::mmove)
     + UOn::mdrag    / ucall(this, &GuiWidgets::mdrag)
     + UOn::mpress   / ucall(this, &GuiWidgets::mpress)
     + UOn::mrelease / ucall(this, &GuiWidgets::mrelease)
     + UOn::kpress   / ucall(this, &GuiWidgets::kpress)
     + UOn::krelease / ucall(this, &GuiWidgets::krelease)
     );

  // ===== navigation, info menus, control panel ====== 

  //created by updateInfo:
  infoMenu = null;

  //the menu that is currently opened (and that will be refreshed
  //in the main loop after the OGL scene is rendered)
  openedMenu = null;

  // shared navigation box
  //navigator = makeNavigator();

  // the navigation menu (now created in advance)
  navigMenu = &upopmenu
    (
     UBgcolor::none + UBorder::none + UOrient::horizontal
     + makeNavigator(true)
     );

  // NOTE: ce menu est dans la glzone, pas dans la Frame car ce sont 
  // des X Windows differentes (a cause d'OGL) et car ce menu est une 
  // "softwin" (cf: navigMenu->setSoftwinMode()) qui est directement 
  // dessine la ou il est affiche sans utiliser de X Window specifique
  // afin de permetre des effets de transparence)

  navigMenu->setSoftwinMode();
  glzone->add(navigMenu);

  // creates the control panel (NB: uses navigator!)
  controlPanel = makeControlPanel();


  // ===== Main Frame ======

  frame = &uframe
    (
     *theme.bg + *theme.fg
     + uhflex()
     + menubar
     + toolbar
     + uvflex()
     + uhbox(uhflex() + uvflex()
	     + uvbox(uhflex() + uvflex() + glzone)
	     + uright() + rightPanel
	     )
     + utop()
     + controlPanel
     );
  
  // adds the main frame to the UAppli
  gui.appli->add(frame);

}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
// updates object info (infobox in the toolbar and contextual info menu)

UMenu* GuiWidgets::updateObjectInfo(ObjInfo *objinfo, int btn){
  UMenu *which_menu = null;

  if (infobox) udelete(infobox);
  infobox = null;

  if (infoMenu) udelete(infoMenu);
  infoMenu = null;

  // show the navigation menu if left button was pressed
  if (btn == 1) which_menu = navigMenu;

  if (objinfo) {
    // NB: objinfo[0].name = class_name / objinfo[1].name = instance_name

    // create and show the contextual info menu if right button
    if (btn == 3) {
      infoMenu = &upopmenu
	(
	 UBgcolor::none 
	 + uvspacing(0)
	 /*
	 + ulabel(UBgcolor::navy + UColor::white + UFont::bold 
		  + UPix::eyes + objinfo[0].name
		  )
	 + ulabel(UBgcolor::darkgrey + UColor::white + UFont::bold
		  + UPix::right + "\"" +objinfo[1].name + "\""
		  )
	 */
	 + ulabel(UBgcolor::navy + UColor::white + UFont::bold 
		  + UPix::right + objinfo[0].name + " " +objinfo[1].name
		  )
	 );
      // pseudo-menu transparent qui est directement dessine dans GLzone
      // avantage: meme quand la scene bouge l'effet de transprence reste
      // preserve (mais attention: il faut constamment reafficher le menu
      // dans la main loop sinon il serait efface par OpenGL)
      infoMenu->setSoftwinMode();
      glzone->add(infoMenu);
      which_menu = infoMenu;
    }

    // creates the new updated infobox
    infobox = &uhbox
      (
       UBorder::none
       + ulabel(theme.objectNameFg + UFont::bold 
		+ USymbol::right + objinfo[0].name + " " + objinfo[1].name
		)
       );

    // add buttons to infobox and infoMenu
    for (ObjInfo *poi = objinfo + 2; poi->name != NULL; poi++) {
      UButton *but1 = &ubutton
	(
	 UBorder::none
	 + UOn::idle/UBgcolor::none
	 + UColor::orange
	 + poi->name
	 );
      //add callback function
      if (poi->fun) but1->add(UOn::action / ucall(poi->fun, poi->farg));
      //add to box & menu
      infobox->add(but1);

      if (infoMenu) {
	UVmargin &vm = uvmargin(0);
	UButton *but2 = &ubutton
	  (
	   vm + UOn::idle/UBgcolor::none
	   + theme.actionNameFg
	   + UFont::bold //+ USymbol::right
	   + poi->name
	   );
	if (poi->fun) but2->add(UOn::action / ucall(poi->fun, poi->farg));
	infoMenu->add(but2);
      }
    }

    // put infobox at the beginning of toolbar
    toolbar->add(infobox, 0);
  }

  //update graphics
  toolbar->update();
  return which_menu;  //can be null!
}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
// External API

void GuiWidgets::entryAction(UEvent*) {
  const char *mess = entryStr->chars();
  if (!mess) return;
  if (!isalnum(*mess)) return;

  // display in message zone
  writeMessage("chat", resources.nick, mess);
  // send to World Management 
  userWriting(mess);

  // clear input zone 
  entryStr->set("");
}

void GuiWidgets::resizeGLZone(int width, int height) {
  glzoneWidth->set(width);
  glzoneHeight->set(height);
  frame->update();
}

// chat, warning, notice...
void GuiWidgets::writeMessage(const char *mode, 
			      const char *from, const char *mess) {
  char *entete = NULL;
  UColor *entete_color = null, *mess_color = null;
  
  if (!mess) mess = ""; //securite
  if (from) {
    entete = (char*) malloc(strlen(from) + 15);
    sprintf(entete, "Chat from %s> ", from);  
    entete_color = &UColor::white;
    mess_color   = &UColor::white;
  }
  else if (mode) {
    entete = (char*) malloc(strlen(mode) + 5);
    sprintf(entete, "%s> ", mode);
    entete_color = &UColor::red;
    mess_color   = &UColor::orange;
  }
  else {
    entete = (char*) malloc(5);
    sprintf(entete, "> ");
    mess_color = &UColor::black;
    mess_color = &UColor::green;
  }
  messages->add(uhbox(UFont::bold + entete_color + entete 
		      + UFont::normal +mess_color + mess
		     ));
  free(entete);
  messages->update();
  messagesPane->getVScrollbar()->setValue(100.);
}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */

static void setUser(GuiUser gu, User *puser){
  gu->addlist
    (
     UFont::bold + UColor::navy 
     + ustr(puser->name.instance_name)
     + umenu(UFont::bold
	     + uhbox(" Name: "
		     + UFont::normal + UColor::navy + puser->name.instance_name)
	     + uhbox(" World: " 
		     + UFont::normal + UColor::navy + puser->name.world_name)
	     + uhbox(" Email: "
		     + UFont::normal + UColor::navy + puser->email)
	     + uhbox(" Cname: "
		     + UFont::normal + UColor::navy + puser->rtcpname)
	     + uhbox(" Vreng: "
		     + UFont::normal + UColor::navy + puser->tool)
	     + uhbox(" Web: "
		     + UFont::normal + UColor::navy + puser->web)
	     )
     );
}

GuiUser GuiWidgets::addUser(User *puser) {
  UBox *gu = &uhref();
  setUser(gu, puser);
  users->add(gu, 2);
  users->update();
  return gu;
}

void GuiWidgets::updateUser(GuiUser gu, User *puser) {
  gu->removeAll(true);
  setUser(gu, puser);
  users->update();
}

void GuiWidgets::removeUser(GuiUser gu) {
  users->remove(gu, true);
  users->update();
}

/* ==================================================== ======== ======= */

static void setWorld(GuiWorld gw, struct _World *pworld, 
		     boolean isCurrentWorld) {

  UFont *ft = isCurrentWorld ? &UFont::bold : &UFont::normal;
  gw->addlist
    (
     UColor::navy + ft 
     + pworld->name
     + umenu(UFont::bold
	     + uhbox(" URL: "
		     + UFont::normal + UColor::navy + pworld->url)
	     + uhbox(" Channel: "
		     + UFont::normal + UColor::navy + pworld->chan)
	     )
     );
}

GuiWorld GuiWidgets::addWorld(struct _World *pworld, boolean isCurrentWorld) {
  if (!pworld) return null;
  GuiWorld gw = &uhref();
  setWorld(gw, pworld, isCurrentWorld);
  worlds->add(gw, 2);
  worlds->update();
  return gw;
}

void GuiWidgets::updateWorld(struct _World *pworld, boolean isCurrentWorld) {
  if (!pworld || !pworld->ptrgui) return;
  GuiWorld gw = (GuiWorld)pworld->ptrgui;
  gw->removeAll(true);
  setWorld(gw, pworld, isCurrentWorld);
  gw->update();
  worlds->update();
}

void GuiWidgets::removeWorld(struct _World *pworld) {
  GuiWorld gw = (GuiWorld)pworld->ptrgui;
  worlds->remove(gw, TRUE);
  pworld->ptrgui = NULL;
  worlds->update();
}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
// Control Panel

static void setkey(int key, boolean ispressed) {
  struct timeval t;
  gettimeofday(&t, NULL);  /* get time */
  changeKey(key, ispressed, t.tv_sec, t.tv_usec);
}

static void action(int spaction) {
  struct timeval t;
  gettimeofday(&t, NULL);  /* get time */
  trace(DBG_WIN, "SpecialAction: action=%d", spaction);
  specialAction(/*solid*/NULL, spaction, NULL, t.tv_sec, t.tv_usec);
}

static void setmode(boolean *variable, boolean value) {
  *variable = value;
}

UBox* GuiWidgets::makeControlPanel() {
  UMode& enterHL = UMode::enterHighlight;

  UBox& boum = uvbox
    (
     uvcenter()
     + ubox(enterHL
	    + UOn::enter/theme.activeBg
	    + UOn::arm  / ucall(action,BULLETUSER)
	    + uhcenter() + UPix::rball)
     + " " 
     + ubox(enterHL
	    + UOn::enter/theme.activeBg
	    + UOn::arm  / ucall(action,DARTUSER, UOn::arm)
	    + uhcenter() + UPix::ray)
     );

  UBox& up_down = uvbox
    (
     uvcenter()
     + ubox(enterHL
	    + UOn::enter/theme.activeBg
	    + UOn::arm    / ucall(setkey, KEY_JU, TRUE)
	    + UOn::disarm / ucall(setkey, KEY_JU, FALSE)
	    + uhcenter() + UPix::raise)  // move up
     + ubox(enterHL
	    + UOn::enter/theme.activeBg
	    + UOn::arm    / ucall(GUI::callVrengAction, USERPAUSE)
	    + uhcenter() + UPix::stop )  // pause
     + ubox(enterHL
	    + UOn::enter/theme.activeBg
	    + UOn::arm    / ucall(setkey, KEY_JD, TRUE)
	    + UOn::disarm / ucall(setkey, KEY_JD, FALSE)
	    + uhcenter() + UPix::lower)  // move down
     );

  UTrow &tilt = utrow
    (
     UFont::bold
     + utcell(UFont::small + "tilt:")
     + utcell(enterHL
	      + UOn::enter/theme.activeFg
	      + UOn::arm    / ucall(setkey, KEY_DE, TRUE)
	      + UOn::disarm / ucall(setkey, KEY_DE, FALSE)
	      + " - ")      // tilt up
     + utcell(enterHL
	      + UOn::enter/theme.activeFg
	      + UOn::arm    / ucall(setkey, KEY_HZ, TRUE)
	      + UOn::disarm / ucall(setkey, KEY_HZ, FALSE)
	      + " = ")      // stand up
     + utcell(enterHL
	      + UOn::enter/theme.activeFg
	      + UOn::arm    / ucall(setkey, KEY_MT, TRUE)
	      + UOn::disarm / ucall(setkey, KEY_MT, FALSE)
	      + " + ")      // tilt down
     );


  UTrow &linear_speed = utrow
    (
     UFont::bold
     + utcell(UFont::small + "lin. speed:")
     + utcell(enterHL
	      + UOn::enter/theme.activeBg
	      + UOn::arm  / ucall(action, LSPEEDLESS)
	      + " - ")
     + utcell(enterHL
	      + UOn::enter/theme.activeBg
	      + UOn::arm  / ucall(action, LSPEEDORIGINAL)
	      + " = ")
     + utcell(enterHL 
	      + UOn::enter/theme.activeBg
	      + UOn::arm  / ucall(action, LSPEEDGREATER)
	      + " + ")
     );

  UTrow &angular_speed = utrow
    (
     utcell(UFont::small + "ang. speed:")
     + UFont::bold
     + utcell(enterHL
	      + UOn::enter/theme.activeBg
	      + UOn::arm  / ucall(action, ASPEEDLESS)
	      + " - ")
     + utcell(enterHL
	      + UOn::enter/theme.activeBg
	      + UOn::arm  / ucall(action, ASPEEDORIGINAL)
	      + " = ")
     + utcell(enterHL
	      + UOn::enter/theme.activeBg
	      + UOn::arm  / ucall(action, ASPEEDGREATER)
	      + " + ")
     );

  UTrow &follow_mode = utrow
    (
     UFont::bold
     + utcell(UFont::small + "auto show:")
     + utcell(1, 3,   //colspan = 3
	      ucheckbox(UBgcolor::none
			+ UOn::enter/theme.activeBg
			+ UOn::select / ucall(setmode,&followMouseMode,TRUE)
			+ UOn::unselect/ucall(setmode,&followMouseMode,FALSE)
			)
	      )
      );

  UTable& settings = utable
    (
     tilt
     + linear_speed
     + angular_speed
     + follow_mode
     );

  /* (
       uhcenter() + theme.Camera
      + ubox( ucall(GUI::callVrengAction, FOVYLESS, UOn::arm)
	      + " - ")
      + ubox( ucall(GUI::callVrengAction, FOVYORIGINAL, UOn::arm)
	      + " = ")
      + ubox( ucall(GUI::callVrengAction, FOVYGREATER, UOn::arm)
	      + " + ")
     )
     );
  */ 

  // === Control Panel =======

  UBox* control_panel = &uhbox
  (
   theme.navigatorBg
   + uvcenter()
   + uvmargin(6) + uhmargin(7)
   + UColor::white

   + uvbox(UFont::bold 
	   + ubox(UMode::enterHighlight + UOn::enter/theme.activeFg
		+ theme.Back2 + ucall(GUI::back, 0, UOn::action)
		)
	   + ubox(UMode::enterHighlight + UOn::enter/theme.activeFg
		  + theme.Forward2 + ucall(GUI::forward, 0, UOn::action)
		  )
	   + ubox(UMode::enterHighlight + UOn::enter/theme.activeFg
		  + theme.Home2 + ucall(GUI::home, 0, UOn::action)
		  )
	   )
   
   + "     "
   //Navig Panel
   + umenubar( UBgcolor::none + UBorder::none 
	       + UOrient::horizontal
	       + makeNavigator(false)	       )
   + "     "
   + uhflex()
   + uvbox(uscale(-1) + messagesPane + entry)
   + "    "
   + uright()
   + boum
   + up_down
   + "  " 
   + settings
   );

  return control_panel;
}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
// ALERT BOX

void GuiWidgets::alert(const char* message) {
  if (!alertBox) {
    alertStr = &ustr();
    alertBox = &udialog
      (
       uhmargin(20) + uvmargin(20)
       + uhcenter() + uvcenter() 
       + UBgcolor::black
       + uhbox(uhmargin(20) + uvmargin(20)
	       + uhcenter() + uvcenter() 
	       + UColor::orange
	       + UFont::bold + UFont::large
	       + alertStr
	       )
       + ubutton(UFont::bold + " OK "+ ucloseDialog())
       );
    frame->add(alertBox);
    alertBox->moveAndCenter();
  }
  if (message) {
    alertStr->set(message);
    alertBox->show(true);
  }
  else alertBox->show(false);
  alertBox->update();
}

/* ==================================================== ======== ======= */
/* ==================================================== ======== ======= */
// VNC Dialog

void GuiWidgets::launchVncConnect(Vnc *po) {
  if (!vnc_dialog) {
    vnc_server = &ustr();
    vnc_port   = &ustr();
    vnc_passwd = &ustr();

    UTable &table = utable
      (
       utrow(utcell(UFont::bold + UColor::white + "Server name:")   
	     + utcell(utextbox(uedit() + vnc_server))
	       )
       + utrow(utcell(UFont::bold + UColor::white + "Port number:") 
	       + utcell(utextbox(uedit() + vnc_port))
	       )
       + utrow(utcell(UFont::bold + UColor::white + "Password:")
	       + utcell(utextbox(uedit() + vnc_passwd))
	       )
       );

    UBox &controls = uhbox
      (
       uhcenter() + UFont::bold 
       + ubutton("Connect" 
		 + ucloseDialog()
		 + ucall(this, &GuiWidgets::initVncConnect, po)
		 )
       + ubutton("Cancel"+ ucloseDialog())
       );

    vnc_dialog = &udialog
      (
       utitle("New VNC server")
       + uhcenter() + uhcenter()
       + uhmargin(10) + uvmargin(10)
       + UBgcolor::black
       + ""
       + table
       + ""
       + controls
       );

    frame->add(vnc_dialog);
    vnc_dialog->moveAndCenter();
  }

  vnc_dialog->show(true);
}

void GuiWidgets::initVncConnect(Vnc *po) {
  po->vncConvert(vnc_server->chars(),
		 vnc_port->chars(), 
		 vnc_passwd->chars());
}


#endif /* !VRENGD */
