// vold.h. Common data structures for vold.cc and volq.cc. -*- C++ -*-
// (c) 1996, 1997 David A. van Leeuwen
//

// defines do better in printf code than (const char *)
#define VOLPIPE "/var/run/vold.pipe"
#define VOLPID "/var/run/vold.pid"
#define VOLTAB "/etc/voltab"

#include "Mntent.h"

enum mount_state {not_mounted, is_mounted, un_mounted};

// a class with list-adding functions would be better...
struct mel {				// mount entry list
     Mntent * mep;
     mel * next;
     mount_state mounted;
     String dir;			// arbitrary size
};

extern int debug;

// vold.cc stuff
void add_entry_mtab(const mel * m);

// cdrom.cc stuff
void mount_isofs(mel * entry, int fd);
int cdrom_media_changed(int fd);
void check_isofs(mel * i);
void after_unmount_isofs(mel * entry, int eject);


//
// local Variables:
// c-file-style: "K&R"
// comment-column: 40
// End:
// 
