(**
  Just a plain area with a given color. Usefull for a buttonimage, when you
  want some kind of palette button.
**)

MODULE VOColorArea;

(*
    Implements a colored area.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This module is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public License
    as published by the Free Software Foundation; either version 2 of
    the License, or (at your option) any later version.

    This module is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with VisualOberon. If not, write to the Free Software Foundation,
    59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT D := VODisplay,
       O := VOGUIObject;

TYPE
  ColorArea*     = POINTER TO ColorAreaDesc;
  ColorAreaDesc* = RECORD (O.ImageDesc)
                     color : D.Color;
                   END;


  PROCEDURE (c : ColorArea) Init*;

  BEGIN
    c.Init^;

    c.color:=D.textColor;
  END Init;

  (**
    The the color of the color area.
  **)

  PROCEDURE (c : ColorArea) SetColor*(color : D.Color);

  BEGIN
    c.color:=color;
    IF c.visible THEN
      c.Redraw;
    END;
  END SetColor;

  PROCEDURE (c : ColorArea) CalcSize*(display : D.Display);

  BEGIN
    IF display.spaceWidth>display.spaceHeight THEN
      c.width:=3*display.spaceWidth;
      c.height:=3*display.spaceWidth;
      c.minWidth:=display.spaceWidth;
      c.minHeight:=display.spaceWidth;
    ELSE
      c.width:=3*display.spaceHeight;
      c.height:=3*display.spaceHeight;
      c.minWidth:=display.spaceHeight;
      c.minHeight:=display.spaceHeight;
    END;

    c.CalcSize^(display);

  END CalcSize;

  PROCEDURE (c : ColorArea) Draw* (x,y : LONGINT; draw : D.DrawInfo);

  BEGIN
    c.Draw^(x,y,draw);

    draw.PushForeground(c.color);
    draw.FillRectangle(c.x,c.y,c.width,c.height);
    draw.PopForeground;
  END Draw;

  PROCEDURE (c :  ColorArea) Hide*;

  BEGIN
    IF c.visible THEN
      c.DrawHide;
      c.Hide^;
    END;
  END Hide;

END VOColorArea.