(**
  A demo for the VOClock class. This little clock is really useable and
  is used by the author as part of its fvwm2 button pannel.
**)

MODULE Clock;

(*
    Demo for VisualOberon. Shows the current time.
    Copyright (C) 1997  Tim Teulings (rael@edge.ping.de)

    This file is part of VisualOberon.

    VisualOberon is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.  

    VisualOberon is distributed in the hope that it will be useful, but
    WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details. 

    You should have received a copy of the GNU General Public License
    along with VisualOberon. If not, write to the Free Software
    Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*)

IMPORT C   := VOClock,
       D   := VODisplay,
       G   := VOGUIObject,
       Q   := VOQuickHelp,
       T   := VOText,
              VOUsePrefs,
       W   := VOWindow,

              Err,
       L   := Locales;

VAR
  d          : D.Display;
  w          : W.Window;

  clock      : C.Clock;

  msg2Exit   : D.Msg2Exit;

  old        : ARRAY 32 OF CHAR;


BEGIN 
  NEW(d);
  IF ~d.InitDisplay("Clock") THEN
    Err.String("Cannot open to display!"); Err.Ln;
    HALT(1);
  END;

  L.Set(L.ALL,"",old);  (* use env variables *)

  NEW(clock);
  clock.Init;
  clock.SetFlags({G.horizontalFlex,G.verticalFlex});
  clock.SetWidth(G.sizeFontRel,10);
  clock.SetHeight(G.sizeFontRel,10);
  clock.SetHelpObject(Q.InitHelp(d,T.MakeLeftText("\ecClock\n@ 1997, Tim Teulings\nwritten with VisualOberon"),clock));
  clock.ShowFrame(FALSE);
(*  clock.SetText("%X","%x");*)
  clock.SetText("%H:%M:%S","%D.%m.%y");

  NEW(w);
  w.Init;
  w.SetDisplay(d);
  w.SetTop(clock);
  w.SetTitle("Clock");
  NEW(msg2Exit);
  msg2Exit.destination:=d;
  w.AddHandler(msg2Exit,W.closeMsg);
  w.Open;
  
  d.Handler;

  d.Deinit;
END Clock.