/*
    vlad - an LDAP visualisation tool
    Copyright (C) 1999-2001 Robert Norris <rob@nauseum.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>

#include "vlad.h"

struct entry *create_entry_struct(void) {
	struct entry *entry;

	if(!(entry = (struct entry *) malloc(sizeof(struct entry)))) return NULL;

	memset(entry, 0, sizeof(struct entry));

	return entry;
	}

void free_entry_list(struct entry *list_head);

void free_entry_struct(struct entry *entry) {
	if(entry->dn) free(entry->dn);
	if(entry->attrs) free_attr_set(entry->attrs);
	if(entry->subentries_head) free_entry_list(entry->subentries_head);

	free(entry);
	}

void free_entry_list(struct entry *list_head) {
	struct entry *scan, *next;

	for(scan = list_head; scan; scan = next) {
		next = scan->next;
		free_entry_struct(scan);
		}
	}

struct entry *create_root_entry_struct(void) {
	struct entry *root;
	
	if(!(root = create_entry_struct())) return NULL;
	
	root->dn = root->shortdn = opt.basedn;

	return root;
	}
