/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <Strings.h>
#include <Setup.h>
#include <MainWindow.h>

#include <qapplication.h>
#include <qmessagebox.h>

#include <iostream.h>
#include <signal.h>

void sighandler( int sig )
{
  cout << "Signal " << sig << " intercepted!" << endl;
}

int main( int argc, char ** argv ) 
{  
  QApplication app( argc, argv );

  QTranslator translator( 0 );
  translator.load( QString("default"), "./messages" );
  app.installTranslator( &translator );

  MainWindow* mw = MainWindow::instance();
  mw->setTranslator( &translator );
  mw->resize(600,420);
  app.setMainWidget(mw);
  QString name = Strings::translate( Strings::MainWindowTitle );
  mw->setCaption( name );
  mw->show();
  app.connect( &app, SIGNAL(lastWindowClosed()), &app, SLOT(quit()) );

  //Parse command line
  for ( int i=1; i<app.argc(); i++ )
    {
      QString param(app.argv()[i]);
      if ( param == "-debug" )
	{
	  cout <<  "ViPEC: Entering debug mode." << endl;
	  Setup::instance()->setDebugMode( TRUE );  
	}
      else
	{
	  cout << "Unknown command line option - ignored!" << endl;
	}
    }

#ifndef _WS_WIN_
  if ( !Setup::instance()->isDebugMode() )
    {
      struct sigaction act;
      act.sa_handler = sighandler;
      sigemptyset( &act.sa_mask );
      act.sa_flags = 0;
      sigaction( SIGINT, &act, 0 );
      sigaction( SIGQUIT, &act, 0 );
      sigaction( SIGKILL, &act, 0 );
    }
#endif

  try
    {
      return app.exec();
    }
  catch (...)
    {
      QMessageBox::warning( mw, Strings::LabelApplicationName,
			    "Unhandled exception! The application will close now." );
      return 1;
    }
}
