/* -*- C++ -*-

  This file is part of ViPEC
  Copyright (C) 1991-2000 Johan Rossouw (jrossouw@alcatel.altech.co.za)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU Library General Public License as
  published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU Library General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <ModifySweepWindow.h>

#include <Setup.h>
#include <Strings.h>
#include <MainWindow.h>
#include <NavigationWindow.h>

#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qpushbutton.h>
#include <qapplication.h>
#include <qvalidator.h>

#include <iostream.h>

//----------------------------------------------------------------------------
ModifySweepWindow::ModifySweepWindow( QWidget* parent, const char* name )
  : QDialog(parent, name, TRUE),
    topLayout_(0)
{
  setCaption( name );

  topLayout_ = new QVBoxLayout( this );
  QGridLayout* gridLayout = new QGridLayout ( 0 );
  QHBoxLayout* buttonLayout = new QHBoxLayout( 0 );
  
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( gridLayout );
  topLayout_->addSpacing( 10 );
  topLayout_->addItem( buttonLayout );

  QString okLabel = Strings::translate( Strings::LabelOk );
  QString cancelLabel = Strings::translate( Strings::LabelCancel );
  QPushButton* ok = new QPushButton( okLabel, this );
  QPushButton* cancel = new QPushButton( cancelLabel, this );
  
  buttonLayout->addWidget( ok );
  buttonLayout->addWidget( cancel );

  connect ( ok, SIGNAL( clicked() ),
	    this, SLOT( ok() ) );
  connect ( cancel, SIGNAL( clicked() ),
	    this, SLOT( cancel() ) );


  QString text1 = Strings::translate( Strings::SweepType);
  QString text2 = Strings::translate( Strings::SweepStartFrequency);
  QString text3 = Strings::translate( Strings::SweepStopFrequency);
  QString text4 = Strings::translate( Strings::SweepNumberOfPoints);

  QLabel* label1 = new QLabel( text1, this );
  QLabel* label2 = new QLabel( text2, this );
  QLabel* label3 = new QLabel( text3, this );
  QLabel* label4 = new QLabel( text4, this );
  
  typeGadget_ = new QComboBox( this );
  startGadget_ = new QLineEdit( this );
  stopGadget_ = new QLineEdit( this );
  pointsGadget_ = new QLineEdit( this );

  QString value1 = Strings::translate( Strings::SweepLinearType);
  QString value2 = Strings::translate( Strings::SweepLogType);
  typeGadget_->insertItem( value1 );
  typeGadget_->insertItem( value2 );

  floatValidator_ = new QDoubleValidator( this );
  floatValidator_->setRange( 1E-10, 1E15, 5 );
  intValidator_ = new QIntValidator( this );
  intValidator_->setRange( 0, 1000);
  startGadget_->setValidator( floatValidator_ );
  stopGadget_->setValidator( floatValidator_ );
  pointsGadget_->setValidator( intValidator_ );
  
  gridLayout->expand( 4, 5 );
  gridLayout->addColSpacing( 0, 30 );
  gridLayout->addColSpacing( 1, 100 );
  gridLayout->addColSpacing( 2, 10 );
  gridLayout->addColSpacing( 3, 100 );
  gridLayout->addColSpacing( 4, 30 );

  for (int i=0; i<4; i++)
    {
       gridLayout->addRowSpacing( i, 35 );
    }

  gridLayout->addWidget( label1, 0, 1 );
  gridLayout->addWidget( label2, 1, 1 );
  gridLayout->addWidget( label3, 2, 1 );
  gridLayout->addWidget( label4, 3, 1 );
  gridLayout->addWidget( typeGadget_,   0, 3 );
  gridLayout->addWidget( startGadget_,  1, 3 );
  gridLayout->addWidget( stopGadget_,   2, 3 );
  gridLayout->addWidget( pointsGadget_, 3, 3 );

  resize( topLayout_->sizeHint() );
}

//----------------------------------------------------------------------------
ModifySweepWindow::~ModifySweepWindow()
{
  delete topLayout_;
  delete floatValidator_;
  delete intValidator_;
}

//----------------------------------------------------------------------------
void ModifySweepWindow::ok()
{
  QString value;
  Setup& setup = *Setup::instance();
  setup.setLinearSweep( typeGadget_->currentItem() == 0 );
  value = startGadget_->text();
  setup.setStartFrequency( value.toDouble() );
  value = stopGadget_->text();
  setup.setStopFrequency( value.toDouble() );
  value = pointsGadget_->text();
  setup.setNumberOfFrequencyPoints( value.toInt() );
  MainWindow::instance()->resetCircuits();
  NavigationWindow::instance()->updateSweep();
  close();
}

//----------------------------------------------------------------------------
void ModifySweepWindow::cancel()
{
  close();
}

//----------------------------------------------------------------------------
void ModifySweepWindow::initialize()
{
  QString tmp;
  Setup& setup = *Setup::instance();
  if ( setup.isLinearSweep() )
    {
      typeGadget_->setCurrentItem( 0 );
    }
  else
    {
      typeGadget_->setCurrentItem( 1 );
    }
  tmp.setNum( setup.getStartFrequency() );
  startGadget_->setText( tmp );
  tmp.setNum( setup.getStopFrequency() );
  stopGadget_->setText( tmp );
  tmp.setNum( setup.getNumberOfFrequencyPoints() );
  pointsGadget_->setText( tmp );
}
