" Vim syntax file
" Language:	php PHP 3/4
" Maintainer:	Lutz Eymers <ixtab@polzin.com>
" URL:		http://www.isp.de/data/php.vim
" Email:	Subject: send syntax_vim.tgz
" Last Change:	2002 Mar 11
"
" Options	php_sql_query = 1  for SQL syntax highlighting inside strings
"		php_htmlInStrings = 1  for HTML syntax highlighting inside strings
"		php_baselib = 1  for highlighting baselib functions
"		php_asp_tags = 1  for highlighting ASP-style short tags
"		php_parent_error_close = 1  for highlighting parent error ] or )
"		php_parent_error_open = 1  for skipping an php end tag, if there exists an open ( or [ without a closing one
"		php_oldStyle = 1  for using old colorstyle
"		php_noShortTags = 1  don't sync <? ?> as php
"		php_folding = 1  for folding classes and functions
"		php_sync_method = x
"			x=-1 to sync by search ( default )
"			x>0 to sync at least x lines backwards
"			x=0 to sync from start

" For version 5.x: Clear all syntax items
" For version 6.x: Quit when a syntax file was already loaded
if version < 600
  syntax clear
elseif exists("b:current_syntax")
  finish
endif

if !exists("main_syntax")
  let main_syntax = 'php'
endif

if version < 600
  so <sfile>:p:h/html.vim
else
  runtime syntax/html.vim
  unlet b:current_syntax
endif

" accept old options
if !exists("php_sync_method")
  if exists("php_minlines")
    let php_sync_method=php_minlines
  else
    let php_sync_method=-1
  endif
endif

if exists("php_parentError")
  let php_parent_error_close=1
  unlet php_parent_error_open
endif

syn cluster htmlPreproc add=phpRegion

syn include @sqlTop <sfile>:p:h/sql.vim
syn sync clear
unlet b:current_syntax
syn cluster sqlTop remove=sqlString,sqlComment
if exists( "php_sql_query")
  syn cluster phpAddStrings contains=@sqlTop
endif

if exists( "php_htmlInStrings")
  syn cluster phpAddStrings add=@htmlTop
endif

syn case match

" Env Variables
syn keyword	phpEnvVar	GATEWAY_INTERFACE SERVER_NAME SERVER_SOFTWARE SERVER_PROTOCOL REQUEST_METHOD QUERY_STRING DOCUMENT_ROOT HTTP_ACCEPT HTTP_ACCEPT_CHARSET HTTP_ENCODING HTTP_ACCEPT_LANGUAGE HTTP_CONNECTION HTTP_HOST HTTP_REFERER HTTP_USER_AGENT REMOTE_ADDR REMOTE_PORT SCRIPT_FILENAME SERVER_ADMIN SERVER_PORT SERVER_SIGNATURE PATH_TRANSLATED SCRIPT_NAME REQUEST_URI	contained

" Internal Variables
syn keyword	phpIntVar GLOBALS HTTP_GET_VARS HTTP_POST_VARS HTTP_COOKIE_VARS	HTTP_POST_FILES HTTP_ENV_VARS HTTP_SERVER_VARS PHP_ERRMSG PHP_SELF HTTP_RAW_POST_DATA HTTP_STATE_VARS _GET _POST _COOKIE _SERVER _ENV	contained

syn case ignore

" Function names
syn keyword	phpFunctions	apache_lookup_uri apache_note ascii2ebcdic ebcdic2ascii getallheaders virtual apache_child_terminate apache_setenv	contained
syn keyword	phpFunctions	array array_change_key_case array_chunk array_count_values array_diff array_filter array_flip array_fill array_intersect array_key_exists array_keys array_map array_merge array_merge_recursive array_multisort array_pad array_pop array_push array_rand array_reverse array_reduce array_shift array_slice array_splice array_sum array_unique array_unshift array_values array_walk arsort asort compact count current each end extract in_array array_search key krsort ksort list natsort natcasesort next pos prev range reset rsort shuffle sizeof sort uasort uksort usort	contained
syn keyword	phpFunctions	aspell_new aspell_check aspell_check_raw aspell_suggest	contained
syn keyword	phpFunctions	bcadd bccomp bcdiv bcmod bcmul bcpow bcscale bcsqrt bcsub	contained
syn keyword	phpFunctions	bzclose bzcompress bzdecompress bzerrno bzerror bzerrstr bzflush bzopen bzread bzwrite	contained
syn keyword	phpFunctions	jdtogregorian gregoriantojd jdtojulian juliantojd jdtojewish jewishtojd jdtofrench frenchtojd jdmonthname jddayofweek easter_date easter_days unixtojd jdtounix cal_days_in_month cal_to_jd cal_from_jd cal_info	contained
syn keyword	phpFunctions	ccvs_init ccvs_done ccvs_new ccvs_add ccvs_delete ccvs_auth ccvs_return ccvs_reverse ccvs_sale ccvs_void ccvs_status ccvs_count ccvs_lookup ccvs_report ccvs_command ccvs_textvalue	contained
syn keyword	phpFunctions	com_load com_invoke com_propget com_get com_propput com_propset com_set com_addref com_release com_isenum com_load_typelib	contained
syn keyword	phpFunctions	call_user_method_array call_user_method class_exists get_class get_class_methods get_class_vars get_declared_classes get_object_vars get_parent_class is_a is_subclass_of method_exists	contained
syn keyword	phpFunctions	cpdf_add_annotation cpdf_add_outline cpdf_arc cpdf_begin_text cpdf_circle cpdf_clip cpdf_close cpdf_closepath cpdf_closepath_fill_stroke cpdf_closepath_stroke cpdf_continue_text cpdf_curveto cpdf_end_text cpdf_fill cpdf_fill_stroke cpdf_finalize cpdf_finalize_page cpdf_global_set_document_limits cpdf_import_jpeg cpdf_lineto cpdf_moveto cpdf_newpath cpdf_open cpdf_output_buffer cpdf_page_init cpdf_place_inline_image cpdf_rect cpdf_restore cpdf_rlineto cpdf_rmoveto cpdf_rotate cpdf_rotate_text cpdf_save cpdf_save_to_file cpdf_scale cpdf_set_char_spacing cpdf_set_creator cpdf_set_current_page cpdf_set_font cpdf_set_horiz_scaling cpdf_set_keywords cpdf_set_leading cpdf_set_page_animation cpdf_set_subject cpdf_set_text_matrix cpdf_set_text_pos cpdf_set_text_rendering cpdf_set_text_rise cpdf_set_title cpdf_set_word_spacing cpdf_setdash cpdf_setflat cpdf_setgray cpdf_setgray_fill cpdf_setgray_stroke cpdf_setlinecap cpdf_setlinejoin cpdf_setlinewidth cpdf_setmiterlimit cpdf_setrgbcolor cpdf_setrgbcolor_fill cpdf_setrgbcolor_stroke cpdf_show cpdf_show_xy cpdf_stringwidth cpdf_set_font_directories cpdf_set_font_map_file cpdf_set_viewer_preferences cpdf_stroke cpdf_text cpdf_translate cpdf_set_action_url	contained
syn keyword	phpFunctions	crack_opendict crack_closedict crack_check crack_getlastmessage	contained
syn keyword	phpFunctions	curl_init curl_setopt curl_exec curl_close curl_version curl_errno curl_error curl_getinfo	contained
syn keyword	phpFunctions	cybercash_encr cybercash_decr cybercash_base64_encode cybercash_base64_decode	contained
syn keyword	phpFunctions	cybermut_creerformulairecm cybermut_testmac cybermut_creerreponsecm	contained
syn keyword	phpFunctions	cyrus_connect cyrus_authenticate cyrus_bind cyrus_unbind cyrus_query cyrus_close	contained
syn keyword	phpFunctions	ctype_alnum ctype_alpha ctype_cntrl ctype_digit ctype_lower ctype_graph ctype_print ctype_punct ctype_space ctype_upper ctype_xdigit	contained
syn keyword	phpFunctions	dba_close dba_delete dba_exists dba_fetch dba_firstkey dba_insert dba_nextkey dba_popen dba_open dba_optimize dba_replace dba_sync	contained
syn keyword	phpFunctions	checkdate date getdate gettimeofday gmdate gmmktime gmstrftime localtime microtime mktime strftime time strtotime	contained
syn keyword	phpFunctions	dbase_create dbase_open dbase_close dbase_pack dbase_add_record dbase_replace_record dbase_delete_record dbase_get_record dbase_get_record_with_names dbase_numfields dbase_numrecords	contained
syn keyword	phpFunctions	dbmopen dbmclose dbmexists dbmfetch dbminsert dbmreplace dbmdelete dbmfirstkey dbmnextkey dblist	contained
syn keyword	phpFunctions	dbx_close dbx_connect dbx_error dbx_query dbx_sort dbx_compare	contained
syn keyword	phpFunctions	dbplus_add dbplus_aql dbplus_chdir dbplus_close dbplus_curr dbplus_errcode dbplus_errno dbplus_find dbplus_first dbplus_flush dbplus_freealllocks dbplus_freelock dbplus_freerlocks dbplus_getlock dbplus_getunique dbplus_info dbplus_last dbplus_lockrel dbplus_next dbplus_open dbplus_prev dbplus_rchperm dbplus_rcreate dbplus_rcrtexact dbplus_rcrtlike dbplus_resolve dbplus_rkeys dbplus_restorepos dbplus_ropen dbplus_rquery dbplus_rrename dbplus_rsecindex dbplus_runlink dbplus_rzap dbplus_savepos dbplus_setindex dbplus_setindexbynumber dbplus_sql dbplus_tcl dbplus_tremove dbplus_undo dbplus_undoprepare dbplus_unlockrel dbplus_unselect dbplus_update dbplus_xlockrel dbplus_xunlockrel	contained
syn keyword	phpFunctions	dio_open dio_read dio_write dio_truncate dio_stat dio_seek dio_fcntl dio_close	contained
syn keyword	phpFunctions	chroot chdir closedir getcwd opendir readdir rewinddir	contained
syn keyword	phpFunctions	xmldoc xmldocfile xmltree domxml_root domxml_add_root domxml_dumpmem domxml_attributes domxml_get_attribute domxml_set_attribute domxml_children domxml_new_child domxml_new_xmldoc xpath_new_context xpath_eval domxml_node domxml_node_set_content domxml_node_unlink_node xpath_eval_expression domxml_version xptr_new_context xptr_eval	contained
syn keyword	phpFunctions	dotnet_load	contained
syn keyword	phpFunctions	error_log error_reporting restore_error_handler set_error_handler trigger_error user_error	contained
syn keyword	phpFunctions	fbsql_affected_rows fbsql_autocommit fbsql_change_user fbsql_close fbsql_commit fbsql_connect fbsql_create_db fbsql_create_blob fbsql_create_clob fbsql_database_password fbsql_data_seek fbsql_db_query fbsql_db_status fbsql_drop_db fbsql_errno fbsql_error fbsql_fetch_array fbsql_fetch_assoc fbsql_fetch_field fbsql_fetch_lengths fbsql_fetch_object fbsql_fetch_row fbsql_field_flags fbsql_field_name fbsql_field_len fbsql_field_seek fbsql_field_table fbsql_field_type fbsql_free_result fbsql_insert_id fbsql_list_dbs fbsql_list_fields fbsql_list_tables fbsql_next_result fbsql_num_fields fbsql_num_rows fbsql_pconnect fbsql_query fbsql_read_blob fbsql_read_clob fbsql_result fbsql_rollback fbsql_set_lob_mode fbsql_select_db fbsql_start_db fbsql_stop_db fbsql_tablename fbsql_warnings fbsql_database fbsql_get_autostart_info fbsql_hostname fbsql_password fbsql_set_transaction fbsql_username	contained
syn keyword	phpFunctions	filepro filepro_fieldname filepro_fieldtype filepro_fieldwidth filepro_retrieve filepro_fieldcount filepro_rowcount	contained
syn keyword	phpFunctions	basename chgrp chmod chown clearstatcache copy delete dirname disk_free_space diskfreespace disk_total_space fclose feof fflush fgetc fgetcsv fgets fgetss file file_exists fileatime filectime filegroup fileinode filemtime fileowner fileperms filesize filetype flock fopen fpassthru fputs fread fscanf fseek fstat ftell ftruncate fwrite set_file_buffer is_dir is_executable is_file is_link is_readable is_writable is_writeable is_uploaded_file link linkinfo mkdir move_uploaded_file parse_ini_file pathinfo pclose popen readfile readlink rename rewind rmdir stat lstat realpath symlink tempnam tmpfile touch umask unlink	contained
syn keyword	phpFunctions	fdf_open fdf_close fdf_create fdf_save fdf_get_value fdf_set_value fdf_next_field_name fdf_set_ap fdf_set_status fdf_get_status fdf_set_file fdf_get_file fdf_set_flags fdf_set_opt fdf_set_submit_form_action fdf_set_javascript_action fdf_set_encoding fdf_add_template	contained
syn keyword	phpFunctions	fribidi_log2vis	contained
syn keyword	phpFunctions	ftp_connect ftp_login ftp_pwd ftp_cdup ftp_chdir ftp_mkdir ftp_rmdir ftp_nlist ftp_rawlist ftp_systype ftp_pasv ftp_get ftp_fget ftp_put ftp_fput ftp_size ftp_mdtm ftp_rename ftp_delete ftp_site ftp_close ftp_quit ftp_exec ftp_set_option ftp_get_option	contained
syn keyword	phpFunctions	call_user_func_array call_user_func create_function func_get_arg func_get_args func_num_args function_exists get_defined_functions register_shutdown_function register_tick_function unregister_tick_function	contained
syn keyword	phpFunctions	bindtextdomain bind_textdomain_codeset dcgettext dcngettext dgettext dngettext gettext ngettext textdomain	contained
syn keyword	phpFunctions	gmp_init gmp_intval gmp_strval gmp_add gmp_sub gmp_mul gmp_div_q gmp_div_r gmp_div_qr gmp_div gmp_mod gmp_divexact gmp_cmp gmp_neg gmp_com gmp_abs gmp_sign gmp_fact gmp_sqrt gmp_sqrtrem gmp_perfect_square gmp_pow gmp_powm gmp_prob_prime gmp_gcd gmp_gcdext gmp_invert gmp_legendre gmp_jacobi gmp_random gmp_and gmp_or gmp_xor gmp_setbit gmp_clrbit gmp_scan0 gmp_scan1 gmp_popcount gmp_hamdist	contained
syn keyword	phpFunctions	header headers_sent setcookie	contained
syn keyword	phpFunctions	hw_array2objrec hw_children hw_childrenobj hw_close hw_connect hw_cp hw_deleteobject hw_docbyanchor hw_docbyanchorobj hw_document_attributes hw_document_bodytag hw_document_content hw_document_setcontent hw_document_size hw_errormsg hw_edittext hw_error hw_free_document hw_getparents hw_getparentsobj hw_getchildcoll hw_getchildcollobj hw_getremote hw_getremotechildren hw_getsrcbydestobj hw_getobject hw_getandlock hw_gettext hw_getobjectbyquery hw_getobjectbyqueryobj hw_getobjectbyquerycoll hw_getobjectbyquerycollobj hw_getchilddoccoll hw_getchilddoccollobj hw_getanchors hw_getanchorsobj hw_mv hw_identify hw_incollections hw_info hw_inscoll hw_insdoc hw_insertdocument hw_insertobject hw_mapid hw_modifyobject hw_new_document hw_objrec2array hw_output_document hw_pconnect hw_pipedocument hw_root hw_unlock hw_who hw_getusername hw_stat hw_setlinkroot hw_connection_info hw_dummy hw_insertanchors hw_getrellink hw_changeobject	contained
syn keyword	phpFunctions	icap_open icap_close icap_fetch_event icap_list_events icap_store_event icap_delete_event icap_snooze icap_list_alarms icap_create_calendar icap_rename_calendar icap_delete_calendar icap_reopen	contained
syn keyword	phpFunctions	iconv iconv_get_encoding iconv_set_encoding ob_iconv_handler	contained
syn keyword	phpFunctions	getimagesize image2wbmp imagealphablending imagearc imagefilledarc imageellipse imagefilledellipse imagechar imagecharup imagecolorallocate imagecolordeallocate imagecolorat imagecolorclosest imagecolorclosestalpha imagecolorclosesthwb imagecolorexact imagecolorexactalpha imagecolorresolve imagecolorresolvealpha imagegammacorrect imagecolorset imagecolorsforindex imagecolorstotal imagecolortransparent imagecopy imagecopymerge imagecopymergegray imagecopyresized imagecopyresampled imagecreate imagecreatetruecolor imagetruecolortopalette imagecreatefromgd imagecreatefromgd2 imagecreatefromgd2part imagecreatefromgif imagecreatefromjpeg imagecreatefrompng imagecreatefromwbmp imagecreatefromstring imagecreatefromxbm imagecreatefromxpm imagedashedline imagedestroy imagefill imagefilledpolygon imagefilledrectangle imagefilltoborder imagefontheight imagefontwidth imagegd imagegd2 imagegif imagepng imagejpeg imagewbmp imageinterlace imageline imageloadfont imagepalettecopy imagepolygon imagepsbbox imagepsencodefont imagepsfreefont imagepsloadfont imagepsextendfont imagepsslantfont imagepstext imagerectangle imagesetpixel imagesetbrush imagesetstyle imagesettile imagesetthickness imagestring imagestringup imagesx imagesy imagettfbbox imageftbbox imagettftext imagefttext imagetypes jpeg2wbmp png2wbmp read_exif_data iptcembed	contained
syn keyword	phpFunctions	imap_8bit imap_alerts imap_append imap_base64 imap_binary imap_body imap_bodystruct imap_check imap_clearflag_full imap_close imap_createmailbox imap_delete imap_deletemailbox imap_errors imap_expunge imap_fetch_overview imap_fetchbody imap_fetchheader imap_fetchstructure imap_get_quota imap_getmailboxes imap_getsubscribed imap_header imap_headerinfo imap_headers imap_last_error imap_listmailbox imap_listsubscribed imap_mail imap_mail_compose imap_mail_copy imap_mail_move imap_mailboxmsginfo imap_mime_header_decode imap_msgno imap_num_msg imap_num_recent imap_open imap_ping imap_popen imap_qprint imap_renamemailbox imap_reopen imap_rfc822_parse_adrlist imap_rfc822_parse_headers imap_rfc822_write_address imap_scanmailbox imap_search imap_setacl imap_set_quota imap_setflag_full imap_sort imap_status imap_subscribe imap_uid imap_undelete imap_unsubscribe imap_utf7_decode imap_utf7_encode imap_utf8 imap_thread	contained
syn keyword	phpFunctions	ifx_connect ifx_pconnect ifx_close ifx_query ifx_prepare ifx_do ifx_error ifx_errormsg ifx_affected_rows ifx_getsqlca ifx_fetch_row ifx_htmltbl_result ifx_fieldtypes ifx_fieldproperties ifx_num_fields ifx_num_rows ifx_free_result ifx_create_char ifx_free_char ifx_update_char ifx_get_char ifx_create_blob ifx_copy_blob ifx_free_blob ifx_get_blob ifx_update_blob ifx_blobinfile_mode ifx_textasvarchar ifx_byteasvarchar ifx_nullformat ifxus_create_slob ifxus_free_slob ifxus_close_slob ifxus_open_slob ifxus_tell_slob ifxus_seek_slob ifxus_read_slob ifxus_write_slob	contained
syn keyword	phpFunctions	ibase_connect ibase_pconnect ibase_close ibase_query ibase_errmsg ibase_fetch_row ibase_fetch_object ibase_field_info ibase_free_query ibase_free_result ibase_prepare ibase_execute ibase_trans ibase_commit ibase_rollback ibase_timefmt ibase_num_fields ibase_blob_add ibase_blob_cancel ibase_blob_close ibase_blob_create ibase_blob_echo ibase_blob_get ibase_blob_import ibase_blob_info ibase_blob_open	contained
syn keyword	phpFunctions	ingres_connect ingres_pconnect ingres_close ingres_query ingres_num_rows ingres_num_fields ingres_field_name ingres_field_type ingres_field_nullable ingres_field_length ingres_field_precision ingres_field_scale ingres_fetch_array ingres_fetch_row ingres_fetch_object ingres_rollback ingres_commit ingres_autocommit	contained
syn keyword	phpFunctions	ircg_pconnect ircg_fetch_error_msg ircg_set_current ircg_join ircg_part ircg_msg ircg_notice ircg_nick ircg_topic ircg_channel_mode ircg_html_encode ircg_whois ircg_kick ircg_ignore_add ircg_ignore_del ircg_disconnect ircg_is_conn_alive ircg_lookup_format_messages ircg_register_format_messages ircg_set_on_die ircg_set_file ircg_get_username ircg_nickname_escape ircg_nickname_unescape	contained
syn keyword	phpFunctions	java_last_exception_clear java_last_exception_get	contained
syn keyword	phpFunctions	ldap_add ldap_bind ldap_close ldap_compare ldap_connect ldap_count_entries ldap_delete ldap_dn2ufn ldap_err2str ldap_errno ldap_error ldap_explode_dn ldap_first_attribute ldap_first_entry ldap_free_result ldap_get_attributes ldap_get_dn ldap_get_entries ldap_get_option ldap_get_values ldap_get_values_len ldap_list ldap_modify ldap_mod_add ldap_mod_del ldap_mod_replace ldap_next_attribute ldap_next_entry ldap_read ldap_rename ldap_search ldap_set_option ldap_unbind ldap_8859_to_t61 ldap_first_reference ldap_next_reference ldap_parse_reference ldap_parse_result ldap_set_rebind_proc ldap_sort ldap_start_tls ldap_t61_to_8859	contained
syn keyword	phpFunctions	mail ezmlm_hash	contained
syn keyword	phpFunctions	mailparse_uudecode_all mailparse_rfc822_parse_addresses mailparse_determine_best_xfer_encoding mailparse_stream_encode mailparse_msg_parse mailparse_msg_parse_file mailparse_msg_free mailparse_msg_create mailparse_msg_get_structure mailparse_msg_extract_part mailparse_msg_extract_part_file mailparse_msg_get_part_data mailparse_msg_get_part	contained
syn keyword	phpFunctions	abs acos acosh asin asinh atan atanh atan2 base_convert bindec ceil cos cosh decbin dechex decoct deg2rad exp expm1 floor getrandmax hexdec hypot lcg_value log log10 log1p max min mt_rand mt_srand mt_getrandmax number_format octdec pi pow rad2deg rand round sin sinh sqrt srand tan tanh	contained
syn keyword	phpFunctions	mb_language mb_parse_str mb_internal_encoding mb_http_input mb_http_output mb_detect_order mb_substitute_character mb_output_handler mb_preferred_mime_name mb_strlen mb_strpos mb_strrpos mb_substr mb_strcut mb_strwidth mb_strimwidth mb_convert_encoding mb_detect_encoding mb_convert_kana mb_encode_mimeheader mb_decode_mimeheader mb_convert_variables mb_encode_numericentity mb_decode_numericentity mb_send_mail mb_get_info	contained
syn keyword	phpFunctions	mcal_open mcal_popen mcal_reopen mcal_close mcal_create_calendar mcal_rename_calendar mcal_delete_calendar mcal_fetch_event mcal_list_events mcal_append_event mcal_store_event mcal_delete_event mcal_snooze mcal_list_alarms mcal_event_init mcal_event_set_category mcal_event_set_title mcal_event_set_description mcal_event_set_start mcal_event_set_end mcal_event_set_alarm mcal_event_set_class mcal_is_leap_year mcal_days_in_month mcal_date_valid mcal_time_valid mcal_day_of_week mcal_day_of_year mcal_date_compare mcal_next_recurrence mcal_event_set_recur_none mcal_event_set_recur_daily mcal_event_set_recur_weekly mcal_event_set_recur_monthly_mday mcal_event_set_recur_monthly_wday mcal_event_set_recur_yearly mcal_fetch_current_stream_event mcal_event_add_attribute mcal_expunge mcal_week_of_year	contained
syn keyword	phpFunctions	mcrypt_get_cipher_name mcrypt_get_block_size mcrypt_get_key_size mcrypt_create_iv mcrypt_cbc mcrypt_cfb mcrypt_ecb mcrypt_ofb mcrypt_list_algorithms mcrypt_list_modes mcrypt_get_iv_size mcrypt_encrypt mcrypt_decrypt mcrypt_module_open mcrypt_module_close mcrypt_generic_deinit mcrypt_generic_init mcrypt_generic mdecrypt_generic mcrypt_generic_end mcrypt_enc_self_test mcrypt_enc_is_block_algorithm_mode mcrypt_enc_is_block_algorithm mcrypt_enc_is_block_mode mcrypt_enc_get_block_size mcrypt_enc_get_key_size mcrypt_enc_get_supported_key_sizes mcrypt_enc_get_iv_size mcrypt_enc_get_algorithms_name mcrypt_enc_get_modes_name mcrypt_module_self_test mcrypt_module_is_block_algorithm_mode mcrypt_module_is_block_algorithm mcrypt_module_is_block_mode mcrypt_module_get_algo_block_size mcrypt_module_get_algo_key_size mcrypt_module_get_supported_key_sizes	contained
syn keyword	phpFunctions	mhash_get_hash_name mhash_get_block_size mhash_count mhash mhash_keygen_s2k	contained
syn keyword	phpFunctions	mssql_close mssql_connect mssql_data_seek mssql_fetch_array mssql_fetch_field mssql_fetch_object mssql_fetch_row mssql_field_length mssql_field_name mssql_field_seek mssql_field_type mssql_free_result mssql_get_last_message mssql_min_error_severity mssql_min_message_severity mssql_next_result mssql_num_fields mssql_num_rows mssql_pconnect mssql_query mssql_result mssql_select_db mssql_bind mssql_execute mssql_fetch_assoc mssql_fetch_batch mssql_guid_string mssql_init mssql_rows_affected	contained
syn keyword	phpFunctions	ming_setcubicthreshold ming_setscale ming_useswfversion swfbutton_keypress swfmovie swfmovie.output swfmovie.save swfmovie.add swfmovie.remove swfmovie.setbackground swfmovie.setrate swfmovie.setdimension swfmovie.setframes swfmovie.nextframe swfmovie.streammp3 swfdisplayitem swfdisplayitem.moveto swfdisplayitem.move swfdisplayitem.scaleto swfdisplayitem.scale swfdisplayitem.rotateto swfdisplayitem.rotate swfdisplayitem.skewxto swfdisplayitem.skewx swfdisplayitem.skewyto swfdisplayitem.skewy swfdisplayitem.setdepth swfdisplayitem.remove swfdisplayitem.setname swfdisplayitem.setratio swfdisplayitem.addcolor swfdisplayitem.multcolor swfshape swfshape.setline swfshape.addfill swfshape.setleftfill swfshape.setrightfill swfshape.movepento swfshape.movepen swfshape.drawlineto swfshape.drawline swfshape.drawcurveto swfshape.drawcurve swfgradient swfgradient.addentry swfbitmap swfbitmap.getwidth swfbitmap.getheight swffill swffill.moveto swffill.scaleto swffill.rotateto swffill.skewxto swffill.skewyto swfmorph swfmorph.getshape1 swfmorph.getshape2 swftext swftext.setfont swftext.setheight swftext.setspacing swftext.setcolor swftext.moveto swftext.addstring swftext.getwidth swffont swffont.getwidth swftextfield swftextfield.setfont swftextfield.setbounds swftextfield.align swftextfield.setheight swftextfield.setleftmargin swftextfield.setrightmargin swftextfield.setmargins swftextfield.setindentation swftextfield.setlinespacing swftextfield.setcolor swftextfield.setname swftextfield.addstring swfsprite swfsprite.add swfsprite.remove swfsprite.setframes swfsprite.nextframe swfbutton swfbutton.addshape swfbutton.setup swfbutton.setover swfbutton.setdown swfbutton.sethit swfbutton.addaction swfbutton.setaction swfaction	contained
syn keyword	phpFunctions	connection_aborted connection_status connection_timeout constant define defined die eval exit get_browser highlight_file highlight_string ignore_user_abort iptcparse leak pack show_source sleep uniqid unpack usleep	contained
syn keyword	phpFunctions	udm_add_search_limit udm_alloc_agent udm_api_version udm_cat_path udm_cat_list udm_clear_search_limits udm_errno udm_error udm_find udm_free_agent udm_free_ispell_data udm_free_res udm_get_doc_count udm_get_res_field udm_get_res_param udm_load_ispell_data udm_set_agent_param udm_check_charset udm_check_stored udm_close_stored udm_crc32 udm_open_stored	contained
syn keyword	phpFunctions	msql msql_affected_rows msql_close msql_connect msql_create_db msql_createdb msql_data_seek msql_dbname msql_drop_db msql_dropdb msql_error msql_fetch_array msql_fetch_field msql_fetch_object msql_fetch_row msql_fieldname msql_field_seek msql_fieldtable msql_fieldtype msql_fieldflags msql_fieldlen msql_free_result msql_freeresult msql_list_fields msql_listfields msql_list_dbs msql_listdbs msql_list_tables msql_listtables msql_num_fields msql_num_rows msql_numfields msql_numrows msql_pconnect msql_query msql_regcase msql_result msql_select_db msql_selectdb msql_tablename	contained
syn keyword	phpFunctions	mysql_affected_rows mysql_change_user mysql_close mysql_connect mysql_create_db mysql_data_seek mysql_db_name mysql_db_query mysql_drop_db mysql_errno mysql_error mysql_escape_string mysql_fetch_array mysql_fetch_assoc mysql_fetch_field mysql_fetch_lengths mysql_fetch_object mysql_fetch_row mysql_field_flags mysql_field_name mysql_field_len mysql_field_seek mysql_field_table mysql_field_type mysql_free_result mysql_insert_id mysql_list_dbs mysql_list_fields mysql_list_tables mysql_num_fields mysql_num_rows mysql_pconnect mysql_query mysql_unbuffered_query mysql_result mysql_select_db mysql_tablename mysql_get_client_info mysql_get_host_info mysql_get_proto_info mysql_get_server_info	contained
syn keyword	phpFunctions	msession_connect msession_disconnect msession_count msession_create msession_destroy msession_lock msession_unlock msession_set msession_get msession_uniq msession_randstr msession_find msession_list msession_get_array msession_set_array msession_listvar msession_timeout msession_inc msession_getdata msession_setdata msession_plugin	contained
syn keyword	phpFunctions	muscat_setup muscat_setup_net muscat_give muscat_get muscat_close	contained
syn keyword	phpFunctions	checkdnsrr closelog debugger_off debugger_on define_syslog_variables fsockopen gethostbyaddr gethostbyname gethostbynamel getmxrr getprotobyname getprotobynumber getservbyname getservbyport ip2long long2ip openlog pfsockopen socket_get_status socket_set_blocking socket_set_timeout syslog	contained
syn keyword	phpFunctions	ncurses_can_change_color ncurses_cbreak ncurses_clear ncurses_clrtobot ncurses_clrtoeol ncurses_def_prog_mode ncurses_def_shell_mode ncurses_delch ncurses_deleteln ncurses_doupdate ncurses_echo ncurses_erase ncurses_erasechar ncurses_flash ncurses_flushinp ncurses_has_colors ncurses_has_ic ncurses_has_il ncurses_inch ncurses_insertln ncurses_isendwin ncurses_killchar ncurses_nl ncurses_nocbreak ncurses_noecho ncurses_nonl ncurses_noraw ncurses_raw ncurses_resetty ncurses_savetty ncurses_slk_init ncurses_slk_attr ncurses_slk_clear ncurses_slk_noutrefresh ncurses_slk_refresh ncurses_slk_restore ncurses_slk_touch ncurses_termattrs ncurses_use_default_colors ncurses_addch ncurses_addchnstr ncurses_addchstr ncurses_addnstr ncurses_addstr ncurses_assume_default_colors ncurses_attroff ncurses_attron ncurses_attrset ncurses_baudrate ncurses_beep ncurses_bkgd ncurses_border ncurses_color_set ncurses_curs_set ncurses_define_key ncurses_delay_output ncurses_delwin ncurses_echochar ncurses_end ncurses_filter ncurses_getch ncurses_halfdelay ncurses_has_key ncurses_hline ncurses_init ncurses_init_color ncurses_init_pair ncurses_insch ncurses_insdelln ncurses_insstr ncurses_instr ncurses_keyok ncurses_mouseinterval ncurses_move ncurses_mvaddch ncurses_mvaddchnstr ncurses_mvaddchstr ncurses_mvaddnstr ncurses_mvaddstr ncurses_mvcur ncurses_mvdelch ncurses_mvgetch ncurses_mvhline ncurses_mvinch ncurses_mvvline ncurses_mvwaddstr ncurses_napms ncurses_newwin ncurses_noqiflush ncurses_putp ncurses_qiflush ncurses_refresh ncurses_scr_dump ncurses_scr_init ncurses_scr_restore ncurses_scr_set ncurses_scrl ncurses_slk_attroff ncurses_slk_attron ncurses_slk_attrset ncurses_slk_color ncurses_standend ncurses_standout ncurses_start_color ncurses_typeahead ncurses_ungetch ncurses_use_extended_names ncurses_vidattr ncurses_vline ncurses_wrefresh ncurses_bkgdset ncurses_timeout ncurses_use_env ncurses_termname ncurses_longname ncurses_mousemask ncurses_getmouse ncurses_ungetmouse	contained
syn keyword	phpFunctions	notes_create_db notes_drop_db notes_version notes_create_note notes_mark_read notes_mark_unread notes_unread notes_header_info notes_body notes_find_note notes_nav_create notes_search notes_copy_db notes_list_msgs	contained
syn keyword	phpFunctions	odbc_autocommit odbc_binmode odbc_close odbc_close_all odbc_commit odbc_connect odbc_cursor odbc_do odbc_error odbc_errormsg odbc_exec odbc_execute odbc_fetch_into odbc_fetch_row odbc_fetch_array odbc_next_result odbc_fetch_object odbc_field_name odbc_field_num odbc_field_type odbc_field_len odbc_field_precision odbc_field_scale odbc_free_result odbc_longreadlen odbc_num_fields odbc_pconnect odbc_prepare odbc_num_rows odbc_result odbc_result_all odbc_rollback odbc_setoption odbc_tables odbc_tableprivileges odbc_columns odbc_columnprivileges odbc_gettypeinfo odbc_primarykeys odbc_foreignkeys odbc_procedures odbc_procedurecolumns odbc_specialcolumns odbc_statistics	contained
syn keyword	phpFunctions	ocidefinebyname ocibindbyname ocilogon ociplogon ocinlogon ocilogoff ociexecute ocicommit ocirollback ocinewdescriptor ocirowcount ocinumcols ociresult ocifetch ocifetchinto ocifetchstatement ocicolumnisnull ocicolumnname ocicolumnsize ocicolumntype ociserverversion ocistatementtype ocinewcursor ocifreestatement ocifreecursor ocifreedesc ociparse ocierror ociinternaldebug ocicancel ocisetprefetch ociwritelobtofile ocisavelobfile ocisavelob ociloadlob ocicolumnscale ocicolumnprecision ocicolumntyperaw ocinewcollection ocifreecollection ocicollassign ocicollappend ocicollassignelem ocicollgetelem ocicollmax ocicollsize ocicolltrim	contained
syn keyword	phpFunctions	openssl_error_string openssl_free_key openssl_get_privatekey openssl_get_publickey openssl_open openssl_seal openssl_sign openssl_verify openssl_pkcs7_decrypt openssl_pkcs7_encrypt openssl_pkcs7_sign openssl_pkcs7_verify openssl_x509_checkpurpose openssl_x509_free openssl_x509_parse openssl_x509_read openssl_x509_export_to_file openssl_x509_export openssl_x509_check_private_key openssl_csr_export_to_file openssl_csr_export openssl_csr_sign openssl_csr_new openssl_pkey_new openssl_pkey_export_to_file openssl_pkey_export openssl_private_encrypt openssl_private_decrypt openssl_public_encrypt openssl_public_decrypt	contained
syn keyword	phpFunctions	ora_bind ora_close ora_columnname ora_columnsize ora_columntype ora_commit ora_commitoff ora_commiton ora_do ora_error ora_errorcode ora_exec ora_fetch ora_fetch_into ora_getcolumn ora_logoff ora_logon ora_plogon ora_numcols ora_numrows ora_open ora_parse ora_rollback	contained
syn keyword	phpFunctions	ovrimos_connect ovrimos_close ovrimos_longreadlen ovrimos_prepare ovrimos_execute ovrimos_cursor ovrimos_exec ovrimos_fetch_into ovrimos_fetch_row ovrimos_result ovrimos_result_all ovrimos_num_rows ovrimos_num_fields ovrimos_field_name ovrimos_field_type ovrimos_field_len ovrimos_field_num ovrimos_free_result ovrimos_commit ovrimos_rollback	contained
syn keyword	phpFunctions	flush ob_start ob_get_contents ob_get_length ob_get_level ob_gzhandler ob_flush ob_clean ob_end_flush ob_end_clean ob_implicit_flush	contained
syn keyword	phpFunctions	overload	contained
syn keyword	phpFunctions	pdf_add_annotation pdf_add_bookmark pdf_add_launchlink pdf_add_locallink pdf_add_note pdf_add_outline pdf_add_pdflink pdf_add_thumbnail pdf_add_weblink pdf_arc pdf_arcn pdf_attach_file pdf_begin_page pdf_begin_pattern pdf_begin_template pdf_circle pdf_clip pdf_close pdf_closepath pdf_closepath_fill_stroke pdf_closepath_stroke pdf_close_image pdf_close_pdi pdf_close_pdi_page pdf_concat pdf_continue_text pdf_curveto pdf_delete pdf_end_page pdf_endpath pdf_end_pattern pdf_end_template pdf_fill pdf_fill_stroke pdf_findfont pdf_get_buffer pdf_get_font pdf_get_fontname pdf_get_fontsize pdf_get_image_height pdf_get_image_width pdf_get_parameter pdf_get_pdi_parameter pdf_get_pdi_value pdf_get_majorversion pdf_get_minorversion pdf_get_value pdf_initgraphics pdf_lineto pdf_makespotcolor pdf_moveto pdf_new pdf_open pdf_open_ccitt pdf_open_file pdf_open_gif pdf_open_image pdf_open_image_file pdf_open_jpeg pdf_open_memory_image pdf_open_pdi pdf_open_pdi_page pdf_open_png pdf_open_tiff pdf_place_image pdf_place_pdi_page pdf_rect pdf_restore pdf_rotate pdf_save pdf_scale pdf_setcolor pdf_setdash pdf_setflat pdf_setfont pdf_setgray pdf_setgray_fill pdf_setgray_stroke pdf_setlinecap pdf_setlinejoin pdf_setlinewidth pdf_setmatrix pdf_setmiterlimit pdf_setpolydash pdf_setrgbcolor pdf_setrgbcolor_fill pdf_setrgbcolor_stroke pdf_set_border_color pdf_set_border_dash pdf_set_border_style pdf_set_char_spacing pdf_set_duration pdf_set_font pdf_set_horiz_scaling pdf_set_info pdf_set_info_author pdf_set_info_creator pdf_set_info_keywords pdf_set_info_subject pdf_set_info_title pdf_set_leading pdf_set_parameter pdf_set_text_pos pdf_set_text_rendering pdf_set_text_rise pdf_set_transition pdf_set_value pdf_set_word_spacing pdf_show pdf_show_boxed pdf_show_xy pdf_skew pdf_stringwidth pdf_stroke pdf_translate	contained
syn keyword	phpFunctions	pfpro_init pfpro_cleanup pfpro_process pfpro_process_raw pfpro_version	contained
syn keyword	phpFunctions	assert assert_options extension_loaded dl getenv get_cfg_var get_current_user get_defined_constants get_extension_funcs getmygid get_included_files get_loaded_extensions get_magic_quotes_gpc get_magic_quotes_runtime getlastmod getmyinode getmypid getmyuid get_required_files getrusage ini_alter ini_get ini_get_all ini_restore ini_set phpcredits phpinfo phpversion php_logo_guid php_sapi_name php_uname putenv set_magic_quotes_runtime set_time_limit version_compare zend_logo_guid zend_version	contained
syn keyword	phpFunctions	posix_kill posix_getpid posix_getppid posix_getuid posix_geteuid posix_getgid posix_getegid posix_setuid posix_seteuid posix_setgid posix_setegid posix_getgroups posix_getlogin posix_getpgrp posix_setsid posix_setpgid posix_getpgid posix_getsid posix_uname posix_times posix_ctermid posix_ttyname posix_isatty posix_getcwd posix_mkfifo posix_getgrnam posix_getgrgid posix_getpwnam posix_getpwuid posix_getrlimit	contained
syn keyword	phpFunctions	pg_close pg_cmdtuples pg_connect pg_dbname pg_end_copy pg_errormessage pg_exec pg_fetch_array pg_fetch_object pg_fetch_row pg_fieldisnull pg_fieldname pg_fieldnum pg_fieldprtlen pg_fieldsize pg_fieldtype pg_freeresult pg_getlastoid pg_host pg_last_notice pg_loclose pg_locreate pg_loexport pg_loimport pg_loopen pg_loread pg_loreadall pg_lounlink pg_lowrite pg_numfields pg_numrows pg_options pg_pconnect pg_port pg_put_line pg_result pg_set_client_encoding pg_client_encoding pg_trace pg_tty pg_untrace pg_get_result pg_result_status pg_send_query pg_cancel_query pg_connection_busy pg_connection_reset pg_connection_status pg_copy_from pg_copy_to pg_escape_bytea pg_escape_string pg_lo_seek pg_lo_tell pg_result_error	contained
syn keyword	phpFunctions	pcntl_fork pcntl_signal pcntl_waitpid pcntl_wexitstatus pcntl_wifexited pcntl_wifsignaled pcntl_wifstopped pcntl_wstopsig pcntl_wtermsig pcntl_exec	contained
syn keyword	phpFunctions	escapeshellarg escapeshellcmd exec passthru system shell_exec	contained
syn keyword	phpFunctions	printer_open printer_abort printer_close printer_write printer_list printer_set_option printer_get_option printer_create_dc printer_delete_dc printer_start_doc printer_end_doc printer_start_page printer_end_page printer_create_pen printer_delete_pen printer_select_pen printer_create_brush printer_delete_brush printer_select_brush printer_create_font printer_delete_font printer_select_font printer_logical_fontheight printer_draw_roundrect printer_draw_rectangle printer_draw_elipse printer_draw_text printer_draw_line printer_draw_chord printer_draw_pie printer_draw_bmp	contained
syn keyword	phpFunctions	pspell_add_to_personal pspell_add_to_session pspell_check pspell_clear_session pspell_config_create pspell_config_ignore pspell_config_mode pspell_config_personal pspell_config_repl pspell_config_runtogether pspell_config_save_repl pspell_new pspell_new_config pspell_new_personal pspell_save_wordlist pspell_store_replacement pspell_suggest	contained
syn keyword	phpFunctions	readline readline_add_history readline_clear_history readline_completion_function readline_info readline_list_history readline_read_history readline_write_history	contained
syn keyword	phpFunctions	recode_string recode recode_file	contained
syn keyword	phpFunctions	preg_match preg_match_all preg_replace preg_replace_callback preg_split preg_quote preg_grep	contained
syn keyword	phpFunctions	qdom_tree qdom_error	contained
syn keyword	phpFunctions	ereg ereg_replace eregi eregi_replace split spliti sql_regcase	contained
syn keyword	phpFunctions	sem_get sem_acquire sem_release sem_remove shm_attach shm_detach shm_remove shm_put_var shm_get_var shm_remove_var ftok	contained
syn keyword	phpFunctions	sesam_connect sesam_disconnect sesam_settransaction sesam_commit sesam_rollback sesam_execimm sesam_query sesam_num_fields sesam_field_name sesam_diagnostic sesam_fetch_result sesam_affected_rows sesam_errormsg sesam_field_array sesam_fetch_row sesam_fetch_array sesam_seek_row sesam_free_result	contained
syn keyword	phpFunctions	session_start session_destroy session_name session_module_name session_save_path session_id session_register session_unregister session_unset session_is_registered session_get_cookie_params session_set_cookie_params session_decode session_encode session_set_save_handler session_cache_limiter session_cache_expire session_write_close	contained
syn keyword	phpFunctions	shmop_open shmop_read shmop_write shmop_size shmop_delete shmop_close	contained
syn keyword	phpFunctions	swf_openfile swf_closefile swf_labelframe swf_showframe swf_setframe swf_getframe swf_mulcolor swf_addcolor swf_placeobject swf_modifyobject swf_removeobject swf_nextid swf_startdoaction swf_actiongotoframe swf_actiongeturl swf_actionnextframe swf_actionprevframe swf_actionplay swf_actionstop swf_actiontogglequality swf_actionwaitforframe swf_actionsettarget swf_actiongotolabel swf_enddoaction swf_defineline swf_definerect swf_definepoly swf_startshape swf_shapelinesolid swf_shapefilloff swf_shapefillsolid swf_shapefillbitmapclip swf_shapefillbitmaptile swf_shapemoveto swf_shapelineto swf_shapecurveto swf_shapecurveto3 swf_shapearc swf_endshape swf_definefont swf_setfont swf_fontsize swf_fontslant swf_fonttracking swf_getfontinfo swf_definetext swf_textwidth swf_definebitmap swf_getbitmapinfo swf_startsymbol swf_endsymbol swf_startbutton swf_addbuttonrecord swf_oncondition swf_endbutton swf_viewport swf_ortho swf_ortho2 swf_perspective swf_polarview swf_lookat swf_pushmatrix swf_popmatrix swf_scale swf_translate swf_rotate swf_posround	contained
syn keyword	phpFunctions	snmpget snmpset snmpwalk snmpwalkoid snmp_get_quick_print snmp_set_quick_print snmprealwalk	contained
syn keyword	phpFunctions	socket_accept socket_bind socket_close socket_connect socket_listen socket_read socket_create socket_strerror socket_write socket_fd_alloc socket_fd_free socket_fd_set socket_fd_clear socket_fd_isset socket_fd_zero socket_select socket_create_listen socket_set_nonblock socket_getsockname socket_getpeername socket_iovec_alloc socket_iovec_fetch socket_iovec_set socket_iovec_add socket_iovec_delete socket_iovec_free socket_readv socket_writev socket_recv socket_send socket_recvfrom socket_sendto socket_recvmsg socket_sendmsg socket_getopt socket_setopt socket_create_pair socket_shutdown socket_last_error	contained
syn keyword	phpFunctions	addcslashes addslashes bin2hex chop chr chunk_split convert_cyr_string count_chars crc32 crypt echo explode get_html_translation_table get_meta_tags hebrev hebrevc htmlentities htmlspecialchars implode join levenshtein localeconv ltrim md5 md5_file metaphone nl2br ord parse_str print printf quoted_printable_decode quotemeta str_rot13 rtrim sscanf setlocale similar_text soundex sprintf strncasecmp strcasecmp strchr strcmp strcoll strcspn strip_tags stripcslashes stripslashes stristr strlen strnatcmp strnatcasecmp strncmp str_pad strpos strrchr str_repeat strrev strrpos strspn strstr strtok strtolower strtoupper str_replace strtr substr substr_count substr_replace trim ucfirst ucwords vprintf vsprintf wordwrap nl_langinfo	contained
syn keyword	phpFunctions	sybase_affected_rows sybase_close sybase_connect sybase_data_seek sybase_fetch_array sybase_fetch_field sybase_fetch_object sybase_fetch_row sybase_field_seek sybase_free_result sybase_get_last_message sybase_min_client_severity sybase_min_error_severity sybase_min_message_severity sybase_min_server_severity sybase_num_fields sybase_num_rows sybase_pconnect sybase_query sybase_result sybase_select_db	contained
syn keyword	phpFunctions	base64_decode base64_encode parse_url rawurldecode rawurlencode urldecode urlencode	contained
syn keyword	phpFunctions	doubleval empty floatval gettype get_defined_vars get_resource_type import_request_variables intval is_array is_bool is_double is_float is_int is_integer is_long is_null is_numeric is_object is_real is_resource is_scalar is_string isset print_r serialize settype strval unserialize unset var_dump var_export is_callable	contained
syn keyword	phpFunctions	vpopmail_add_domain vpopmail_del_domain vpopmail_add_alias_domain vpopmail_add_domain_ex vpopmail_del_domain_ex vpopmail_add_alias_domain_ex vpopmail_add_user vpopmail_del_user vpopmail_passwd vpopmail_set_user_quota vpopmail_auth_user vpopmail_alias_add vpopmail_alias_del vpopmail_alias_del_domain vpopmail_alias_get vpopmail_alias_get_all vpopmail_error	contained
syn keyword	phpFunctions	w32api_set_call_method w32api_register_function w32api_invoke_function w32api_deftype w32api_init_dtype	contained
syn keyword	phpFunctions	wddx_serialize_value wddx_serialize_vars wddx_packet_start wddx_packet_end wddx_add_vars wddx_deserialize	contained
syn keyword	phpFunctions	xml_parser_create xml_set_object xml_set_element_handler xml_set_character_data_handler xml_set_processing_instruction_handler xml_set_default_handler xml_set_unparsed_entity_decl_handler xml_set_notation_decl_handler xml_set_external_entity_ref_handler xml_parse xml_get_error_code xml_error_string xml_get_current_line_number xml_get_current_column_number xml_get_current_byte_index xml_parse_into_struct xml_parser_free xml_parser_set_option xml_parser_get_option utf8_decode utf8_encode xml_parser_create_ns xml_set_end_namespace_decl_handler xml_set_start_namespace_decl_handler	contained
syn keyword	phpFunctions	xmlrpc_encode_request xmlrpc_encode xmlrpc_decode_request xmlrpc_decode xmlrpc_server_create xmlrpc_server_destroy xmlrpc_server_register_method xmlrpc_server_register_introspection_callback xmlrpc_server_call_method xmlrpc_server_add_introspection_data xmlrpc_parse_method_descriptions xmlrpc_set_type xmlrpc_get_type	contained
syn keyword	phpFunctions	xslt_set_log xslt_create xslt_errno xslt_error xslt_free xslt_process xslt_set_sax_handler xslt_set_scheme_handler xslt_set_error_handler xslt_set_base xslt_set_encoding xslt_set_sax_handlers xslt_set_scheme_handlers	contained
syn keyword	phpFunctions	yaz_addinfo yaz_close yaz_connect yaz_errno yaz_error yaz_hits yaz_element yaz_database yaz_range yaz_record yaz_search yaz_present yaz_syntax yaz_scan yaz_scan_result yaz_ccl_conf yaz_ccl_parse yaz_itemorder yaz_wait yaz_sort	contained
syn keyword	phpFunctions	yp_get_default_domain yp_order yp_master yp_match yp_first yp_next yp_errno yp_err_string yp_all yp_cat	contained
syn keyword	phpFunctions	zip_close zip_entry_close zip_entry_compressedsize zip_entry_compressionmethod zip_entry_filesize zip_entry_name zip_entry_open zip_entry_read zip_open zip_read	contained
syn keyword	phpFunctions	gzclose gzeof gzfile gzgetc gzgets gzgetss gzopen gzpassthru gzputs gzread gzrewind gzseek gztell gzwrite readgzfile gzcompress gzuncompress gzdeflate gzinflate gzencode	contained

if exists( "php_baselib" )
  syn keyword	phpBaselib	query next_record num_rows affected_rows nf f p np num_fields haltmsg seek link_id query_id metadata table_names nextid connect halt free register unregister is_registered delete url purl self_url pself_url hidden_session add_query padd_query reimport_get_vars reimport_post_vars reimport_cookie_vars set_container set_tokenname release_token put_headers get_id get_id put_id freeze thaw gc reimport_any_vars start url purl login_if is_authenticated auth_preauth auth_loginform auth_validatelogin auth_refreshlogin auth_registerform auth_doregister start check have_perm permsum perm_invalid	contained
  syn keyword	phpFunctions	page_open page_close sess_load sess_save	contained
endif

" Conditional
syn keyword	phpConditional	if else elseif endif switch endswitch	contained

" Repeat
syn keyword	phpRepeat	do for while endwhile foreach	contained

" Repeat
syn keyword	phpLabel	case default switch	contained

" Statement
syn keyword	phpStatement	return break continue exit contained

" Keyword
syn keyword	phpKeyword	var	contained

" Type
syn keyword	phpType	bool[ean] int[eger] real double float string array object NULL	contained

" Structure
syn keyword	phpStructure	extends	contained

" StorageClass
syn keyword	phpStorageClass	global static	contained

" Operator
syn match	phpOperator	"[-=+%^&|*!.~?:]"	contained display
syn match	phpOperator	"[-+*/%^&|.]="	contained display
syn match	phpOperator	"/[^*/]"me=e-1	contained display
syn match	phpOperator	"\$"	contained display
syn match	phpOperator	"&&\|\<and\>"	contained display
syn match	phpOperator	"||\|\<x\=or\>"	contained display
syn match	phpRelation	"[!=<>]="	contained display
syn match	phpRelation	"[<>]"	contained display
syn match	phpMemberSelector	"->"	contained display
syn match	phpVarSelector	"\$"	contained display

" Identifier
syn match	phpIdentifier	"$\h\w*"	contained contains=phpEnvVar,phpIntVar,phpVarSelector display

" Methoden
syn match	phpMethodsVar	"->\h\w*"	contained contains=phpBaselib,phpMemberSelector display

" Include
syn keyword	phpInclude	include require include_once require_once	contained

" Define
syn keyword	phpDefine	new	contained

" Boolean
syn keyword	phpBoolean	true false	contained

" Number
syn match phpNumber	"-\=\<\d\+\>"	contained display

" Float
syn match phpFloat	"\(-\=\<\d+\|-\=\)\.\d\+\>"	contained display

" SpecialChar
syn match phpSpecialChar	"\\[abcfnrtyv\\]"	contained display
syn match phpSpecialChar	"\\\d\{3}"	contained contains=phpOctalError display
syn match phpSpecialChar	"\\x[0-9a-fA-F]\{2}"	contained display

" Error
syn match phpOctalError	"[89]"	contained display
if exists("php_parent_error_close")
  syn match phpParentError	"[)\]}]"	contained display
endif

" Todo
syn keyword	phpTodo	todo fixme xxx	contained

" Comment
syn region	phpComment	start="/\*" end="\*/"	contained contains=phpTodo extend
syn match	phpComment	"#.\{-}\(?>\|$\)\@="	contained contains=phpTodo
syn match	phpComment	"//.\{-}\(?>\|$\)\@="	contained contains=phpTodo

" String
syn region	phpStringDouble	matchgroup=None start=+"+ skip=+\\\\\|\\"+ end=+"+	contains=@phpAddStrings,phpIdentifier,phpSpecialChar contained keepend extend
syn region	phpStringSingle	matchgroup=None start=+'+ skip=+\\\\\|\\'+ end=+'+	contains=@phpAddStrings,phpSpecialChar contained keepend extend

" HereDoc
syn case match
syn region	phpHeredoc	matchgroup=Delimiter start="\(<<<\)\@<=\z(\I\i*\)$" end="^\z1;\=$"	contained contains=phpIdentifier,phpSpecialChar,phpMemberMethodsVar keepend extend
" including HTML,JavaScript,SQL even if not enabled via options
syn region	phpHeredoc	matchgroup=Delimiter start="\(<<<\)\@<=\z(\(\I\i*\)\=\(html\)\c\(\i*\)\)$" end="^\z1;\=$"	contained contains=@htmlTop,phpIdentifier,phpSpecialChar,phpMemberMethodsVar keepend extend
syn region	phpHeredoc	matchgroup=Delimiter start="\(<<<\)\@<=\z(\(\I\i*\)\=\(sql\)\c\(\i*\)\)$" end="^\z1;\=$"	contained contains=@sqlTop,phpIdentifier,phpSpecialChar,phpMemberMethodsVar keepend extend
syn region	phpHeredoc	matchgroup=Delimiter start="\(<<<\)\@<=\z(\(\I\i*\)\=\(javascript\)\c\(\i*\)\)$" end="^\z1;\=$"	contained contains=@htmlJavascript,phpIdentifier,phpSpecialChar,phpMemberMethodsVar keepend extend
syn case ignore

" Parent
if exists("php_parent_error_close") || exists("php_parent_error_open")
  syn match phpParent	"[{}]"	contained
  syn region	phpParent	matchgroup=Delimiter start="(" end=")"	contained contains=@phpClInside transparent
  syn region	phpParent	matchgroup=Delimiter start="\[" end="\]"	contained contains=@phpClInside transparent
else
  syn match phpParent	"[({[\]})]"	contained
endif

syn cluster	phpClInside	contains=phpComment,phpFunctions,phpIdentifier,phpConditional,phpRepeat,phpLabel,phpStatement,phpOperator,phpRelation,phpStringSingle,phpStringDouble,phpNumber,phpFloat,phpSpecialChar,phpParent,phpParentError,phpInclude,phpKeyword,phpType,phpIdentifierParent,phpBoolean,phpStructure,phpMethodsVar,phpHereDoc
syn cluster	phpClFunction	contains=@phpClInside,phpDefine,phpParentError,phpStorageClass
syn cluster	phpClTop	contains=@phpClFunction,phpFoldFunction,phpFoldClass

if exists("php_parent_error_open")
  " Php Region
  if exists("php_noShortTags")
    syn region	 phpRegion	matchgroup=Delimiter start="<?php" end="?>"	contains=@phpClTop
  else
    syn region	 phpRegion	matchgroup=Delimiter start="<?\(php\)\=" end="?>"	contains=@phpClTop
  endif
  syn region	 phpRegion	matchgroup=Delimiter start=+<script language="php">+ end=+</script>+	contains=@phpClTop
  if exists("php_asp_tags")
    syn region	 phpRegion	matchgroup=Delimiter start="<%\(=\)\=" end="%>"	contains=@phpClTop
  endif
else
  " Php Region
  if exists("php_noShortTags")
    syn region	 phpRegion	matchgroup=Delimiter start="<?php" end="?>"	contains=@phpClTop keepend
  else
    syn region	 phpRegion	matchgroup=Delimiter start="<?\(php\)\=" end="?>"	contains=@phpClTop keepend
  endif
  syn region	 phpRegion	matchgroup=Delimiter start=+<script language="php">+ end=+</script>+	contains=@phpClTop keepend
  if exists("php_asp_tags")
    syn region	 phpRegion	matchgroup=Delimiter start="<%\(=\)\=" end="%>"	contains=@phpClTop keepend
  endif

endif

" Fold
if exists("php_folding")
  set foldmethod=syntax
  syn region phpFoldHtmlInside	matchgroup=Delimiter start="?>" end="<?\(php\)\=" contained transparent contains=@htmlTop
  syn region phpFoldFunction	matchgroup=Define start="^\z\(\s*\)Function" matchgroup=Delimiter end="^\z1}" contains=@phpClFunction,phpFoldHtmlInside contained transparent fold extend
  syn region phpFoldClass	matchgroup=Structure start="^\z\(\s*\)Class" matchgroup=Delimiter end="^\z1}" contains=@phpClFunction,phpFoldFunction contained transparent fold extend
else
  syn keyword	phpDefine	function	contained
  syn keyword	phpStructure	class	contained
endif

" Sync
if php_sync_method==-1
  if exists("php_noShortTags")
    syn sync match phpRegionSync grouphere phpRegion "<?php"
  else
    syn sync match phpRegionSync grouphere phpRegion "<?\(php\)\="
  endif
  syn sync match phpRegionSync grouphere phpRegion +<script language="php">+
  if exists("php_asp_tags")
    syn sync match phpRegionSync grouphere phpRegion "<%\(=\)\="
  endif
  syn sync match phpRegionSync groupthere NONE "?>"
  syn sync minlines=50
elseif php_sync_method>0
  exec "syn sync minlines=" . php_sync_method
else
  exec "syn sync fromstart"
endif

" Define the default highlighting.
" For version 5.7 and earlier: only when not done already
" For version 5.8 and later: only when an item doesn't have highlighting yet
if version >= 508 || !exists("did_php_syn_inits")
  if version < 508
    let did_php_syn_inits = 1
    command -nargs=+ HiLink hi link <args>
  else
    command -nargs=+ HiLink hi def link <args>
  endif

  HiLink	 phpComment	Comment
  HiLink	 phpBoolean	Boolean
  HiLink	 phpStorageClass	StorageClass
  HiLink	 phpStructure	Structure
  HiLink	 phpStringSingle	String
  HiLink	 phpStringDouble	String
  HiLink	 phpHereDoc	String
  HiLink	 phpNumber	Number
  HiLink	 phpFloat	Float
  HiLink	 phpFunctions	Function
  HiLink	 phpBaselib	Function
  HiLink	 phpRepeat	Repeat
  HiLink	 phpConditional	Conditional
  HiLink	 phpLabel	Label
  HiLink	 phpStatement	Statement
  HiLink	 phpKeyword	Statement
  HiLink	 phpType	Type
  HiLink	 phpInclude	Include
  HiLink	 phpDefine	Define
  HiLink	 phpSpecialChar	SpecialChar
  HiLink	 phpParent	Delimiter
  HiLink	 phpParentError	Error
  HiLink	 phpOctalError	Error
  HiLink	 phpTodo	Todo
  HiLink	 phpMemberSelector	Structure
  if exists("php_oldStyle")
	hi	phpIntVar guifg=Red ctermfg=DarkRed
	hi	phpEnvVar guifg=Red ctermfg=DarkRed
	hi	phpOperator guifg=SeaGreen ctermfg=DarkGreen
	hi	phpVarSelector guifg=SeaGreen ctermfg=DarkGreen
	hi	phpRelation guifg=SeaGreen ctermfg=DarkGreen
	hi	phpIdentifier guifg=DarkGray ctermfg=Brown
  else
	HiLink	phpIntVar	Identifier
	HiLink	phpEnvVar	Identifier
	HiLink	phpOperator	Operator
	HiLink	phpVarSelector	Operator
	HiLink	phpRelation	Operator
	HiLink	phpIdentifier	Identifier
  endif

  delcommand HiLink
endif

let b:current_syntax = "php"

if main_syntax == 'php'
  unlet main_syntax
endif

" vim: ts=8
