%pointer
%x NORMAL

%{
/*
 * $Header: /usr/build/vile/vile/filters/RCS/wbt-filt.l,v 1.9 2009/04/25 16:20:07 tom Exp $
 *
 * Filter to add vile "attribution" sequences to selected bits of WinBatch script.
 */

#include <filters.h>

DefineFilter("wbt");

static const char *want_attr(char *want, char *name);

static char *Comment_attr;
static char *Error_attr;
static char *Number_attr;
static char *Prepro_attr;
static char *String_attr;

%}

BSTRING		\`([^`\r\n]|``)*\`
SSTRING		\'([^'\r\n]|'')*\'
DSTRING		\"([^"\r\n]|"")*\"
STRING		{DSTRING}|{SSTRING}|{BSTRING}

NAME		[[:alnum:]]

IDENT		[[:alpha:]]{NAME}*

DECIMAL		[[:digit:]]+
REAL		[-+]?([[:digit:]]*\.[[:digit:]]+)([eE][+-]?[[:digit:]]+)?
NUMBER		({REAL}|{DECIMAL})

%%

<NORMAL>{IDENT}		{ WriteToken(ci_keyword_attr(yytext)); }
<NORMAL>#{IDENT}	{ WriteToken(want_attr(Prepro_attr, yytext)); }
<NORMAL>"@"{IDENT}	{ WriteToken(want_attr(Number_attr, yytext)); }

<NORMAL>";"[^\r\n]*	{ WriteToken(Comment_attr); }

<NORMAL>{NUMBER}	{ WriteToken(Number_attr); }
<NORMAL>[[:digit:]]{NUMBER}{NAME}+ {
			  flt_error("not a number");
			  WriteToken(Error_attr);
			}
<NORMAL>{STRING}	{ WriteToken(String_attr); }

%%

static const char *
want_attr(char *want, char *name)
{
    const char *have = ci_keyword_attr(name);
    if (have != want)
	have = Error_attr;
    return have;
}

static void
init_filter(int before GCC_UNUSED)
{
    (void) before;
}

static void
do_filter(FILE *inputs)
{
    InitLEX(inputs);

    Comment_attr = class_attr(NAME_COMMENT);
    Error_attr   = class_attr(NAME_ERROR);
    Number_attr  = class_attr(NAME_NUMBER);
    Prepro_attr  = class_attr(NAME_PREPROC);
    String_attr  = class_attr(NAME_LITERAL);

    BEGIN(NORMAL);

    RunLEX();
}

#if NO_LEAKS
static void
free_filter(void)
{
    USE_LEXFREE;
}
#endif
