/*
 * Copyright (C) 2003  Stefan Kleine Stegemann
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#include "DocumentPosition.h"

/*
 * Non-Public methods.
 */
@interface DocumentPosition(Private)
@end


/*
 * Specifies a position somewhere in the document. The position
 * is indentified by the page and a rectangular area on this
 * page.
 */
@implementation DocumentPosition

- (id) initWithPage: (int)aPage boundingRect: (NSRect)rect
{
   if ((self = [super init]))
   {
      [self setPage: aPage];
      [self setBoundingRect: rect];
   }

   return self;
}


+ (DocumentPosition*) positionAtPage: (int)aPage boundingRect: (NSRect)rect
{
   DocumentPosition* pos =
      [[DocumentPosition alloc] initWithPage: aPage boundingRect: rect];

   return [pos autorelease];
}


- (int) page
{
   return page;
}


- (void) setPage: (int)aPage
{
   page = aPage;
}


- (NSRect) boundingRect
{
   return boundingRect;
}


- (void) setBoundingRect: (NSRect)rect
{
   boundingRect = rect;
}

@end
